/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public final class MediaResourceLocator {
    private static final Logger logger = LoggerFactory.getLogger(MediaResourceLocator.class);
    private static final Pattern MRL_LOCATION_PATTERN = Pattern.compile(".+://.*");

    private MediaResourceLocator() {
    }

    public static boolean isLocation(String mrl) {
        return MRL_LOCATION_PATTERN.matcher(mrl).matches();
    }

    public static String encodeMrl(String mrl) {
        String result;
        block5: {
            logger.debug("encodeMrl(mrl={})", (Object)mrl);
            result = mrl;
            if (MediaResourceLocator.containsUnicode(mrl)) {
                logger.debug("MRL contains Unicode characters");
                try {
                    URI uri = new URI(mrl);
                    logger.debug("uri={}", (Object)uri);
                    String scheme = uri.getScheme();
                    logger.debug("scheme={}", (Object)uri.getScheme());
                    if (scheme == null) {
                        logger.debug("MRL has no scheme, assuming a local file name that should be encoded");
                        result = MediaResourceLocator.encode(mrl);
                        break block5;
                    }
                    logger.debug("Ignoring MRL with scheme '{}'", (Object)scheme);
                }
                catch (URISyntaxException e) {
                    logger.debug("Can not obtain a valid URI from the MRL");
                    if (RuntimeUtil.isWindows() && MediaResourceLocator.isAbsolutePath(mrl)) {
                        result = MediaResourceLocator.encode(mrl);
                    }
                    break block5;
                }
            }
            logger.debug("MRL does not contain any Unicode characters");
        }
        logger.debug("result={}", (Object)result);
        return result;
    }

    private static boolean containsUnicode(String value) {
        boolean result = false;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) < '\u0080') continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isAbsolutePath(String value) {
        logger.debug("isAbsolutePath(value={})", (Object)value);
        boolean result = new File(value).isAbsolute();
        logger.debug("result={}", (Object)result);
        return result;
    }

    private static String encode(String value) {
        logger.debug("encode(value={})", (Object)value);
        String result = new File(value).toURI().toASCIIString().replaceFirst("file:/", "file:///");
        logger.debug("result={}", (Object)result);
        return result;
    }
}

