/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.discovery;

import com.sun.jna.NativeLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.Info;
import uk.co.caprica.vlcj.discovery.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.linux.DefaultLinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.mac.DefaultMacNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.windows.DefaultWindowsNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class NativeDiscovery {
    private static final String JNA_SYSTEM_PROPERTY_NAME = "jna.library.path";
    private final Logger logger = LoggerFactory.getLogger(NativeDiscovery.class);
    private final NativeDiscoveryStrategy[] discoveryStrategies;

    public NativeDiscovery(NativeDiscoveryStrategy ... discoveryStrategies) {
        this.discoveryStrategies = discoveryStrategies;
    }

    public NativeDiscovery() {
        this(new DefaultLinuxNativeDiscoveryStrategy(), new DefaultWindowsNativeDiscoveryStrategy(), new DefaultMacNativeDiscoveryStrategy());
    }

    public final boolean discover() {
        this.logger.debug("discover()");
        String jnaLibraryPath = System.getProperty(JNA_SYSTEM_PROPERTY_NAME);
        this.logger.debug("jnaLibraryPath={}", (Object)jnaLibraryPath);
        if (jnaLibraryPath == null) {
            for (NativeDiscoveryStrategy discoveryStrategy : this.discoveryStrategies) {
                this.logger.debug("discoveryStrategy={}", (Object)discoveryStrategy);
                boolean supported = discoveryStrategy.supported();
                this.logger.debug("supported={}", (Object)supported);
                if (!supported) continue;
                String path = discoveryStrategy.discover();
                this.logger.debug("path={}", (Object)path);
                if (path == null) continue;
                this.logger.info("Discovery found libvlc at '{}'", (Object)path);
                NativeLibrary.addSearchPath(RuntimeUtil.getLibVlcLibraryName(), path);
                discoveryStrategy.onFound(path);
                return true;
            }
            this.logger.warn("Discovery did not find libvlc");
        } else {
            this.logger.info("Skipped discovery as system property '{}' already set to '{}'", (Object)JNA_SYSTEM_PROPERTY_NAME, (Object)jnaLibraryPath);
        }
        return false;
    }

    static {
        Info.getInstance();
    }
}

