/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.discovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.discovery.NativeDiscoveryStrategy;

public abstract class AbstractNativeDiscoveryStrategy
implements NativeDiscoveryStrategy {
    private final Logger logger = LoggerFactory.getLogger(AbstractNativeDiscoveryStrategy.class);
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";

    @Override
    public final String discover() {
        this.logger.debug("discover()");
        String result = null;
        ArrayList<String> directoryNames = new ArrayList<String>();
        this.getDirectoryNames(directoryNames);
        this.logger.debug("directoryNames={}", (Object)directoryNames);
        for (String directoryName : directoryNames) {
            this.logger.debug("directoryName={}", (Object)directoryName);
            if (!this.find(directoryName)) continue;
            result = directoryName;
            break;
        }
        this.logger.debug("result={}", (Object)result);
        return result;
    }

    private boolean find(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            Pattern[] patternsToMatch = this.getFilenamePatterns();
            HashSet<String> matches = new HashSet<String>(patternsToMatch.length);
            for (File file : files) {
                for (Pattern pattern : patternsToMatch) {
                    Matcher matcher = pattern.matcher(file.getName());
                    if (!matcher.matches()) continue;
                    this.logger.debug("Matched '{}' in '{}'", (Object)file.getName(), (Object)directoryName);
                    matches.add(pattern.pattern());
                    if (matches.size() != patternsToMatch.length) continue;
                    this.logger.debug("Matched all required files");
                    return true;
                }
            }
        }
        this.logger.debug("Failed to matched all required files");
        return false;
    }

    protected final List<String> getSystemPath() {
        String path = System.getenv("PATH");
        if (path != null) {
            String[] paths = path.split(File.pathSeparator);
            return Arrays.asList(paths);
        }
        return Collections.emptyList();
    }

    protected abstract Pattern[] getFilenamePatterns();

    protected abstract void getDirectoryNames(List<String> var1);

    @Override
    public void onFound(String path) {
    }
}

