/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.component.overlay;

import com.sun.jna.platform.WindowUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJWindowOverlayComponent
extends JWindow {
    private final Logger logger = LoggerFactory.getLogger(AbstractJWindowOverlayComponent.class);
    private static final long serialVersionUID = 1L;
    private int layoutWidth = -1;
    private int layoutHeight = -1;

    public AbstractJWindowOverlayComponent(Window owner) {
        this(owner, WindowUtils.getAlphaCompatibleGraphicsConfiguration());
    }

    public AbstractJWindowOverlayComponent(Window owner, GraphicsConfiguration graphicsConfiguration) {
        super(owner, graphicsConfiguration);
        if (owner == null) {
            throw new IllegalArgumentException("The overlay window owner must not be null");
        }
        this.onSetWindowTransparency();
        this.onCreateOverlay();
        if (this.onHideCursor()) {
            this.setCursor(this.getBlankCursor());
        }
    }

    protected void onSetWindowTransparency() {
        String javaSpecificationVersion = System.getProperty("java.specification.version");
        if ("1.7".compareTo(javaSpecificationVersion) <= 0) {
            this.setBackground(new Color(0, 0, 0, 0));
        } else {
            try {
                Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
                Method setWindowOpaqueMethod = awtUtilitiesClass.getMethod("setWindowOpaque", Window.class, Boolean.class);
                setWindowOpaqueMethod.invoke(null, this, false);
            }
            catch (Exception e) {
                this.logger.debug("No apparent support for transparent windows", (Object)e.getMessage());
                this.setBackground(new Color(0, 0, 0, 0));
            }
        }
    }

    protected void onCreateOverlay() {
    }

    protected boolean onHideCursor() {
        return true;
    }

    @Override
    public final void paint(Graphics g) {
        this.layoutHeight = this.getHeight();
        this.layoutWidth = this.getWidth();
        if (this.layoutWidth != this.layoutWidth | this.layoutHeight != this.layoutHeight) {
            this.onNewSize(this.layoutWidth, this.layoutHeight);
        }
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        this.onPrepareGraphicsContext(g2);
        this.onPaintOverlay(g2);
    }

    protected void onNewSize(int width, int height) {
    }

    protected void onPrepareGraphicsContext(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    protected void onPaintOverlay(Graphics2D g2) {
    }

    private Cursor getBlankCursor() {
        BufferedImage blankImage = new BufferedImage(1, 1, 2);
        return Toolkit.getDefaultToolkit().createCustomCursor(blankImage, new Point(0, 0), "");
    }
}

