/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.version.Version;

public final class Info {
    private final Logger logger = LoggerFactory.getLogger(Info.class);
    private Version version;

    public static Info getInstance() {
        return InfoHolder.INSTANCE;
    }

    private Info() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/uk/co/caprica/vlcj/build.properties"));
            this.version = new Version(properties.getProperty("build.version"));
        }
        catch (Exception e) {
            this.version = null;
        }
        this.logger.info("vlcj: {}", this.version != null ? this.version : "<version not available>");
        this.logger.info("java: {} {}", (Object)System.getProperty("java.version"), (Object)System.getProperty("java.vendor"));
        this.logger.info("java home: {}", (Object)System.getProperty("java.home"));
        this.logger.info("os: {} {} {}", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        if (RuntimeUtil.isNix()) {
            this.logger.info("LD_LIBRARY_PATH: {}", (Object)System.getenv("LD_LIBRARY_PATH"));
        }
    }

    public final Version version() {
        return this.version;
    }

    private static class InfoHolder {
        public static final Info INSTANCE = new Info();

        private InfoHolder() {
        }
    }
}

