/*
 * Decompiled with CFR 0.152.
 */
package org.jnativehook;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeLibraryLocator;
import org.jnativehook.NativeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLibraryLocator
implements NativeLibraryLocator {
    private static Logger logger = Logger.getLogger(GlobalScreen.class.getPackage().getName());

    @Override
    public Iterator<File> getLibraries() {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(1);
        String string = System.getProperty("jnativehook.lib.name", "JNativeHook");
        String string2 = GlobalScreen.class.getPackage().getName().replace('.', '/');
        String string3 = System.mapLibraryName(string);
        string3 = string3.replaceAll("\\.jnilib$", "\\.dylib");
        int n = string3.lastIndexOf(46);
        String string4 = string3.substring(0, n) + '-';
        String string5 = NativeSystem.getArchitecture().toString().toLowerCase();
        String string6 = '.' + string5 + string3.substring(n);
        String string7 = null;
        StringBuilder stringBuilder = new StringBuilder("/");
        stringBuilder.append(string2).append("/lib/");
        stringBuilder.append(NativeSystem.getFamily().toString().toLowerCase()).append('/');
        stringBuilder.append(string5).append('/');
        stringBuilder.append(string3);
        InputStream inputStream = GlobalScreen.class.getResourceAsStream(stringBuilder.toString());
        if (inputStream != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            try {
                serializable = GlobalScreen.class.getProtectionDomain().getCodeSource().getLocation();
                object4 = new JarInputStream(((URL)serializable).openStream());
                Manifest manifest = ((JarInputStream)object4).getManifest();
                if (manifest != null) {
                    object3 = manifest.getAttributes(string2);
                    if (object3 != null) {
                        object2 = ((Attributes)object3).getValue("Specification-Version");
                        object = ((Attributes)object3).getValue("Implementation-Version");
                        string7 = (String)object2 + '.' + (String)object;
                    } else {
                        logger.warning("Invalid library manifest!\n");
                    }
                } else {
                    logger.warning("Cannot find library manifest!\n");
                }
                ((ZipInputStream)object4).close();
            }
            catch (IOException iOException) {
                logger.severe(iOException.getMessage());
            }
            serializable = null;
            if (string7 != null && ((File)(serializable = new File(System.getProperty("java.io.tmpdir"), string4 + string7 + string6))).exists()) {
                arrayList.add(serializable);
            }
            if (arrayList.isEmpty()) {
                try {
                    int n2;
                    if (serializable == null) {
                        serializable = File.createTempFile(string4, string6);
                    }
                    object4 = new byte[4096];
                    object3 = new FileOutputStream((File)serializable);
                    object2 = MessageDigest.getInstance("SHA-1");
                    object = new DigestInputStream(inputStream, (MessageDigest)object2);
                    while ((n2 = ((FilterInputStream)object).read((byte[])object4)) != -1) {
                        ((FileOutputStream)object3).write((byte[])object4, 0, n2);
                    }
                    ((FilterInputStream)object).close();
                    inputStream.close();
                    ((FileOutputStream)object3).close();
                    String string8 = new BigInteger(1, ((MessageDigest)object2).digest()).toString(16).toUpperCase();
                    if (string7 == null) {
                        string7 = string8;
                        File file = new File(System.getProperty("java.io.tmpdir"), string4 + string7 + string6);
                        if (((File)serializable).renameTo(file)) {
                            serializable = file;
                        }
                    }
                    System.setProperty("jnativehook.lib.version", string7);
                    arrayList.add(serializable);
                    logger.info("Library extracted successfully: " + ((File)serializable).getPath() + " (0x" + string8 + ").\n");
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException.getMessage(), iOException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new IllegalStateException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
                }
            }
        } else {
            logger.severe("Unable to extract the native library " + stringBuilder.toString() + "!\n");
        }
        return arrayList.iterator();
    }
}

