/*
 * Decompiled with CFR 0.152.
 */
package library;

import application.ColorImage;
import application.Console;
import application.Functions;
import application.OverlayWindow;
import application.RenderQueue;
import application.SceneDetection;
import application.Settings;
import application.Shutter;
import application.VideoPlayer;
import functions.video.DVD;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Taskbar;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import library.FFPROBE;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FFMPEG
extends Shutter {
    public static int dureeTotale = 0;
    public static boolean error = false;
    public static boolean isRunning = false;
    public static BufferedWriter writer;
    public static Thread runProcess;
    public static Process process;
    public static String analyseLufs;
    public static Float mseSensibility;
    public static float newVolume;
    public static StringBuilder shortTermValues;
    public static StringBuilder blackFrame;
    public static StringBuilder mediaOfflineFrame;
    public static String inPoint;
    public static String outPoint;
    public static String postInPoint;
    private static boolean firstInput;
    public static int firstScreenIndex;
    public static StringBuilder videoDevices;
    public static StringBuilder audioDevices;
    public static int differenceMax;
    private static int frame0;
    private static long time;
    public static long elapsedTime;
    public static int previousElapsedTime;
    private static int fps;
    private static StringBuilder getAll;

    static {
        runProcess = new Thread();
        mseSensibility = Float.valueOf(800.0f);
        inPoint = "";
        outPoint = "";
        postInPoint = "";
        firstInput = true;
        firstScreenIndex = 0;
        frame0 = 0;
        time = 0L;
        elapsedTime = 0L;
        previousElapsedTime = 0;
        fps = 0;
    }

    public static void run(final String cmd) {
        time = 0L;
        fps = 0;
        elapsedTime = System.currentTimeMillis() - (long)previousElapsedTime;
        error = false;
        firstInput = true;
        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none") + " " + cmd.replace("-y", "-threads " + Settings.txtThreads.getText() + " -y") + System.lineSeparator() + System.lineSeparator());
        getAll = new StringBuilder();
        if (saveCode) {
            if (!cmd.contains("-pass 2")) {
                FFMPEG.saveToXML(cmd);
            }
        } else if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && RenderQueue.btnStartRender.isEnabled() && !cmd.contains("preview.bmp") && !cmd.contains("logo.png")) {
            if (lblEncodageEnCours.getText().equals(Shutter.language.getProperty("lblEncodageEnCours"))) {
                lblEncodageEnCours.setText(RenderQueue.tableRow.getValueAt(RenderQueue.tableRow.getRowCount() - 1, 0).toString());
            }
            if (!caseChangeFolder1.isSelected()) {
                lblDestination1.setText(Shutter.language.getProperty("sameAsSource"));
            }
            if (caseChangeFolder3.isSelected() && caseChangeFolder2.isSelected()) {
                RenderQueue.tableRow.addRow(new Object[]{lblEncodageEnCours.getText(), "ffmpeg" + FFMPEG.checkList(cmd), String.valueOf(lblDestination1.getText()) + " | " + lblDestination2.getText() + " | " + lblDestination3.getText()});
            } else if (caseChangeFolder2.isSelected()) {
                RenderQueue.tableRow.addRow(new Object[]{lblEncodageEnCours.getText(), "ffmpeg" + FFMPEG.checkList(cmd), String.valueOf(lblDestination1.getText()) + " | " + lblDestination2.getText()});
            } else {
                RenderQueue.tableRow.addRow(new Object[]{lblEncodageEnCours.getText(), "ffmpeg" + FFMPEG.checkList(cmd), lblDestination1.getText()});
            }
            lblEncodageEnCours.setText(Shutter.language.getProperty("lblEncodageEnCours"));
        } else {
            isRunning = true;
            if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                FFMPEG.disableAll();
            }
            runProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            String line;
                            ProcessBuilder processFFMPEG;
                            String aspect;
                            String codec;
                            String pipe;
                            String PathToFFMPEG;
                            if (System.getProperty("os.name").contains("Windows")) {
                                PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                                PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                                PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                                pipe = "";
                                if (cmd.contains("pipe:play")) {
                                    PathToFFMPEG = "Library\\ffmpeg.exe";
                                    codec = "";
                                    if (comboFonctions.getSelectedItem().equals("QT Animation")) {
                                        codec = " -vcodec qtrle";
                                    }
                                    aspect = "";
                                    if (caseForcerDAR.isSelected()) {
                                        aspect = ",setdar=" + comboDAR.getSelectedItem().toString().replace(":", "/");
                                    }
                                    pipe = " | " + PathToFFMPEG.replace("ffmpeg", "ffplay") + " -loglevel quiet -x 320 -y 180 -alwaysontop -autoexit -an -vf setpts=FRAME_RATE" + aspect + " -i " + '\"' + "pipe:play" + '\"' + codec + " -window_title " + '\"' + Shutter.language.getProperty("viewEncoding") + '\"';
                                    process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", String.valueOf(PathToFFMPEG) + " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none") + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG).replace("-y", "-threads " + Settings.txtThreads.getText() + " -y") + pipe});
                                } else if (cmd.contains("pipe:stab") || comboFonctions.getSelectedItem().equals(language.getProperty("functionPicture")) || comboFonctions.getSelectedItem().toString().equals("JPEG") || (caseForcerDAR.isSelected() && grpAdvanced.isVisible() || caseAddOverlay.isSelected() && grpOverlay.isVisible() || caseColor.isSelected() && grpLUTs.isVisible() || caseLUTs.isSelected() && grpLUTs.isVisible() || caseColormatrix.isSelected() && comboInColormatrix.getSelectedItem().toString().equals("HDR") && grpLUTs.isVisible() || caseDeflicker.isSelected() && grpCorrections.isVisible()) && !caseDisplay.isSelected()) {
                                    PathToFFMPEG = "Library\\ffmpeg.exe";
                                    process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", String.valueOf(PathToFFMPEG) + " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none") + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG).replace("-y", "-threads " + Settings.txtThreads.getText() + " -y")});
                                } else {
                                    processFFMPEG = new ProcessBuilder(String.valueOf('\"') + PathToFFMPEG + '\"' + " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none") + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG).replace("-y", "-threads " + Settings.txtThreads.getText() + " -y"));
                                    process = processFFMPEG.start();
                                }
                            } else {
                                PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                                PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                                PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                                pipe = "";
                                if (cmd.contains("pipe:play")) {
                                    codec = "";
                                    if (comboFonctions.getSelectedItem().equals("QT Animation")) {
                                        codec = " -vcodec qtrle";
                                    }
                                    aspect = "";
                                    if (caseForcerDAR.isSelected()) {
                                        aspect = ",setdar=" + comboDAR.getSelectedItem().toString().replace(":", "/");
                                    }
                                    pipe = " | " + PathToFFMPEG.replace("ffmpeg", "ffplay") + " -loglevel quiet -x 320 -y 180 -alwaysontop -autoexit -an -vf setpts=FRAME_RATE" + aspect + " -i " + '\"' + "pipe:play" + '\"' + codec + " -window_title " + '\"' + Shutter.language.getProperty("viewEncoding") + '\"';
                                }
                                processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none") + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG).replace("-y", "-threads " + Settings.txtThreads.getText() + " -y") + pipe);
                                process = processFFMPEG.start();
                            }
                            BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            OutputStream stdin = process.getOutputStream();
                            writer = new BufferedWriter(new OutputStreamWriter(stdin));
                            while ((line = input.readLine()) != null) {
                                getAll.append(line);
                                getAll.append(System.lineSeparator());
                                Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                                if (line.contains("Invalid data found when processing input") || line.contains("No such file or directory") || line.contains("Invalid data found") || line.contains("No space left") || line.contains("does not contain any stream") || line.contains("Invalid argument") || line.contains("Error opening filters!") || line.contains("matches no streams") || line.contains("Error while opening encoder") || line.contains("Decoder (codec none) not found") || line.contains("Unknown encoder") || line.contains("Could not set video options") || line.contains("Input/output error") || line.contains("Operation not permitted")) {
                                    error = true;
                                }
                                if (cancelled) break;
                                if (cmd.contains("-pass 2")) {
                                    FFMPEG.Progression(line, true);
                                    continue;
                                }
                                FFMPEG.Progression(line, false);
                            }
                            process.waitFor();
                            if (!cancelled) {
                                FFMPEG.postAnalyse();
                            }
                        }
                        catch (IOException PathToFFMPEG) {
                            isRunning = false;
                            caseRunInBackground.setEnabled(false);
                            caseDisplay.setEnabled(true);
                        }
                        catch (InterruptedException e) {
                            error = true;
                            isRunning = false;
                            caseRunInBackground.setEnabled(false);
                            caseDisplay.setEnabled(true);
                        }
                    }
                    finally {
                        isRunning = false;
                        caseRunInBackground.setEnabled(false);
                        caseDisplay.setEnabled(true);
                    }
                }
            });
            runProcess.start();
        }
    }

    private static String checkList(String cmd) {
        if (cmd.contains("pass 2")) {
            return RenderQueue.tableRow.getValueAt(RenderQueue.tableRow.getRowCount() - 1, 1).toString().replace("ffmpeg", "").replace("pass 1", "pass 2");
        }
        String cmdFinale = cmd;
        String[] s = cmd.split("\"");
        String cmdFile = s[s.length - 1];
        int n = 0;
        int i = 0;
        while (i < RenderQueue.tableRow.getRowCount()) {
            String[] s2 = RenderQueue.tableRow.getValueAt(i, 1).toString().split("\"");
            String renduFile = s2[s2.length - 1];
            if (cmdFile.equals(renduFile)) {
                String[] s3 = cmd.split("\"");
                String ext = cmdFile.substring(cmdFile.lastIndexOf("."), cmdFile.lastIndexOf(".") + 4);
                String originalCmdFile = s3[s3.length - 1];
                cmdFile = originalCmdFile.replace(ext, "_" + ++n + ext);
            }
            ++i;
        }
        String[] s4 = cmd.split("\"");
        cmdFinale = cmd.replace(s4[s4.length - 1], cmdFile);
        return cmdFinale;
    }

    public static void toFFPLAY(final String cmd) {
        error = false;
        frame.setCursor(Cursor.getPredefinedCursor(3));
        isRunning = true;
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        String line;
                        ProcessBuilder processFFMPEG;
                        String PathToFFMPEG;
                        File file = fileList.getSelectedIndices().length == 0 ? new File((String)liste.firstElement()) : new File((String)fileList.getSelectedValue());
                        String fullscreen = "";
                        if (ColorImage.frame != null && ColorImage.frame.isVisible()) {
                            fullscreen = " -fs";
                        }
                        if (System.getProperty("os.name").contains("Windows")) {
                            PathToFFMPEG = "Library\\ffmpeg.exe";
                            processFFMPEG = new ProcessBuilder("cmd.exe", "/c", String.valueOf(PathToFFMPEG) + " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none") + " " + cmd + " " + PathToFFMPEG.replace("ffmpeg", "ffplay") + fullscreen + " -i " + '\"' + "pipe:play" + '\"' + " -window_title " + '\"' + file.getName() + '\"');
                        } else {
                            PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                            PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                            processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none") + " " + cmd + " " + PathToFFMPEG.replace("ffmpeg", "ffplay") + fullscreen + " -i " + '\"' + "pipe:play" + '\"' + " -window_title " + '\"' + file.getName() + '\"');
                        }
                        Console.consoleFFPLAY.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " " + PathToFFMPEG + " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none") + " " + cmd + " " + PathToFFMPEG.replace("ffmpeg", "ffplay") + fullscreen + " -i " + '\"' + "pipe:play" + '\"' + " -window_title " + '\"' + file.getName() + '\"' + System.lineSeparator() + System.lineSeparator());
                        process = processFFMPEG.start();
                        BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        while ((line = input.readLine()) != null) {
                            Console.consoleFFPLAY.append(String.valueOf(line) + System.lineSeparator());
                            if (line.contains("Invalid data found when processing input") || line.contains("No such file or directory") || line.contains("Invalid data found") || line.contains("No space left") || line.contains("does not contain any stream") || line.contains("Invalid argument") || line.contains("Error opening filters!") || line.contains("matches no streams") || line.contains("Error while opening encoder") || line.contains("Decoder (codec none) not found") || line.contains("Unknown encoder") || line.contains("Could not set video options") || line.contains("Input/output error") || line.contains("Operation not permitted")) {
                                error = true;
                            }
                            if (!line.contains("frame")) continue;
                            frame.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        process.waitFor();
                    }
                    catch (IOException PathToFFMPEG) {
                        isRunning = false;
                    }
                    catch (InterruptedException e) {
                        error = true;
                        isRunning = false;
                    }
                }
                finally {
                    isRunning = false;
                }
            }
        });
        runProcess.start();
    }

    public static void hwaccel(final String cmd) {
        error = false;
        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " " + cmd + System.lineSeparator() + System.lineSeparator());
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessBuilder processFFMPEG;
                    String PathToFFMPEG;
                    if (System.getProperty("os.name").contains("Windows")) {
                        PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                        PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                        processFFMPEG = new ProcessBuilder(String.valueOf('\"') + PathToFFMPEG + '\"' + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                        process = processFFMPEG.start();
                    } else {
                        PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                        PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                        processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                        process = processFFMPEG.start();
                    }
                    if (cmd.contains("-hwaccels")) {
                        String line;
                        StringBuilder hwaccels = new StringBuilder();
                        InputStreamReader isr = new InputStreamReader(process.getInputStream());
                        BufferedReader br = new BufferedReader(isr);
                        hwaccels.append("auto" + System.lineSeparator());
                        while ((line = br.readLine()) != null) {
                            if (line.contains("Hardware acceleration methods") || line.equals("") || line == null) continue;
                            Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                            hwaccels.append(String.valueOf(line) + System.lineSeparator());
                        }
                        hwaccels.append(language.getProperty("aucun"));
                        Settings.comboGPU = new JComboBox<String>(hwaccels.toString().split(System.lineSeparator()));
                    } else {
                        String line;
                        BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        while ((line = input.readLine()) != null) {
                            Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                            if (!line.contains("Invalid data found when processing input") && !line.contains("No such file or directory") && !line.contains("Invalid data found") && !line.contains("No space left") && !line.contains("does not contain any stream") && !line.contains("Invalid argument") && !line.contains("Error opening filters!") && !line.contains("matches no streams") && !line.contains("Error while opening encoder") && !line.contains("Decoder (codec none) not found") && !line.contains("Unknown encoder") && !line.contains("Could not set video options") && !line.contains("Input/output error") && !line.contains("Operation not permitted")) continue;
                            error = true;
                        }
                    }
                    process.waitFor();
                }
                catch (IOException PathToFFMPEG) {
                }
                catch (InterruptedException e) {
                    error = true;
                }
            }
        });
        runProcess.start();
    }

    public static void devices(final String cmd) {
        error = false;
        isRunning = true;
        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " " + cmd + System.lineSeparator() + System.lineSeparator());
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        String line;
                        ProcessBuilder processFFMPEG;
                        String PathToFFMPEG;
                        if (System.getProperty("os.name").contains("Windows")) {
                            PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                            PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                            processFFMPEG = new ProcessBuilder(String.valueOf('\"') + PathToFFMPEG + '\"' + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                            process = processFFMPEG.start();
                        } else {
                            PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                            PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                            processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                            process = processFFMPEG.start();
                        }
                        BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        boolean isVideoDevices = false;
                        boolean isAudioDevices = false;
                        if (!cmd.contains("openal")) {
                            videoDevices = new StringBuilder();
                            videoDevices.append(language.getProperty("noVideo"));
                        }
                        audioDevices = new StringBuilder();
                        audioDevices.append(language.getProperty("noAudio"));
                        while ((line = input.readLine()) != null) {
                            String[] s;
                            Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                            if (cmd.contains("avfoundation") && line.contains("]")) {
                                if (isAudioDevices) {
                                    s = line.split("\\]");
                                    audioDevices.append(":" + s[2].substring(1, s[2].length()));
                                }
                                if (line.contains("AVFoundation audio devices")) {
                                    isAudioDevices = true;
                                }
                                if (isVideoDevices && !line.contains("Capture screen") && !isAudioDevices) {
                                    s = line.split("\\]");
                                    videoDevices.append(":" + s[2].substring(1, s[2].length()));
                                }
                                if (line.contains("AVFoundation video devices")) {
                                    isVideoDevices = true;
                                }
                            }
                            if (cmd.contains("avfoundation") && line.contains("Capture screen")) {
                                s = line.split("\\[");
                                String[] s2 = s[2].split("\\]");
                                firstScreenIndex = Integer.parseInt(s2[0]);
                            }
                            if (cmd.contains("dshow")) {
                                if (line.contains("DirectShow audio devices")) {
                                    isAudioDevices = true;
                                } else if (isAudioDevices && line.contains("\"") && !line.contains("Alternative name")) {
                                    s = line.split("\"");
                                    audioDevices.append(":" + s[1]);
                                }
                                if (line.contains("DirectShow video devices")) {
                                    isVideoDevices = true;
                                } else if (isVideoDevices && line.contains("\"") && !line.contains("Alternative name") && !isAudioDevices) {
                                    s = line.split("\"");
                                    videoDevices.append(":" + s[1]);
                                }
                            }
                            if (!line.contains("Invalid data found when processing input") && !line.contains("No such file or directory") && !line.contains("Invalid data found") && !line.contains("No space left") && !line.contains("does not contain any stream") && !line.contains("Invalid argument") && !line.contains("Error opening filters!") && !line.contains("matches no streams") && !line.contains("Error while opening encoder") && !line.contains("Decoder (codec none) not found") && !line.contains("Unknown encoder") && !line.contains("Could not set video options") && !line.contains("Input/output error") && !line.contains("Operation not permitted")) continue;
                            error = true;
                        }
                        process.waitFor();
                    }
                    catch (IOException PathToFFMPEG) {
                        isRunning = false;
                    }
                    catch (InterruptedException e) {
                        error = true;
                        isRunning = false;
                    }
                }
                finally {
                    isRunning = false;
                }
            }
        });
        runProcess.start();
    }

    private static void saveToXML(String cmd) {
        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("saveSettings"), 1);
        dialog.setDirectory(Functions.fonctionsFolder.toString());
        dialog.setLocation(FFMPEG.frame.getLocation().x - 50, FFMPEG.frame.getLocation().y + 50);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        if (dialog.getFile() != null) {
            try {
                DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element root = document.createElement("Shutter");
                document.appendChild(root);
                Element settings = document.createElement("settings");
                root.appendChild(settings);
                Attr attr = document.createAttribute("id");
                attr.setValue("10");
                settings.setAttributeNode(attr);
                String[] split = cmd.split("\"");
                String entree = split[1];
                int i = 0;
                while (++i < split.length) {
                }
                String sortie = split[i - 1];
                Element firstName = document.createElement("command");
                firstName.appendChild(document.createTextNode("ffmpeg" + cmd.replace(inPoint, "").replace(" -i ", "").replace(String.valueOf('\"') + entree + '\"', "").replace(String.valueOf('\"') + sortie + '\"', "").replace(" -y ", "").replace(" -n ", "")));
                settings.appendChild(firstName);
                Element lastname = document.createElement("pointIn");
                lastname.appendChild(document.createTextNode(inPoint));
                settings.appendChild(lastname);
                String ext = cmd.substring(cmd.lastIndexOf("."));
                Element email = document.createElement("extension");
                email.appendChild(document.createTextNode(ext.replace("\"", "")));
                settings.appendChild(email);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource domSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(new File(String.valueOf(dialog.getDirectory()) + dialog.getFile().toString().replace(".enc", "")) + ".enc");
                transformer.transform(domSource, streamResult);
            }
            catch (ParserConfigurationException | TransformerException exception) {
                // empty catch block
            }
        }
    }

    public static void suspendProcess() {
        try {
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                Runtime.getRuntime().exec("kill -SIGSTOP " + process.pid());
            } else {
                String pausep = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pausep = pausep.substring(1, pausep.length() - 1);
                pausep = String.valueOf('\"') + pausep.substring(0, pausep.lastIndexOf("/")).replace("%20", " ") + "/Library/pausep.exe" + '\"';
                Runtime.getRuntime().exec(String.valueOf(pausep) + " " + process.pid());
            }
            if (System.getProperty("os.name").contains("Windows") && Taskbar.isTaskbarSupported()) {
                Taskbar.getTaskbar().setWindowProgressState(frame, Taskbar.State.PAUSED);
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException exception) {
            // empty catch block
        }
    }

    public static void resumeProcess() {
        try {
            elapsedTime = System.currentTimeMillis() - (long)previousElapsedTime;
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                Runtime.getRuntime().exec("kill -SIGCONT " + process.pid());
            } else {
                String pausep = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pausep = pausep.substring(1, pausep.length() - 1);
                pausep = String.valueOf('\"') + pausep.substring(0, pausep.lastIndexOf("/")).replace("%20", " ") + "/Library/pausep.exe" + '\"';
                Runtime.getRuntime().exec(String.valueOf(pausep) + " " + process.pid() + " /r");
            }
            if (System.getProperty("os.name").contains("Windows") && Taskbar.isTaskbarSupported()) {
                Taskbar.getTaskbar().setWindowProgressState(frame, Taskbar.State.NORMAL);
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException exception) {
            // empty catch block
        }
    }

    public static String setConcat(File file, String sortie) {
        String extension = file.toString().substring(file.toString().lastIndexOf("."));
        File listeBAB = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + file.getName().replace(extension, ".txt"));
        if (VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
            block5: {
                try {
                    PrintWriter writer = new PrintWriter(listeBAB.toString(), "UTF-8");
                    DecimalFormat formatter = new DecimalFormat("00");
                    DecimalFormat formatFrame = new DecimalFormat("000");
                    int h = Integer.parseInt(VideoPlayer.caseInH.getText());
                    int m = Integer.parseInt(VideoPlayer.caseInM.getText());
                    int s = Integer.parseInt(VideoPlayer.caseInS.getText());
                    int f = (int)((float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                    writer.println("file '" + file + "'");
                    writer.println("outpoint " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f));
                    h = Integer.parseInt(VideoPlayer.caseOutH.getText());
                    m = Integer.parseInt(VideoPlayer.caseOutM.getText());
                    s = Integer.parseInt(VideoPlayer.caseOutS.getText());
                    f = (int)((float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                    writer.println("file '" + file + "'");
                    writer.println("inpoint " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f));
                    inPoint = "";
                    postInPoint = "";
                    outPoint = "";
                    writer.close();
                }
                catch (FileNotFoundException | UnsupportedEncodingException e) {
                    error = true;
                    if (!listeBAB.exists()) break block5;
                    listeBAB.delete();
                }
            }
            return " -safe 0 -f concat";
        }
        if (Settings.btnSetBab.isSelected()) {
            FFMPEG.setBAB(file.getName(), extension, sortie);
            if (!caseEnableSequence.isSelected()) {
                return " -safe 0 -f concat";
            }
        }
        return "";
    }

    protected static void setBAB(String fichier, String extension, String sortie) {
        block14: {
            File listeBAB = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
            try {
                int dureeTotale = 0;
                frame.setCursor(Cursor.getPredefinedCursor(3));
                PrintWriter writer = new PrintWriter(listeBAB, "UTF-8");
                int i = 0;
                while (i < liste.getSize()) {
                    if (Settings.btnWaitFileComplete.isSelected()) {
                        File file = new File((String)liste.getElementAt(i));
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    FFPROBE.Data((String)liste.getElementAt(i));
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (FFPROBE.isRunning);
                    dureeTotale += FFPROBE.totalLength;
                    writer.println("file '" + (String)liste.getElementAt(i) + "'");
                    ++i;
                }
                writer.close();
                frame.setCursor(Cursor.getPredefinedCursor(0));
                progressBar1.setMaximum(dureeTotale / 1000);
                FFPROBE.totalLength = progressBar1.getMaximum();
                FFMPEG.dureeTotale = progressBar1.getMaximum();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
                error = true;
                if (!listeBAB.exists()) break block14;
                listeBAB.delete();
            }
        }
    }

    public static void fonctionInOut() throws InterruptedException {
        if (caseInAndOut.isSelected()) {
            if (VideoPlayer.caseTcInterne.isSelected()) {
                VideoPlayer.caseTcInterne.doClick();
            }
            int h = Integer.parseInt(VideoPlayer.caseInH.getText());
            int m = Integer.parseInt(VideoPlayer.caseInM.getText());
            int s = Integer.parseInt(VideoPlayer.caseInS.getText());
            int f = (int)((float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
            DecimalFormat formatter = new DecimalFormat("00");
            DecimalFormat formatFrame = new DecimalFormat("000");
            if (VideoPlayer.sliderIn.getValue() > VideoPlayer.sliderIn.getMinimum() && !Shutter.comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionCut")) && !Shutter.comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionRewrap"))) {
                if (h > 0 && m == 0 && s < 10) {
                    --h;
                    m = 59;
                    s = 50 + Integer.parseInt(VideoPlayer.caseInS.getText());
                    postInPoint = " -ss 00:00:10.000";
                    FFPROBE.timecode3 = String.valueOf(Integer.parseInt(OverlayWindow.TC3.getText()) - 10);
                } else if (m > 0 && s < 10) {
                    --m;
                    s = 50 + Integer.parseInt(VideoPlayer.caseInS.getText());
                    postInPoint = " -ss 00:00:10.000";
                    FFPROBE.timecode3 = String.valueOf(Integer.parseInt(OverlayWindow.TC3.getText()) - 10);
                } else if (s < 10) {
                    postInPoint = " -ss " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f);
                } else if (s >= 10) {
                    s -= 10;
                    postInPoint = " -ss 00:00:10.000";
                    FFPROBE.timecode3 = String.valueOf(Integer.parseInt(OverlayWindow.TC3.getText()) - 10);
                }
            } else {
                postInPoint = "";
            }
            inPoint = Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000 + Integer.parseInt(VideoPlayer.caseInF.getText()) > 10000 || Shutter.comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionCut")) || Shutter.comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionRewrap")) ? " -ss " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f) : "";
            outPoint = VideoPlayer.sliderOut.getValue() != VideoPlayer.sliderOut.getMaximum() ? " -t " + formatter.format(VideoPlayer.dureeHeures) + ":" + formatter.format(VideoPlayer.dureeMinutes) + ":" + formatter.format(VideoPlayer.dureeSecondes) + "." + formatFrame.format((float)(VideoPlayer.dureeImages * 1000) / FFPROBE.currentFPS) : "";
        } else {
            postInPoint = "";
            inPoint = "";
            outPoint = "";
        }
    }

    public static void Progression(String line, boolean pass2) {
        String ffmpegTime;
        String[] split;
        String str;
        if (line.contains("Input #1")) {
            firstInput = false;
        }
        if (line.contains("Duration") && !line.contains("Duration: N/A") && !line.contains("<Duration>") && firstInput) {
            float newFPS;
            str = line.substring(line.indexOf(":") + 2);
            split = str.split(",");
            ffmpegTime = split[0].replace(".", ":");
            dureeTotale = caseEnableSequence.isSelected() ? (int)((float)liste.getSize() / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", "."))) : (caseInAndOut.isSelected() ? VideoPlayer.dureeHeures * 3600 + VideoPlayer.dureeMinutes * 60 + VideoPlayer.dureeSecondes : FFMPEG.CalculTemps(ffmpegTime));
            if (caseConform.isSelected()) {
                newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
                if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed"))) {
                    dureeTotale = (int)((float)dureeTotale * (FFPROBE.currentFPS / newFPS));
                } else if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
                    dureeTotale = (int)((float)dureeTotale * (newFPS / FFPROBE.currentFPS));
                }
            }
            if (comboFonctions.getSelectedItem().toString().equals("functionConform")) {
                newFPS = Float.parseFloat(comboFilter.getSelectedItem().toString().replace(" i/s", "").replace(",", "."));
                dureeTotale = (int)((float)dureeTotale * (FFPROBE.currentFPS / newFPS));
            }
            if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
                dureeTotale = 1;
            }
            if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("OGV") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && DVD.multiplesPass) {
                dureeTotale *= 2;
            }
            if (!comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionInsert"))) {
                progressBar1.setMaximum(dureeTotale);
            }
        }
        if (line.contains("time=")) {
            error = false;
            str = line.substring(line.indexOf(":") - 2);
            split = str.split("b");
            ffmpegTime = split[0].replace(".", ":").replace(" ", "");
            if (progressBar1.getString().equals("NaN") || inputDeviceIsRunning) {
                progressBar1.setStringPainted(false);
            } else {
                progressBar1.setStringPainted(true);
            }
            if (pass2) {
                progressBar1.setValue(dureeTotale / 2 + FFMPEG.CalculTemps(ffmpegTime));
            } else {
                progressBar1.setValue(FFMPEG.CalculTemps(ffmpegTime));
            }
        }
        previousElapsedTime = (int)(System.currentTimeMillis() - elapsedTime);
        int timeH = previousElapsedTime / 3600000 % 60;
        int timeMin = previousElapsedTime / 60000 % 60;
        int timeSec = previousElapsedTime / 1000 % 60;
        String heures = "";
        String minutes = "";
        String secondes = "";
        heures = timeH >= 1 ? String.valueOf(timeH) + "h " : "";
        minutes = timeMin >= 1 ? String.valueOf(timeMin) + "min " : "";
        secondes = timeSec > 0 ? String.valueOf(timeSec) + "sec" : "0sec";
        tempsEcoule.setText(String.valueOf(Shutter.language.getProperty("tempsEcoule")) + " " + heures + minutes + secondes);
        if ((line.contains("frame=") || line.contains("time=")) && !comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
            String[] split2 = line.split("=");
            int frames = 0;
            if (line.contains("frame=")) {
                frames = Integer.parseInt(split2[1].replace("fps", "").replace(" ", ""));
            } else if (line.contains("time=")) {
                String[] rawTime = split2[2].split(" ");
                String timecode = rawTime[0].replace(".", ":");
                String[] time = timecode.split(":");
                int h = Integer.parseInt(time[0]);
                int m = Integer.parseInt(time[1]);
                int s = Integer.parseInt(time[2]);
                int fps = Integer.parseInt(time[3]);
                frames = (int)((float)(h * 3600) * FFPROBE.currentFPS + (float)(m * 60) * FFPROBE.currentFPS + (float)s * FFPROBE.currentFPS + (float)fps);
            }
            if (time == 0L) {
                frame0 = frames;
                time = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - time >= 1000L && frames - frame0 > 0) {
                int total;
                if (fps == 0) {
                    fps = frames - frame0;
                } else if (frames - frame0 < fps - 100 || frames - frame0 > fps + 100) {
                    fps = frames - frame0;
                } else if (frames - frame0 > fps + 1) {
                    ++fps;
                } else if (frames - frame0 < fps - 1 && fps > 1) {
                    --fps;
                }
                time = 0L;
                if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("OGV") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && DVD.multiplesPass) {
                    total = (int)((float)(dureeTotale / 2) * FFPROBE.currentFPS);
                } else if (caseConform.isSelected() && !comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) && !caseForcerEntrelacement.isSelected()) {
                    float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
                    total = (int)((float)dureeTotale * FFPROBE.currentFPS * (newFPS / FFPROBE.currentFPS));
                } else {
                    total = (int)((float)dureeTotale * FFPROBE.currentFPS);
                }
                int restant = (total - frames) / fps;
                if (!(comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture")) || comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSceneDetection")) || comboFonctions.getSelectedItem().equals("Synchronisation automatique"))) {
                    String pass = "";
                    if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("OGV") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && DVD.multiplesPass) {
                        pass = !pass2 ? " - " + Shutter.language.getProperty("firstPass") : " - " + Shutter.language.getProperty("secondPass");
                    }
                    timeH = restant / 3600 % 60;
                    timeMin = restant / 60 % 60;
                    timeSec = restant % 60;
                    heures = timeH >= 1 ? String.valueOf(timeH) + "h " : "";
                    minutes = timeMin >= 1 ? String.valueOf(timeMin) + "min " : "";
                    secondes = timeSec > 0 ? String.valueOf(timeSec) + "sec" : "";
                    tempsRestant.setText(String.valueOf(Shutter.language.getProperty("tempsRestant")) + " " + heures + minutes + secondes + pass);
                    if (heures != "" || minutes != "" || secondes != "") {
                        tempsRestant.setVisible(true);
                    } else {
                        tempsRestant.setVisible(false);
                    }
                }
            }
        } else if (line.contains("frame=") && !caseDisplay.isSelected()) {
            tempsEcoule.setVisible(true);
        }
        if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSceneDetection")) && line.contains("pts")) {
            DecimalFormat formatter = new DecimalFormat("00");
            String[] rawline = line.split(":");
            String[] fullTime = rawline[3].split(" ");
            int rawTime = (int)(Float.valueOf(fullTime[0]).floatValue() * 1000.0f);
            String h = formatter.format(rawTime / 3600000);
            String m = formatter.format(rawTime / 60000 % 60);
            String s = formatter.format(rawTime / 1000 % 60);
            String f = formatter.format((int)((float)rawTime / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS));
            File imageName = new File(SceneDetection.sortieDossier + "/" + SceneDetection.tableRow.getRowCount() + ".png");
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!imageName.exists());
            ImageIcon imageIcon = new ImageIcon(imageName.toString());
            ImageIcon icon = new ImageIcon(imageIcon.getImage().getScaledInstance(142, 80, 1));
            SceneDetection.tableRow.addRow(new Object[]{SceneDetection.tableRow.getRowCount() + 1, icon, String.valueOf(h) + ":" + m + ":" + s + ":" + f});
            SceneDetection.scrollPane.getVerticalScrollBar().setValue(SceneDetection.scrollPane.getVerticalScrollBar().getMaximum());
            SceneDetection.table.repaint();
        }
    }

    private static void postAnalyse() {
        DecimalFormat formatter;
        Object shortTermTC;
        if (comboFonctions.getSelectedItem().toString().equals("Loudness & True Peak") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionNormalization"))) {
            analyseLufs = null;
            analyseLufs = getAll.toString().substring(getAll.toString().lastIndexOf("Summary:") + 12);
            shortTermValues = new StringBuilder();
            float momentaryTerm = -1000.0f;
            String momentaryTermTC = "";
            float shortTerm = -1000.0f;
            shortTermTC = "";
            String[] stringArray = getAll.toString().split(System.lineSeparator());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String allValues = stringArray[n2];
                if (allValues.contains("Parsed_ebur128") && !allValues.contains("Summary:")) {
                    String[] spliter = allValues.split(":");
                    DecimalFormat round = new DecimalFormat("0.##");
                    String[] splitTime = spliter[1].split(" ");
                    int temps = (int)(Float.parseFloat(round.format(Double.valueOf(splitTime[1].replace(",", ""))).replace(",", ".")) * 1000.0f);
                    formatter = new DecimalFormat("00");
                    String h = formatter.format(temps / 3600000);
                    String m = formatter.format(temps / 60000 % 60);
                    String s = formatter.format(temps / 1000 % 60);
                    String f = formatter.format((int)((float)temps / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS));
                    String timecode = String.valueOf(h) + ":" + m + ":" + s + ":" + f;
                    String values = allValues.substring(allValues.indexOf("M"));
                    String[] v = values.split(":");
                    try {
                        float S;
                        float M = Float.parseFloat(v[1].replace(" S", ""));
                        if (M > momentaryTerm) {
                            momentaryTerm = M;
                            momentaryTermTC = timecode;
                        }
                        if ((S = Float.parseFloat(v[2].replace("     I", ""))) > shortTerm) {
                            shortTerm = S;
                            shortTermTC = timecode;
                        }
                        if ((double)S > -16.0) {
                            shortTermValues.append(String.valueOf(timecode) + ": Short-term: " + S + " LUFS" + System.lineSeparator());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "  Momentary max: " + momentaryTerm + " LUFS";
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "    Timecode:     " + momentaryTermTC;
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator();
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "  Short-term max: " + shortTerm + " LUFS";
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "    Timecode:     " + (String)shortTermTC;
            if (shortTermValues.length() == 0) {
                shortTermValues.append(Shutter.language.getProperty("shortTerm"));
            }
            if (lblEncodageEnCours.getText().contains(Shutter.language.getProperty("analyzing"))) {
                String[] lufs = analyseLufs.split(":");
                String[] lufsFinal = lufs[2].split("L");
                String[] db = comboFilter.getSelectedItem().toString().split(" ");
                newVolume = Float.parseFloat(db[0]) - Float.parseFloat(lufsFinal[0].replace(" ", ""));
            }
        }
        if (comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionBlackDetection"))) {
            blackFrame = new StringBuilder();
            shortTermTC = getAll.toString().split(System.lineSeparator());
            int shortTerm = ((String[])shortTermTC).length;
            int momentaryTermTC = 0;
            while (momentaryTermTC < shortTerm) {
                float maxDuration;
                String blackdetect;
                String[] d;
                float duration;
                String blackLine = shortTermTC[momentaryTermTC];
                if (blackLine.contains("blackdetect") && (duration = Float.parseFloat((d = (blackdetect = blackLine.substring(blackLine.indexOf("black_start"))).split(":"))[3])) <= (maxDuration = (float)Integer.parseInt(Settings.txtBlackDetection.getText()) / FFPROBE.currentFPS)) {
                    String blackstart = d[1].replace(" black_end", "");
                    String[] bsDuree = blackstart.split("\\.");
                    int secondes = Integer.valueOf(bsDuree[0]);
                    int images = 0;
                    formatter = new DecimalFormat("00");
                    String tcBlackFrame = String.valueOf(formatter.format(secondes / 3600)) + ":" + formatter.format(secondes / 60 % 60) + ":" + formatter.format(secondes % 60);
                    switch (bsDuree[1].length()) {
                        case 1: {
                            images = Integer.valueOf(bsDuree[1]) * 100;
                            break;
                        }
                        case 2: {
                            images = Integer.valueOf(bsDuree[1]) * 10;
                            break;
                        }
                        case 3: {
                            images = Integer.valueOf(bsDuree[1]);
                        }
                    }
                    tcBlackFrame = String.valueOf(tcBlackFrame) + ":" + formatter.format((int)((float)images / (1000.0f / FFPROBE.currentFPS)));
                    blackFrame.append(String.valueOf(tcBlackFrame) + System.lineSeparator());
                }
                ++momentaryTermTC;
            }
        }
        if (comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionOfflineDetection"))) {
            mediaOfflineFrame = new StringBuilder();
            File stats_file = System.getProperty("os.name").contains("Windows") ? new File("stats_file") : new File(String.valueOf(Shutter.dirTemp) + "stats_file");
            if (stats_file.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(stats_file.toString()));
                    boolean offline = false;
                    Float mseValue = Float.valueOf(0.0f);
                    String line = reader.readLine();
                    while (line != null) {
                        if (line.contains("mse_avg")) {
                            String[] s = line.split(":");
                            String[] m = s[2].split(" ");
                            Float mse = Float.valueOf(Float.parseFloat(m[0]));
                            String[] f = s[1].split(" ");
                            String frame = f[0];
                            int frameNumber = Integer.parseInt(frame) - 2;
                            if (mse.floatValue() <= mseSensibility.floatValue() && !offline) {
                                if (mseValue.floatValue() == mse.floatValue()) {
                                    offline = true;
                                    DecimalFormat formatter2 = new DecimalFormat("00");
                                    String tcOfflineFrame = String.valueOf(formatter2.format(Math.floor((float)frameNumber / FFPROBE.currentFPS) / 3600.0)) + ":" + formatter2.format(Math.floor((float)frameNumber / FFPROBE.currentFPS / 60.0f) % 60.0) + ":" + formatter2.format(Math.floor((float)frameNumber / FFPROBE.currentFPS) % 60.0) + ":" + formatter2.format((float)frameNumber % FFPROBE.currentFPS);
                                    mediaOfflineFrame.append(String.valueOf(tcOfflineFrame) + System.lineSeparator());
                                }
                                mseValue = mse;
                            } else if (mse.floatValue() > mseSensibility.floatValue()) {
                                offline = false;
                                mseValue = Float.valueOf(0.0f);
                            }
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                stats_file.delete();
            }
        }
    }

    public static int CalculTemps(String temps) {
        String[] time = temps.split(":");
        int heures = Integer.parseInt(time[0]);
        int minutes = Integer.parseInt(time[1]);
        int secondes = Integer.parseInt(time[2]);
        int images = Integer.parseInt(time[3]);
        images /= 40;
        int totalSecondes = heures * 3600 + minutes * 60 + secondes;
        return totalSecondes;
    }
}

