/*
 * Decompiled with CFR 0.152.
 */
package functions.video;

import application.Ftp;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.WatermarkWindow;
import application.Wetransfer;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import library.DCRAW;
import library.EXIFTOOL;
import library.FFMPEG;
import library.FFPROBE;
import library.XPDF;

public class Picture
extends Shutter {
    private static int complete;

    public static void main(final boolean encode) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = new File((String)liste.getElementAt(i));
                    if (Shutter.scanIsRunning) {
                        file = Utils.scanFolder((String)liste.getElementAt(i));
                        if (file == null) break;
                        btnStart.setEnabled(true);
                        progressBar1.setIndeterminate(false);
                    } else if (Settings.btnWaitFileComplete.isSelected()) {
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    try {
                        String fichier = file.getName();
                        lblEncodageEnCours.setText(fichier);
                        String extension = fichier.substring(fichier.lastIndexOf("."));
                        boolean isRaw = false;
                        switch (extension.toLowerCase()) {
                            case ".3fr": 
                            case ".arw": 
                            case ".cr2": 
                            case ".cr3": 
                            case ".crw": 
                            case ".dng": 
                            case ".kdc": 
                            case ".mrw": 
                            case ".nef": 
                            case ".nrw": 
                            case ".orf": 
                            case ".pef": 
                            case ".r3d": 
                            case ".ptx": 
                            case ".raf": 
                            case ".rw2": 
                            case ".srw": 
                            case ".x3f": {
                                isRaw = true;
                            }
                        }
                        if (Picture.analyse(file, extension, isRaw) && Picture.imageFilter(file)) {
                            String frameRate = Picture.setFramerate();
                            String filter = Picture.setDeinterlace(extension, isRaw);
                            String logo = Picture.setLogo();
                            filter = Picture.setWatermark(filter);
                            filter = Picture.setCrop(filter);
                            filter = Picture.setFramesize(filter);
                            filter = Picture.setRotate(filter);
                            filter = Picture.setDisplay(filter, fichier);
                            filter = Picture.setLUT(filter);
                            filter = Picture.setLevels(filter);
                            filter = Picture.setColormatrix(filter);
                            filter = Picture.setColor(filter);
                            filter = Picture.setFilterComplex(filter);
                            String flags = Picture.setFlags();
                            String colorspace = Picture.setColorspace();
                            String compression = Picture.setCompression();
                            String sortie = Picture.setSortie("", file);
                            String newExtension = Picture.setExtension();
                            String singleFrame = Picture.setFrame();
                            String sortieFichier = String.valueOf(sortie) + "/" + fichier.replace(extension, newExtension);
                            FFMPEG.fonctionInOut();
                            File fileOut = new File(sortieFichier);
                            if (!fileOut.exists() || (fileOut = Utils.fileReplacement(sortie, fichier, extension, "_", newExtension)) != null) {
                                String cmd = String.valueOf(filter) + singleFrame + colorspace + compression + flags + " -an -y ";
                                if (extension.toLowerCase().equals(".pdf")) {
                                    int p = 1;
                                    while (p < XPDF.pagesCount + 1) {
                                        int n = 1;
                                        do {
                                            fileOut = new File(String.valueOf(sortie) + "/" + fichier.replace(extension, "_" + n + newExtension));
                                            ++n;
                                        } while (fileOut.exists());
                                        if (!cancelled) {
                                            XPDF.run(" -r 300 -f " + p + " -l " + p + " " + '\"' + file.toString() + '\"' + " - | PathToFFMPEG -i -" + logo + cmd + '\"' + fileOut + '\"');
                                        }
                                        do {
                                            Thread.sleep(100L);
                                        } while (XPDF.runProcess.isAlive());
                                        ++p;
                                    }
                                    btnStart.setEnabled(true);
                                } else if (isRaw) {
                                    btnStart.setEnabled(false);
                                    DCRAW.run(" -v -w -c -q 0 -6 -g 2.4 12.92 \"" + file.toString() + '\"' + " | PathToFFMPEG -i -" + logo + cmd + '\"' + fileOut + '\"');
                                } else {
                                    FFMPEG.run(String.valueOf(FFMPEG.inPoint) + frameRate + " -i " + '\"' + file.toString() + '\"' + logo + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + '\"' + fileOut + '\"');
                                }
                                if (isRaw) {
                                    do {
                                        Thread.sleep(100L);
                                    } while (DCRAW.runProcess.isAlive());
                                    btnStart.setEnabled(true);
                                } else {
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.runProcess.isAlive());
                                }
                                if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && Picture.actionsDeFin(fichier, extension, fileOut, sortie)) {
                                    break;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && encode) {
                    Picture.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    protected static boolean analyse(File file, String extension, boolean isRaw) throws InterruptedException {
        btnStart.setEnabled(false);
        EXIFTOOL.run(file.toString());
        do {
            Thread.sleep(100L);
        } while (EXIFTOOL.isRunning);
        if (Picture.errorAnalyse(file.toString())) {
            return false;
        }
        if (!isRaw && !extension.toLowerCase().equals(".pdf")) {
            FFPROBE.FrameData(file.toString());
            do {
                Thread.sleep(100L);
            } while (FFPROBE.isRunning);
            if (Picture.errorAnalyse(file.toString())) {
                return false;
            }
            FFPROBE.Data(file.toString());
            do {
                Thread.sleep(100L);
            } while (FFPROBE.isRunning);
            if (Picture.errorAnalyse(file.toString())) {
                return false;
            }
        } else if (extension.toLowerCase().equals(".pdf")) {
            XPDF.info(file.toString());
            do {
                Thread.sleep(100L);
            } while (XPDF.isRunning);
            if (Picture.errorAnalyse(file.toString())) {
                return false;
            }
            XPDF.toFFPROBE(file.toString());
            do {
                Thread.sleep(100L);
            } while (XPDF.isRunning);
            if (Picture.errorAnalyse(file.toString())) {
                return false;
            }
        }
        return true;
    }

    protected static String setFramerate() {
        if (caseCreateSequence.isSelected()) {
            return " -r " + FFPROBE.currentFPS / Float.parseFloat(comboInterpret.getSelectedItem().toString().replace(",", "."));
        }
        return "";
    }

    protected static boolean imageFilter(File file) throws InterruptedException {
        if (caseYear.isSelected() || caseMonth.isSelected() || caseDay.isSelected() || caseFrom.isSelected()) {
            EXIFTOOL.run(file.toString());
            do {
                Thread.sleep(100L);
            } while (EXIFTOOL.isRunning);
            String[] date = EXIFTOOL.exifDate.split(":");
            if (caseYear.isSelected() && !comboYear.getSelectedItem().toString().equals(date[0])) {
                return false;
            }
            if (caseMonth.isSelected() && !comboMonth.getSelectedItem().toString().equals(date[1])) {
                return false;
            }
            if (caseDay.isSelected() && !comboDay.getSelectedItem().toString().equals(date[2])) {
                return false;
            }
            if (caseFrom.isSelected()) {
                String[] exif = EXIFTOOL.exifHours.split(":");
                String[] from = comboFrom.getSelectedItem().toString().split(":");
                String[] to = comboTo.getSelectedItem().toString().split(":");
                int eH = Integer.parseInt(exif[0]) * 60;
                int eM = Integer.parseInt(exif[1]);
                int exifTime = eH + eM;
                int fH = Integer.parseInt(from[0]) * 60;
                int fM = Integer.parseInt(from[1]);
                int fromTime = fH + fM;
                int tH = Integer.parseInt(to[0]) * 60;
                int tM = Integer.parseInt(to[1]);
                int toTime = tH + tM;
                if (exifTime < fromTime || exifTime > toTime) {
                    return false;
                }
            }
        }
        return true;
    }

    protected static String setDeinterlace(String extension, boolean isRaw) {
        if (isRaw || extension.toLowerCase().equals(".pdf")) {
            return "";
        }
        if (FFPROBE.entrelaced.equals("1")) {
            return "yadif=0:" + FFPROBE.fieldOrder + ":0";
        }
        return "";
    }

    protected static String setLogo() {
        if (caseLogo.isSelected()) {
            return " -i \"" + WatermarkWindow.logoFile + '\"';
        }
        return "";
    }

    protected static String setWatermark(String filter) {
        if (caseLogo.isSelected()) {
            filter = filter != "" ? String.valueOf(filter) + "[v];[1:v]scale=iw*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(WatermarkWindow.textOpacity.getText()) / 100.0f + "[scaledwatermark];[v][scaledwatermark]overlay=" + WatermarkWindow.textPosX.getText() + ":" + WatermarkWindow.textPosY.getText() : "[1:v]scale=iw*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(WatermarkWindow.textOpacity.getText()) / 100.0f + "[scaledwatermark];[0:v][scaledwatermark]overlay=" + WatermarkWindow.textPosX.getText() + ":" + WatermarkWindow.textPosY.getText();
        }
        return filter;
    }

    protected static String setCrop(String filter) {
        if (caseRognerImage.isSelected()) {
            filter = filter != "" ? String.valueOf(filter) + "," + cropFinal : cropFinal;
        }
        return filter;
    }

    protected static String setFramesize(String filter) {
        String frameSize = "";
        if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
            if (comboResolution.getSelectedItem().toString().contains(":")) {
                if (comboResolution.getSelectedItem().toString().contains("auto")) {
                    String[] s = comboResolution.getSelectedItem().toString().split(":");
                    frameSize = s[0].toString().equals("auto") ? "scale=-1:" + s[1] : "scale=" + s[0] + ":-1";
                } else {
                    String[] s = comboResolution.getSelectedItem().toString().split(":");
                    float number = 1.0f / (float)Integer.parseInt(s[0]);
                    frameSize = "scale=iw*" + number + ":ih*" + number;
                }
            } else {
                String[] i = FFPROBE.imageResolution.split("x");
                String[] o = comboResolution.getSelectedItem().toString().split("x");
                int iw = Integer.parseInt(i[0]);
                int ih = Integer.parseInt(i[1]);
                int ow = Integer.parseInt(o[0]);
                int oh = Integer.parseInt(o[1]);
                float ir = (float)iw / (float)ih;
                frameSize = iw > ow && ih > oh ? ((float)ow / ir >= (float)oh ? "scale=" + ow + ":-1,crop=" + "'" + ow + ":" + oh + ":0:(ih-oh)*0.5" + "'" : "scale=-1:" + oh + ",crop=" + "'" + ow + ":" + oh + ":(iw-ow)*0.5:0" + "'") : "scale=" + ow + ":" + oh;
            }
        } else if (comboFilter.getSelectedItem().toString().equals(".ico")) {
            frameSize = "scale=256x256";
        }
        if (frameSize != "") {
            filter = filter != "" ? String.valueOf(filter) + "," + frameSize : frameSize;
        }
        return filter;
    }

    protected static String setFlags() {
        return " -sws_flags " + Settings.comboScale.getSelectedItem().toString();
    }

    protected static String setRotate(String filter) {
        String rotate;
        block19: {
            block17: {
                rotate = "";
                if (!caseRotate.isSelected()) break block17;
                String transpose = "";
                switch (comboRotate.getSelectedItem().toString()) {
                    case "90": {
                        if (caseMiror.isSelected()) {
                            transpose = "transpose=3";
                            break;
                        }
                        transpose = "transpose=1";
                        break;
                    }
                    case "-90": {
                        if (caseMiror.isSelected()) {
                            transpose = "transpose=0";
                            break;
                        }
                        transpose = "transpose=2";
                        break;
                    }
                    case "180": {
                        transpose = caseMiror.isSelected() ? "transpose=1,transpose=1,hflip" : "transpose=1,transpose=1";
                    }
                }
                rotate = transpose;
                break block19;
            }
            if (caseMiror.isSelected()) {
                rotate = "hflip";
            }
        }
        if (rotate != "") {
            filter = filter != "" ? String.valueOf(filter) + "," + rotate : rotate;
        }
        return filter;
    }

    protected static String setDisplay(String filterComplex, String fichier) {
        if (caseShowDate.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",drawtext=fontfile=" + Shutter.pathToFont + ":text='" + EXIFTOOL.exifDate.replace(":", "-") + "':r=" + FFPROBE.currentFPS + ":" + '\"' + "x=(w-tw)*0.5:y=h-(2*lh)" + '\"' + ":fontcolor=white:fontsize=w*0.0422:box=1:boxcolor=0x00000099" : "drawtext=fontfile=" + Shutter.pathToFont + ":text='" + EXIFTOOL.exifDate.replace(":", "-") + "':r=" + FFPROBE.currentFPS + ":" + '\"' + "x=(w-tw)*0.5:y=h-(2*lh)" + '\"' + ":fontcolor=white:fontsize=w*0.0422:box=1:boxcolor=0x00000099";
        }
        if (caseShowFileName.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",drawtext=fontfile=" + Shutter.pathToFont + ":text='" + fichier + "':r=" + FFPROBE.currentFPS + ":" + '\"' + "x=(w-tw)*0.5:y=lh" + '\"' + ":fontcolor=white:fontsize=w*0.0422:box=1:boxcolor=0x00000099" : "drawtext=fontfile=" + Shutter.pathToFont + ":text='" + fichier + "':r=" + FFPROBE.currentFPS + ":" + '\"' + "x=(w-tw)*0.5:y=lh" + '\"' + ":fontcolor=white:fontsize=w*0.0422:box=1:boxcolor=0x00000099";
        }
        return filterComplex;
    }

    protected static String setLUT(String filterComplex) {
        if (caseLUTs.isSelected()) {
            String pathToLuts;
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/";
            } else {
                pathToLuts = "LUTs/";
            }
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",lut3d=file=" + pathToLuts + Shutter.comboLUTs.getSelectedItem().toString() : "lut3d=file=" + pathToLuts + Shutter.comboLUTs.getSelectedItem().toString();
        }
        return filterComplex;
    }

    protected static String setLevels(String filterComplex) {
        if (caseLevels.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "scale=in_range=" + comboInLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full") + ":out_range=" + comboOutLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full");
        }
        return filterComplex;
    }

    protected static String setColormatrix(String filterComplex) {
        if (caseColormatrix.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            if (comboInColormatrix.getSelectedItem().equals("HDR")) {
                String pathToLuts;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                    pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/HDR-to-SDR.cube";
                } else {
                    pathToLuts = "LUTs/HDR-to-SDR.cube";
                }
                filterComplex = String.valueOf(filterComplex) + "lut3d=file=" + pathToLuts;
            } else {
                filterComplex = String.valueOf(filterComplex) + "colorspace=iall=" + Shutter.comboInColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625") + ":all=" + Shutter.comboOutColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625");
            }
        }
        return filterComplex;
    }

    protected static String setColor(String filterComplex) {
        if (caseColor.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + "," + finalEQ : finalEQ;
        }
        return filterComplex;
    }

    protected static String setFilterComplex(String filterComplex) {
        if (filterComplex != "") {
            filterComplex = " -filter_complex \"" + filterComplex + "[out]" + '\"' + " -map " + '\"' + "[out]" + '\"';
        }
        return filterComplex;
    }

    protected static String setColorspace() {
        if (caseColorspace.isSelected()) {
            if (comboColorspace.getSelectedItem().equals("Rec. 709")) {
                return " -color_primaries bt709 -color_trc bt709 -colorspace bt709";
            }
            if (comboColorspace.getSelectedItem().equals("Rec. 2020 PQ")) {
                return " -color_primaries bt2020 -color_trc smpte2084 -colorspace bt2020nc";
            }
            if (comboColorspace.getSelectedItem().equals("Rec. 2020 HLG")) {
                return " -color_primaries bt2020 -color_trc arib-std-b67 -colorspace bt2020nc";
            }
            return "";
        }
        return "";
    }

    protected static String setCompression() {
        if (comboFonctions.getSelectedItem().equals("JPEG")) {
            int q = Math.round(31.0f - (float)Integer.valueOf(comboFilter.getSelectedItem().toString().replace("%", "")).intValue() * 31.0f / 100.0f);
            return " -q:v " + q;
        }
        if (comboFilter.getSelectedItem().toString().equals(".webp")) {
            return " -quality 100";
        }
        return " -q:v 0";
    }

    protected static String setSortie(String sortie, File file) {
        if (caseChangeFolder1.isSelected()) {
            sortie = lblDestination1.getText();
        } else {
            sortie = file.getParent();
            lblDestination1.setText(sortie);
        }
        return sortie;
    }

    protected static String setExtension() {
        if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
            if (caseCreateSequence.isSelected()) {
                return "_%06d" + comboFilter.getSelectedItem().toString();
            }
            return comboFilter.getSelectedItem().toString();
        }
        if (comboFonctions.getSelectedItem().equals("JPEG") && caseCreateSequence.isSelected()) {
            return "_%06d.jpg";
        }
        return ".jpg";
    }

    protected static String setFrame() {
        if (caseCreateSequence.isSelected()) {
            return " -r 1";
        }
        return " -vframes 1";
    }

    private static boolean errorAnalyse(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            return true;
        }
        return false;
    }

    private static boolean actionsDeFin(String fichier, String extension, File fileOut, String sortie) {
        if (FFMPEG.error || fileOut.length() == 0L && !caseCreateSequence.isSelected() && !extension.toLowerCase().equals(".pdf")) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cancelled && !caseCreateSequence.isSelected() && !extension.toLowerCase().equals(".pdf")) {
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblTermine.setText(Utils.completedFiles(++complete));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(sortie));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.sendMail(fichier);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            Picture.main(true);
            return true;
        }
        return false;
    }
}

