/*
 * Decompiled with CFR 0.152.
 */
package functions.video;

import application.Ftp;
import application.OverlayWindow;
import application.RecordInputDevice;
import application.Settings;
import application.Shutter;
import application.SubtitlesWindow;
import application.Utils;
import application.VideoPlayer;
import application.WatermarkWindow;
import application.Wetransfer;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import library.FFMPEG;
import library.FFPROBE;

public class MJPEG
extends Shutter {
    private static int complete;
    private static String cmd;

    public static void main(final boolean encode) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = new File((String)liste.getElementAt(i));
                    if (Shutter.scanIsRunning) {
                        file = Utils.scanFolder((String)liste.getElementAt(i));
                        if (file == null) break;
                        btnStart.setEnabled(true);
                        progressBar1.setIndeterminate(false);
                    } else if (Settings.btnWaitFileComplete.isSelected()) {
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    try {
                        String fichier = file.getName();
                        String extension = fichier.substring(fichier.lastIndexOf("."));
                        lblEncodageEnCours.setText(fichier);
                        if (MJPEG.analyse(file)) {
                            FFMPEG.fonctionInOut();
                            String sequence = MJPEG.setSequence(file, extension);
                            file = MJPEG.setSequenceName(file, extension);
                            String loop = MJPEG.setLoop(extension);
                            String subtitles = MJPEG.setSubtitles();
                            String bitrate = MJPEG.setBitrate();
                            String gamma = MJPEG.setGamma();
                            String resolution = MJPEG.setResolution();
                            String colorspace = MJPEG.setColorspace();
                            String filterComplex = MJPEG.setDeinterlace();
                            filterComplex = MJPEG.setBlend(filterComplex);
                            filterComplex = MJPEG.setMotionBlur(filterComplex);
                            filterComplex = MJPEG.setLUT(filterComplex);
                            filterComplex = MJPEG.setLevels(filterComplex);
                            filterComplex = MJPEG.setColormatrix(filterComplex);
                            filterComplex = MJPEG.setColor(filterComplex);
                            filterComplex = MJPEG.setDecimate(filterComplex);
                            filterComplex = MJPEG.setInterpolation(filterComplex);
                            filterComplex = MJPEG.setSlowMotion(filterComplex);
                            filterComplex = MJPEG.setPTS(filterComplex);
                            filterComplex = MJPEG.setDeband(filterComplex);
                            filterComplex = MJPEG.setDetails(filterComplex);
                            String flags = MJPEG.setFlags();
                            filterComplex = MJPEG.setDenoiser(filterComplex);
                            filterComplex = MJPEG.setConform(filterComplex);
                            String frameRate = MJPEG.setFramerate();
                            String logo = MJPEG.setLogo();
                            filterComplex = MJPEG.setWatermark(filterComplex);
                            filterComplex = MJPEG.showTimecode(filterComplex, fichier);
                            filterComplex = MJPEG.setCrop(filterComplex);
                            filterComplex = MJPEG.setRotate(filterComplex);
                            filterComplex = MJPEG.setPad(filterComplex);
                            filterComplex = MJPEG.setOverlay(filterComplex);
                            String audio = MJPEG.setAudio(filterComplex);
                            filterComplex = MJPEG.setFade(filterComplex);
                            filterComplex = MJPEG.setFilterComplex(filterComplex, audio);
                            String sortie = MJPEG.setSortie("", file);
                            String nomExtension = (OverlayWindow.caseAddTimecode.isSelected() || OverlayWindow.caseShowTimecode.isSelected()) && caseAddOverlay.isSelected() ? "_MJPEG_TC" : "_MJPEG";
                            if (case2pass.isSelected()) {
                                nomExtension = String.valueOf(nomExtension) + "_2pass";
                            }
                            if (Settings.btnExtension.isSelected()) {
                                nomExtension = Settings.txtExtension.getText();
                            }
                            String sortieFichier = String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, String.valueOf(nomExtension) + ".mov");
                            String pass = MJPEG.setPass(sortieFichier);
                            File fileOut = new File(sortieFichier);
                            if (!fileOut.exists() || (fileOut = Utils.fileReplacement(sortie, fichier, extension, String.valueOf(nomExtension) + "_", ".mov")) != null) {
                                String output = String.valueOf('\"') + fileOut.toString() + '\"';
                                if (caseDisplay.isSelected()) {
                                    output = "-flags:v +global_header -f tee \"" + fileOut.toString().replace("\\", "/") + "|[f=matroska]pipe:play" + '\"';
                                }
                                String concat = FFMPEG.setConcat(file, sortie);
                                if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
                                    file = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
                                }
                                cmd = String.valueOf(frameRate) + resolution + colorspace + pass + filterComplex + " -vcodec mjpeg" + bitrate + gamma + flags + " -y ";
                                if (inputDeviceIsRunning) {
                                    String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(Calendar.getInstance().getTime());
                                    if ((((String)liste.getElementAt(0)).equals("Capture.current.screen") || System.getProperty("os.name").contains("Mac")) && RecordInputDevice.audioDeviceIndex > 0) {
                                        cmd = cmd.replace("1:v", "2:v").replace("-map v", "-map 1:v").replace("0:v", "1:v");
                                    }
                                    if (!encode) {
                                        FFMPEG.toFFPLAY(" " + RecordInputDevice.setInputDevices() + logo + cmd + " -f matroska pipe:play |");
                                        break;
                                    }
                                    FFMPEG.run(" " + RecordInputDevice.setInputDevices() + logo + cmd + output.replace("Capture.current", timeStamp).replace("Capture.input", timeStamp));
                                    fileOut = new File(fileOut.toString().replace("Capture.current", timeStamp).replace("Capture.input", timeStamp));
                                } else if (encode) {
                                    FFMPEG.run(String.valueOf(loop) + FFMPEG.inPoint + sequence + concat + " -i " + '\"' + file.toString() + '\"' + logo + subtitles + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + output);
                                } else {
                                    FFMPEG.toFFPLAY(String.valueOf(loop) + FFMPEG.inPoint + sequence + concat + " -i " + '\"' + file.toString() + '\"' + logo + subtitles + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + " -f matroska pipe:play |");
                                    break;
                                }
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                                if (case2pass.isSelected()) {
                                    if (!FFMPEG.cancelled) {
                                        FFMPEG.run(String.valueOf(loop) + FFMPEG.inPoint + sequence + concat + " -i " + '\"' + file.toString() + '\"' + logo + subtitles + FFMPEG.postInPoint + FFMPEG.outPoint + cmd.replace("-pass 1", "-pass 2") + output);
                                    }
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.runProcess.isAlive());
                                    File folder = new File(new File(sortieFichier).getParent());
                                    MJPEG.listFilesForFolder(fichier.replace(extension, ""), folder);
                                }
                                if ((!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !FFMPEG.saveCode && caseEnableSequence.isSelected() || !FFMPEG.saveCode && Settings.btnSetBab.isSelected() || !FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) && MJPEG.actionsDeFin(fichier, fileOut, sortie)) {
                                    break;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && encode) {
                    MJPEG.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    protected static String setFade(String filterComplex) {
        String videoFade;
        long videoStart;
        if (caseVideoFadeIn.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            long videoInValue = (long)((float)Integer.parseInt(spinnerVideoFadeIn.getText()) * (1000.0f / FFPROBE.currentFPS));
            videoStart = 0L;
            if (caseInAndOut.isSelected() && VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper"))) {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                videoStart = totalIn >= 10000L ? 10000L : (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
            }
            String color = "black";
            if (lblFadeInColor.getText().equals(language.getProperty("white"))) {
                color = "white";
            }
            videoFade = "fade=in:st=" + videoStart + "ms:d=" + videoInValue + "ms:color=" + color;
            filterComplex = String.valueOf(filterComplex) + videoFade;
        }
        if (caseVideoFadeOut.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            long videoOutValue = (long)((float)Integer.parseInt(spinnerVideoFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
            videoStart = (long)FFPROBE.totalLength - videoOutValue;
            if (caseInAndOut.isSelected()) {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long totalOut = (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                videoStart = VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper")) ? (totalIn >= 10000L ? 10000L + (totalOut - totalIn) - videoOutValue : (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - videoOutValue) : (long)FFPROBE.totalLength - (totalOut - totalIn) - videoOutValue;
            }
            String color = "black";
            if (lblFadeOutColor.getText().equals(language.getProperty("white"))) {
                color = "white";
            }
            videoFade = "fade=out:st=" + videoStart + "ms:d=" + videoOutValue + "ms:color=" + color;
            filterComplex = String.valueOf(filterComplex) + videoFade;
        }
        return filterComplex;
    }

    protected static String setFilterComplex(String filterComplex, String audio) {
        float value;
        float newFPS;
        if (filterComplex != "") {
            filterComplex = caseLogo.isSelected() || caseSubtitles.isSelected() && subtitlesBurn ? " -filter_complex \"" + filterComplex + "[out]" : " -filter_complex \"[0:v]" + filterComplex + "[out]";
            newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            value = newFPS / FFPROBE.currentFPS;
            filterComplex = caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse"))) && (value < 0.5f || value > 2.0f) ? String.valueOf(filterComplex) + "\" -map \"[out]\"" + audio : (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) ? String.valueOf(filterComplex) + "\" -map \"[out]\"" + audio : (FFPROBE.channels > 1 && (lblAudioMapping.getText().equals(language.getProperty("stereo")) || lblAudioMapping.getText().equals(language.getProperty("mono"))) && !debitAudio.getSelectedItem().toString().equals("0") && !FFPROBE.stereo ? String.valueOf(filterComplex) + audio + " -map " + '\"' + "[out]" + '\"' + " -map " + '\"' + "[a]" + '\"' : (FFPROBE.stereo && lblAudioMapping.getText().equals(language.getProperty("mono")) && !debitAudio.getSelectedItem().toString().equals("0") && !FFPROBE.surround ? String.valueOf(filterComplex) + audio + " -map " + '\"' + "[out]" + '\"' + " -map " + '\"' + "[a]" + '\"' : (FFPROBE.stereo && lblAudioMapping.getText().equals("Multi") && !debitAudio.getSelectedItem().toString().equals("0") ? String.valueOf(filterComplex) + audio + '\"' + " -map " + '\"' + "[out]" + '\"' + " -map " + '\"' + "[a1]" + '\"' + " -map " + '\"' + "[a2]" + '\"' : String.valueOf(filterComplex) + "\" -map \"[out]\"" + audio))));
        } else {
            newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            value = newFPS / FFPROBE.currentFPS;
            filterComplex = caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse"))) && (value < 0.5f || value > 2.0f) ? " -map v" + audio : (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) ? " -map v" + audio : (FFPROBE.channels > 1 && (lblAudioMapping.getText().equals(language.getProperty("stereo")) || lblAudioMapping.getText().equals(language.getProperty("mono"))) && !debitAudio.getSelectedItem().toString().equals("0") && !FFPROBE.stereo ? String.valueOf(audio) + " -map v -map " + '\"' + "[a]" + '\"' : (FFPROBE.stereo && lblAudioMapping.getText().equals(language.getProperty("mono")) && !debitAudio.getSelectedItem().toString().equals("0") && !FFPROBE.surround ? String.valueOf(audio) + " -map v -map " + '\"' + "[a]" + '\"' : (FFPROBE.stereo && lblAudioMapping.getText().equals("Multi") && !debitAudio.getSelectedItem().toString().equals("0") ? String.valueOf(audio) + " -map v -map " + '\"' + "[a1]" + '\"' + " -map " + '\"' + "[a2]" + '\"' : " -map v" + audio))));
        }
        if (caseSubtitles.isSelected() && !subtitlesBurn) {
            String map = " -map 1:s";
            if (caseLogo.isSelected()) {
                map = " -map 2:s";
            }
            String[] languages = Locale.getISOLanguages();
            Locale loc = new Locale(languages[comboSubtitles.getSelectedIndex()]);
            filterComplex = String.valueOf(filterComplex) + map + " -c:s mov_text -metadata:s:s:0 language=" + loc.getISO3Language();
        }
        return filterComplex;
    }

    protected static String setLogo() {
        if (caseLogo.isSelected() && Shutter.overlayDeviceIsRunning) {
            return " " + RecordInputDevice.setOverlayDevice();
        }
        if (caseLogo.isSelected()) {
            return " -i \"" + WatermarkWindow.logoFile + '\"';
        }
        return "";
    }

    protected static String setWatermark(String filterComplex) {
        if (caseLogo.isSelected()) {
            filterComplex = filterComplex != "" ? "[0:v]" + filterComplex + "[v];[1:v]scale=iw*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(WatermarkWindow.textOpacity.getText()) / 100.0f + "[scaledwatermark];[v][scaledwatermark]overlay=" + WatermarkWindow.textPosX.getText() + ":" + WatermarkWindow.textPosY.getText() : "[1:v]scale=iw*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(WatermarkWindow.textOpacity.getText()) / 100.0f + "[scaledwatermark];[0:v][scaledwatermark]overlay=" + WatermarkWindow.textPosX.getText() + ":" + WatermarkWindow.textPosY.getText();
        }
        return filterComplex;
    }

    protected static String setPass(String sortieFichier) {
        if (case2pass.isSelected()) {
            return " -pass 1 -passlogfile \"" + sortieFichier + '\"';
        }
        return "";
    }

    protected static String setAudio(String filterComplex) {
        long audioStart;
        if (comboAudioCodec.getSelectedItem().equals(language.getProperty("codecCopy"))) {
            String mapping = "";
            if (comboAudio1.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio1.getSelectedIndex() + "?";
            }
            if (comboAudio2.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio2.getSelectedIndex() + "?";
            }
            if (comboAudio3.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio3.getSelectedIndex() + "?";
            }
            if (comboAudio4.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio4.getSelectedIndex() + "?";
            }
            if (comboAudio5.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio5.getSelectedIndex() + "?";
            }
            if (comboAudio6.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio6.getSelectedIndex() + "?";
            }
            if (comboAudio7.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio7.getSelectedIndex() + "?";
            }
            if (comboAudio8.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio8.getSelectedIndex() + "?";
            }
            return " -c:a copy" + mapping;
        }
        if (debitAudio.getSelectedItem().toString().equals("0") || comboAudioCodec.getSelectedItem().equals(language.getProperty("noAudio"))) {
            return " -an";
        }
        String audio = "";
        String audioCodec = "pcm_s16be";
        String newAudio = "";
        if (caseAudioFadeIn.isSelected()) {
            long audioInValue = (long)((float)Integer.parseInt(spinnerAudioFadeIn.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioStart = 0L;
            if (caseInAndOut.isSelected() && VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper"))) {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = totalIn >= 10000L ? 10000L : (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
            }
            String audioFade = "afade=in:st=" + audioStart + "ms:d=" + audioInValue + "ms";
            newAudio = newAudio != "" ? String.valueOf(newAudio) + "," + audioFade : String.valueOf(newAudio) + audioFade;
        }
        if (caseAudioFadeOut.isSelected()) {
            long audioOutValue = (long)((float)Integer.parseInt(spinnerAudioFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioStart = (long)FFPROBE.totalLength - audioOutValue;
            if (caseInAndOut.isSelected()) {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long totalOut = (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper")) ? (totalIn >= 10000L ? 10000L + (totalOut - totalIn) - audioOutValue : (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - audioOutValue) : (long)FFPROBE.totalLength - (totalOut - totalIn) - audioOutValue;
            }
            String audioFade = "afade=out:st=" + audioStart + "ms:d=" + audioOutValue + "ms";
            newAudio = newAudio != "" ? String.valueOf(newAudio) + "," + audioFade : String.valueOf(newAudio) + audioFade;
        }
        if (caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse")))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            float value = newFPS / FFPROBE.currentFPS;
            if (value < 0.5f || value > 2.0f) {
                return " -an";
            }
            newAudio = newAudio != "" ? ",atempo=" + value : "atempo=" + value;
        } else if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            return " -an";
        }
        if (FFPROBE.stereo) {
            if (newAudio != "") {
                newAudio = " -filter:a \"" + newAudio + '\"';
            }
            if (FFPROBE.surround) {
                if (lblAudioMapping.getText().equals("Multi")) {
                    FFPROBE.stereo = false;
                    audio = String.valueOf(audio) + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" + newAudio + " -map a:0";
                } else if (lblAudioMapping.getText().equals(language.getProperty("mono"))) {
                    if (newAudio != "") {
                        newAudio = String.valueOf(newAudio.replace(" -filter:a", "").replace("\"", "")) + ",";
                    }
                    audio = String.valueOf(audio) + " -c:a " + audioCodec + " -ac 1 -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k -filter:a " + '\"' + newAudio + "pan=stereo|FL=FC+0.30*FL+0.30*BL|FR=FC+0.30*FR+0.30*BR" + '\"' + " -map a?";
                } else {
                    if (newAudio != "") {
                        newAudio = String.valueOf(newAudio.replace(" -filter:a", "").replace("\"", "")) + ",";
                    }
                    audio = String.valueOf(audio) + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k -filter:a " + '\"' + newAudio + "pan=stereo|FL=FC+0.30*FL+0.30*BL|FR=FC+0.30*FR+0.30*BR" + '\"' + " -map a?";
                }
            } else if (lblAudioMapping.getText().equals("Multi")) {
                if (newAudio != "") {
                    newAudio = "," + newAudio;
                }
                audio = filterComplex != "" ? String.valueOf(audio) + ";" : String.valueOf(audio) + " -filter_complex \"";
                audio = String.valueOf(audio) + "[a:0]pan=1c|c0=c" + comboAudio1.getSelectedIndex() + newAudio + "[a1];[a:0]pan=1c|c0=c" + comboAudio2.getSelectedIndex() + newAudio + "[a2]" + '\"' + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k";
            } else if (lblAudioMapping.getText().equals(language.getProperty("mono"))) {
                if (newAudio != "") {
                    newAudio = "," + newAudio;
                }
                audio = filterComplex != "" ? String.valueOf(audio) + ";" : String.valueOf(audio) + " -filter_complex \"";
                audio = comboAudio1.getSelectedIndex() != 8 && comboAudio2.getSelectedIndex() != 8 ? String.valueOf(audio) + "[0:a]anull" + newAudio + "[a]" + '\"' + " -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" : (comboAudio1.getSelectedIndex() == 0 ? String.valueOf(audio) + "[0:a]channelsplit=channel_layout=stereo:channels=FL" + newAudio + "[a]" + '\"' + " -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" : String.valueOf(audio) + "[0:a]channelsplit=channel_layout=stereo:channels=FR" + newAudio + "[a]" + '\"' + " -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k");
            } else {
                audio = String.valueOf(audio) + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" + newAudio + " -map a:0";
            }
        } else if (FFPROBE.channels > 1) {
            if (inputDeviceIsRunning) {
                if (newAudio != "") {
                    newAudio = "," + newAudio;
                }
                audio = filterComplex != "" ? String.valueOf(audio) + ";" : String.valueOf(audio) + " -filter_complex \"";
                if (lblAudioMapping.getText().equals(language.getProperty("stereo"))) {
                    audio = String.valueOf(audio) + "[0:a][2:a]amix=inputs=2" + newAudio + "[a]" + '\"' + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k";
                } else if (lblAudioMapping.getText().equals("Multi")) {
                    if (newAudio != "") {
                        newAudio = " -filter:a \"" + newAudio + '\"';
                    }
                    audio = String.valueOf(audio) + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" + newAudio + " -map 0:a? -map 2:a?";
                } else if (lblAudioMapping.getText().equals(language.getProperty("mono"))) {
                    audio = comboAudio1.getSelectedIndex() != 8 && comboAudio2.getSelectedIndex() != 8 ? String.valueOf(audio) + "[" + String.valueOf(comboAudio1.getSelectedIndex()).replace("1", "2") + ":a][" + String.valueOf(comboAudio2.getSelectedIndex()).replace("1", "2") + ":a]amerge=inputs=2" + newAudio + "[a]" + '\"' + " -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" : String.valueOf(audio) + "[" + String.valueOf(comboAudio1.getSelectedIndex()).replace("1", "2") + ":a]anull" + newAudio + "[a]" + '\"' + " -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k";
                }
            } else if (lblAudioMapping.getText().equals(language.getProperty("stereo"))) {
                if (newAudio != "") {
                    newAudio = "," + newAudio;
                }
                audio = filterComplex != "" ? String.valueOf(audio) + ";" : String.valueOf(audio) + " -filter_complex \"";
                audio = String.valueOf(audio) + "[0:a:" + comboAudio1.getSelectedIndex() + "][0:a:" + comboAudio2.getSelectedIndex() + "]amerge=inputs=2" + newAudio + "[a]" + '\"' + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k";
            } else if (lblAudioMapping.getText().equals(language.getProperty("mono"))) {
                if (newAudio != "") {
                    newAudio = "," + newAudio;
                }
                audio = filterComplex != "" ? String.valueOf(audio) + ";" : String.valueOf(audio) + " -filter_complex \"";
                audio = comboAudio1.getSelectedIndex() != 8 && comboAudio2.getSelectedIndex() != 8 ? String.valueOf(audio) + "[0:a:" + comboAudio1.getSelectedIndex() + "][0:a:" + comboAudio2.getSelectedIndex() + "]amerge=inputs=2" + newAudio + "[a]" + '\"' + " -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" : String.valueOf(audio) + "[0:a:" + comboAudio1.getSelectedIndex() + "]anull" + newAudio + "[a]" + '\"' + " -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k";
            } else {
                String mapping = "";
                if (comboAudio1.getSelectedIndex() != 8) {
                    mapping = String.valueOf(mapping) + " -map a:" + comboAudio1.getSelectedIndex() + "?";
                }
                if (comboAudio2.getSelectedIndex() != 8) {
                    mapping = String.valueOf(mapping) + " -map a:" + comboAudio2.getSelectedIndex() + "?";
                }
                if (comboAudio3.getSelectedIndex() != 8) {
                    mapping = String.valueOf(mapping) + " -map a:" + comboAudio3.getSelectedIndex() + "?";
                }
                if (comboAudio4.getSelectedIndex() != 8) {
                    mapping = String.valueOf(mapping) + " -map a:" + comboAudio4.getSelectedIndex() + "?";
                }
                if (comboAudio5.getSelectedIndex() != 8) {
                    mapping = String.valueOf(mapping) + " -map a:" + comboAudio5.getSelectedIndex() + "?";
                }
                if (comboAudio6.getSelectedIndex() != 8) {
                    mapping = String.valueOf(mapping) + " -map a:" + comboAudio6.getSelectedIndex() + "?";
                }
                if (comboAudio7.getSelectedIndex() != 8) {
                    mapping = String.valueOf(mapping) + " -map a:" + comboAudio7.getSelectedIndex() + "?";
                }
                if (comboAudio8.getSelectedIndex() != 8) {
                    mapping = String.valueOf(mapping) + " -map a:" + comboAudio8.getSelectedIndex() + "?";
                }
                if (newAudio != "") {
                    newAudio = " -filter:a \"" + newAudio + '\"';
                }
                audio = String.valueOf(audio) + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" + newAudio + mapping;
            }
        } else {
            if (newAudio != "") {
                newAudio = " -filter:a \"" + newAudio + '\"';
            }
            audio = String.valueOf(audio) + " -c:a " + audioCodec + " -ar " + lbl48k.getText() + " -b:a " + debitAudio.getSelectedItem().toString() + "k" + newAudio + " -map a?";
        }
        return audio;
    }

    protected static File setSequenceName(File file, String extension) {
        if (caseEnableSequence.isSelected()) {
            int n = 0;
            while (file.toString().substring(file.toString().lastIndexOf(".") - ++n).replace(extension, "").matches("[0-9]+")) {
            }
            int nombre = n - 1;
            file = new File(String.valueOf(file.toString().substring(0, file.toString().lastIndexOf(".") - nombre)) + "%0" + nombre + "d" + extension);
        }
        return file;
    }

    protected static String setLoop(String extension) {
        block21: {
            if (caseEnableSequence.isSelected()) break block21;
            switch (extension) {
                case ".bmp": 
                case ".jpg": 
                case ".png": 
                case ".psd": 
                case ".tga": 
                case ".tif": 
                case ".jpeg": 
                case ".tiff": {
                    Shutter.progressBar1.setMaximum(10);
                    return " -loop 1 -t " + Settings.txtImageDuration.getText();
                }
            }
        }
        return "";
    }

    protected static String setSequence(File file, String extension) {
        if (caseEnableSequence.isSelected()) {
            int n = 0;
            while (file.toString().substring(file.toString().lastIndexOf(".") - ++n).replace(extension, "").matches("[0-9]+")) {
            }
            if (caseBlend.isSelected()) {
                return " -start_number " + file.toString().substring(file.toString().lastIndexOf(".") - n + 1).replace(extension, "");
            }
            return " -framerate " + caseSequenceFPS.getSelectedItem().toString().replace(",", ".") + " -start_number " + file.toString().substring(file.toString().lastIndexOf(".") - n + 1).replace(extension, "");
        }
        return "";
    }

    protected static String setCrop(String filterComplex) {
        if (caseRognage.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + "[w];[w]";
            }
            filterComplex = String.valueOf(filterComplex) + "crop=" + FFPROBE.cropHeight + ":" + FFPROBE.cropWidth + ":" + FFPROBE.cropPixelsWidth + ":" + FFPROBE.cropPixelsHeight;
        }
        if (caseRognerImage.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + "[w];[w]";
            }
            filterComplex = String.valueOf(filterComplex) + Shutter.cropFinal;
        }
        return filterComplex;
    }

    protected static String setPad(String filterComplex) {
        if (lblPad.getText().equals(language.getProperty("lblPad")) && !comboH264Taille.getSelectedItem().toString().equals(language.getProperty("source"))) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + "[c];[c]";
            }
            String[] s = FFPROBE.imageResolution.split("x");
            if (caseRognage.isSelected()) {
                filterComplex = String.valueOf(filterComplex) + "pad=" + FFPROBE.imageResolution.replace("x", ":") + ":(ow-iw)*0.5:(oh-ih)*0.5";
            } else {
                s = comboH264Taille.getSelectedItem().toString().split("x");
                filterComplex = String.valueOf(filterComplex) + "scale=" + s[0] + ":" + s[1] + ":force_original_aspect_ratio=decrease,pad=" + s[0] + ":" + s[1] + ":(ow-iw)*0.5:(oh-ih)*0.5";
            }
        }
        return filterComplex;
    }

    protected static String setRotate(String filterComplex) {
        String rotate;
        block20: {
            block18: {
                rotate = "";
                if (!caseRotate.isSelected()) break block18;
                String transpose = "";
                switch (comboRotate.getSelectedItem().toString()) {
                    case "90": {
                        if (caseMiror.isSelected()) {
                            transpose = "transpose=3";
                            break;
                        }
                        transpose = "transpose=1";
                        break;
                    }
                    case "-90": {
                        if (caseMiror.isSelected()) {
                            transpose = "transpose=0";
                            break;
                        }
                        transpose = "transpose=2";
                        break;
                    }
                    case "180": {
                        transpose = caseMiror.isSelected() ? "transpose=1,transpose=1,hflip" : "transpose=1,transpose=1";
                    }
                }
                rotate = transpose;
                break block20;
            }
            if (caseMiror.isSelected()) {
                rotate = "hflip";
            }
        }
        if (rotate != "") {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + rotate;
        }
        return filterComplex;
    }

    protected static String setBitrate() {
        if (lblVBR.getText().equals("CQ")) {
            return " -crf " + debitVideo.getSelectedItem().toString();
        }
        return " -b:v " + debitVideo.getSelectedItem().toString() + "k";
    }

    protected static String setGamma() {
        return " -pix_fmt yuvj422p";
    }

    protected static boolean analyse(File file) throws InterruptedException {
        if (!inputDeviceIsRunning) {
            FFPROBE.FrameData(file.toString());
            do {
                Thread.sleep(100L);
            } while (FFPROBE.isRunning);
            if (MJPEG.errorAnalyse(file.toString())) {
                return false;
            }
        }
        FFPROBE.Data(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        return !MJPEG.errorAnalyse(file.toString());
    }

    protected static String setResolution() {
        String resolution = comboH264Taille.getSelectedItem().toString();
        if (comboH264Taille.getSelectedItem().toString().equals(language.getProperty("source")) && !caseRognage.isSelected()) {
            return "";
        }
        if (caseRognage.isSelected() && lblPad.getText().equals(language.getProperty("lblPad"))) {
            String[] s = comboH264Taille.getSelectedItem().toString().split("x");
            String[] i = FFPROBE.imageResolution.split("x");
            int ow = Integer.parseInt(s[0]);
            int iw = Integer.parseInt(i[0]);
            int ih = Integer.parseInt(i[1]);
            return " -s " + s[0] + "x" + (int)((float)ow / ((float)iw / (float)ih));
        }
        return " -s " + resolution;
    }

    protected static String setColorspace() {
        if (caseColorspace.isSelected()) {
            if (comboColorspace.getSelectedItem().equals("Rec. 709")) {
                return " -color_primaries bt709 -color_trc bt709 -colorspace bt709";
            }
            if (comboColorspace.getSelectedItem().equals("Rec. 2020 PQ")) {
                return " -color_primaries bt2020 -color_trc smpte2084 -colorspace bt2020nc";
            }
            if (comboColorspace.getSelectedItem().equals("Rec. 2020 HLG")) {
                return " -color_primaries bt2020 -color_trc arib-std-b67 -colorspace bt2020nc";
            }
            return "";
        }
        return "";
    }

    protected static String setDeinterlace() {
        if (caseForcerDesentrelacement.isSelected() && comboForcerDesentrelacement.getSelectedItem().toString().equals("detelecine")) {
            String detelecineFields = "top";
            if (lblTFF.getText().equals("BFF")) {
                detelecineFields = "bottom";
            }
            return String.valueOf(comboForcerDesentrelacement.getSelectedItem().toString()) + "=first_field=" + detelecineFields;
        }
        if (caseForcerDesentrelacement.isSelected() || FFPROBE.entrelaced.equals("1")) {
            int doubler = 0;
            if (lblTFF.getText().equals("x2") && caseForcerDesentrelacement.isSelected()) {
                doubler = 1;
            }
            return String.valueOf(comboForcerDesentrelacement.getSelectedItem().toString()) + "=" + doubler + ":" + FFPROBE.fieldOrder + ":0";
        }
        return "";
    }

    protected static String setBlend(String videoFilter) {
        if (caseBlend.isSelected()) {
            int value = sliderBlend.getValue();
            StringBuilder blend = new StringBuilder();
            int i = 0;
            while (i < value) {
                blend.append("tblend=all_mode=average,");
                ++i;
            }
            blend.append("setpts=" + 25.0f / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", ".")) + "*PTS");
            videoFilter = videoFilter != "" ? String.valueOf(videoFilter) + "," + blend : blend.toString();
        }
        return videoFilter;
    }

    protected static String setMotionBlur(String videoFilter) {
        if (caseMotionBlur.isSelected()) {
            float fps = Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", ".")) * 2.0f;
            videoFilter = videoFilter != "" ? String.valueOf(videoFilter) + ",minterpolate=fps=" + fps + ",tblend=all_mode=average,framestep=2" : "minterpolate=fps=" + fps + ",tblend=all_mode=average,framestep=2";
        }
        return videoFilter;
    }

    protected static String setLUT(String filterComplex) {
        if (caseLUTs.isSelected()) {
            String pathToLuts;
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/";
            } else {
                pathToLuts = "LUTs/";
            }
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",lut3d=file=" + pathToLuts + Shutter.comboLUTs.getSelectedItem().toString() : "lut3d=file=" + pathToLuts + Shutter.comboLUTs.getSelectedItem().toString();
        }
        return filterComplex;
    }

    protected static String setLevels(String filterComplex) {
        if (caseLevels.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "scale=in_range=" + comboInLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full") + ":out_range=" + comboOutLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full");
        }
        return filterComplex;
    }

    protected static String setColormatrix(String filterComplex) {
        if (caseColormatrix.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            if (comboInColormatrix.getSelectedItem().equals("HDR")) {
                String pathToLuts;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                    pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/HDR-to-SDR.cube";
                } else {
                    pathToLuts = "LUTs/HDR-to-SDR.cube";
                }
                filterComplex = String.valueOf(filterComplex) + "lut3d=file=" + pathToLuts;
            } else {
                filterComplex = String.valueOf(filterComplex) + "colorspace=iall=" + Shutter.comboInColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625") + ":all=" + Shutter.comboOutColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625");
            }
        }
        return filterComplex;
    }

    protected static String setColor(String filterComplex) {
        if (caseColor.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + "," + finalEQ : finalEQ;
        }
        return filterComplex;
    }

    protected static String setDeband(String filterComplex) {
        if (caseBanding.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",deband=r=32" : "deband=r=32";
        }
        return filterComplex;
    }

    protected static String setDetails(String videoFilter) {
        if (caseDetails.isSelected()) {
            float value = 0.0f - (float)sliderDetails.getValue() / 10.0f;
            videoFilter = videoFilter != "" ? String.valueOf(videoFilter) + ",smartblur=1.0:" + value : "smartblur=1.0:" + value;
        }
        return videoFilter;
    }

    protected static String setFlags() {
        String flags = " -sws_flags " + Settings.comboScale.getSelectedItem().toString();
        if (caseDecimate.isSelected()) {
            flags = String.valueOf(flags) + " -vsync vfr";
        }
        return flags;
    }

    protected static String setDenoiser(String videoFilter) {
        if (caseBruit.isSelected()) {
            int value = sliderBruit.getValue();
            videoFilter = videoFilter != "" ? String.valueOf(videoFilter) + ",hqdn3d=" + value + ":" + value + ":" + value + ":" + value : "hqdn3d=" + value + ":" + value + ":" + value + ":" + value;
        }
        return videoFilter;
    }

    protected static String setDecimate(String filterComplex) {
        if (caseDecimate.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",mpdecimate" : "mpdecimate";
        }
        return filterComplex;
    }

    protected static String setInterpolation(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformByInterpolation"))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS;
        }
        return filterComplex;
    }

    protected static String setSlowMotion(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS + ",setpts=" + newFPS / FFPROBE.currentFPS + "*PTS";
        }
        return filterComplex;
    }

    protected static String setPTS(String videoFilter) {
        if (caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse")))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (videoFilter != "") {
                videoFilter = String.valueOf(videoFilter) + ",";
            }
            videoFilter = String.valueOf(videoFilter) + "setpts=" + FFPROBE.currentFPS / newFPS + "*PTS";
            if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse"))) {
                videoFilter = String.valueOf(videoFilter) + ",reverse";
            }
        }
        return videoFilter;
    }

    protected static String setSubtitles() {
        if (caseSubtitles.isSelected() && subtitlesBurn) {
            if (subtitlesFile.toString().substring(subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
                String background = "";
                background = SubtitlesWindow.lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn")) ? ",BorderStyle=4,BackColour=&H" + SubtitlesWindow.alpha + SubtitlesWindow.hex2 + "&,Outline=0" : ",OutlineColour=&H" + SubtitlesWindow.alpha + SubtitlesWindow.hex2 + "&";
                if (SubtitlesWindow.btnG.getForeground() != Color.BLACK) {
                    background = String.valueOf(background) + ",Bold=1";
                }
                if (SubtitlesWindow.btnI.getForeground() != Color.BLACK) {
                    background = String.valueOf(background) + ",Italic=1";
                }
                String[] i = FFPROBE.imageResolution.split("x");
                if (caseRognage.isSelected() && lblPad.getText().equals(Shutter.language.getProperty("lblCrop"))) {
                    return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + SubtitlesWindow.textWidth.getText() + ":" + FFPROBE.cropWidth + "+" + SubtitlesWindow.spinnerSubtitlesPosition.getValue() + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + SubtitlesWindow.comboFont.getSelectedItem().toString() + ",FontSize=" + SubtitlesWindow.spinnerSize.getValue() + ",PrimaryColour=&H" + SubtitlesWindow.hex + "&" + background + "'" + '\"';
                }
                if (!caseRognage.isSelected() && lblPad.getText().equals(language.getProperty("lblPad")) && !comboH264Taille.getSelectedItem().toString().equals(language.getProperty("source"))) {
                    String[] s = comboH264Taille.getSelectedItem().toString().split("x");
                    int iw = Integer.parseInt(i[0]);
                    int ih = Integer.parseInt(i[1]);
                    int ow = Integer.parseInt(s[0]);
                    int oh = Integer.parseInt(s[1]);
                    int width = (int)((float)Integer.parseInt(SubtitlesWindow.textWidth.getText()) / ((float)iw / (float)ow));
                    int height = (int)((float)(ih + Integer.parseInt(SubtitlesWindow.spinnerSubtitlesPosition.getValue().toString())) / ((float)ih / (float)oh));
                    return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + width + ":" + height + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + SubtitlesWindow.comboFont.getSelectedItem().toString() + ",FontSize=" + SubtitlesWindow.spinnerSize.getValue() + ",PrimaryColour=&H" + SubtitlesWindow.hex + "&" + background + "'" + '\"';
                }
                return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + SubtitlesWindow.textWidth.getText() + ":" + i[1] + "+" + SubtitlesWindow.spinnerSubtitlesPosition.getValue() + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + SubtitlesWindow.comboFont.getSelectedItem().toString() + ",FontSize=" + SubtitlesWindow.spinnerSize.getValue() + ",PrimaryColour=&H" + SubtitlesWindow.hex + "&" + background + "'" + '\"';
            }
            String[] i = FFPROBE.imageResolution.split("x");
            SubtitlesWindow.textWidth.setText(i[0]);
            if (!comboH264Taille.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] s = comboH264Taille.getSelectedItem().toString().split("x");
                int iw = Integer.parseInt(i[0]);
                int ih = Integer.parseInt(i[1]);
                int ow = Integer.parseInt(s[0]);
                int oh = Integer.parseInt(s[1]);
                int width = (int)((float)Integer.parseInt(SubtitlesWindow.textWidth.getText()) / ((float)iw / (float)ow));
                int height = (int)((float)(ih + Integer.parseInt(SubtitlesWindow.spinnerSubtitlesPosition.getValue().toString())) / ((float)ih / (float)oh));
                return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + width + ":" + height + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1" + '\"';
            }
            return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + i[0] + ":" + i[1] + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1" + '\"';
        }
        if (caseSubtitles.isSelected() && !subtitlesBurn) {
            return String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + subtitlesFile.toString() + '\"';
        }
        return "";
    }

    protected static String setOverlay(String filterComplex) {
        if (caseSubtitles.isSelected() && subtitlesBurn) {
            String[] i = FFPROBE.imageResolution.split("x");
            if (caseRognage.isSelected() && lblPad.getText().equals(Shutter.language.getProperty("lblCrop")) && FFMPEG.ratioFinal < (float)Integer.parseInt(i[0]) / (float)Integer.parseInt(i[1])) {
                i = String.valueOf(String.valueOf((int)((float)Integer.parseInt(i[1]) * FFMPEG.ratioFinal)) + "x" + i[1]).split("x");
            }
            int ImageWidth = Integer.parseInt(i[0]);
            int posX = (ImageWidth - Integer.parseInt(SubtitlesWindow.textWidth.getText())) / 2;
            if (!caseRognage.isSelected() && lblPad.getText().equals(language.getProperty("lblPad")) && !comboH264Taille.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] s = comboH264Taille.getSelectedItem().toString().split("x");
                int iw = Integer.parseInt(i[0]);
                int ow = Integer.parseInt(s[0]);
                posX = (int)((float)posX / ((float)iw / (float)ow));
            }
            filterComplex = caseLogo.isSelected() ? String.valueOf(filterComplex) + "[p];[p][2:v]overlay=shortest=1:x=" + posX : (filterComplex != "" ? "[0:v]" + filterComplex + "[p];[p][1:v]overlay=shortest=1:x=" + posX : "[0:v][1:v]overlay=shortest=1:x=" + posX);
        }
        return filterComplex;
    }

    protected static String showTimecode(String filterComplex, String fichier) {
        String tc1 = FFPROBE.timecode1;
        String tc2 = FFPROBE.timecode2;
        String tc3 = FFPROBE.timecode3;
        String tc4 = FFPROBE.timecode4;
        if (caseInAndOut.isSelected() && VideoPlayer.sliderIn.getValue() > VideoPlayer.sliderIn.getMinimum() && OverlayWindow.caseAddTimecode.isSelected()) {
            tc1 = String.valueOf(Integer.parseInt(tc1) - Integer.parseInt(VideoPlayer.caseInH.getText()));
            tc2 = String.valueOf(Integer.parseInt(tc2) - Integer.parseInt(VideoPlayer.caseInM.getText()));
            tc3 = String.valueOf(Integer.parseInt(tc3) - Integer.parseInt(VideoPlayer.caseInS.getText()));
            tc4 = String.valueOf(Integer.parseInt(tc4) - Integer.parseInt(VideoPlayer.caseInF.getText()));
        }
        String rate = String.valueOf(FFPROBE.currentFPS);
        if (caseConform.isSelected()) {
            rate = comboFPS.getSelectedItem().toString().replace(",", ".");
        }
        if (OverlayWindow.caseShowFileName.isSelected() && caseAddOverlay.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "drawtext=" + OverlayWindow.font + ":text='" + fichier + "':r=" + rate + ":x=" + OverlayWindow.textNamePosX.getText() + ":y=" + OverlayWindow.textNamePosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaName + ":fontsize=" + OverlayWindow.spinnerSizeName.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexName;
        }
        if (OverlayWindow.caseShowText.isSelected() && caseAddOverlay.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "drawtext=" + OverlayWindow.font + ":text='" + OverlayWindow.text.getText() + "':r=" + rate + ":x=" + OverlayWindow.textNamePosX.getText() + ":y=" + OverlayWindow.textNamePosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaName + ":fontsize=" + OverlayWindow.spinnerSizeName.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexName;
        }
        if ((OverlayWindow.caseAddTimecode.isSelected() || OverlayWindow.caseShowTimecode.isSelected()) && caseAddOverlay.isSelected()) {
            String dropFrame = ":";
            if (!caseConform.isSelected() && (FFPROBE.currentFPS == 29.97f || FFPROBE.currentFPS == 59.94f) || caseConform.isSelected() && (comboFPS.getSelectedItem().toString().equals("29,97") || comboFPS.getSelectedItem().toString().equals("59,94"))) {
                dropFrame = ";";
            }
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            if (OverlayWindow.caseAddTimecode.isSelected() && OverlayWindow.lblTimecode.getText().equals(Shutter.language.getProperty("lblFrameNumber"))) {
                String startNumber = String.format("%.0f", Float.valueOf((float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS + (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS + (float)Integer.parseInt(tc3) * FFPROBE.currentFPS + (float)Integer.parseInt(tc4)));
                filterComplex = String.valueOf(filterComplex) + "drawtext=" + OverlayWindow.font + ":text='%{frame_num}': start_number=" + startNumber + ":x=" + OverlayWindow.textTcPosX.getText() + ":y=" + OverlayWindow.textTcPosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaTc + ":fontsize=" + OverlayWindow.spinnerSizeTC.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexTc;
            } else {
                filterComplex = String.valueOf(filterComplex) + "drawtext=" + OverlayWindow.font + ":timecode='" + tc1 + "\\:" + tc2 + "\\:" + tc3 + "\\" + dropFrame + tc4 + "':r=" + rate + ":x=" + OverlayWindow.textTcPosX.getText() + ":y=" + OverlayWindow.textTcPosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaTc + ":fontsize=" + OverlayWindow.spinnerSizeTC.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexTc + ":tc24hmax=1";
            }
        }
        return filterComplex;
    }

    protected static String setConform(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformByBlending"))) {
            float newFPS = Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")).floatValue();
            float FPS = FFPROBE.currentFPS;
            if (caseEnableSequence.isSelected()) {
                FPS = Float.valueOf(caseSequenceFPS.getSelectedItem().toString().replace(",", ".").replace(",", ".")).floatValue();
            }
            if (FPS != newFPS) {
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS + ":mi_mode=blend";
            }
        }
        return filterComplex;
    }

    protected static String setFramerate() {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            return " -r " + FFPROBE.currentFPS;
        }
        if (caseConform.isSelected()) {
            return " -r " + Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
        }
        if (caseEnableSequence.isSelected()) {
            if (caseConform.isSelected()) {
                return " -r " + Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")) + " -frames:v " + liste.getSize();
            }
            return " -r " + caseSequenceFPS.getSelectedItem().toString().replace(",", ".") + " -frames:v " + liste.getSize();
        }
        if (inputDeviceIsRunning) {
            return " -vsync vfr";
        }
        return "";
    }

    protected static String setSortie(String sortie, File file) {
        if (caseChangeFolder1.isSelected()) {
            sortie = lblDestination1.getText();
            if (caseCreateTree.isSelected()) {
                File pathToFile = null;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    String[] s = file.getParent().toString().split("/");
                    pathToFile = new File(String.valueOf(lblDestination1.getText()) + file.getParent().toString().replace("/Volumes", "").replace(s[2], ""));
                } else {
                    pathToFile = new File(String.valueOf(lblDestination1.getText()) + file.getParent().toString().substring(2));
                }
                if (!pathToFile.exists()) {
                    pathToFile.mkdirs();
                }
                sortie = pathToFile.toString();
            }
        } else {
            sortie = file.getParent();
            lblDestination1.setText(sortie);
        }
        return sortie;
    }

    public static void listFilesForFolder(String fichier, File folder) {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            if (fileEntry.isFile() && fileEntry.getName().contains(fichier) && fileEntry.getName().contains("log")) {
                File fileToDelete = new File(fileEntry.getAbsolutePath());
                fileToDelete.delete();
            }
            ++n2;
        }
    }

    private static boolean errorAnalyse(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            return true;
        }
        return false;
    }

    private static boolean actionsDeFin(String fichier, File fileOut, String sortie) {
        if (FFMPEG.error || fileOut.length() == 0L) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
            String extension = fichier.substring(fichier.lastIndexOf("."));
            File listeBAB = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
            listeBAB.delete();
        }
        if (cancelled) {
            try {
                fileOut.delete();
            }
            catch (Exception extension) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblTermine.setText(Utils.completedFiles(++complete));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(sortie));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.sendMail(fichier);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (caseEnableSequence.isSelected() || Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            MJPEG.main(true);
            return true;
        }
        return false;
    }
}

