/*
 * Decompiled with CFR 0.152.
 */
package functions.video;

import application.Ftp;
import application.OverlayWindow;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import application.Wetransfer;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import library.FFMPEG;
import library.FFPROBE;

public class DVPAL
extends Shutter {
    private static int complete;

    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = new File((String)liste.getElementAt(i));
                    if (Shutter.scanIsRunning) {
                        file = Utils.scanFolder((String)liste.getElementAt(i));
                        if (file == null) break;
                        btnStart.setEnabled(true);
                        progressBar1.setIndeterminate(false);
                    } else if (Settings.btnWaitFileComplete.isSelected()) {
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    try {
                        String fichier = file.getName();
                        String extension = fichier.substring(fichier.lastIndexOf("."));
                        lblEncodageEnCours.setText(fichier);
                        if (DVPAL.analyse(file)) {
                            String sortieFichier;
                            File fileOut;
                            FFMPEG.fonctionInOut();
                            String filterComplex = DVPAL.setTimecode(fichier);
                            String flags = DVPAL.setFlags();
                            String sortie = DVPAL.setSortie("", file);
                            String nomExtension = (OverlayWindow.caseAddTimecode.isSelected() || OverlayWindow.caseShowTimecode.isSelected()) && caseAddOverlay.isSelected() ? "_DV_TC" : "_DV";
                            if (Settings.btnExtension.isSelected()) {
                                nomExtension = Settings.txtExtension.getText();
                            }
                            if (!(fileOut = new File(sortieFichier = String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, String.valueOf(nomExtension) + ".mov").replace("\\", "/"))).exists() || (fileOut = Utils.fileReplacement(sortie, fichier, extension, String.valueOf(nomExtension) + "_", ".mov")) != null) {
                                String output = String.valueOf('\"') + fileOut.toString() + '\"';
                                if (caseDisplay.isSelected()) {
                                    output = "-flags:v +global_header -f tee \"" + fileOut.toString().replace("\\", "/") + "|[f=matroska]pipe:play" + '\"';
                                }
                                String concat = FFMPEG.setConcat(file, sortie);
                                if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
                                    file = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
                                }
                                String cmd = " -aspect " + comboFilter.getSelectedItem().toString().replace("/", ":") + filterComplex + flags + " -c:a pcm_s16le -map v:0 -map a? -ar 48000 -s 720x576 -vcodec dvvideo -b:v 25000 -r 25 -y ";
                                FFMPEG.run(String.valueOf(FFMPEG.inPoint) + concat + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + output);
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                                if ((!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !FFMPEG.saveCode && Settings.btnSetBab.isSelected() || !FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) && DVPAL.actionsDeFin(fichier, fileOut, sortie)) {
                                    break;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    DVPAL.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    protected static String setTimecode(String fichier) {
        String timecodeText = "";
        String tc1 = FFPROBE.timecode1;
        String tc2 = FFPROBE.timecode2;
        String tc3 = FFPROBE.timecode3;
        String tc4 = FFPROBE.timecode4;
        if (OverlayWindow.caseAddTimecode.isSelected()) {
            tc1 = OverlayWindow.TC1.getText();
            tc2 = OverlayWindow.TC2.getText();
            tc3 = OverlayWindow.TC3.getText();
            tc4 = OverlayWindow.TC4.getText();
        }
        if (caseInAndOut.isSelected() && VideoPlayer.sliderIn.getValue() > VideoPlayer.sliderIn.getMinimum() && OverlayWindow.caseAddTimecode.isSelected()) {
            tc1 = String.valueOf(Integer.parseInt(tc1) - Integer.parseInt(VideoPlayer.caseInH.getText()));
            tc2 = String.valueOf(Integer.parseInt(tc2) - Integer.parseInt(VideoPlayer.caseInM.getText()));
            tc3 = String.valueOf(Integer.parseInt(tc3) - Integer.parseInt(VideoPlayer.caseInS.getText()));
            tc4 = String.valueOf(Integer.parseInt(tc4) - Integer.parseInt(VideoPlayer.caseInF.getText()));
        }
        String rate = String.valueOf(FFPROBE.currentFPS);
        if (caseConform.isSelected()) {
            rate = comboFPS.getSelectedItem().toString().replace(",", ".");
        }
        if (OverlayWindow.caseShowFileName.isSelected() && caseAddOverlay.isSelected()) {
            if (timecodeText != "") {
                timecodeText = String.valueOf(timecodeText) + ",";
            }
            timecodeText = String.valueOf(timecodeText) + "drawtext=" + OverlayWindow.font + ":text='" + fichier + "':r=" + rate + ":x=" + OverlayWindow.textNamePosX.getText() + ":y=" + OverlayWindow.textNamePosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaName + ":fontsize=" + OverlayWindow.spinnerSizeName.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexName;
        }
        if (OverlayWindow.caseShowText.isSelected() && caseAddOverlay.isSelected()) {
            if (timecodeText != "") {
                timecodeText = String.valueOf(timecodeText) + ",";
            }
            timecodeText = String.valueOf(timecodeText) + "drawtext=" + OverlayWindow.font + ":text='" + OverlayWindow.text.getText() + "':r=" + rate + ":x=" + OverlayWindow.textNamePosX.getText() + ":y=" + OverlayWindow.textNamePosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaName + ":fontsize=" + OverlayWindow.spinnerSizeName.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexName;
        }
        if ((OverlayWindow.caseAddTimecode.isSelected() || OverlayWindow.caseShowTimecode.isSelected()) && caseAddOverlay.isSelected()) {
            if (timecodeText != "") {
                timecodeText = String.valueOf(timecodeText) + ",";
            }
            if (OverlayWindow.caseAddTimecode.isSelected() && OverlayWindow.lblTimecode.getText().equals(Shutter.language.getProperty("lblFrameNumber"))) {
                String startNumber = String.format("%.0f", Float.valueOf((float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS + (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS + (float)Integer.parseInt(tc3) * FFPROBE.currentFPS + (float)Integer.parseInt(tc4)));
                timecodeText = String.valueOf(timecodeText) + "drawtext=" + OverlayWindow.font + ":text='%{frame_num}': start_number=" + startNumber + ":x=" + OverlayWindow.textTcPosX.getText() + ":y=" + OverlayWindow.textTcPosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaTc + ":fontsize=" + OverlayWindow.spinnerSizeTC.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexTc;
            } else {
                timecodeText = String.valueOf(timecodeText) + "drawtext=" + OverlayWindow.font + ":timecode='" + tc1 + "\\:" + tc2 + "\\:" + tc3 + "\\:" + tc4 + "':r=" + rate + ":x=" + OverlayWindow.textTcPosX.getText() + ":y=" + OverlayWindow.textTcPosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaTc + ":fontsize=" + OverlayWindow.spinnerSizeTC.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexTc + ":tc24hmax=1";
            }
        }
        if (timecodeText != "") {
            timecodeText = " -filter_complex \"" + timecodeText + '\"';
        }
        return timecodeText;
    }

    protected static String setFlags() {
        return " -sws_flags " + Settings.comboScale.getSelectedItem().toString();
    }

    protected static boolean analyse(File file) throws InterruptedException {
        FFPROBE.FrameData(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        if (DVPAL.errorAnalyse(file.toString())) {
            return false;
        }
        FFPROBE.Data(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        return !DVPAL.errorAnalyse(file.toString());
    }

    protected static String setSortie(String sortie, File file) {
        if (caseChangeFolder1.isSelected()) {
            sortie = lblDestination1.getText();
        } else {
            sortie = file.getParent();
            lblDestination1.setText(sortie);
        }
        return sortie;
    }

    private static boolean errorAnalyse(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            return true;
        }
        return false;
    }

    private static boolean actionsDeFin(String fichier, File fileOut, String sortie) {
        if (FFMPEG.error || fileOut.length() == 0L) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
            String extension = fichier.substring(fichier.lastIndexOf("."));
            File listeBAB = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
            listeBAB.delete();
        }
        if (cancelled) {
            try {
                fileOut.delete();
            }
            catch (Exception extension) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblTermine.setText(Utils.completedFiles(++complete));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(sortie));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.sendMail(fichier);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            DVPAL.main();
            return true;
        }
        return false;
    }
}

