/*
 * Decompiled with CFR 0.152.
 */
package functions.video;

import application.Ftp;
import application.OverlayWindow;
import application.RecordInputDevice;
import application.Settings;
import application.Shutter;
import application.SubtitlesWindow;
import application.Utils;
import application.VideoPlayer;
import application.WatermarkWindow;
import application.Wetransfer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import library.BMXTRANSWRAP;
import library.FFMPEG;
import library.FFPROBE;

public class AppleProRes
extends Shutter {
    private static int complete;
    private static File OPAtomFolder;
    private static File vidstab;

    static {
        vidstab = null;
    }

    public static void main(final boolean encode) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    block34: {
                        File file = new File((String)liste.getElementAt(i));
                        if (Shutter.scanIsRunning) {
                            file = Utils.scanFolder((String)liste.getElementAt(i));
                            if (file == null) break;
                            btnStart.setEnabled(true);
                            progressBar1.setIndeterminate(false);
                        } else if (Settings.btnWaitFileComplete.isSelected()) {
                            progressBar1.setIndeterminate(true);
                            lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                            lblEncodageEnCours.setText(file.getName());
                            tempsRestant.setVisible(false);
                            btnStart.setEnabled(false);
                            btnCancel.setEnabled(true);
                            comboFonctions.setEnabled(false);
                            long fileSize = 0L;
                            do {
                                fileSize = file.length();
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (fileSize != file.length() && !cancelled);
                            while (!file.renameTo(file) && !cancelled) {
                                if (!file.exists()) break;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (cancelled) {
                                progressBar1.setIndeterminate(false);
                                lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                                btnStart.setEnabled(true);
                                btnCancel.setEnabled(false);
                                comboFonctions.setEnabled(true);
                                break;
                            }
                            progressBar1.setIndeterminate(false);
                            btnCancel.setEnabled(false);
                        }
                        try {
                            String fichier = file.getName();
                            String extension = fichier.substring(fichier.lastIndexOf("."));
                            String audio = "";
                            if (caseOPATOM.isSelected()) {
                                frame.setCursor(Cursor.getPredefinedCursor(3));
                                String audioFiles = "";
                                if (!FFPROBE.FindStreams(file.toString())) break block34;
                                audio = audioFiles = AppleProRes.setAudioFiles(audioFiles, file);
                                frame.setCursor(Cursor.getPredefinedCursor(0));
                            }
                            lblEncodageEnCours.setText(fichier);
                            if (AppleProRes.analyse(file)) {
                                audio = AppleProRes.setAudio(audio);
                                FFMPEG.fonctionInOut();
                                String sortie = AppleProRes.setSortie("", file);
                                String concat = FFMPEG.setConcat(file, sortie);
                                if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
                                    file = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
                                }
                                String sequence = AppleProRes.setSequence(file, extension);
                                file = AppleProRes.setSequenceName(file, extension);
                                String loop = AppleProRes.setLoop(extension);
                                String logo = AppleProRes.setLogo();
                                String subtitles = AppleProRes.setSubtitles();
                                String forceField = AppleProRes.setInterlace();
                                String codec = AppleProRes.setCodec();
                                String colorspace = AppleProRes.setColorspace();
                                String filterComplex = AppleProRes.setDeinterlace();
                                filterComplex = AppleProRes.setBlend(filterComplex);
                                filterComplex = AppleProRes.setMotionBlur(filterComplex);
                                filterComplex = AppleProRes.setLUT(filterComplex);
                                filterComplex = AppleProRes.setLevels(filterComplex);
                                filterComplex = AppleProRes.setColormatrix(filterComplex);
                                filterComplex = AppleProRes.setColor(filterComplex);
                                filterComplex = AppleProRes.setStabilisation(vidstab, filterComplex, file, fichier, concat);
                                filterComplex = AppleProRes.setDeflicker(filterComplex);
                                filterComplex = AppleProRes.setDeband(filterComplex);
                                filterComplex = AppleProRes.setDetails(filterComplex);
                                filterComplex = AppleProRes.setDenoiser(filterComplex);
                                filterComplex = AppleProRes.setExposure(filterComplex);
                                filterComplex = AppleProRes.setInterpolation(filterComplex);
                                filterComplex = AppleProRes.setSlowMotion(filterComplex);
                                filterComplex = AppleProRes.setPTS(filterComplex);
                                filterComplex = AppleProRes.setConform(filterComplex);
                                filterComplex = AppleProRes.setWatermark(filterComplex);
                                filterComplex = AppleProRes.showTimecode(filterComplex, fichier);
                                filterComplex = AppleProRes.setCrop(filterComplex);
                                filterComplex = AppleProRes.setRotate(filterComplex);
                                filterComplex = AppleProRes.setDAR(filterComplex);
                                filterComplex = AppleProRes.setPad(filterComplex);
                                filterComplex = AppleProRes.setInterlace50p(filterComplex);
                                filterComplex = AppleProRes.setOverlay(filterComplex);
                                filterComplex = AppleProRes.setLimiter(filterComplex);
                                filterComplex = AppleProRes.setFade(filterComplex);
                                filterComplex = AppleProRes.setFilterComplex(filterComplex, audio);
                                String timecode = AppleProRes.setTimecode();
                                String flags = AppleProRes.setFlags();
                                String opatom = AppleProRes.setOPATOM(audio);
                                String frameRate = AppleProRes.setFramerate();
                                String nomExtension = Settings.btnExtension.isSelected() ? Settings.txtExtension.getText() : "_ProRes_" + comboFilter.getSelectedItem().toString().replace(" ", "_");
                                String sortieFichier = caseCreateOPATOM.isSelected() ? String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, String.valueOf(nomExtension) + ".mxf") : String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, String.valueOf(nomExtension) + ".mov");
                                File fileOut = new File(sortieFichier);
                                if (!fileOut.exists() || (fileOut = caseCreateOPATOM.isSelected() ? Utils.fileReplacement(sortie, fichier, extension, String.valueOf(nomExtension) + "_", ".mxf") : Utils.fileReplacement(sortie, fichier, extension, String.valueOf(nomExtension) + "_", ".mov")) != null) {
                                    String output = String.valueOf('\"') + fileOut.toString() + '\"';
                                    if (caseDisplay.isSelected()) {
                                        output = "-f tee \"" + fileOut.toString().replace("\\", "/") + "|[f=matroska]pipe:play" + '\"';
                                    }
                                    if (!cancelled && !FFMPEG.error) {
                                        String cmd = String.valueOf(opatom) + frameRate + filterComplex + codec + colorspace + forceField + timecode + flags + " -y ";
                                        if (caseStabilisation.isSelected()) {
                                            String stab = " PathToFFMPEG -i pipe:stab" + cmd;
                                            FFMPEG.run(String.valueOf(FFMPEG.inPoint) + concat + " -i " + '\"' + file.toString() + '\"' + logo + subtitles + FFMPEG.postInPoint + FFMPEG.outPoint + " -pix_fmt yuv420p -f yuv4mpegpipe pipe:stab |" + stab + output);
                                        } else if (inputDeviceIsRunning) {
                                            String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(Calendar.getInstance().getTime());
                                            if ((((String)liste.getElementAt(0)).equals("Capture.current.screen") || System.getProperty("os.name").contains("Mac")) && RecordInputDevice.audioDeviceIndex > 0) {
                                                cmd = cmd.replace("1:v", "2:v").replace("-map v", "-map 1:v").replace("0:v", "1:v");
                                            }
                                            if (!encode) {
                                                FFMPEG.toFFPLAY(" " + RecordInputDevice.setInputDevices() + logo + cmd + " -f matroska pipe:play |");
                                                break;
                                            }
                                            FFMPEG.run(" " + RecordInputDevice.setInputDevices() + logo + cmd + output.replace("Capture.current", timeStamp).replace("Capture.input", timeStamp));
                                            fileOut = new File(fileOut.toString().replace("Capture.current", timeStamp).replace("Capture.input", timeStamp));
                                        } else if (encode) {
                                            FFMPEG.run(String.valueOf(loop) + FFMPEG.inPoint + sequence + concat + " -i " + '\"' + file.toString() + '\"' + logo + subtitles + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + output);
                                        } else {
                                            FFMPEG.toFFPLAY(String.valueOf(loop) + FFMPEG.inPoint + sequence + concat + " -i " + '\"' + file.toString() + '\"' + logo + subtitles + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + " -f matroska pipe:play |");
                                            break;
                                        }
                                        do {
                                            Thread.sleep(100L);
                                        } while (FFMPEG.runProcess.isAlive());
                                        if (caseCreateOPATOM.isSelected() && !FFMPEG.saveCode && !cancelled && !FFMPEG.error) {
                                            lblEncodageEnCours.setText(Shutter.language.getProperty("createOpatomFiles"));
                                            String key = AppleProRes.getRandomHexString().toUpperCase();
                                            BMXTRANSWRAP.run("-t avid -p -o \"" + sortie + "/" + fichier.replace(extension, key) + '\"' + " --clip " + '\"' + fichier.replace(extension, "") + '\"' + " --tape " + '\"' + fichier + '\"' + " " + '\"' + fileOut.toString() + '\"');
                                            do {
                                                Thread.sleep(100L);
                                            } while (BMXTRANSWRAP.isRunning);
                                        }
                                    }
                                    if ((!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !FFMPEG.saveCode && caseEnableSequence.isSelected() || !FFMPEG.saveCode && Settings.btnSetBab.isSelected() || !FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) && AppleProRes.actionsDeFin(fichier, fileOut, sortie, vidstab)) {
                                        break;
                                    }
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            FFMPEG.error = true;
                        }
                    }
                    ++i;
                }
                OPAtomFolder = null;
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && encode) {
                    AppleProRes.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    protected static boolean analyse(File file) throws InterruptedException {
        if (!inputDeviceIsRunning) {
            FFPROBE.FrameData(file.toString());
            do {
                Thread.sleep(100L);
            } while (FFPROBE.isRunning);
            if (AppleProRes.errorAnalyse(file.toString())) {
                return false;
            }
        }
        FFPROBE.Data(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        return !AppleProRes.errorAnalyse(file.toString());
    }

    protected static String setAudioFiles(String audioFiles, File file) {
        int channels = 1;
        int i2 = 0;
        while (i2 < liste.getSize()) {
            File audioName = new File((String)liste.getElementAt(i2));
            audioName = new File(audioName.getName().substring(0, audioName.getName().lastIndexOf(".")));
            File videoName = new File(file.getName().substring(0, file.getName().lastIndexOf(".")));
            if (audioName.toString().contains(videoName.toString()) && !audioName.toString().equals(videoName.toString())) {
                audioFiles = String.valueOf(audioFiles) + " -i \"" + (String)liste.getElementAt(i2) + '\"' + " ";
                ++channels;
            }
            ++i2;
        }
        int map = 0;
        while (map < channels) {
            if (map > 0) {
                audioFiles = String.valueOf(audioFiles) + "-map " + map + ":a ";
            }
            ++map;
        }
        return audioFiles;
    }

    protected static String setAudio(String audioFiles) {
        long audioStart;
        String audio = " -c:a pcm_s16le";
        if (FFPROBE.qantization == 24) {
            audio = " -c:a pcm_s24le";
        } else if (FFPROBE.qantization == 32) {
            audio = " -c:a pcm_s32le";
        }
        if (caseAudioFadeIn.isSelected()) {
            long audioInValue = (long)((float)Integer.parseInt(spinnerAudioFadeIn.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioStart = 0L;
            if (caseInAndOut.isSelected() && VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper"))) {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = totalIn >= 10000L ? 10000L : (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
            }
            String audioFade = "afade=in:st=" + audioStart + "ms:d=" + audioInValue + "ms";
            audio = audio.contains("-filter:a") ? String.valueOf(audio) + "," + audioFade : String.valueOf(audio) + " -filter:a " + audioFade;
        }
        if (caseAudioFadeOut.isSelected()) {
            long audioOutValue = (long)((float)Integer.parseInt(spinnerAudioFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioStart = (long)FFPROBE.totalLength - audioOutValue;
            if (caseInAndOut.isSelected()) {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long totalOut = (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper")) ? (totalIn >= 10000L ? 10000L + (totalOut - totalIn) - audioOutValue : (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - audioOutValue) : (long)FFPROBE.totalLength - (totalOut - totalIn) - audioOutValue;
            }
            String audioFade = "afade=out:st=" + audioStart + "ms:d=" + audioOutValue + "ms";
            audio = audio.contains("-filter:a") ? String.valueOf(audio) + "," + audioFade : String.valueOf(audio) + " -filter:a " + audioFade;
        }
        if (caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse")))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            float value = newFPS / FFPROBE.currentFPS;
            if (value < 0.5f || value > 2.0f) {
                return " -an";
            }
            audio = audio.contains("-filter:a") ? String.valueOf(audio) + "," + "atempo=" + value : String.valueOf(audio) + " -filter:a " + "atempo=" + value;
        }
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            return " -an";
        }
        if (caseOPATOM.isSelected()) {
            return String.valueOf(audioFiles) + audio + " -ar 48000";
        }
        String mapping = "";
        if (inputDeviceIsRunning) {
            mapping = ((String)liste.getElementAt(0)).equals("Capture.current.screen") && RecordInputDevice.audioDeviceIndex > 0 && RecordInputDevice.overlayAudioDeviceIndex > 0 ? " -map a? -map 2?" : " -map a?";
        } else {
            if (comboAudio1.getSelectedIndex() == 0 && comboAudio2.getSelectedIndex() == 1 && comboAudio3.getSelectedIndex() == 2 && comboAudio4.getSelectedIndex() == 3 && comboAudio5.getSelectedIndex() == 4 && comboAudio6.getSelectedIndex() == 5 && comboAudio7.getSelectedIndex() == 6 && comboAudio8.getSelectedIndex() == 7) {
                return String.valueOf(audio) + " -ar 48000 -map a?";
            }
            if (comboAudio1.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio1.getSelectedIndex() + "?";
            }
            if (comboAudio2.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio2.getSelectedIndex() + "?";
            }
            if (comboAudio3.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio3.getSelectedIndex() + "?";
            }
            if (comboAudio4.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio4.getSelectedIndex() + "?";
            }
            if (comboAudio5.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio5.getSelectedIndex() + "?";
            }
            if (comboAudio6.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio6.getSelectedIndex() + "?";
            }
            if (comboAudio7.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio7.getSelectedIndex() + "?";
            }
            if (comboAudio8.getSelectedIndex() != 8) {
                mapping = String.valueOf(mapping) + " -map a:" + comboAudio8.getSelectedIndex() + "?";
            }
        }
        return String.valueOf(audio) + " -ar 48000" + mapping;
    }

    protected static String setSequence(File file, String extension) {
        if (caseEnableSequence.isSelected()) {
            int n = 0;
            while (file.toString().substring(file.toString().lastIndexOf(".") - ++n).replace(extension, "").matches("[0-9]+")) {
            }
            if (caseBlend.isSelected()) {
                return " -start_number " + file.toString().substring(file.toString().lastIndexOf(".") - n + 1).replace(extension, "");
            }
            return " -framerate " + caseSequenceFPS.getSelectedItem().toString().replace(",", ".") + " -start_number " + file.toString().substring(file.toString().lastIndexOf(".") - n + 1).replace(extension, "");
        }
        return "";
    }

    protected static File setSequenceName(File file, String extension) {
        if (caseEnableSequence.isSelected()) {
            int n = 0;
            while (file.toString().substring(file.toString().lastIndexOf(".") - ++n).replace(extension, "").matches("[0-9]+")) {
            }
            int nombre = n - 1;
            file = new File(String.valueOf(file.toString().substring(0, file.toString().lastIndexOf(".") - nombre)) + "%0" + nombre + "d" + extension);
        }
        return file;
    }

    protected static String setCrop(String filterComplex) {
        if (caseRognerImage.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + "," + Shutter.cropFinal : Shutter.cropFinal;
        }
        return filterComplex;
    }

    protected static String setPad(String filterComplex) {
        if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
            String[] s = comboResolution.getSelectedItem().toString().split("x");
            if (lblPad.getText().equals(language.getProperty("lblPad"))) {
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "scale=" + s[0] + ":" + s[1] + ":force_original_aspect_ratio=decrease,pad=" + s[0] + ":" + s[1] + ":(ow-iw)*0.5:(oh-ih)*0.5";
            } else if (lblPad.getText().equals(language.getProperty("lblStretch"))) {
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "scale=" + s[0] + ":" + s[1];
            } else {
                String[] i = FFPROBE.imageResolution.split("x");
                int iw = Integer.parseInt(i[0]);
                int ih = Integer.parseInt(i[1]);
                int ow = Integer.parseInt(s[0]);
                int oh = Integer.parseInt(s[1]);
                float ir = (float)iw / (float)ih;
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = iw > ow || ih > oh ? ((float)ow / ir >= (float)oh ? String.valueOf(filterComplex) + "scale=" + ow + ":-1,crop=" + "'" + ow + ":" + oh + ":0:(ih-oh)*0.5" + "'" : String.valueOf(filterComplex) + "scale=-1:" + oh + ",crop=" + "'" + ow + ":" + oh + ":(iw-ow)*0.5:0" + "'") : String.valueOf(filterComplex) + "scale=" + ow + ":" + oh;
            }
        }
        return filterComplex;
    }

    protected static String setDAR(String filterComplex) {
        if (caseForcerDAR.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "setdar=" + comboDAR.getSelectedItem().toString().replace(":", "/");
        }
        return filterComplex;
    }

    protected static String setLoop(String extension) {
        block21: {
            if (caseEnableSequence.isSelected()) break block21;
            switch (extension) {
                case ".bmp": 
                case ".jpg": 
                case ".png": 
                case ".psd": 
                case ".tga": 
                case ".tif": 
                case ".jpeg": 
                case ".tiff": {
                    Shutter.progressBar1.setMaximum(10);
                    return " -loop 1 -t " + Settings.txtImageDuration.getText();
                }
            }
        }
        return "";
    }

    protected static String setInterlace() {
        if (caseForcerProgressif.isSelected()) {
            return " -field_order progressive";
        }
        if (FFPROBE.entrelaced.equals("1") || caseForcerEntrelacement.isSelected()) {
            if (FFPROBE.entrelaced.equals("1") && FFPROBE.fieldOrder.equals("1") || caseForcerInversion.isSelected()) {
                return " -field_order bt";
            }
            return " -field_order tt";
        }
        return "";
    }

    protected static String setDeinterlace() {
        if (caseForcerDesentrelacement.isSelected() && comboForcerDesentrelacement.getSelectedItem().toString().equals("detelecine")) {
            String detelecineFields = "top";
            if (lblTFF.getText().equals("BFF")) {
                detelecineFields = "bottom";
            }
            return String.valueOf(comboForcerDesentrelacement.getSelectedItem().toString()) + "=first_field=" + detelecineFields;
        }
        if (caseForcerDesentrelacement.isSelected()) {
            int doubler = 0;
            if (lblTFF.getText().equals("x2") && caseForcerDesentrelacement.isSelected()) {
                doubler = 1;
            }
            return String.valueOf(comboForcerDesentrelacement.getSelectedItem().toString()) + "=" + doubler + ":" + FFPROBE.fieldOrder + ":0";
        }
        if (FFPROBE.entrelaced.equals("1") && caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByInterpolation")))) {
            return String.valueOf(comboForcerDesentrelacement.getSelectedItem().toString()) + "=0:" + FFPROBE.fieldOrder + ":0";
        }
        return "";
    }

    protected static String setBlend(String filterComplex) {
        if (caseBlend.isSelected()) {
            int value = sliderBlend.getValue();
            StringBuilder blend = new StringBuilder();
            int i = 0;
            while (i < value) {
                blend.append("tblend=all_mode=average,");
                ++i;
            }
            blend.append("setpts=" + 25.0f / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", ".")) + "*PTS");
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + "," + blend : "" + blend;
        }
        return filterComplex;
    }

    protected static String setMotionBlur(String filterComplex) {
        if (caseMotionBlur.isSelected()) {
            float fps = Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", ".")) * 2.0f;
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",minterpolate=fps=" + fps + ",tblend=all_mode=average,framestep=2" : "minterpolate=fps=" + fps + ",tblend=all_mode=average,framestep=2";
        }
        return filterComplex;
    }

    protected static String setLUT(String filterComplex) {
        if (caseLUTs.isSelected()) {
            String pathToLuts;
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/";
            } else {
                pathToLuts = "LUTs/";
            }
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",lut3d=file=" + pathToLuts + Shutter.comboLUTs.getSelectedItem().toString() : "lut3d=file=" + pathToLuts + Shutter.comboLUTs.getSelectedItem().toString();
        }
        return filterComplex;
    }

    protected static String setLevels(String filterComplex) {
        if (caseLevels.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "scale=in_range=" + comboInLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full") + ":out_range=" + comboOutLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full");
        }
        return filterComplex;
    }

    protected static String setColormatrix(String filterComplex) {
        if (caseColormatrix.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            if (comboInColormatrix.getSelectedItem().equals("HDR")) {
                String pathToLuts;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                    pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/HDR-to-SDR.cube";
                } else {
                    pathToLuts = "LUTs/HDR-to-SDR.cube";
                }
                filterComplex = String.valueOf(filterComplex) + "lut3d=file=" + pathToLuts;
            } else {
                filterComplex = String.valueOf(filterComplex) + "colorspace=iall=" + Shutter.comboInColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625") + ":all=" + Shutter.comboOutColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625");
            }
        }
        return filterComplex;
    }

    protected static String setColor(String filterComplex) {
        if (caseColor.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + "," + finalEQ : finalEQ;
        }
        return filterComplex;
    }

    protected static String setInterlace50p(String videoFilter) {
        if (caseForcerEntrelacement.isSelected()) {
            if (caseConform.isSelected() && !comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
                if (caseConform.isSelected() && Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")).floatValue() >= 50.0f) {
                    videoFilter = videoFilter != "" ? String.valueOf(videoFilter) + ",format=yuv444p,interlace" : "format=yuv444p,interlace";
                }
            } else if (FFPROBE.currentFPS == 50.0f || FFPROBE.currentFPS == 59.94f || FFPROBE.currentFPS == 60.0f) {
                videoFilter = videoFilter != "" ? String.valueOf(videoFilter) + ",format=yuv444p,interlace" : "format=yuv444p,interlace";
            }
        }
        return videoFilter;
    }

    protected static String setStabilisation(File vidstab, String filterComplex, File file, String fichier, String concat) throws InterruptedException {
        if (caseStabilisation.isSelected()) {
            vidstab = System.getProperty("os.name").contains("Windows") ? new File("vidstab.trf") : new File(String.valueOf(Shutter.dirTemp) + "vidstab.trf");
            lblEncodageEnCours.setText(String.valueOf(Shutter.language.getProperty("analyzeOf")) + " " + fichier);
            String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -an -pix_fmt yuv420p -f yuv4mpegpipe pipe:stab | PathToFFMPEG -i pipe:stab -vf vidstabdetect=result=" + vidstab.toString() + " -y -f null -" : " -an -pix_fmt yuv420p -f yuv4mpegpipe pipe:stab | PathToFFMPEG -i pipe:stab -vf vidstabdetect=result=" + vidstab.toString() + " -y -f null -" + '\"';
            FFMPEG.run(String.valueOf(FFMPEG.inPoint) + concat + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd);
            do {
                Thread.sleep(100L);
            } while (FFMPEG.runProcess.isAlive());
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",vidstabtransform=input=" + vidstab.toString() : "vidstabtransform=input=" + vidstab.toString();
            lblEncodageEnCours.setText(fichier);
        }
        return filterComplex;
    }

    protected static String setCodec() {
        switch (comboFilter.getSelectedItem().toString()) {
            case "Proxy": {
                return " -vcodec prores -profile:v 0 -pix_fmt yuv422p10";
            }
            case "LT": {
                return " -vcodec prores -profile:v 1 -pix_fmt yuv422p10";
            }
            case "422": {
                return " -vcodec prores -profile:v 2 -pix_fmt yuv422p10";
            }
            case "422 HQ": {
                return " -vcodec prores -profile:v 3 -pix_fmt yuv422p10";
            }
            case "444": {
                return " -vcodec prores -profile:v 4 -pix_fmt yuv444p10";
            }
            case "4444": {
                return " -vcodec prores_ks -pix_fmt yuva444p10le -alpha_bits 16 -profile:v 4444";
            }
            case "4444 XQ": {
                return " -vcodec prores_ks -pix_fmt yuva444p10le -alpha_bits 16 -profile:v 4444xq";
            }
        }
        return "";
    }

    protected static String setColorspace() {
        if (caseColorspace.isSelected()) {
            if (comboColorspace.getSelectedItem().equals("Rec. 709")) {
                return " -color_primaries bt709 -color_trc bt709 -colorspace bt709";
            }
            if (comboColorspace.getSelectedItem().equals("Rec. 2020 PQ")) {
                return " -color_primaries bt2020 -color_trc smpte2084 -colorspace bt2020nc";
            }
            if (comboColorspace.getSelectedItem().equals("Rec. 2020 HLG")) {
                return " -color_primaries bt2020 -color_trc arib-std-b67 -colorspace bt2020nc";
            }
            return "";
        }
        return "";
    }

    protected static String setRotate(String filter) {
        String rotate;
        block19: {
            block17: {
                rotate = "";
                if (!caseRotate.isSelected()) break block17;
                String transpose = "";
                switch (comboRotate.getSelectedItem().toString()) {
                    case "90": {
                        if (caseMiror.isSelected()) {
                            transpose = "transpose=3";
                            break;
                        }
                        transpose = "transpose=1";
                        break;
                    }
                    case "-90": {
                        if (caseMiror.isSelected()) {
                            transpose = "transpose=0";
                            break;
                        }
                        transpose = "transpose=2";
                        break;
                    }
                    case "180": {
                        transpose = caseMiror.isSelected() ? "transpose=1,transpose=1,hflip" : "transpose=1,transpose=1";
                    }
                }
                rotate = transpose;
                break block19;
            }
            if (caseMiror.isSelected()) {
                rotate = "hflip";
            }
        }
        if (rotate != "") {
            filter = filter != "" ? String.valueOf(filter) + "," + rotate : rotate;
        }
        return filter;
    }

    protected static String setDeflicker(String filterComplex) {
        if (caseDeflicker.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",split[a][b];[b]setpts=PTS-STARTPTS+" + 1.0f / FFPROBE.currentFPS + "/TB,format=rgba,colorchannelmixer=aa=0.5[deflicker];[a][deflicker]overlay=shortest=1" : "split[a][b];[b]setpts=PTS-STARTPTS+" + 1.0f / FFPROBE.currentFPS + "/TB,format=rgba,colorchannelmixer=aa=0.5[deflicker];[a][deflicker]overlay=shortest=1";
        }
        return filterComplex;
    }

    protected static String setDeband(String filterComplex) {
        if (caseBanding.isSelected()) {
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",deband=r=32" : "deband=r=32";
        }
        return filterComplex;
    }

    protected static String setDetails(String filterComplex) {
        if (caseDetails.isSelected()) {
            float value = 0.0f - (float)sliderDetails.getValue() / 10.0f;
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",smartblur=1.0:" + value : "smartblur=1.0:" + value;
        }
        return filterComplex;
    }

    protected static String setFlags() {
        String metadata = " -metadata:s \"encoder=" + comboFonctions.getSelectedItem().toString() + " " + comboFilter.getSelectedItem().toString() + '\"' + " -vendor apl0 -movflags write_colr -flags bitexact -chunk_duration 500K";
        return " -sws_flags " + Settings.comboScale.getSelectedItem().toString() + metadata;
    }

    protected static String setDenoiser(String filterComplex) {
        if (caseBruit.isSelected()) {
            int value = sliderBruit.getValue();
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",hqdn3d=" + value + ":" + value + ":" + value + ":" + value : "hqdn3d=" + value + ":" + value + ":" + value + ":" + value;
        }
        return filterComplex;
    }

    protected static String setExposure(String filterComplex) {
        if (caseExposure.isSelected()) {
            int value = sliderExposure.getValue();
            filterComplex = filterComplex != "" ? String.valueOf(filterComplex) + ",deflicker=s=" + Math.ceil(128 * value / 100 + 1) : "deflicker=s=" + Math.ceil(128 * value / 100 + 1);
        }
        return filterComplex;
    }

    protected static String setInterpolation(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformByInterpolation"))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS;
        }
        return filterComplex;
    }

    protected static String setSlowMotion(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS + ",setpts=" + newFPS / FFPROBE.currentFPS + "*PTS";
        }
        return filterComplex;
    }

    protected static String setPTS(String videoFilter) {
        if (caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse")))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (videoFilter != "") {
                videoFilter = String.valueOf(videoFilter) + ",";
            }
            videoFilter = String.valueOf(videoFilter) + "setpts=" + FFPROBE.currentFPS / newFPS + "*PTS";
            if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse"))) {
                videoFilter = String.valueOf(videoFilter) + ",reverse";
            }
        }
        return videoFilter;
    }

    protected static String setLogo() {
        if (caseLogo.isSelected() && Shutter.overlayDeviceIsRunning) {
            return " " + RecordInputDevice.setOverlayDevice();
        }
        if (caseLogo.isSelected()) {
            return " -i \"" + WatermarkWindow.logoFile + '\"';
        }
        return "";
    }

    protected static String setWatermark(String filterComplex) {
        if (caseLogo.isSelected()) {
            filterComplex = filterComplex != "" ? "[0:v]" + filterComplex + "[v];[1:v]scale=iw*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(WatermarkWindow.textOpacity.getText()) / 100.0f + "[scaledwatermark];[v][scaledwatermark]overlay=" + WatermarkWindow.textPosX.getText() + ":" + WatermarkWindow.textPosY.getText() : "[1:v]scale=iw*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(WatermarkWindow.textSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(WatermarkWindow.textOpacity.getText()) / 100.0f + "[scaledwatermark];[0:v][scaledwatermark]overlay=" + WatermarkWindow.textPosX.getText() + ":" + WatermarkWindow.textPosY.getText();
        }
        return filterComplex;
    }

    protected static String setSubtitles() {
        if (caseSubtitles.isSelected() && subtitlesBurn) {
            if (subtitlesFile.toString().substring(subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
                String background = "";
                background = SubtitlesWindow.lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn")) ? ",BorderStyle=4,BackColour=&H" + SubtitlesWindow.alpha + SubtitlesWindow.hex2 + "&,Outline=0" : ",OutlineColour=&H" + SubtitlesWindow.alpha + SubtitlesWindow.hex2 + "&";
                if (SubtitlesWindow.btnG.getForeground() != Color.BLACK) {
                    background = String.valueOf(background) + ",Bold=1";
                }
                if (SubtitlesWindow.btnI.getForeground() != Color.BLACK) {
                    background = String.valueOf(background) + ",Italic=1";
                }
                String[] i = FFPROBE.imageResolution.split("x");
                if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                    String[] s = comboResolution.getSelectedItem().toString().split("x");
                    int iw = Integer.parseInt(i[0]);
                    int ih = Integer.parseInt(i[1]);
                    int ow = Integer.parseInt(s[0]);
                    int oh = Integer.parseInt(s[1]);
                    int width = (int)((float)Integer.parseInt(SubtitlesWindow.textWidth.getText()) / ((float)iw / (float)ow));
                    int height = (int)((float)(ih + Integer.parseInt(SubtitlesWindow.spinnerSubtitlesPosition.getValue().toString())) / ((float)ih / (float)oh));
                    return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + width + ":" + height + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + SubtitlesWindow.comboFont.getSelectedItem().toString() + ",FontSize=" + SubtitlesWindow.spinnerSize.getValue() + ",PrimaryColour=&H" + SubtitlesWindow.hex + "&" + background + "'" + '\"';
                }
                return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + SubtitlesWindow.textWidth.getText() + ":" + i[1] + "+" + SubtitlesWindow.spinnerSubtitlesPosition.getValue() + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + SubtitlesWindow.comboFont.getSelectedItem().toString() + ",FontSize=" + SubtitlesWindow.spinnerSize.getValue() + ",PrimaryColour=&H" + SubtitlesWindow.hex + "&" + background + "'" + '\"';
            }
            String[] i = FFPROBE.imageResolution.split("x");
            SubtitlesWindow.textWidth.setText(i[0]);
            if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] s = comboResolution.getSelectedItem().toString().split("x");
                int iw = Integer.parseInt(i[0]);
                int ih = Integer.parseInt(i[1]);
                int ow = Integer.parseInt(s[0]);
                int oh = Integer.parseInt(s[1]);
                int width = (int)((float)Integer.parseInt(SubtitlesWindow.textWidth.getText()) / ((float)iw / (float)ow));
                int height = (int)((float)(ih + Integer.parseInt(SubtitlesWindow.spinnerSubtitlesPosition.getValue().toString())) / ((float)ih / (float)oh));
                return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + width + ":" + height + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1" + '\"';
            }
            return " -f lavfi" + FFMPEG.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + i[0] + ":" + i[1] + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1" + '\"';
        }
        if (caseSubtitles.isSelected() && !subtitlesBurn) {
            return String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + subtitlesFile.toString() + '\"';
        }
        return "";
    }

    protected static String showTimecode(String filterComplex, String fichier) {
        String tc1 = FFPROBE.timecode1;
        String tc2 = FFPROBE.timecode2;
        String tc3 = FFPROBE.timecode3;
        String tc4 = FFPROBE.timecode4;
        if (OverlayWindow.caseAddTimecode.isSelected()) {
            tc1 = OverlayWindow.TC1.getText();
            tc2 = OverlayWindow.TC2.getText();
            tc3 = OverlayWindow.TC3.getText();
            tc4 = OverlayWindow.TC4.getText();
        }
        if (caseInAndOut.isSelected() && VideoPlayer.sliderIn.getValue() > VideoPlayer.sliderIn.getMinimum() && OverlayWindow.caseAddTimecode.isSelected()) {
            tc1 = String.valueOf(Integer.parseInt(tc1) - Integer.parseInt(VideoPlayer.caseInH.getText()));
            tc2 = String.valueOf(Integer.parseInt(tc2) - Integer.parseInt(VideoPlayer.caseInM.getText()));
            tc3 = String.valueOf(Integer.parseInt(tc3) - Integer.parseInt(VideoPlayer.caseInS.getText()));
            tc4 = String.valueOf(Integer.parseInt(tc4) - Integer.parseInt(VideoPlayer.caseInF.getText()));
        }
        String rate = String.valueOf(FFPROBE.currentFPS);
        if (caseConform.isSelected()) {
            rate = comboFPS.getSelectedItem().toString().replace(",", ".");
        }
        if (OverlayWindow.caseShowFileName.isSelected() && caseAddOverlay.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "drawtext=" + OverlayWindow.font + ":text='" + fichier + "':r=" + rate + ":x=" + OverlayWindow.textNamePosX.getText() + ":y=" + OverlayWindow.textNamePosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaName + ":fontsize=" + OverlayWindow.spinnerSizeName.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexName;
        }
        if (OverlayWindow.caseShowText.isSelected() && caseAddOverlay.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "drawtext=" + OverlayWindow.font + ":text='" + OverlayWindow.text.getText() + "':r=" + rate + ":x=" + OverlayWindow.textNamePosX.getText() + ":y=" + OverlayWindow.textNamePosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaName + ":fontsize=" + OverlayWindow.spinnerSizeName.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexName;
        }
        if ((OverlayWindow.caseAddTimecode.isSelected() || OverlayWindow.caseShowTimecode.isSelected()) && caseAddOverlay.isSelected()) {
            String dropFrame = ":";
            if (!caseConform.isSelected() && (FFPROBE.currentFPS == 29.97f || FFPROBE.currentFPS == 59.94f) || caseConform.isSelected() && (comboFPS.getSelectedItem().toString().equals("29,97") || comboFPS.getSelectedItem().toString().equals("59,94"))) {
                dropFrame = ";";
            }
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            if (OverlayWindow.caseAddTimecode.isSelected() && OverlayWindow.lblTimecode.getText().equals(Shutter.language.getProperty("lblFrameNumber"))) {
                String startNumber = String.format("%.0f", Float.valueOf((float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS + (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS + (float)Integer.parseInt(tc3) * FFPROBE.currentFPS + (float)Integer.parseInt(tc4)));
                filterComplex = String.valueOf(filterComplex) + "drawtext=" + OverlayWindow.font + ":text='%{frame_num}': start_number=" + startNumber + ":x=" + OverlayWindow.textTcPosX.getText() + ":y=" + OverlayWindow.textTcPosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaTc + ":fontsize=" + OverlayWindow.spinnerSizeTC.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexTc;
            } else {
                filterComplex = String.valueOf(filterComplex) + "drawtext=" + OverlayWindow.font + ":timecode='" + tc1 + "\\:" + tc2 + "\\:" + tc3 + "\\" + dropFrame + tc4 + "':r=" + rate + ":x=" + OverlayWindow.textTcPosX.getText() + ":y=" + OverlayWindow.textTcPosY.getText() + ":fontcolor=0x" + OverlayWindow.hex + OverlayWindow.hexAlphaTc + ":fontsize=" + OverlayWindow.spinnerSizeTC.getValue() + ":box=1:boxcolor=0x" + OverlayWindow.hex2 + OverlayWindow.hexTc + ":tc24hmax=1";
            }
        }
        return filterComplex;
    }

    protected static String setOverlay(String filterComplex) {
        if (caseSubtitles.isSelected() && subtitlesBurn) {
            String[] i = FFPROBE.imageResolution.split("x");
            int ImageWidth = Integer.parseInt(i[0]);
            int posX = (ImageWidth - Integer.parseInt(SubtitlesWindow.textWidth.getText())) / 2;
            if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] s = comboResolution.getSelectedItem().toString().split("x");
                int iw = Integer.parseInt(i[0]);
                int ow = Integer.parseInt(s[0]);
                posX = (int)((float)posX / ((float)iw / (float)ow));
            }
            filterComplex = caseLogo.isSelected() ? String.valueOf(filterComplex) + "[p];[p][2:v]overlay=shortest=1:x=" + posX : (filterComplex != "" ? String.valueOf(filterComplex) + "[p];[p][1:v]overlay=shortest=1:x=" + posX : "[0:v][1:v]overlay=shortest=1:x=" + posX);
        }
        return filterComplex;
    }

    protected static String setLimiter(String filterComplex) {
        if (caseLimiter.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            if (FFPROBE.imageDepth == 8) {
                filterComplex = "limiter=16:235";
            } else if (FFPROBE.imageDepth == 10) {
                filterComplex = "limiter=64:940";
            } else if (FFPROBE.imageDepth == 12) {
                filterComplex = "limiter=256:3760";
            } else if (FFPROBE.imageDepth == 16) {
                filterComplex = "limiter=4096:60160";
            }
        }
        return filterComplex;
    }

    protected static String setTimecode() {
        if (caseSetTimecode.isSelected()) {
            return " -timecode " + TCset1.getText() + ":" + TCset2.getText() + ":" + TCset3.getText() + ":" + TCset4.getText();
        }
        if (FFPROBE.timecode1 != "") {
            return " -timecode " + FFPROBE.timecode1 + ":" + FFPROBE.timecode2 + ":" + FFPROBE.timecode3 + ":" + FFPROBE.timecode4;
        }
        return "";
    }

    protected static String setConform(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformByBlending"))) {
            float newFPS = Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")).floatValue();
            float FPS = FFPROBE.currentFPS;
            if (caseEnableSequence.isSelected()) {
                FPS = Float.valueOf(caseSequenceFPS.getSelectedItem().toString().replace(",", ".").replace(",", ".")).floatValue();
            }
            if (FPS != newFPS) {
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS + ":mi_mode=blend";
            }
        }
        return filterComplex;
    }

    protected static String setFade(String filterComplex) {
        String videoFade;
        long videoStart;
        if (caseVideoFadeIn.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            long videoInValue = (long)((float)Integer.parseInt(spinnerVideoFadeIn.getText()) * (1000.0f / FFPROBE.currentFPS));
            videoStart = 0L;
            if (caseInAndOut.isSelected() && VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper"))) {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                videoStart = totalIn >= 10000L ? 10000L : (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
            }
            String color = "black";
            if (lblFadeInColor.getText().equals(language.getProperty("white"))) {
                color = "white";
            }
            videoFade = "fade=in:st=" + videoStart + "ms:d=" + videoInValue + "ms:color=" + color;
            filterComplex = String.valueOf(filterComplex) + videoFade;
        }
        if (caseVideoFadeOut.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            long videoOutValue = (long)((float)Integer.parseInt(spinnerVideoFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
            videoStart = (long)FFPROBE.totalLength - videoOutValue;
            if (caseInAndOut.isSelected()) {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long totalOut = (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                videoStart = VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper")) ? (totalIn >= 10000L ? 10000L + (totalOut - totalIn) - videoOutValue : (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - videoOutValue) : (long)FFPROBE.totalLength - (totalOut - totalIn) - videoOutValue;
            }
            String color = "black";
            if (lblFadeOutColor.getText().equals(language.getProperty("white"))) {
                color = "white";
            }
            videoFade = "fade=out:st=" + videoStart + "ms:d=" + videoOutValue + "ms:color=" + color;
            filterComplex = String.valueOf(filterComplex) + videoFade;
        }
        return filterComplex;
    }

    protected static String setFilterComplex(String filterComplex, String audio) {
        if (caseOPATOM.isSelected()) {
            audio = "";
        }
        if (filterComplex != "") {
            filterComplex = caseLogo.isSelected() || caseSubtitles.isSelected() && subtitlesBurn ? " -filter_complex \"" + filterComplex + "[out]" : " -filter_complex \"[0:v]" + filterComplex + "[out]";
            filterComplex = String.valueOf(filterComplex) + "\" -map \"[out]\"" + audio;
        } else {
            filterComplex = " -map v" + audio;
        }
        if (caseSubtitles.isSelected() && !subtitlesBurn) {
            String map = " -map 1:s";
            if (caseLogo.isSelected()) {
                map = " -map 2:s";
            }
            String[] languages = Locale.getISOLanguages();
            Locale loc = new Locale(languages[comboSubtitles.getSelectedIndex()]);
            filterComplex = String.valueOf(filterComplex) + map + " -c:s mov_text -metadata:s:s:0 language=" + loc.getISO3Language();
        }
        return filterComplex;
    }

    protected static String setOPATOM(String audio) {
        if (caseOPATOM.isSelected()) {
            return audio;
        }
        return "";
    }

    protected static String setFramerate() {
        if (caseForcerEntrelacement.isSelected() && caseConform.isSelected() && comboFPS.getSelectedItem().toString().equals("50")) {
            return " -r 25";
        }
        if (caseForcerEntrelacement.isSelected() && caseConform.isSelected() && comboFPS.getSelectedItem().toString().equals("59,94")) {
            return " -r 29.97";
        }
        if (caseForcerEntrelacement.isSelected() && caseConform.isSelected() && comboFPS.getSelectedItem().toString().equals("60")) {
            return " -r 30";
        }
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            return " -r " + FFPROBE.currentFPS;
        }
        if (caseConform.isSelected()) {
            return " -r " + Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", "."));
        }
        if (caseEnableSequence.isSelected()) {
            if (caseConform.isSelected()) {
                return " -r " + Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")) + " -frames:v " + liste.getSize();
            }
            return " -r " + caseSequenceFPS.getSelectedItem().toString().replace(",", ".") + " -frames:v " + liste.getSize();
        }
        if (inputDeviceIsRunning) {
            return " -vsync vfr";
        }
        return "";
    }

    protected static String setSortie(String sortie, File file) {
        if (caseChangeFolder1.isSelected()) {
            sortie = lblDestination1.getText();
            if (caseCreateOPATOM.isSelected()) {
                String number = new File(sortie).getName();
                if (number.matches("^[0-9]+$")) {
                    if (OPAtomFolder == null) {
                        OPAtomFolder = file.getName().contains(file.getParentFile().getName()) ? new File(file.getParentFile().getParent()) : new File(file.getParent());
                    } else if (file.getName().contains(file.getParentFile().getName())) {
                        if (!file.getParentFile().getParent().toString().equals(OPAtomFolder.toString())) {
                            File newFolder;
                            int n = Integer.parseInt(number) + 1;
                            do {
                                newFolder = new File(String.valueOf(new File(sortie).getParent()) + "/" + n);
                                ++n;
                            } while (newFolder.exists());
                            newFolder.mkdir();
                            lblDestination1.setText(newFolder.toString());
                            sortie = lblDestination1.getText();
                            OPAtomFolder = new File(file.getParentFile().getParent());
                        }
                    } else if (!file.getParent().toString().equals(OPAtomFolder.toString())) {
                        File newFolder;
                        int n = Integer.parseInt(number) + 1;
                        do {
                            newFolder = new File(String.valueOf(new File(sortie).getParent()) + "/" + n);
                            ++n;
                        } while (newFolder.exists());
                        newFolder.mkdir();
                        lblDestination1.setText(newFolder.toString());
                        sortie = lblDestination1.getText();
                        OPAtomFolder = new File(file.getParent());
                    }
                }
            } else if (caseCreateTree.isSelected()) {
                File pathToFile = null;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    String[] s = file.getParent().toString().split("/");
                    pathToFile = new File(String.valueOf(lblDestination1.getText()) + file.getParent().toString().replace("/Volumes", "").replace(s[2], ""));
                } else {
                    pathToFile = new File(String.valueOf(lblDestination1.getText()) + file.getParent().toString().substring(2));
                }
                if (!pathToFile.exists()) {
                    pathToFile.mkdirs();
                }
                sortie = pathToFile.toString();
            }
        } else {
            sortie = file.getParent();
            lblDestination1.setText(sortie);
        }
        return sortie;
    }

    public static String getRandomHexString() {
        Random r = new Random();
        StringBuffer sb = new StringBuffer();
        while (sb.length() < 10) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.toString().substring(0, 10);
    }

    private static boolean errorAnalyse(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            return true;
        }
        return false;
    }

    private static boolean actionsDeFin(String fichier, File fileOut, String sortie, File vidstab) {
        if (FFMPEG.error || fileOut.length() == 0L || caseCreateOPATOM.isSelected()) {
            if (FFMPEG.error) {
                FFMPEG.errorList.append(fichier);
                FFMPEG.errorList.append(System.lineSeparator());
            }
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (vidstab != null && vidstab.exists()) {
            vidstab.delete();
        }
        if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
            String extension = fichier.substring(fichier.lastIndexOf("."));
            File listeBAB = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
            listeBAB.delete();
        }
        if (cancelled) {
            try {
                fileOut.delete();
            }
            catch (Exception extension) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblTermine.setText(Utils.completedFiles(++complete));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(sortie));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.sendMail(fichier);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (caseEnableSequence.isSelected() || Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (caseIncrementTimecode.isSelected()) {
            DecimalFormat formatter = new DecimalFormat("00");
            int timecodeToMs = Integer.parseInt(TCset1.getText()) * 3600000 + Integer.parseInt(TCset2.getText()) * 60000 + Integer.parseInt(TCset3.getText()) * 1000 + Integer.parseInt(TCset4.getText()) * (int)(1000.0f / FFPROBE.currentFPS);
            int millisecondsToTc = timecodeToMs + FFPROBE.totalLength;
            if (caseInAndOut.isSelected()) {
                millisecondsToTc = timecodeToMs + VideoPlayer.dureeHeures * 3600000 + VideoPlayer.dureeMinutes * 60000 + VideoPlayer.dureeSecondes * 1000 + VideoPlayer.dureeImages * (int)(1000.0f / FFPROBE.currentFPS);
            }
            TCset1.setText(formatter.format(millisecondsToTc / 3600000));
            TCset2.setText(formatter.format(millisecondsToTc / 60000 % 60));
            TCset3.setText(formatter.format(millisecondsToTc / 1000 % 60));
            TCset4.setText(formatter.format((int)((float)millisecondsToTc / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
        }
        if (Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            AppleProRes.main(true);
            return true;
        }
        return false;
    }
}

