/*
 * Decompiled with CFR 0.152.
 */
package functions.other;

import application.Settings;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;

public class OfflineDetection
extends Shutter {
    private static int complete;

    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = new File((String)liste.getElementAt(i));
                    if (Shutter.scanIsRunning) {
                        file = Utils.scanFolder((String)liste.getElementAt(i));
                        if (file == null) break;
                        btnStart.setEnabled(true);
                        progressBar1.setIndeterminate(false);
                    } else if (Settings.btnWaitFileComplete.isSelected()) {
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    try {
                        String fichier = file.getName();
                        lblEncodageEnCours.setText(fichier);
                        if (OfflineDetection.analyse(file)) {
                            FFMPEG.fonctionInOut();
                            String stats_file = System.getProperty("os.name").contains("Windows") ? "stats_file" : String.valueOf(Shutter.dirTemp) + "stats_file";
                            String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -i \"" + Shutter.dirTemp + "offline.png" + '\"' + " -lavfi " + '\"' + "[0:v]scale=1920x1080[source];[1:v]scale=1920x1080[reference];[source][reference]psnr=" + stats_file + '\"' + " -an -f null -" : " -i \"" + Shutter.dirTemp + "offline.png" + '\"' + " -lavfi " + '\"' + "[0:v]scale=1920x1080[source];[1:v]scale=1920x1080[reference];[source][reference]psnr=" + stats_file + '\"' + " -an -f null -" + '\"';
                            FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd);
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if (!cancelled) {
                                OfflineDetection.showDetection(fichier);
                            }
                            if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && OfflineDetection.actionsDeFin(fichier)) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    OfflineDetection.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    protected static boolean analyse(File file) throws InterruptedException {
        FFPROBE.FrameData(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        if (OfflineDetection.errorAnalyse(file.toString())) {
            return false;
        }
        FFPROBE.Data(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        return !OfflineDetection.errorAnalyse(file.toString());
    }

    protected static void showDetection(String fichier) {
        if (FFMPEG.mediaOfflineFrame.length() > 0 && !Shutter.cancelled && !FFMPEG.error) {
            JOptionPane.showMessageDialog(frame, FFMPEG.mediaOfflineFrame, Shutter.language.getProperty("functionOfflineDetection"), 0);
            int q = JOptionPane.showConfirmDialog(Shutter.frame, Shutter.language.getProperty("saveResult"), Shutter.language.getProperty("analyzeEnded"), 0, -1);
            if (q == 0) {
                FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("saveResult"), 1);
                dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                dialog.setVisible(true);
                if (dialog.getFile() != null) {
                    try {
                        PrintWriter writer = new PrintWriter(String.valueOf(dialog.getDirectory()) + dialog.getFile().replace(".txt", "") + ".txt", "UTF-8");
                        writer.println(String.valueOf(Shutter.language.getProperty("analyzeOf")) + " " + fichier);
                        writer.println("");
                        writer.println(FFMPEG.mediaOfflineFrame);
                        writer.close();
                    }
                    catch (FileNotFoundException | UnsupportedEncodingException iOException) {}
                }
            } else {
                cancelled = false;
            }
        } else {
            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("noErrorDetected"), Shutter.language.getProperty("functionOfflineDetection"), 1);
        }
    }

    private static boolean errorAnalyse(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            return true;
        }
        return false;
    }

    private static boolean actionsDeFin(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
        }
        if (cancelled) {
            return true;
        }
        if (!FFMPEG.error) {
            ++complete;
        }
        lblTermine.setText(Utils.completedFiles(complete));
        Utils.sendMail(fichier);
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            OfflineDetection.main();
            return true;
        }
        return false;
    }
}

