/*
 * Decompiled with CFR 0.152.
 */
package functions.other;

import application.Ftp;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import application.Wetransfer;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import library.FFMPEG;
import library.FFPROBE;

public class Extract
extends Shutter {
    private static int complete;
    private static int subStream;
    private static boolean extractSubsComplete;
    private static int audioStream;
    private static boolean extractAudioComplete;

    static {
        subStream = 0;
        extractSubsComplete = false;
        audioStream = 0;
        extractAudioComplete = false;
    }

    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = new File((String)liste.getElementAt(i));
                    if (Shutter.scanIsRunning) {
                        file = Utils.scanFolder((String)liste.getElementAt(i));
                        if (file == null) break;
                        btnStart.setEnabled(true);
                        progressBar1.setIndeterminate(false);
                    } else if (Settings.btnWaitFileComplete.isSelected()) {
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    try {
                        String extension;
                        FFPROBE.Data(file.toString());
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException fileSize) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                        String fichier = file.getName();
                        lblEncodageEnCours.setText(fichier);
                        String mapping = Extract.setMapping();
                        String sortie = Extract.setSortie("", file);
                        String nomExtension = comboFilter.getSelectedItem().toString().equals(language.getProperty("video")) ? "_" + Shutter.language.getProperty("video") : (comboFilter.getSelectedItem().toString().equals(language.getProperty("audio")) ? "_" + Shutter.language.getProperty("audio") + "_" + (audioStream + 1) : (comboFilter.getSelectedItem().toString().equals(language.getProperty("subtitles")) ? "_" + Shutter.language.getProperty("subtitles") + "_" + (subStream + 1) : ""));
                        String newExtension = extension = fichier.substring(fichier.lastIndexOf("."));
                        if (comboFilter.getSelectedItem().toString().equals(language.getProperty("audio")) && FFPROBE.audioCodec.contains("pcm")) {
                            newExtension = ".wav";
                        } else if (comboFilter.getSelectedItem().toString().equals(language.getProperty("subtitles"))) {
                            newExtension = ".srt";
                        }
                        String sortieFichier = String.valueOf(sortie) + "/" + fichier.replace(extension, String.valueOf(nomExtension) + newExtension);
                        File fileOut = new File(sortieFichier);
                        if (!fileOut.exists() || (fileOut = Utils.fileReplacement(sortie, fichier, extension, String.valueOf(nomExtension) + "_", newExtension)) != null) {
                            String cmd = " -c copy -c:s mov_text -c:s srt" + mapping + " -y ";
                            FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd + '\"' + fileOut + '\"');
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if ((!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) && Extract.actionsDeFin(fichier, fileOut, sortie)) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    Extract.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    public static void extractAll() {
        Thread wait = new Thread(new Runnable(){

            @Override
            public void run() {
                comboFilter.setSelectedItem(language.getProperty("video"));
                btnStart.doClick();
                FFMPEG.isRunning = true;
                if (!cancelled && !FFMPEG.error) {
                    do {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while ((FFMPEG.isRunning || !btnStart.isEnabled()) && !cancelled && !FFMPEG.error);
                }
                if (FFPROBE.audioStreams > 0 && !cancelled && !FFMPEG.error) {
                    comboFilter.setSelectedItem(language.getProperty("audio"));
                    Extract.extractAudio();
                    do {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!extractAudioComplete);
                }
                if (FFPROBE.subtitleStreams > 0 && !cancelled && !FFMPEG.error) {
                    comboFilter.setSelectedItem(language.getProperty("subtitles"));
                    Extract.extractSubs();
                    do {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!extractSubsComplete);
                }
                comboFilter.setSelectedItem(language.getProperty("setAll"));
            }
        });
        wait.start();
    }

    public static void extractAudio() {
        Thread wait = new Thread(new Runnable(){

            @Override
            public void run() {
                audioStream = 0;
                extractAudioComplete = false;
                do {
                    Extract.main();
                    do {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while ((FFMPEG.isRunning || !btnStart.isEnabled()) && !cancelled && !FFMPEG.error);
                } while (++audioStream < FFPROBE.audioStreams && !cancelled && !cancelled && !FFMPEG.error);
                extractAudioComplete = true;
            }
        });
        wait.start();
    }

    public static void extractSubs() {
        Thread wait = new Thread(new Runnable(){

            @Override
            public void run() {
                subStream = 0;
                extractSubsComplete = false;
                do {
                    Extract.main();
                    do {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while ((FFMPEG.isRunning || !btnStart.isEnabled()) && !cancelled && !FFMPEG.error);
                } while (++subStream < FFPROBE.subtitleStreams && !cancelled && !cancelled && !FFMPEG.error);
                extractSubsComplete = true;
            }
        });
        wait.start();
    }

    protected static String setMapping() {
        if (comboFilter.getSelectedItem().toString().equals(language.getProperty("video"))) {
            return " -an -map v?";
        }
        if (comboFilter.getSelectedItem().toString().equals(language.getProperty("audio"))) {
            return " -vn -map a:" + audioStream + "?";
        }
        if (comboFilter.getSelectedItem().toString().equals(language.getProperty("subtitles"))) {
            return " -vn -an -map s:" + subStream + "?";
        }
        return " -map v? -map a? -map s?";
    }

    protected static String setSortie(String sortie, File file) {
        if (caseChangeFolder1.isSelected()) {
            sortie = lblDestination1.getText();
        } else {
            sortie = file.getParent();
            lblDestination1.setText(sortie);
        }
        return sortie;
    }

    private static boolean actionsDeFin(String fichier, File fileOut, String sortie) {
        if (FFMPEG.error || fileOut.length() == 0L) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cancelled) {
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblTermine.setText(Utils.completedFiles(++complete));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(sortie));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.sendMail(fichier);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            Extract.main();
            return true;
        }
        return false;
    }
}

