/*
 * Decompiled with CFR 0.152.
 */
package functions.audio;

import application.Settings;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;

public class LoudnessTruePeak
extends Shutter {
    private static int complete;

    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = new File((String)liste.getElementAt(i));
                    if (Shutter.scanIsRunning) {
                        file = Utils.scanFolder((String)liste.getElementAt(i));
                        if (file == null) break;
                        btnStart.setEnabled(true);
                        progressBar1.setIndeterminate(false);
                    } else if (Settings.btnWaitFileComplete.isSelected()) {
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    try {
                        String fichier = file.getName();
                        lblEncodageEnCours.setText(fichier);
                        if (LoudnessTruePeak.analyse(file)) {
                            FFMPEG.fonctionInOut();
                            String audio = LoudnessTruePeak.setAudio();
                            String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -vn" + audio + " -f null -" : " -vn" + audio + " -f null -" + '\"';
                            FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd);
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if (!cancelled) {
                                LoudnessTruePeak.showDetection(fichier);
                            }
                            if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && LoudnessTruePeak.actionsDeFin(fichier)) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    LoudnessTruePeak.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    protected static boolean analyse(File file) throws InterruptedException {
        FFPROBE.Data(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        return !LoudnessTruePeak.errorAnalyse(file.toString());
    }

    protected static String setAudio() {
        if (FFPROBE.stereo) {
            return " -filter_complex ebur128=peak=true";
        }
        if (FFPROBE.channels > 1) {
            if (FFPROBE.channels >= 4) {
                Object[] options = new String[]{"A1 & A2", "A3 & A4"};
                int q = JOptionPane.showOptionDialog(frame, language.getProperty("ChooseMultitrack"), language.getProperty("multitrack"), -1, 1, null, options, options[0]);
                if (q == 0) {
                    return " -filter_complex \"[0:a:0][0:a:1]amerge=inputs=2[a];[a]ebur128=peak=true\"";
                }
                return " -filter_complex \"[0:a:2][0:a:3]amerge=inputs=2[a];[a]ebur128=peak=true\"";
            }
            return " -filter_complex \"[0:a:0][0:a:1]amerge=inputs=2[a];[a]ebur128=peak=true\"";
        }
        return " -filter_complex ebur128=peak=true";
    }

    protected static void showDetection(String fichier) {
        if (FFMPEG.analyseLufs != null && !Shutter.cancelled && !FFMPEG.error) {
            JOptionPane.showMessageDialog(frame, FFMPEG.analyseLufs, "Loudness & True Peak", 1);
            int q = JOptionPane.showConfirmDialog(Shutter.frame, Shutter.language.getProperty("saveResult"), Shutter.language.getProperty("analyzeEnded"), 0, -1);
            if (q == 0) {
                FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("saveResult"), 1);
                dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                dialog.setVisible(true);
                if (dialog.getFile() != null) {
                    try {
                        PrintWriter writer = new PrintWriter(String.valueOf(dialog.getDirectory()) + dialog.getFile().replace(".txt", "") + ".txt", "UTF-8");
                        writer.println(String.valueOf(Shutter.language.getProperty("analyzeOf")) + " " + fichier);
                        writer.println("");
                        writer.println(String.valueOf(FFMPEG.analyseLufs) + System.lineSeparator() + System.lineSeparator() + FFMPEG.shortTermValues);
                        writer.close();
                    }
                    catch (FileNotFoundException | UnsupportedEncodingException iOException) {}
                }
            } else {
                cancelled = false;
            }
        }
    }

    private static boolean errorAnalyse(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            return true;
        }
        return false;
    }

    private static boolean actionsDeFin(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
        }
        if (cancelled) {
            return true;
        }
        if (!FFMPEG.error) {
            ++complete;
        }
        lblTermine.setText(Utils.completedFiles(complete));
        Utils.sendMail(fichier);
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            LoudnessTruePeak.main();
            return true;
        }
        return false;
    }
}

