/*
 * Decompiled with CFR 0.152.
 */
package functions.audio;

import application.Ftp;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.Wetransfer;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;

public class AudioNormalization
extends Shutter {
    private static int complete;
    private static int audioTracks;

    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = new File((String)liste.getElementAt(i));
                    if (Shutter.scanIsRunning) {
                        file = Utils.scanFolder((String)liste.getElementAt(i));
                        if (file == null) break;
                        btnStart.setEnabled(true);
                        progressBar1.setIndeterminate(false);
                    } else if (Settings.btnWaitFileComplete.isSelected()) {
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    try {
                        String fichier = file.getName();
                        lblEncodageEnCours.setText(String.valueOf(Shutter.language.getProperty("analyzing")) + " " + fichier);
                        if (AudioNormalization.analyse(file)) {
                            String filterComplex = AudioNormalization.setFilterComplex();
                            String sortie = AudioNormalization.setSortie("", file);
                            String nomExtension = Settings.btnExtension.isSelected() ? Settings.txtExtension.getText() : "_Norm";
                            String extension = fichier.substring(fichier.lastIndexOf("."));
                            String sortieFichier = String.valueOf(sortie) + "/" + fichier.replace(extension, String.valueOf(nomExtension) + extension);
                            String audio = AudioNormalization.setAudio(extension);
                            File fileOut = new File(sortieFichier);
                            if (!fileOut.exists() || (fileOut = Utils.fileReplacement(sortie, fichier, extension, String.valueOf(nomExtension) + "_", extension)) != null) {
                                String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -vn" + filterComplex + " -f null -" : " -vn" + filterComplex + " -f null -" + '\"';
                                FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd);
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                                lblEncodageEnCours.setText(fichier);
                                if (!cancelled) {
                                    if (FFPROBE.stereo) {
                                        cmd = " -filter_complex volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB -c:v copy -c:s copy" + audio + " -y ";
                                    } else if (FFPROBE.channels > 1) {
                                        cmd = FFPROBE.channels >= 4 ? (audioTracks == 0 ? " -filter_complex \"[0:a:0]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a1];[0:a:1]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a2]" + '\"' + " -c:v copy -c:s copy" + audio.replace("-map a?", "-map [a1] -map [a2] -map 0:a:2? -map 0:a:3? -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7?") + " -y " : " -filter_complex \"[0:a:2]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a3];[0:a:3]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a4]" + '\"' + " -c:v copy -c:s copy" + audio.replace("-map a?", "-map 0:a:0 -map 0:a:1 -map [a3] -map [a4] -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7?") + " -y ") : " -filter_complex \"[0:a:0]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a1];[0:a:1]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a2]" + '\"' + " -c:v copy -c:s copy" + audio.replace("-map a?", "-map [a1] -map [a2] -map 0:a:2? -map 0:a:3? -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7?") + " -y ";
                                    }
                                    FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd + '\"' + fileOut + '\"');
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.runProcess.isAlive());
                                    if (FFMPEG.error) {
                                        if (FFPROBE.stereo) {
                                            cmd = " -filter_complex volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB -c:v copy -c:s copy -acodec aac -ar " + lbl48k.getText() + " -b:a 320k -map v? -map a? -map s? -y ";
                                        } else if (FFPROBE.channels > 1) {
                                            cmd = FFPROBE.channels >= 4 ? (audioTracks == 0 ? " -filter_complex \"[0:a:0]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a1];[0:a:1]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a2]" + '\"' + " -c:v copy -c:s copy -acodec aac -ar " + lbl48k.getText() + " -b:a 320k -map v? -map [a1] -map [a2] -map 0:a:2? -map 0:a:3? -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7? -map s? -y " : " -filter_complex \"[0:a:2]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a3];[0:a:3]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a4]" + '\"' + " -c:v copy -c:s copy -acodec aac -ar " + lbl48k.getText() + " -b:a 320k -map v? -map 0:a:0 -map 0:a:1 -map [a3] -map [a4] -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7? -map s? -y ") : " -filter_complex \"[0:a:0]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a1];[0:a:1]volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB[a2]" + '\"' + " -c:v copy -c:s copy -acodec aac -ar " + lbl48k.getText() + " -b:a 320k -map v? -map [a1] -map [a2] -map 0:a:2? -map 0:a:3? -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7? -map s? -y ";
                                        }
                                        FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd + '\"' + fileOut + '\"');
                                    }
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.runProcess.isAlive());
                                }
                                if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && AudioNormalization.actionsDeFin(fichier, fileOut, sortie)) {
                                    break;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    AudioNormalization.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    protected static boolean analyse(File file) throws InterruptedException {
        FFPROBE.Data(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        return !AudioNormalization.errorAnalyse(file.toString());
    }

    protected static String setFilterComplex() {
        if (FFPROBE.stereo) {
            return " -filter_complex ebur128=peak=true";
        }
        if (FFPROBE.channels > 1) {
            if (FFPROBE.channels >= 4) {
                Object[] options = new String[]{"A1 & A2", "A3 & A4"};
                audioTracks = JOptionPane.showOptionDialog(frame, language.getProperty("ChooseMultitrack"), language.getProperty("multitrack"), -1, 1, null, options, options[0]);
                if (audioTracks == 0) {
                    return " -filter_complex \"[0:a:0][0:a:1]amerge=inputs=2[a];[a]ebur128=peak=true\"";
                }
                return " -filter_complex \"[0:a:2][0:a:3]amerge=inputs=2[a];[a]ebur128=peak=true\"";
            }
            return " -filter_complex \"[0:a:0][0:a:1]amerge=inputs=2[a];[a]ebur128=peak=true\"";
        }
        return " -filter_complex ebur128=peak=true";
    }

    protected static String setSortie(String sortie, File file) {
        if (caseChangeFolder1.isSelected()) {
            sortie = lblDestination1.getText();
        } else {
            sortie = file.getParent();
            lblDestination1.setText(sortie);
        }
        return sortie;
    }

    protected static String setAudio(String ext) {
        block35: {
            block34: {
                if (!caseChangeAudioCodec.isSelected()) break block34;
                if (comboAudioCodec.getSelectedItem().toString().contains("PCM")) {
                    switch (comboAudioCodec.getSelectedIndex()) {
                        case 0: {
                            return " -c:a pcm_f32le -ar " + lbl48k.getText() + " -b:a 1536k -map v? -map a? -map s?";
                        }
                        case 1: {
                            return " -c:a pcm_s32le -ar " + lbl48k.getText() + " -b:a 1536k -map v? -map a? -map s?";
                        }
                        case 2: {
                            return " -c:a pcm_s24le -ar " + lbl48k.getText() + " -b:a 1536k -map v? -map a? -map s?";
                        }
                        case 3: {
                            return " -c:a pcm_s16le -ar " + lbl48k.getText() + " -b:a 1536k -map v? -map a? -map s?";
                        }
                    }
                } else {
                    if (comboAudioCodec.getSelectedItem().toString().equals("AAC")) {
                        return " -c:a aac -ar " + lbl48k.getText() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k -map v? -map a? -map s?";
                    }
                    if (comboAudioCodec.getSelectedItem().toString().equals("AC3")) {
                        return " -c:a ac3 -ar " + lbl48k.getText() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k -map v? -map a? -map s?";
                    }
                    if (comboAudioCodec.getSelectedItem().toString().equals("OPUS")) {
                        return " -c:a libopus -ar " + lbl48k.getText() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                    }
                    if (comboAudioCodec.getSelectedItem().toString().equals("OGG")) {
                        return " -c:a libvorbis -ar " + lbl48k.getText() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                    }
                }
                break block35;
            }
            switch (ext.toLowerCase()) {
                case ".mp4": {
                    return " -c:a aac -ar " + lbl48k.getText() + " -b:a 256k -map v? -map a? -map s?";
                }
                case ".wmv": {
                    return " -c:a wmav2 -ar " + lbl48k.getText() + " -b:a 256k -map v? -map a? -map s?";
                }
                case ".mpg": {
                    return " -c:a mp2 -ar " + lbl48k.getText() + " -b:a 256k -map v? -map a? -map s?";
                }
                case ".av1": 
                case ".ogv": 
                case ".webm": {
                    return " -c:a libopus -ar " + lbl48k.getText() + " -b:a 192k -map v? -map a? -map s?";
                }
            }
        }
        if (FFPROBE.qantization == 24) {
            return " -c:a pcm_s24le -map v? -map a? -map s?";
        }
        if (FFPROBE.qantization == 32) {
            return " -c:a pcm_s32le -map v? -map a? -map s?";
        }
        return " -c:a pcm_s16le -map v? -map a? -map s?";
    }

    private static boolean errorAnalyse(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            return true;
        }
        return false;
    }

    private static boolean actionsDeFin(String fichier, File fileOut, String sortie) {
        if (FFMPEG.error || fileOut.length() == 0L) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cancelled) {
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblTermine.setText(Utils.completedFiles(++complete));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(sortie));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.sendMail(fichier);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            AudioNormalization.main();
            return true;
        }
        return false;
    }
}

