/*
 * Decompiled with CFR 0.152.
 */
package functions.audio;

import application.Ftp;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import application.Wetransfer;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;

public class AIFF
extends Shutter {
    private static int complete;

    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    complete = 0;
                }
                lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = new File((String)liste.getElementAt(i));
                    if (Shutter.scanIsRunning) {
                        file = Utils.scanFolder((String)liste.getElementAt(i));
                        if (file == null) break;
                        btnStart.setEnabled(true);
                        progressBar1.setIndeterminate(false);
                    } else if (Settings.btnWaitFileComplete.isSelected()) {
                        progressBar1.setIndeterminate(true);
                        lblEncodageEnCours.setForeground(Color.LIGHT_GRAY);
                        lblEncodageEnCours.setText(file.getName());
                        tempsRestant.setVisible(false);
                        btnStart.setEnabled(false);
                        btnCancel.setEnabled(true);
                        comboFonctions.setEnabled(false);
                        long fileSize = 0L;
                        do {
                            fileSize = file.length();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (fileSize != file.length() && !cancelled);
                        while (!file.renameTo(file) && !cancelled) {
                            if (!file.exists()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (cancelled) {
                            progressBar1.setIndeterminate(false);
                            lblEncodageEnCours.setText(language.getProperty("lblEncodageEnCours"));
                            btnStart.setEnabled(true);
                            btnCancel.setEnabled(false);
                            comboFonctions.setEnabled(true);
                            break;
                        }
                        progressBar1.setIndeterminate(false);
                        btnCancel.setEnabled(false);
                    }
                    try {
                        String fichier = file.getName();
                        String extension = fichier.substring(fichier.lastIndexOf("."));
                        lblEncodageEnCours.setText(fichier);
                        if (AIFF.analyse(file)) {
                            FFMPEG.fonctionInOut();
                            String sortie = AIFF.setSortie("", file);
                            String nomExtension = Settings.btnExtension.isSelected() ? Settings.txtExtension.getText() : "_MIX";
                            String sortieFichier = caseMixAudio.isSelected() ? String.valueOf(sortie) + "/" + fichier.replace(extension, String.valueOf(nomExtension) + ".aif") : String.valueOf(sortie) + "/" + fichier.replace(extension, ".aif");
                            String audio = AIFF.setAudio("");
                            FFMPEG.fonctionInOut();
                            File fileOut = new File(sortieFichier);
                            if (!fileOut.exists() || caseSplitAudio.isSelected() || (fileOut = caseMixAudio.isSelected() ? Utils.fileReplacement(sortie, fichier, extension, String.valueOf(nomExtension) + "_", ".aif") : Utils.fileReplacement(sortie, fichier, extension, "_", ".aif")) != null) {
                                String cmd;
                                String concat = FFMPEG.setConcat(file, sortie);
                                if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
                                    file = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
                                }
                                if (caseSplitAudio.isSelected()) {
                                    if (FFPROBE.surround) {
                                        if (lblSplit.getText().equals(language.getProperty("mono"))) {
                                            cmd = " -filter_complex \"channelsplit=channel_layout=5.1[FL][FR][FC][LFE][BL][BR]\" -vn -y ";
                                            FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + " -map " + '\"' + "[FL]" + '\"' + " " + '\"' + fileOut.toString().replace(".aif", "_FL.aif") + '\"' + " -map " + '\"' + "[FR]" + '\"' + " " + '\"' + fileOut.toString().replace(".aif", "_FR.aif") + '\"' + " -map " + '\"' + "[FC]" + '\"' + " " + '\"' + fileOut.toString().replace(".aif", "_FC.aif") + '\"' + " -map " + '\"' + "[LFE]" + '\"' + " " + '\"' + fileOut.toString().replace(".aif", "_LFE.aif") + '\"' + " -map " + '\"' + "[BL]" + '\"' + " " + '\"' + fileOut.toString().replace(".aif", "_BL.aif") + '\"' + " -map " + '\"' + "[BR]" + '\"' + " " + '\"' + fileOut.toString().replace(".aif", "_BR.aif") + '\"');
                                        } else if (lblSplit.getText().equals(language.getProperty("stereo"))) {
                                            cmd = " -af \"pan=stereo|c0=FL|c1=FR\" -vn -y ";
                                            FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + '\"' + fileOut + '\"');
                                        }
                                    } else {
                                        AIFF.splitAudio(fichier, extension, file, sortie);
                                    }
                                } else if (caseMixAudio.isSelected() && lblMix.getText().equals("5.1")) {
                                    cmd = " " + audio + "-vn -y ";
                                    FFMPEG.run(String.valueOf(FFMPEG.inPoint) + concat + " -i " + '\"' + (String)liste.getElementAt(0) + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + " -i " + '\"' + (String)liste.getElementAt(1) + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + " -i " + '\"' + (String)liste.getElementAt(2) + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + " -i " + '\"' + (String)liste.getElementAt(3) + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + " -i " + '\"' + (String)liste.getElementAt(4) + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + " -i " + '\"' + (String)liste.getElementAt(5) + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + '\"' + fileOut + '\"');
                                } else {
                                    cmd = " " + audio + "-vn -y ";
                                    FFMPEG.run(String.valueOf(FFMPEG.inPoint) + concat + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + '\"' + fileOut + '\"');
                                }
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                                if ((!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && !caseSplitAudio.isSelected() || !FFMPEG.saveCode && Settings.btnSetBab.isSelected() || !FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) && AIFF.actionsDeFin(fichier, fileOut, sortie)) {
                                    break;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    AIFF.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setAudio(String audio) {
        long totalIn;
        long audioStart;
        String audioFilter = "";
        if (caseAudioFadeIn.isSelected()) {
            long audioInValue = (long)((float)Integer.parseInt(spinnerAudioFadeIn.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioStart = 0L;
            if (caseInAndOut.isSelected() && VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper"))) {
                totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = totalIn >= 10000L ? 10000L : (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
            }
            audioFilter = String.valueOf(audioFilter) + ",afade=in:st=" + audioStart + "ms:d=" + audioInValue + "ms";
        }
        if (caseAudioFadeOut.isSelected()) {
            long audioOutValue = (long)((float)Integer.parseInt(spinnerAudioFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioStart = (long)FFPROBE.totalLength - audioOutValue;
            if (caseInAndOut.isSelected()) {
                totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long totalOut = (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper")) ? (totalIn >= 10000L ? 10000L + (totalOut - totalIn) - audioOutValue : (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - audioOutValue) : (long)FFPROBE.totalLength - (totalOut - totalIn) - audioOutValue;
            }
            audioFilter = String.valueOf(audioFilter) + ",afade=out:st=" + audioStart + "ms:d=" + audioOutValue + "ms";
        }
        if (caseConvertAudioFramerate.isSelected()) {
            float AudioFPSIn = Float.parseFloat(comboAudioIn.getSelectedItem().toString().replace(",", "."));
            float AudioFPSOut = Float.parseFloat(comboAudioOut.getSelectedItem().toString().replace(",", "."));
            float value = AudioFPSOut / AudioFPSIn;
            audioFilter = String.valueOf(audioFilter) + ",atempo=" + value;
        }
        if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("stereo"))) {
            int n = 1;
            while (n < liste.size()) {
                audio = String.valueOf(audio) + "-i \"" + (String)liste.elementAt(n) + '\"' + " ";
                ++n;
            }
            if (FFPROBE.stereo) {
                audio = String.valueOf(audio) + "-filter_complex amerge=inputs=" + liste.size() + audioFilter + " -ac 2 ";
            } else {
                audio = String.valueOf(audio) + "-filter_complex \"";
                String left = "";
                int cl = 0;
                String right = "";
                int cr = 0;
                int n2 = 0;
                while (n2 < liste.size()) {
                    if (n2 % 2 == 0) {
                        left = String.valueOf(left) + "[" + n2 + ":0]";
                        ++cl;
                    } else {
                        right = String.valueOf(right) + "[" + n2 + ":0]";
                        ++cr;
                    }
                    ++n2;
                }
                audio = String.valueOf(audio) + left + "amerge=inputs=" + cl + ",channelmap=map=FL[left];" + right + "amerge=inputs=" + cr + ",channelmap=map=FR[right];";
                audio = String.valueOf(audio) + "[left][right]amerge=inputs=2" + audioFilter + "[out]" + '\"' + " -map " + '\"' + "[out]" + '\"' + " -ac 2 ";
            }
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals("5.1")) {
            audio = "-filter_complex \"[0:a][1:a][2:a][3:a][4:a][5:a]join=inputs=6:channel_layout=5.1" + audioFilter + "[a]" + '\"' + " -map " + '\"' + "[a]" + '\"' + " ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("mono"))) {
            int n = 1;
            while (n < liste.size()) {
                audio = String.valueOf(audio) + "-i \"" + (String)liste.elementAt(n) + '\"' + " ";
                ++n;
            }
            audio = String.valueOf(audio) + "-filter_complex amerge=inputs=" + liste.size() + audioFilter + " -ac 1 ";
        } else if (FFPROBE.stereo) {
            audio = "-map a:0 ";
            if (audioFilter != "") {
                audio = String.valueOf(audio) + audioFilter.replaceFirst(",", " -filter_complex ") + " ";
            }
        } else if (FFPROBE.channels > 1) {
            audio = "-filter_complex \"[0:a:0][0:a:1]amerge=inputs=2" + audioFilter + "[a]" + '\"' + " -map " + '\"' + "[a]" + '\"' + " ";
        } else if (audioFilter != "") {
            audio = String.valueOf(audio) + audioFilter.replaceFirst(",", " -filter_complex ") + " ";
        }
        audio = comboFilter.getSelectedItem().toString().contains("Float") ? String.valueOf(audio) + "-acodec pcm_f" + comboFilter.getSelectedItem().toString().replace(" Float", "") + "be " : String.valueOf(audio) + "-acodec pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "be ";
        if (caseSampleRate.isSelected()) {
            audio = String.valueOf(audio) + "-ar " + lbl48k.getText() + " ";
        }
        return audio;
    }

    private static void splitAudio(String fichier, String extension, File file, String sortie) throws InterruptedException {
        long totalIn;
        long audioStart;
        String audioFilter = "";
        if (caseAudioFadeIn.isSelected()) {
            long audioInValue = (long)((float)Integer.parseInt(spinnerAudioFadeIn.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioStart = 0L;
            if (caseInAndOut.isSelected() && VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper"))) {
                totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = totalIn >= 10000L ? 10000L : (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
            }
            audioFilter = String.valueOf(audioFilter) + ",afade=in:st=" + audioStart + "ms:d=" + audioInValue + "ms";
        }
        if (caseAudioFadeOut.isSelected()) {
            long audioOutValue = (long)((float)Integer.parseInt(spinnerAudioFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioStart = (long)FFPROBE.totalLength - audioOutValue;
            if (caseInAndOut.isSelected()) {
                totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long totalOut = (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper")) ? (totalIn >= 10000L ? 10000L + (totalOut - totalIn) - audioOutValue : (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - audioOutValue) : (long)FFPROBE.totalLength - (totalOut - totalIn) - audioOutValue;
            }
            audioFilter = String.valueOf(audioFilter) + ",afade=out:st=" + audioStart + "ms:d=" + audioOutValue + "ms";
        }
        if (caseConvertAudioFramerate.isSelected()) {
            float AudioFPSIn = Float.parseFloat(comboAudioIn.getSelectedItem().toString().replace(",", "."));
            float AudioFPSOut = Float.parseFloat(comboAudioOut.getSelectedItem().toString().replace(",", "."));
            float value = AudioFPSOut / AudioFPSIn;
            audioFilter = String.valueOf(audioFilter) + ",atempo=" + value;
        }
        if (FFPROBE.channels == 1 && lblSplit.getText().equals(language.getProperty("mono"))) {
            int i = 1;
            while (i < 3) {
                String yesno = " -y ";
                File fileOut = new File(String.valueOf(sortie) + "/" + fichier.replace(extension, "_Audio_" + i + ".aif"));
                if (fileOut.exists() && (fileOut = Utils.fileReplacement(sortie, fichier, extension, "_Audio_" + i + "_", ".aif")) == null) {
                    yesno = " -n ";
                }
                String cmd = " -filter_complex \"[a:0]pan=1c|c0=c" + (i - 1) + audioFilter + "[a" + (i - 1) + "]" + '\"' + " -map " + '\"' + "[a" + (i - 1) + "]" + '\"' + " -acodec pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "be -vn" + yesno;
                FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + '\"' + fileOut + '\"');
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AIFF.actionsDeFin(fichier, fileOut, sortie)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (FFPROBE.channels == 1 && lblSplit.getText().equals(Shutter.language.getProperty("stereo"))) {
            JOptionPane.showMessageDialog(Shutter.frame, String.valueOf(Shutter.language.getProperty("theFile")) + " " + fichier + " " + Shutter.language.getProperty("isAlreadyStereo"), Shutter.language.getProperty("cantSplitAudio"), 0);
        } else if (FFPROBE.channels > 1 && lblSplit.getText().equals(language.getProperty("mono"))) {
            int i = 1;
            while (i < FFPROBE.channels + 1) {
                String yesno = " -y ";
                File fileOut = new File(String.valueOf(sortie) + "/" + fichier.replace(extension, "_Audio_" + i + ".aif"));
                if (fileOut.exists() && (fileOut = Utils.fileReplacement(sortie, fichier, extension, "_Audio_" + i + "_", ".aif")) == null) {
                    yesno = " -n ";
                }
                if (audioFilter != "") {
                    audioFilter = audioFilter.replaceFirst(",", " -filter_complex ");
                }
                String cmd = String.valueOf(audioFilter) + " -map a:" + (i - 1) + " -acodec pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "be -vn" + yesno;
                FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + '\"' + fileOut + '\"');
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AIFF.actionsDeFin(fichier, fileOut, sortie)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (FFPROBE.channels > 1 && lblSplit.getText().equals(Shutter.language.getProperty("stereo"))) {
            int number = 1;
            int i = 1;
            while (i < FFPROBE.channels + 1) {
                String yesno = " -y ";
                File fileOut = new File(String.valueOf(sortie) + "/" + fichier.replace(extension, "_Audio_" + number + ".aif"));
                if (fileOut.exists() && (fileOut = Utils.fileReplacement(sortie, fichier, extension, "_Audio_" + number + "_", ".aif")) == null) {
                    yesno = " -n ";
                }
                String cmd = " -filter_complex \"[0:a:" + (i - 1) + "][0:a:" + i + "]amerge=inputs=2" + audioFilter + "[a]" + '\"' + " -map " + '\"' + "[a]" + '\"' + " -acodec pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "be -vn" + yesno;
                FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd + '\"' + fileOut + '\"');
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AIFF.actionsDeFin(fichier, fileOut, sortie)) {
                    ++number;
                    i += 2;
                    continue;
                }
                break;
            }
        } else {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
        }
    }

    protected static boolean analyse(File file) throws InterruptedException {
        FFPROBE.Data(file.toString());
        do {
            Thread.sleep(100L);
        } while (FFPROBE.isRunning);
        return !AIFF.errorAnalyse(file.toString());
    }

    protected static String setSortie(String sortie, File file) {
        if (caseChangeFolder1.isSelected()) {
            sortie = lblDestination1.getText();
        } else {
            sortie = file.getParent();
            lblDestination1.setText(sortie);
        }
        return sortie;
    }

    private static boolean errorAnalyse(String fichier) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            return true;
        }
        return false;
    }

    private static boolean actionsDeFin(String fichier, File fileOut, String sortie) {
        if (FFMPEG.error || fileOut.length() == 0L) {
            FFMPEG.errorList.append(fichier);
            FFMPEG.errorList.append(System.lineSeparator());
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
            String extension = fichier.substring(fichier.lastIndexOf("."));
            File listeBAB = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.replace(extension, ".txt"));
            listeBAB.delete();
        }
        if (cancelled) {
            try {
                fileOut.delete();
            }
            catch (Exception extension) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblTermine.setText(Utils.completedFiles(++complete));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(sortie));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.sendMail(fichier);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (caseMixAudio.isSelected()) {
            return true;
        }
        if (Shutter.scanIsRunning) {
            Utils.moveScannedFiles(fichier);
            AIFF.main();
            return true;
        }
        return false;
    }
}

