/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.Forms;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;

public final class ListViewBuilder {
    private final ComponentFactory factory;
    private JComponent labelView;
    private JComponent filterView;
    private JComponent listView;
    private JComponent listBarView;
    private JComponent listExtrasView;
    private JComponent detailsView;
    private Border border;
    private boolean honorsVisibility = true;
    private FocusTraversalPolicy focusTraversalPolicy;
    private String namePrefix = "ListView";
    private String filterViewColSpec = "[100dlu, p]";
    private String listViewRowSpec = "fill:100dlu:grow";
    private JComponent panel;

    public ListViewBuilder() {
        this(FormsSetup.getComponentFactoryDefault());
    }

    public ListViewBuilder(ComponentFactory factory) {
        this.factory = factory;
    }

    public ListViewBuilder border(Border border) {
        this.border = border;
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder focusTraversal(FocusTraversalPolicy policy) {
        this.focusTraversalPolicy = policy;
        return this;
    }

    public ListViewBuilder honorVisibility(boolean b) {
        this.honorsVisibility = b;
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder namePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    public ListViewBuilder labelView(JComponent labelView) {
        this.labelView = labelView;
        this.setName(labelView, "label");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder label(String markedText) {
        this.labelView(this.factory.createLabel(markedText));
        return this;
    }

    public ListViewBuilder headerLabel(String markedText) {
        this.labelView(this.factory.createHeaderLabel(markedText));
        return this;
    }

    public ListViewBuilder filterView(JComponent filterView) {
        this.filterView = filterView;
        this.setName(filterView, "filter");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder filterViewColSpec(String colSpec) {
        Preconditions.checkNotNull(colSpec, "The filter view column specification must not be null.");
        this.filterViewColSpec = colSpec;
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listView(JComponent listView) {
        Preconditions.checkNotNull(listView, "The list view must not be null.");
        this.listView = listView instanceof JTable || listView instanceof JList || listView instanceof JTree ? new JScrollPane(listView) : listView;
        this.setName(listView, "listView");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listViewRowSpec(String rowSpec) {
        Preconditions.checkNotNull(rowSpec, "The list view row specification must not be null.");
        this.listViewRowSpec = rowSpec;
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listBarView(JComponent listBarView) {
        this.listBarView = listBarView;
        this.setName(listBarView, "listBarView");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listBar(JComponent ... buttons) {
        this.listBarView(Forms.buttonBar(buttons));
        return this;
    }

    public ListViewBuilder listExtrasView(JComponent listExtrasView) {
        this.listExtrasView = listExtrasView;
        this.setName(listExtrasView, "listExtrasView");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder detailsView(JComponent detailsView) {
        this.detailsView = detailsView;
        this.setName(detailsView, "detailsView");
        this.invalidatePanel();
        return this;
    }

    public JComponent build() {
        if (this.panel == null) {
            this.panel = this.buildPanel();
        }
        return this.panel;
    }

    private void invalidatePanel() {
        this.panel = null;
    }

    private JComponent buildPanel() {
        JLabel theLabelView;
        Preconditions.checkNotNull(this.listView, "The list view must be set before #build is invoked.");
        FormLayout layout = new FormLayout("fill:default:grow", "p, " + this.listViewRowSpec + ", p, p");
        layout.setHonorsVisibility(this.honorsVisibility);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.border(this.border);
        if (this.focusTraversalPolicy != null) {
            builder.focusTraversal(this.focusTraversalPolicy);
        }
        if (this.labelView != null || this.filterView != null) {
            builder.add((Component)this.buildDecoratedHeaderView(), CC.xy(1, 1));
        }
        builder.add((Component)this.listView, CC.xy(1, 2));
        if (this.listBarView != null || this.listExtrasView != null) {
            builder.add((Component)this.buildDecoratedListBarAndExtras(), CC.xy(1, 3));
        }
        if (this.detailsView != null) {
            builder.add((Component)this.buildDecoratedDetailsView(), CC.xy(1, 4));
        }
        if (this.labelView instanceof JLabel && (theLabelView = (JLabel)this.labelView).getLabelFor() == null) {
            theLabelView.setLabelFor(this.listView);
        }
        return builder.build();
    }

    private JComponent buildDecoratedHeaderView() {
        String columnSpec = this.filterView != null ? "default:grow, 9dlu, " + this.filterViewColSpec : "default:grow, 0, 0";
        FormLayout layout = new FormLayout(columnSpec, "[14dlu,p], $lcg");
        PanelBuilder builder = new PanelBuilder(layout).labelForFeatureEnabled(false);
        if (this.labelView != null) {
            builder.add((Component)this.labelView, CC.xy(1, 1));
        }
        if (this.filterView != null) {
            builder.add((Component)this.filterView, CC.xy(3, 1));
        }
        return builder.build();
    }

    private JComponent buildDecoratedListBarAndExtras() {
        FormLayout layout = new FormLayout("left:default, 9dlu:grow, right:pref", "$rgap, p");
        layout.setHonorsVisibility(this.honorsVisibility);
        PanelBuilder builder = new PanelBuilder(layout);
        if (this.listBarView != null) {
            builder.add((Component)this.listBarView, CC.xy(1, 2));
        }
        if (this.listExtrasView != null) {
            builder.add((Component)this.listExtrasView, CC.xy(3, 2));
        }
        return builder.build();
    }

    private JComponent buildDecoratedDetailsView() {
        FormLayout layout = new FormLayout("fill:default:grow", "14, p");
        layout.setHonorsVisibility(this.honorsVisibility);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.add((Component)this.detailsView, CC.xy(1, 2));
        return builder.build();
    }

    private void setName(JComponent component, String suffix) {
        if (Strings.isNotBlank(component.getName())) {
            return;
        }
        component.setName(this.namePrefix + '.' + suffix);
    }
}

