/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class SVGUtils {
    public static List<Image> createWindowIconImages(String svgName) {
        return Arrays.asList(SVGUtils.svg2image(svgName, 1.0f), SVGUtils.svg2image(svgName, 1.5f), SVGUtils.svg2image(svgName, 2.0f), SVGUtils.svg2image(svgName, 3.0f), SVGUtils.svg2image(svgName, 4.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage svg2image(String svgName, float scaleFactor) {
        try {
            URL url = SVGUtils.class.getResource(svgName);
            SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(url.toURI());
            BufferedImage image = new BufferedImage((int)(diagram.getWidth() * scaleFactor), (int)(diagram.getHeight() * scaleFactor), 2);
            Graphics2D g = image.createGraphics();
            try {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                if (scaleFactor != 1.0f) {
                    g.scale(scaleFactor, scaleFactor);
                }
                diagram.setIgnoringClipHeuristic(true);
                diagram.render(g);
            }
            finally {
                g.dispose();
            }
            return image;
        }
        catch (SVGException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }
}

