/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.Functions;
import application.RecordInputDevice;
import application.RenderQueue;
import application.Shutter;
import application.Utils;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import library.FFMPEG;
import library.FFPROBE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WatermarkWindow {
    public static JDialog frame;
    private static JPanel image;
    private static JRadioButton caseSafeArea;
    public static String logoFile;
    private JLabel quit;
    private JPanel topPanel;
    private JLabel topImage;
    private JButton btnOK;
    public static int containerWidth;
    public static int containerHeight;
    public static float logoRatio;
    public static int ImageWidth;
    public static int ImageHeight;
    public static int finalWidth;
    public static int finalHeight;
    private int logoPosX = 0;
    private int logoPosY = 0;
    private static int logoLocX;
    private static int logoLocY;
    private static JSlider positionVideo;
    public static JTextField textPosX;
    public static JTextField textPosY;
    public static JTextField textSize;
    public static JTextField textOpacity;
    public static JPanel logo;

    static {
        image = new JPanel();
        logoFile = new String();
        containerWidth = 640;
        containerHeight = 360;
        logoRatio = 3.0f;
        logoLocX = 0;
        logoLocY = 0;
        logo = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                if (textOpacity.getText().length() > 0 && Integer.parseInt(textOpacity.getText()) <= 100) {
                    g2d.setComposite(AlphaComposite.getInstance(3, (float)Integer.valueOf(textOpacity.getText()).intValue() / 100.0f));
                }
            }
        };
    }

    public WatermarkWindow() {
        frame = new JDialog();
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameLogo"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(665, 481);
        frame.setResizable(false);
        if (Functions.frame != null && Functions.frame.isVisible()) {
            frame.setModal(false);
        } else {
            frame.setModal(true);
        }
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - WatermarkWindow.frame.getSize().width / 2, dim.height / 2 - WatermarkWindow.frame.getSize().height / 2);
        }
        this.topPanel();
        image.setLayout(null);
        image.setOpaque(false);
        frame.getContentPane().add(image);
        image.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    logo.setLocation(image.getWidth() / 2 - logo.getWidth() / 2, image.getHeight() / 2 - logo.getHeight() / 2);
                    logoLocX = WatermarkWindow.logo.getLocation().x;
                    logoLocY = WatermarkWindow.logo.getLocation().y;
                    textPosX.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().x * logoRatio))));
                    textPosY.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().y * logoRatio))));
                }
            }
        });
        caseSafeArea = new JRadioButton(Shutter.language.getProperty("caseSafeArea"));
        caseSafeArea.setFont(new Font("FreeSans", 0, 12));
        caseSafeArea.setBounds(12, 448, WatermarkWindow.caseSafeArea.getPreferredSize().width, 23);
        frame.getContentPane().add(caseSafeArea);
        caseSafeArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseSafeArea.isSelected()) {
                    ImageIcon logoIcon = new ImageIcon(this.getClass().getClassLoader().getResource("contents/safeArea.png"));
                    logoIcon = new ImageIcon(logoIcon.getImage().getScaledInstance(640, 360, 1));
                    JLabel newLogo = new JLabel(logoIcon);
                    logoIcon.getImage().flush();
                    newLogo.setHorizontalAlignment(0);
                    newLogo.setSize(640, 360);
                    image.add(newLogo);
                    frame.setGlassPane(newLogo);
                    frame.getGlassPane().setVisible(true);
                } else {
                    frame.getGlassPane().setVisible(false);
                }
            }
        });
        logo.setLayout(null);
        logo.setOpaque(false);
        logo.setBackground(new Color(0, 0, 0, 50));
        logo.setSize(640, 360);
        image.add(logo);
        logo.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    logo.setLocation(image.getWidth() / 2 - logo.getWidth() / 2, image.getHeight() / 2 - logo.getHeight() / 2);
                    textPosX.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().x * logoRatio))));
                    textPosY.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().y * logoRatio))));
                } else {
                    WatermarkWindow.this.logoPosX = e.getLocationOnScreen().x;
                    WatermarkWindow.this.logoPosY = e.getLocationOnScreen().y;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                logoLocX = WatermarkWindow.logo.getLocation().x;
                logoLocY = WatermarkWindow.logo.getLocation().y;
            }
        });
        logo.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                logo.setLocation(MouseInfo.getPointerInfo().getLocation().x - WatermarkWindow.this.logoPosX + logoLocX, MouseInfo.getPointerInfo().getLocation().y - WatermarkWindow.this.logoPosY + logoLocY);
                textPosX.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().x * logoRatio))));
                textPosY.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().y * logoRatio))));
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        WatermarkWindow.loadImage("0", "0", "0", true, -1, true);
        logo.setLocation(image.getWidth() / 2 - logo.getWidth() / 2, image.getHeight() / 2 - logo.getHeight() / 2);
        logoLocX = WatermarkWindow.logo.getLocation().x;
        logoLocY = WatermarkWindow.logo.getLocation().y;
        this.btnOK = new JButton(Shutter.language.getProperty("btnApply"));
        this.btnOK.setFont(new Font("Montserrat", 0, 12));
        this.btnOK.setBounds(172, 450, 476, 21);
        frame.getContentPane().add(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file2;
                Shutter.cropFinal = "crop=" + textSize.getText() + ":" + textOpacity.getText() + ":" + textPosX.getText() + ":" + textPosY.getText();
                Shutter.tempsRestant.setVisible(false);
                Shutter.progressBar1.setValue(0);
                Utils.changeDialogVisibility(frame, true);
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                if ((file2 = new File(String.valueOf(Shutter.dirTemp) + "logo.png")).exists()) {
                    file2.delete();
                }
            }
        });
        this.valeurs();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent ke = (KeyEvent)event;
                switch (ke.getKeyCode()) {
                    case 38: {
                        textPosY.setText(String.valueOf(Integer.parseInt(textPosY.getText()) - 1));
                        logo.setLocation(WatermarkWindow.logo.getLocation().x, (int)((float)Integer.parseInt(textPosY.getText()) / logoRatio));
                        break;
                    }
                    case 40: {
                        textPosY.setText(String.valueOf(Integer.parseInt(textPosY.getText()) + 1));
                        logo.setLocation(WatermarkWindow.logo.getLocation().x, (int)((float)Integer.parseInt(textPosY.getText()) / logoRatio));
                        break;
                    }
                    case 37: {
                        textPosX.setText(String.valueOf(Integer.parseInt(textPosX.getText()) - 1));
                        logo.setLocation((int)((float)Integer.parseInt(textPosX.getText()) / logoRatio), WatermarkWindow.logo.getLocation().y);
                        break;
                    }
                    case 39: {
                        textPosX.setText(String.valueOf(Integer.parseInt(textPosX.getText()) + 1));
                        logo.setLocation((int)((float)Integer.parseInt(textPosX.getText()) / logoRatio), WatermarkWindow.logo.getLocation().y);
                        break;
                    }
                    case 27: {
                        logo.setLocation(image.getWidth() / 2 - logo.getWidth() / 2, image.getHeight() / 2 - logo.getHeight() / 2);
                        textPosX.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().x * logoRatio))));
                        textPosY.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().y * logoRatio))));
                    }
                }
            }
        }, 8L);
        Utils.changeDialogVisibility(frame, false);
        frame.repaint();
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(WatermarkWindow.frame.getSize().width - 24, 0, 21, 21);
        this.topPanel.add(this.quit);
        this.topPanel.setBounds(0, 0, 1000, 52);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                WatermarkWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    File file2;
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                    Utils.changeDialogVisibility(frame, true);
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    if ((file2 = new File(String.valueOf(Shutter.dirTemp) + "logo.png")).exists()) {
                        file2.delete();
                    }
                    Shutter.caseLogo.setSelected(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                WatermarkWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WatermarkWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        JLabel title = new JLabel(Shutter.language.getProperty("frameLogo"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 52);
        title.setFont(new Font("Magneto", 0, 26));
        this.topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.topPanel.add(this.topImage);
        this.topPanel.setBounds(0, 0, 1000, 52);
        frame.getContentPane().add(this.topPanel);
        this.topImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.topImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void valeurs() {
        positionVideo = new JSlider();
        if (Shutter.scanIsRunning) {
            File dir = new File(Shutter.liste.firstElement());
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.isHidden() && f.isFile()) {
                    FFPROBE.Data(f.toString());
                }
                ++n2;
            }
        } else if (!Utils.inputDeviceIsRunning) {
            FFPROBE.Data(Shutter.liste.firstElement());
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException dir) {
                // empty catch block
            }
        } while (FFPROBE.totalLength == 0 && FFPROBE.isRunning);
        positionVideo.setMaximum(FFPROBE.totalLength);
        positionVideo.setValue(0);
        positionVideo.setFont(new Font("FreeSans", 0, 11));
        positionVideo.setBounds(12, this.btnOK.getLocation().y - 24, 146, 22);
        Component[] components = frame.getContentPane().getComponents();
        boolean addToFrame = true;
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JSlider) {
                addToFrame = false;
            }
            ++i;
        }
        if (addToFrame) {
            frame.getContentPane().add(positionVideo);
        }
        positionVideo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Thread runProcess = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DecimalFormat tc = new DecimalFormat("00");
                        String h = String.valueOf(tc.format(positionVideo.getValue() / 3600000));
                        String m = String.valueOf(tc.format(positionVideo.getValue() / 60000 % 60));
                        String s = String.valueOf(tc.format(positionVideo.getValue() / 1000 % 60));
                        FFPROBE.Data(logoFile);
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                        if (FFPROBE.totalLength > 40) {
                            WatermarkWindow.loadImage(h, m, s, true, Integer.parseInt(textSize.getText()), true);
                        } else {
                            WatermarkWindow.loadImage(h, m, s, false, -1, true);
                        }
                    }
                });
                runProcess.start();
            }
        });
        JLabel posX = new JLabel(Shutter.language.getProperty("posX"));
        posX.setHorizontalAlignment(2);
        posX.setFont(new Font("FreeSans", 0, 12));
        posX.setForeground(Utils.themeColor);
        posX.setBounds(WatermarkWindow.positionVideo.getLocation().x + positionVideo.getWidth() + 12, this.btnOK.getLocation().y - 22, posX.getPreferredSize().width, 16);
        textPosX = new JTextField(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().x * logoRatio))));
        textPosX.setName("textPosX");
        textPosX.setBounds(posX.getLocation().x + posX.getWidth() + 2, posX.getLocation().y, 34, 16);
        textPosX.setHorizontalAlignment(4);
        textPosX.setFont(new Font("FreeSans", 0, 12));
        JLabel px1 = new JLabel("px");
        px1.setFont(new Font("FreeSans", 0, 12));
        px1.setForeground(Utils.themeColor);
        px1.setBounds(WatermarkWindow.textPosX.getLocation().x + textPosX.getWidth() + 2, this.btnOK.getLocation().y - 22, posX.getPreferredSize().width, 16);
        textPosX.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textPosX.getText().length() > 0) {
                    logo.setLocation((int)((float)Integer.valueOf(textPosX.getText()).intValue() / logoRatio), WatermarkWindow.logo.getLocation().y);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textPosX.getText().length() >= 4) {
                    textPosX.setText("");
                }
            }
        });
        textPosX.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textPosX.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseLogoPosition.mouseX = e.getX();
                MouseLogoPosition.offsetX = Integer.parseInt(textPosX.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textPosX.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textPosX.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textPosX.setText(String.valueOf(MouseLogoPosition.offsetX + (e.getX() - MouseLogoPosition.mouseX)));
                    logo.setLocation((int)Math.floor((float)Integer.valueOf(textPosX.getText()).intValue() / logoRatio), WatermarkWindow.logo.getLocation().y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel posY = new JLabel(Shutter.language.getProperty("posY"));
        posY.setFont(new Font("FreeSans", 0, 12));
        posY.setForeground(Utils.themeColor);
        posY.setBounds(px1.getLocation().x + 22, posX.getLocation().y, posY.getPreferredSize().width, 16);
        textPosY = new JTextField(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().y * logoRatio))));
        textPosY.setName("textPosY");
        textPosY.setBounds(posY.getLocation().x + posY.getWidth() + 2, posY.getLocation().y, 34, 16);
        textPosY.setHorizontalAlignment(4);
        textPosY.setFont(new Font("FreeSans", 0, 12));
        textPosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textPosY.getText().length() > 0) {
                    logo.setLocation(WatermarkWindow.logo.getLocation().x, (int)((float)Integer.valueOf(textPosY.getText()).intValue() / logoRatio));
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textPosY.getText().length() >= 4) {
                    textPosY.setText("");
                }
            }
        });
        textPosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textPosY.getText().length() > 0) {
                    logo.setLocation(WatermarkWindow.logo.getLocation().x, (int)Math.floor((float)Integer.valueOf(textPosY.getText()).intValue() / logoRatio));
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textPosY.getText().length() >= 4) {
                    textPosY.setText("");
                }
            }
        });
        textPosY.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textPosY.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseLogoPosition.mouseY = e.getY();
                MouseLogoPosition.offsetY = Integer.parseInt(textPosY.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textPosY.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textPosY.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textPosY.setText(String.valueOf(MouseLogoPosition.offsetY + (e.getY() - MouseLogoPosition.mouseY)));
                    logo.setLocation(WatermarkWindow.logo.getLocation().x, (int)Math.floor((float)Integer.valueOf(textPosY.getText()).intValue() / logoRatio));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel px2 = new JLabel("px");
        px2.setFont(new Font("FreeSans", 0, 12));
        px2.setForeground(Utils.themeColor);
        px2.setBounds(WatermarkWindow.textPosY.getLocation().x + textPosY.getWidth() + 2, this.btnOK.getLocation().y - 22, posX.getPreferredSize().width, 16);
        JLabel size = new JLabel(Shutter.language.getProperty("lblSize"));
        size.setFont(new Font("FreeSans", 0, 12));
        size.setForeground(Utils.themeColor);
        size.setBounds(px2.getLocation().x + 42, posX.getLocation().y, size.getPreferredSize().width, 16);
        textSize = new JTextField("100");
        textSize.setName("textSize");
        textSize.setBounds(size.getLocation().x + size.getWidth() + 2, size.getLocation().y, 34, 16);
        textSize.setHorizontalAlignment(4);
        textSize.setFont(new Font("FreeSans", 0, 12));
        textSize.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textSize.getText().length() > 0 && e.getKeyCode() == 10) {
                    WatermarkWindow.loadLogo(Integer.parseInt(textSize.getText()));
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textSize.getText().length() >= 3) {
                    textSize.setText("");
                }
            }
        });
        JLabel px3 = new JLabel("%");
        px3.setFont(new Font("FreeSans", 0, 12));
        px3.setForeground(Utils.themeColor);
        px3.setBounds(WatermarkWindow.textSize.getLocation().x + textSize.getWidth() + 2, this.btnOK.getLocation().y - 22, posX.getPreferredSize().width, 16);
        JLabel opacity = new JLabel(Shutter.language.getProperty("lblOpacity"));
        opacity.setHorizontalAlignment(4);
        opacity.setFont(new Font("FreeSans", 0, 12));
        opacity.setForeground(Utils.themeColor);
        opacity.setBounds(this.btnOK.getLocation().x + this.btnOK.getWidth() - 104, posX.getLocation().y, opacity.getPreferredSize().width, 16);
        textOpacity = new JTextField("100");
        textOpacity.setName("textOpacity");
        textOpacity.setBounds(opacity.getLocation().x + opacity.getWidth() + 2, opacity.getLocation().y, 34, 16);
        textOpacity.setHorizontalAlignment(4);
        textOpacity.setFont(new Font("FreeSans", 0, 12));
        textOpacity.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                logo.repaint();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textOpacity.getText().length() > 0 && Integer.valueOf(textOpacity.getText()) >= 100) {
                    textOpacity.setText("100");
                    logo.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textOpacity.getText().length() >= 3) {
                    textOpacity.setText("");
                }
            }
        });
        JLabel px4 = new JLabel("%");
        px4.setFont(new Font("FreeSans", 0, 12));
        px4.setForeground(Utils.themeColor);
        px4.setBounds(WatermarkWindow.textOpacity.getLocation().x + textOpacity.getWidth() + 2, this.btnOK.getLocation().y - 22, posX.getPreferredSize().width, 16);
        frame.getContentPane().add(posX);
        frame.getContentPane().add(textPosX);
        frame.getContentPane().add(px1);
        frame.getContentPane().add(posY);
        frame.getContentPane().add(textPosY);
        frame.getContentPane().add(px2);
        frame.getContentPane().add(size);
        frame.getContentPane().add(textSize);
        frame.getContentPane().add(px3);
        frame.getContentPane().add(opacity);
        frame.getContentPane().add(textOpacity);
        frame.getContentPane().add(px4);
    }

    public static void loadImage(String h, String m, String s, boolean logo, int size, boolean loadImage) {
        block33: {
            try {
                try {
                    String fichier = Shutter.liste.firstElement();
                    if (Shutter.scanIsRunning) {
                        File dir = new File(Shutter.liste.firstElement());
                        File[] fileArray = dir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (!f.isHidden() && f.isFile()) {
                                fichier = f.toString();
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (loadImage) {
                        File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                        if (file.exists() && !Shutter.inputDeviceIsRunning) {
                            file.delete();
                        }
                        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("tempFolder") + " " + Shutter.dirTemp + System.lineSeparator() + System.lineSeparator());
                        if (Utils.inputDeviceIsRunning) {
                            RecordInputDevice.setInputDevices();
                        } else {
                            FFPROBE.Data(fichier);
                            do {
                                Thread.sleep(100L);
                            } while (FFPROBE.isRunning);
                        }
                        if ((float)ImageWidth / (float)ImageHeight >= 1.7777778f) {
                            containerHeight = (int)Math.floor(640.0f / ((float)ImageWidth / (float)ImageHeight));
                            containerWidth = 640;
                        } else {
                            containerWidth = (int)Math.floor((float)ImageWidth / (float)ImageHeight * 360.0f);
                            containerHeight = 360;
                        }
                        logoRatio = (float)ImageHeight / (float)containerHeight;
                        String seek = " ";
                        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture")) && !Shutter.comboFonctions.getSelectedItem().toString().equals("JPEG")) {
                            seek = " -ss " + h + ":" + m + ":" + s + ".0";
                        }
                        if (Shutter.inputDeviceIsRunning) {
                            if (file.exists()) {
                                FFMPEG.run(" -i \"" + file + '\"' + " -vframes 1 -an -vf scale=" + containerWidth + ":" + containerHeight + " -y " + '\"' + Shutter.dirTemp + "preview.bmp" + '\"');
                            } else {
                                FFMPEG.run(" " + RecordInputDevice.setInputDevices() + " -vframes 1 -an -vf scale=" + containerWidth + ":" + containerHeight + " -y " + '\"' + Shutter.dirTemp + "preview.bmp" + '\"');
                            }
                        } else {
                            FFMPEG.run(String.valueOf(seek) + " -i " + '\"' + fichier + '\"' + " -vframes 1 -an -vf scale=" + containerWidth + ":" + containerHeight + " -y " + '\"' + Shutter.dirTemp + "preview.bmp" + '\"');
                        }
                        do {
                            Thread.sleep(100L);
                        } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error);
                    }
                    image.removeAll();
                    image.add(WatermarkWindow.logo);
                    BufferedImage imageBMP = ImageIO.read(new File(String.valueOf(Shutter.dirTemp) + "preview.bmp"));
                    ImageIcon imageIcon = new ImageIcon(imageBMP);
                    JLabel newImage = new JLabel(imageIcon);
                    if (loadImage) {
                        imageIcon.getImage().flush();
                    }
                    newImage.setHorizontalAlignment(0);
                    newImage.setLocation(0, 0);
                    newImage.setSize(containerWidth, containerHeight);
                    image.setLocation(12 + (640 - containerWidth) / 2, 58 + (int)((float)(360 - containerHeight) / 2.0f));
                    image.setSize(newImage.getSize());
                    imageIcon = new ImageIcon(imageBMP);
                    newImage = new JLabel(imageIcon);
                    newImage.setSize(containerWidth, containerHeight);
                    JPanel topBorder = new JPanel();
                    topBorder.setBackground(Color.BLACK);
                    topBorder.setVisible(false);
                    topBorder.setOpaque(true);
                    JPanel bottomBorder = new JPanel();
                    bottomBorder.setBackground(Color.BLACK);
                    bottomBorder.setVisible(false);
                    bottomBorder.setOpaque(true);
                    JPanel leftBorder = new JPanel();
                    leftBorder.setBackground(Color.BLACK);
                    leftBorder.setVisible(false);
                    leftBorder.setOpaque(true);
                    JPanel rightBorder = new JPanel();
                    rightBorder.setBackground(Color.BLACK);
                    rightBorder.setVisible(false);
                    rightBorder.setOpaque(true);
                    if (Shutter.caseRognage.isSelected()) {
                        String[] i = FFPROBE.imageResolution.split("x");
                        String original = String.valueOf((float)Integer.parseInt(i[0]) / (float)Integer.parseInt(i[1]));
                        String[] o = Shutter.comboH264Taille.getSelectedItem().toString().split("x");
                        String output = String.valueOf((float)Integer.parseInt(o[0]) / (float)Integer.parseInt(o[1]));
                        if (original.length() > 4) {
                            original = original.substring(0, 4);
                        }
                        if (Float.parseFloat(output) < Float.parseFloat(original)) {
                            int crop = Integer.parseInt(o[0]);
                            int borderWidth = (int)Math.floor(((float)containerWidth - (float)newImage.getHeight() / ((float)ImageHeight / (float)crop)) / 2.0f);
                            leftBorder.setSize(borderWidth, newImage.getHeight());
                            rightBorder.setSize(borderWidth, newImage.getHeight());
                            rightBorder.setLocation(containerWidth - rightBorder.getWidth(), 0);
                            leftBorder.setVisible(true);
                            rightBorder.setVisible(true);
                            newImage.add(leftBorder);
                            newImage.add(rightBorder);
                        } else {
                            int crop = Integer.parseInt(o[1]);
                            int borderHeight = (int)Math.floor(((float)containerHeight - (float)newImage.getWidth() / ((float)ImageWidth / (float)crop)) / 2.0f);
                            topBorder.setSize(newImage.getWidth(), borderHeight);
                            bottomBorder.setSize(newImage.getWidth(), borderHeight);
                            bottomBorder.setLocation(0, containerHeight - bottomBorder.getHeight());
                            topBorder.setVisible(true);
                            bottomBorder.setVisible(true);
                            newImage.add(topBorder);
                            newImage.add(bottomBorder);
                        }
                    }
                    image.add(newImage);
                    image.repaint();
                    if (logo && size == -1) {
                        if (textSize != null) {
                            textSize.setText("100");
                        }
                        WatermarkWindow.loadLogo(100);
                    } else if (logo) {
                        WatermarkWindow.loadLogo(size);
                    }
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                    Shutter.enableAll();
                    if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        break block33;
                    }
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
            finally {
                Shutter.enableAll();
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        }
    }

    public static boolean loadLogo(int size) {
        block19: {
            try {
                try {
                    if (Shutter.overlayDeviceIsRunning) {
                        RecordInputDevice.setOverlayDevice();
                    } else {
                        FFPROBE.Data(logoFile);
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                    }
                    File logoTemp = new File(String.valueOf(Shutter.dirTemp) + "logo.png");
                    int logoFinalSizeWidth = (int)((float)ImageWidth / logoRatio);
                    int logoFinalSizeHeight = (int)((float)ImageHeight / logoRatio);
                    logoFinalSizeWidth = (int)((double)logoFinalSizeWidth * ((double)size / 100.0));
                    logoFinalSizeHeight = (int)((double)logoFinalSizeHeight * ((double)size / 100.0));
                    int newPosX = (logo.getWidth() - logoFinalSizeWidth) / 2;
                    int newPosY = (logo.getHeight() - logoFinalSizeHeight) / 2;
                    if (logoTemp.exists()) {
                        logoTemp.delete();
                    }
                    String offset = "";
                    if (FFPROBE.totalLength > 40 && positionVideo != null && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture")) && !Shutter.comboFonctions.getSelectedItem().toString().equals("JPEG")) {
                        DecimalFormat tc = new DecimalFormat("00");
                        String h = String.valueOf(tc.format(positionVideo.getValue() / 3600000));
                        String m = String.valueOf(tc.format(positionVideo.getValue() / 60000 % 60));
                        String s = String.valueOf(tc.format(positionVideo.getValue() / 1000 % 60));
                        offset = " -ss " + h + ":" + m + ":" + s + ".0";
                    }
                    if (Shutter.overlayDeviceIsRunning) {
                        FFMPEG.run(" " + RecordInputDevice.setOverlayDevice() + " -vframes 1 -an -vf scale=" + logoFinalSizeWidth + ":" + logoFinalSizeHeight + " -y " + '\"' + Shutter.dirTemp + "logo.png" + '\"');
                    } else {
                        FFMPEG.run(String.valueOf(offset) + " -i " + '\"' + logoFile + '\"' + " -vframes 1 -an -vf scale=" + logoFinalSizeWidth + ":" + logoFinalSizeHeight + " -y " + '\"' + Shutter.dirTemp + "logo.png" + '\"');
                    }
                    do {
                        Thread.sleep(100L);
                    } while (!logoTemp.exists() && !FFMPEG.error);
                    if (FFMPEG.error) {
                        JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadLogo"), Shutter.language.getProperty("error"), 0);
                    }
                    logo.removeAll();
                    ImageIcon logoIcon = new ImageIcon(String.valueOf(Shutter.dirTemp) + "logo.png");
                    JLabel newLogo = new JLabel(logoIcon);
                    logoIcon.getImage().flush();
                    newLogo.setHorizontalAlignment(0);
                    newLogo.setLocation(0, 0);
                    logo.setLocation(WatermarkWindow.logo.getLocation().x + newPosX, WatermarkWindow.logo.getLocation().y + newPosY);
                    logo.setSize(logoFinalSizeWidth, logoFinalSizeHeight);
                    logoIcon = new ImageIcon(String.valueOf(Shutter.dirTemp) + "logo.png");
                    newLogo = new JLabel(logoIcon);
                    newLogo.setSize(logoFinalSizeWidth, logoFinalSizeHeight);
                    logoLocX = WatermarkWindow.logo.getLocation().x;
                    logoLocY = WatermarkWindow.logo.getLocation().y;
                    logo.add(newLogo);
                    logo.repaint();
                    textPosX.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().x * logoRatio))));
                    textPosY.setText(String.valueOf((Object)((int)((float)WatermarkWindow.logo.getLocation().y * logoRatio))));
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                }
                catch (Exception exception) {
                    Shutter.enableAll();
                    if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        break block19;
                    }
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
            finally {
                Shutter.enableAll();
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        }
        return true;
    }

    public static void loadSettings(final File encFile) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        Thread.sleep(100L);
                    } while (frame == null && !frame.isVisible());
                    File file = new File(String.valueOf(Shutter.dirTemp) + "logo.png");
                    do {
                        Thread.sleep(100L);
                    } while (!file.exists());
                    int posX = 0;
                    int posY = 0;
                    File fXmlFile = encFile;
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(fXmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("Component");
                    int temp = 0;
                    while (temp < nList.getLength()) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            Element eElement = (Element)nNode;
                            Component[] componentArray = frame.getContentPane().getComponents();
                            int n = componentArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Component p = componentArray[n2];
                                if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent()) && p instanceof JTextField) {
                                    do {
                                        Thread.sleep(100L);
                                    } while (!file.exists());
                                    ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                    ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    if (p.getName().equals("textPosX") && textPosX.getText().length() > 0) {
                                        posX = Integer.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    }
                                    if (p.getName().equals("textPosY") && textPosY.getText().length() > 0) {
                                        posY = Integer.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    }
                                    if (p.getName().equals("textOpacity") && textOpacity.getText().length() > 0) {
                                        WatermarkWindow.loadLogo(Integer.parseInt(textSize.getText()));
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        textPosX.setText(String.valueOf(posX));
                                        textPosY.setText(String.valueOf(posY));
                                        logo.setLocation((int)((float)posX / logoRatio), WatermarkWindow.logo.getLocation().y);
                                        logo.setLocation(WatermarkWindow.logo.getLocation().x, (int)((float)posY / logoRatio));
                                    }
                                }
                                ++n2;
                            }
                        }
                        ++temp;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    private static class MouseLogoPosition {
        static int mouseX;
        static int offsetX;
        static int mouseY;
        static int offsetY;

        private MouseLogoPosition() {
        }
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }
}

