/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Settings;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import library.FFMPEG;
import library.YOUTUBEDL;

public class VideoWeb {
    public static JDialog frame;
    ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
    private static int complete;
    private JLabel quit;
    private JLabel help;
    private JPanel topPanel;
    private JLabel topImage;
    private JPanel grpURL;
    private JLabel lblURL;
    private JTextField textURL;
    private JTextField textVideoPass;
    private JTextField textUser;
    private JPasswordField textPass;
    private JLabel lblQualit;
    private JButton btnOK;
    private JRadioButton caseMP3;
    private JRadioButton caseWAV;
    private JRadioButton caseAuto;
    private JRadioButton caseUser;
    private JRadioButton casePass;
    private JRadioButton caseVideoPass;
    private JComboBox<String> comboFormats;

    public VideoWeb() {
        frame = new JDialog();
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameVideoWeb"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(420, 247);
        frame.setResizable(false);
        frame.setModal(true);
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - VideoWeb.frame.getSize().width / 2, dim.height / 2 - VideoWeb.frame.getSize().height / 2);
        }
        this.topPanel();
        this.grpURL();
        Utils.changeDialogVisibility(frame, false);
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.topPanel.setBounds(0, 0, 420, 52);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(VideoWeb.frame.getSize().width - 24, 0, 21, 21);
        this.topPanel.add(this.quit);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoWeb.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    Shutter.lblEncodageEnCours.setForeground(Color.RED);
                    Shutter.lblEncodageEnCours.setText(Shutter.language.getProperty("processCancelled"));
                    Shutter.progressBar1.setValue(0);
                    Utils.changeDialogVisibility(frame, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoWeb.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoWeb.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        this.help = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/help2.png")));
        this.help.setHorizontalAlignment(0);
        this.help.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        this.topPanel.add(this.help);
        this.help.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoWeb.this.help.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/help3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    try {
                        Desktop.getDesktop().browse(new URL("https://rg3.github.io/youtube-dl/supportedsites.html").toURI());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoWeb.this.help.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/help.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoWeb.this.help.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/help2.png")));
                this.accept = false;
            }
        });
        JLabel title = new JLabel(Shutter.language.getProperty("panelWebVideo"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 52);
        title.setFont(new Font("Magneto", 0, 26));
        this.topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.topPanel.add(this.topImage);
        frame.getContentPane().add(this.topPanel);
        this.topImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.topImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void grpURL() {
        this.grpURL = new JPanel();
        this.grpURL.setLayout(null);
        this.grpURL.setLocation(6, 56);
        this.grpURL.setSize(408, 185);
        this.grpURL.setBackground(new Color(50, 50, 50));
        this.grpURL.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(80, 80, 80), 1), String.valueOf(Shutter.language.getProperty("videoUrl")) + " ", 0, 0, new Font("Montserrat", 0, 12), Color.WHITE));
        this.lblURL = new JLabel(Shutter.language.getProperty("lblURL"));
        this.lblURL.setHorizontalAlignment(4);
        this.lblURL.setFont(new Font("FreeSans", 0, 12));
        this.lblURL.setBounds(26, 25, 35, 16);
        this.grpURL.add(this.lblURL);
        this.textURL = new JTextField();
        this.textURL.setForeground(Color.LIGHT_GRAY);
        this.textURL.setFont(new Font("SansSerif", 2, 12));
        this.textURL.setText(Shutter.language.getProperty("textURL"));
        this.textURL.setBounds(66, 22, 270, 21);
        this.textURL.setColumns(10);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem coller = new JMenuItem(Shutter.language.getProperty("MenuItemPaste"));
        coller.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoWeb.this.PasteFromClipBoard(true);
            }
        });
        menu.add(coller);
        this.textURL.setComponentPopupMenu(menu);
        this.textURL.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (VideoWeb.this.textURL.getText().equals("") || VideoWeb.this.textURL.getText().equals(Shutter.language.getProperty("textURL"))) {
                    VideoWeb.this.btnOK.setEnabled(false);
                    if (!VideoWeb.this.caseAuto.isSelected()) {
                        VideoWeb.this.caseAuto.doClick();
                    }
                    VideoWeb.this.caseAuto.setEnabled(false);
                } else {
                    if (Settings.comboTheme.getSelectedItem().equals(Shutter.language.getProperty("darkTheme"))) {
                        VideoWeb.this.textURL.setForeground(Color.WHITE);
                    } else {
                        VideoWeb.this.textURL.setForeground(Color.BLACK);
                    }
                    VideoWeb.this.textURL.setFont(new Font("SansSerif", 0, 12));
                    VideoWeb.this.btnOK.setEnabled(true);
                    if (!VideoWeb.this.caseAuto.isSelected()) {
                        VideoWeb.this.caseAuto.doClick();
                    }
                    VideoWeb.this.caseAuto.setEnabled(true);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 86 && (e.getModifiersEx() & 0x100) != 0 || e.getKeyCode() == 86 && (e.getModifiersEx() & 0x80) != 0) {
                    VideoWeb.this.PasteFromClipBoard(false);
                }
                if (e.getKeyCode() == 65 && (e.getModifiersEx() & 0x100) != 0 || e.getKeyCode() == 65 && (e.getModifiersEx() & 0x80) != 0) {
                    VideoWeb.this.textURL.selectAll();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.grpURL.add(this.textURL);
        this.caseAuto = new JRadioButton("Auto");
        this.caseAuto.setSelected(true);
        this.caseAuto.setFont(new Font("FreeSans", 0, 12));
        this.caseAuto.setBounds(66, 52, this.caseAuto.getPreferredSize().width, 16);
        this.caseAuto.setEnabled(false);
        this.grpURL.add(this.caseAuto);
        this.caseAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoWeb.this.comboFormats.removeAllItems();
                if (VideoWeb.this.caseAuto.isSelected()) {
                    VideoWeb.this.comboFormats.addItem("bestvideo+bestaudio");
                    VideoWeb.this.comboFormats.addItem("bestvideo");
                    VideoWeb.this.comboFormats.addItem("bestaudio");
                } else {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    YOUTUBEDL.getAvailableFormats(VideoWeb.this.textURL.getText(), VideoWeb.this.options());
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (YOUTUBEDL.runProcess.isAlive() && !Shutter.cancelled);
                    if (!YOUTUBEDL.error) {
                        String allFormats = YOUTUBEDL.formatsOutput.substring(YOUTUBEDL.formatsOutput.lastIndexOf(":") + 2).replace("null", "").replace("DASH audio", "").replace("DASH video", "");
                        String[] stringArray = allFormats.split(System.lineSeparator());
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String format = stringArray[n2];
                            if (!format.contains("format")) {
                                VideoWeb.this.comboFormats.addItem(format);
                            }
                            ++n2;
                        }
                    } else {
                        if (!VideoWeb.this.caseAuto.isSelected()) {
                            VideoWeb.this.caseAuto.doClick();
                        }
                        JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("invalidUrl"), Shutter.language.getProperty("downloadError"), 0);
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.comboFormats = new JComboBox();
        this.comboFormats.addItem("bestvideo+bestaudio");
        this.comboFormats.addItem("bestvideo");
        this.comboFormats.addItem("bestaudio");
        this.comboFormats.setLocation(16, 153);
        this.comboFormats.setSize(380, 22);
        this.comboFormats.setMaximumRowCount(10);
        this.grpURL.add(this.comboFormats);
        this.comboFormats.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (VideoWeb.this.comboFormats.getPreferredSize().getWidth() > 380.0) {
                    VideoWeb.this.comboFormats.setSize(VideoWeb.this.comboFormats.getPreferredSize());
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                VideoWeb.this.comboFormats.setSize(380, 22);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.lblQualit = new JLabel(Shutter.language.getProperty("lblQualit"));
        this.lblQualit.setHorizontalAlignment(4);
        this.lblQualit.setFont(new Font("FreeSans", 0, 12));
        this.lblQualit.setBounds(16, 51, 45, 16);
        this.grpURL.add(this.lblQualit);
        this.btnOK = new JButton("OK");
        this.btnOK.setFont(new Font("Montserrat", 0, 12));
        this.btnOK.setBounds(343, 22, 53, 21);
        this.btnOK.setEnabled(false);
        this.grpURL.add(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoWeb.this.startDownload();
            }
        });
        this.caseMP3 = new JRadioButton(Shutter.language.getProperty("caseMP3"));
        this.caseMP3.setFont(new Font("FreeSans", 0, 12));
        this.caseMP3.setBounds(121, 52, 127, 16);
        this.grpURL.add(this.caseMP3);
        this.caseMP3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoWeb.this.caseMP3.isSelected()) {
                    VideoWeb.this.caseWAV.setSelected(false);
                    if (VideoWeb.this.caseAuto.isSelected()) {
                        VideoWeb.this.comboFormats.setSelectedIndex(1);
                    }
                } else if (VideoWeb.this.caseAuto.isSelected()) {
                    VideoWeb.this.comboFormats.setSelectedIndex(0);
                }
            }
        });
        this.caseWAV = new JRadioButton(Shutter.language.getProperty("caseWAV"));
        this.caseWAV.setFont(new Font("FreeSans", 0, 12));
        this.caseWAV.setBounds(248, 52, 127, 16);
        this.grpURL.add(this.caseWAV);
        this.caseWAV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoWeb.this.caseWAV.isSelected()) {
                    VideoWeb.this.caseMP3.setSelected(false);
                    if (VideoWeb.this.caseAuto.isSelected()) {
                        VideoWeb.this.comboFormats.setSelectedIndex(1);
                    }
                } else if (VideoWeb.this.caseAuto.isSelected()) {
                    VideoWeb.this.comboFormats.setSelectedIndex(0);
                }
            }
        });
        frame.getContentPane().add(this.grpURL);
        this.caseVideoPass = new JRadioButton(Shutter.language.getProperty("caseVideoPass"));
        this.caseVideoPass.setFont(new Font("FreeSans", 0, 12));
        this.caseVideoPass.setBounds(66, 123, this.caseVideoPass.getPreferredSize().width, 16);
        this.grpURL.add(this.caseVideoPass);
        this.caseVideoPass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (VideoWeb.this.caseVideoPass.isSelected()) {
                    VideoWeb.this.textVideoPass.setEnabled(true);
                } else {
                    VideoWeb.this.textVideoPass.setText("");
                    VideoWeb.this.textVideoPass.setEnabled(false);
                }
            }
        });
        this.textVideoPass = new JTextField();
        this.textVideoPass.setFont(new Font("SansSerif", 0, 12));
        this.textVideoPass.setBounds(this.caseVideoPass.getLocation().x + this.caseVideoPass.getWidth() + 4, 120, this.grpURL.getSize().width - (this.caseVideoPass.getLocation().x + this.caseVideoPass.getSize().width) - 17, 21);
        this.textVideoPass.setEnabled(false);
        this.textVideoPass.setColumns(10);
        this.grpURL.add(this.textVideoPass);
        this.caseUser = new JRadioButton(Shutter.language.getProperty("caseUser"));
        this.caseUser.setFont(new Font("FreeSans", 0, 12));
        this.caseUser.setBounds(66, 79, this.caseUser.getPreferredSize().width, 16);
        this.grpURL.add(this.caseUser);
        this.caseUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (VideoWeb.this.caseUser.isSelected()) {
                    VideoWeb.this.textUser.setEnabled(true);
                } else {
                    VideoWeb.this.textUser.setText("");
                    VideoWeb.this.textUser.setEnabled(false);
                }
            }
        });
        this.textUser = new JTextField();
        this.textUser.setEnabled(false);
        this.textUser.setText(null);
        this.textUser.setFont(new Font("SansSerif", 0, 12));
        this.textUser.setColumns(10);
        this.textUser.setBounds(this.caseVideoPass.getLocation().x + this.caseVideoPass.getWidth() + 4, 76, this.grpURL.getSize().width - (this.caseVideoPass.getLocation().x + this.caseVideoPass.getSize().width) - 17, 21);
        this.grpURL.add(this.textUser);
        this.casePass = new JRadioButton(Shutter.language.getProperty("casePass"));
        this.casePass.setFont(new Font("FreeSans", 0, 12));
        this.casePass.setBounds(66, 101, this.casePass.getPreferredSize().width, 16);
        this.grpURL.add(this.casePass);
        this.casePass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (VideoWeb.this.casePass.isSelected()) {
                    VideoWeb.this.textPass.setEnabled(true);
                } else {
                    VideoWeb.this.textPass.setText("");
                    VideoWeb.this.textPass.setEnabled(false);
                }
            }
        });
        this.textPass = new JPasswordField();
        this.textPass.setEnabled(false);
        this.textPass.setText(null);
        this.textPass.setFont(new Font("SansSerif", 0, 12));
        this.textPass.setColumns(10);
        this.textPass.setEchoChar('\u2022');
        this.textPass.setBounds(this.caseVideoPass.getLocation().x + this.caseVideoPass.getWidth() + 4, 98, this.grpURL.getSize().width - (this.caseVideoPass.getLocation().x + this.caseVideoPass.getSize().width) - 17, 21);
        this.grpURL.add(this.textPass);
    }

    private String options() {
        String options = "";
        if (this.caseUser.isSelected()) {
            options = String.valueOf(options) + " --username \"" + this.textUser.getText() + '\"';
        }
        if (this.casePass.isSelected()) {
            options = String.valueOf(options) + " --password \"" + new String(this.textPass.getPassword()) + '\"';
        }
        if (this.caseVideoPass.isSelected()) {
            options = String.valueOf(options) + " --video-password \"" + this.textVideoPass.getText() + '\"';
        }
        return options;
    }

    private void startDownload() {
        Thread downloadProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                block21: {
                    complete = 0;
                    Shutter.lblTermine.setText(Utils.completedFiles(complete));
                    try {
                        if (VideoWeb.this.textURL.getText().toLowerCase().equals("update")) {
                            FFMPEG.disableAll();
                            Shutter.btnStart.setEnabled(false);
                            Shutter.lblEncodageEnCours.setText(Shutter.language.getProperty("update"));
                            YOUTUBEDL.update();
                            Shutter.progressBar1.setIndeterminate(true);
                            do {
                                Thread.sleep(100L);
                            } while (YOUTUBEDL.isRunning);
                            Shutter.progressBar1.setIndeterminate(false);
                            FFMPEG.enableAll();
                            FFMPEG.enfOfFunction();
                            break block21;
                        }
                        if (VideoWeb.this.caseAuto.isSelected()) {
                            YOUTUBEDL.format = "-f " + VideoWeb.this.comboFormats.getSelectedItem().toString();
                        } else {
                            String[] f = VideoWeb.this.comboFormats.getSelectedItem().toString().split(" ");
                            YOUTUBEDL.format = VideoWeb.this.comboFormats.getSelectedItem().toString().contains("audio only") ? "-f " + f[0] : "-f " + f[0] + "+bestaudio";
                        }
                        FFMPEG.disableAll();
                        Shutter.btnStart.setEnabled(false);
                        YOUTUBEDL.run(VideoWeb.this.textURL.getText(), VideoWeb.this.options());
                        do {
                            Thread.sleep(100L);
                        } while (YOUTUBEDL.runProcess.isAlive() && !FFMPEG.cancelled);
                        if (Shutter.cancelled) {
                            if (YOUTUBEDL.fichierDeSortie.exists()) {
                                YOUTUBEDL.fichierDeSortie.delete();
                            }
                        } else {
                            Shutter.tempsRestant.setVisible(false);
                            String ext = YOUTUBEDL.fichierDeSortie.toString().substring(YOUTUBEDL.fichierDeSortie.toString().lastIndexOf("."));
                            if (VideoWeb.this.caseWAV.isSelected()) {
                                Shutter.lblEncodageEnCours.setText(Shutter.language.getProperty("convertToWAV"));
                                String cmd = " -vn -y ";
                                FFMPEG.run(" -i \"" + YOUTUBEDL.fichierDeSortie.toString() + '\"' + cmd + '\"' + YOUTUBEDL.fichierDeSortie.toString().replace(ext, ".wav") + '\"');
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.isRunning && !FFMPEG.cancelled);
                                if (Shutter.cancelled) {
                                    File audioFile = new File(YOUTUBEDL.fichierDeSortie.toString().replace(ext, ".wav"));
                                    audioFile.delete();
                                }
                            } else if (VideoWeb.this.caseMP3.isSelected()) {
                                Shutter.lblEncodageEnCours.setText(Shutter.language.getProperty("convertToMP3"));
                                String cmd = " -vn -acodec mp3 -b:a 256k -y ";
                                FFMPEG.run(" -i \"" + YOUTUBEDL.fichierDeSortie.toString() + '\"' + cmd + '\"' + YOUTUBEDL.fichierDeSortie.toString().replace(ext, ".mp3") + '\"');
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.isRunning && !FFMPEG.cancelled);
                                if (Shutter.cancelled) {
                                    File audioFile = new File(YOUTUBEDL.fichierDeSortie.toString().replace(ext, ".mp3"));
                                    audioFile.delete();
                                }
                            }
                        }
                        if (!Shutter.cancelled) {
                            Shutter.lblTermine.setText(Utils.completedFiles(++complete));
                            if (Shutter.caseOpenFolderAtEnd1.isSelected()) {
                                try {
                                    Desktop.getDesktop().open(new File(Shutter.lblDestination1.getText()));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        FFMPEG.enableAll();
                        FFMPEG.enfOfFunction();
                        Utils.sendMail(YOUTUBEDL.fichierDeSortie.toString());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        downloadProcess.start();
        Utils.changeDialogVisibility(frame, true);
    }

    private void PasteFromClipBoard(boolean mouse) {
        Clipboard sysClip;
        Transferable clipTf;
        if (this.textURL.getText().equals(Shutter.language.getProperty("textURL"))) {
            this.textURL.setText("");
        }
        this.textURL.setFont(new Font("SansSerif", 0, 13));
        this.btnOK.setEnabled(true);
        if (!this.caseAuto.isSelected()) {
            this.caseAuto.doClick();
        }
        this.caseAuto.setEnabled(true);
        if (mouse && (clipTf = (sysClip = Toolkit.getDefaultToolkit().getSystemClipboard()).getContents(null)) != null && clipTf.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                this.textURL.setText((String)clipTf.getTransferData(DataFlavor.stringFlavor));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.textURL.getText().equals(Shutter.language.getProperty("textURL"))) {
            this.textURL.setText("");
        }
        if (Settings.comboTheme.getSelectedItem().equals(Shutter.language.getProperty("darkTheme"))) {
            this.textURL.setForeground(Color.WHITE);
        } else {
            this.textURL.setForeground(Color.BLACK);
        }
        this.textURL.setFont(new Font("SansSerif", 0, 13));
        this.caseAuto.setEnabled(true);
        this.btnOK.setEnabled(true);
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }
}

