/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.RenderQueue;
import application.Settings;
import application.Shutter;
import application.Subtitles;
import application.Utils;
import com.sun.jna.NativeLibrary;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import library.FFMPEG;
import library.FFPLAY;
import library.FFPROBE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.caprica.vlcj.binding.LibC;
import uk.co.caprica.vlcj.component.DirectMediaPlayerComponent;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.direct.BufferFormat;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.direct.RenderCallbackAdapter;
import uk.co.caprica.vlcj.player.direct.format.RV32BufferFormat;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class VideoPlayer {
    public static JFrame frame = new JFrame();
    JLabel title = new JLabel(Shutter.language.getProperty("frameLecteurVideo"));
    ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
    private boolean isFullScreen = false;
    private JLabel quit;
    private JLabel fullscreen;
    private JLabel reduce;
    private JPanel topPanel;
    private JLabel topImage;
    private JLabel bottomImage;
    public static JPanel playerLeft;
    public static JPanel playerRight;
    public static JPanel grpOut;
    public static JTextField caseOutH;
    public static JTextField caseOutM;
    public static JTextField caseOutS;
    public static JTextField caseOutF;
    private static JPanel grpIn;
    public static JTextField caseInH;
    public static JTextField caseInM;
    public static JTextField caseInS;
    public static JTextField caseInF;
    public static JSlider sliderIn;
    public static JSlider sliderOut;
    private JButton btnCaptureIn;
    private JButton btnPreview;
    public static JButton leftPrevious;
    public static JButton leftNext;
    private JButton rightPrevious;
    private JButton rightNext;
    private JRadioButton casePlaySound;
    public static JRadioButton caseTcInterne;
    public static String videoPath;
    private static int width;
    private static int height;
    public static float ratio;
    private static JPanel videoSurfaceLeft;
    private static JPanel videoSurfaceRight;
    private static BufferedImage imageLeft;
    private static BufferedImage imageRight;
    public static DirectMediaPlayerComponent mediaPlayerComponentLeft;
    public static DirectMediaPlayerComponent mediaPlayerComponentRight;
    public static JButton leftStop;
    public static JButton leftPlay;
    private static JButton rightStop;
    public static JButton rightPlay;
    private static JLabel lblVideo;
    private static boolean drag;
    public static boolean sliderInChange;
    static boolean sliderOutChange;
    private JLabel lblVolume;
    public static JSlider sliderVolume;
    private static JLabel lblDuree;
    private static JLabel lblMode;
    public static JComboBox<Object> comboMode;
    private static boolean showInfoMessage;
    public static int offset;
    public static int dureeHeures;
    public static int dureeMinutes;
    public static int dureeSecondes;
    public static int dureeImages;
    private static boolean calculIn;
    private static boolean calculOut;
    public static long timeIn;
    static long timeOut;
    static boolean frameControl;
    public static boolean addWaveformIsRunning;
    public static File waveform;
    public static JLabel waveformLeft;
    public static JLabel waveformRight;
    public static JPanel panelWaveformLeft;
    private static JPanel panelWaveformRight;

    static {
        videoPath = null;
        width = 640;
        height = 360;
        ratio = 1.777777f;
        sliderInChange = false;
        sliderOutChange = false;
        comboMode = new JComboBox<String>(new String[]{Shutter.language.getProperty("cutUpper"), Shutter.language.getProperty("removeMode")});
        showInfoMessage = true;
        offset = 0;
        dureeHeures = 0;
        dureeMinutes = 0;
        dureeSecondes = 0;
        dureeImages = 0;
        calculIn = true;
        calculOut = true;
        frameControl = false;
        addWaveformIsRunning = false;
        waveform = new File(String.valueOf(Shutter.dirTemp) + "waveform.png");
    }

    public VideoPlayer() {
        String NATIVE_LIBRARY_SEARCH_PATH;
        showInfoMessage = true;
        if (System.getProperty("os.name").contains("Windows")) {
            NATIVE_LIBRARY_SEARCH_PATH = "Library/vlc/";
        } else {
            NATIVE_LIBRARY_SEARCH_PATH = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            NATIVE_LIBRARY_SEARCH_PATH = NATIVE_LIBRARY_SEARCH_PATH.substring(0, NATIVE_LIBRARY_SEARCH_PATH.length() - 1);
            NATIVE_LIBRARY_SEARCH_PATH = String.valueOf(NATIVE_LIBRARY_SEARCH_PATH.substring(0, NATIVE_LIBRARY_SEARCH_PATH.lastIndexOf("/")).replace("%20", " ")) + "/Library/vlc/lib";
            LibC.INSTANCE.setenv("VLC_PLUGIN_PATH", NATIVE_LIBRARY_SEARCH_PATH.replace("lib", "plugins"), 1);
        }
        NativeLibrary.addSearchPath(RuntimeUtil.getLibVlcLibraryName(), NATIVE_LIBRARY_SEARCH_PATH);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(null);
        frame.setVisible(false);
        frame.setSize(646, 629);
        frame.setTitle(Shutter.language.getProperty("frameLecteurVideo"));
        frame.setForeground(Color.WHITE);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - VideoPlayer.frame.getSize().width / 2, dim.height / 2 - VideoPlayer.frame.getSize().height / 2);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
        }
        this.topPanel();
        this.btnCaptureIn = new JButton(Shutter.language.getProperty("btnCaptureIn"));
        this.btnCaptureIn.setFont(new Font("Montserrat", 0, 12));
        this.btnCaptureIn.setMargin(new Insets(0, 0, 0, 0));
        this.btnCaptureIn.setBounds(8, this.topPanel.getSize().height + 10, 130, 21);
        frame.getContentPane().add(this.btnCaptureIn);
        this.btnCaptureIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File fileOut;
                    String sortie;
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    File file = new File(Shutter.liste.firstElement());
                    String ext = file.toString().substring(file.toString().lastIndexOf("."));
                    FFMPEG.fonctionInOut();
                    if (Shutter.caseChangeFolder1.isSelected()) {
                        sortie = Shutter.lblDestination1.getText();
                    } else {
                        sortie = file.getParent();
                        Shutter.lblDestination1.setText(sortie);
                    }
                    String newExtension = ".jpg";
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
                        newExtension = Shutter.comboFilter.getSelectedItem().toString();
                    }
                    if ((fileOut = new File(String.valueOf(sortie) + "/" + file.getName().replace(ext, newExtension))).exists()) {
                        int n = 1;
                        do {
                            fileOut = new File(String.valueOf(sortie) + "/" + file.getName().replace(ext, "_" + n + newExtension));
                            ++n;
                        } while (fileOut.exists());
                    }
                    FFPROBE.FrameData(file.toString());
                    do {
                        Thread.sleep(10L);
                    } while (FFPROBE.isRunning);
                    String filter = "";
                    if (FFPROBE.entrelaced.equals("1")) {
                        filter = " -filter:v yadif=0:" + FFPROBE.fieldOrder + ":0";
                    }
                    if (sliderOut.getValue() != sliderOut.getMaximum()) {
                        int frameIn = (int)((float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                        int frameOut = (int)((float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                        DecimalFormat formatFrame = new DecimalFormat("000");
                        FFMPEG.run(" -ss " + caseInH.getText() + ":" + caseInM.getText() + ":" + caseInS.getText() + "." + formatFrame.format(frameIn) + " -i " + '\"' + file.toString() + '\"' + " -ss " + caseOutH.getText() + ":" + caseOutM.getText() + ":" + caseOutS.getText() + "." + formatFrame.format(frameOut) + " -i " + '\"' + file.toString() + '\"' + filter + " -vframes 1 -q:v 0 -an -filter_complex hstack -y " + '\"' + fileOut + '\"');
                    } else {
                        FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + filter + " -vframes 1 -q:v 0 -an -y " + '\"' + fileOut + '\"');
                    }
                    do {
                        Thread.sleep(10L);
                    } while (FFMPEG.isRunning);
                    FFMPEG.enableAll();
                    Shutter.caseRunInBackground.setEnabled(false);
                    Shutter.caseRunInBackground.setSelected(false);
                    Shutter.btnCancel.setEnabled(false);
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        });
        this.btnPreview = new JButton(Shutter.language.getProperty("preview"));
        this.btnPreview.setFont(new Font("Montserrat", 0, 12));
        this.btnPreview.setMargin(new Insets(0, 0, 0, 0));
        this.btnPreview.setBounds(VideoPlayer.frame.getSize().width - 6 - 130 - 4, this.topPanel.getSize().height + 10, 130, 21);
        frame.getContentPane().add(this.btnPreview);
        this.btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int i;
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    FFMPEG.fonctionInOut();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (FFPROBE.isRunning);
                    String channels = "";
                    String videoOutput = "";
                    String audioOutput = "";
                    if (FFPROBE.audioOnly) {
                        if (FFPROBE.channels > 1) {
                            i = 0;
                            while (i < FFPROBE.channels) {
                                channels = String.valueOf(channels) + "[0:a:" + i + "]showvolume=f=0.001:b=4:w=720:h=12[a" + i + "];";
                                audioOutput = String.valueOf(audioOutput) + "[a" + i + "]";
                                ++i;
                            }
                            audioOutput = String.valueOf(channels) + audioOutput + "vstack=" + i + "[volume]" + '\"' + " -map " + '\"' + "[volume]" + '\"';
                        } else if (FFPROBE.channels <= 1) {
                            audioOutput = "[0:a:0]showvolume=f=0.001:b=4:w=720:h=12[volume]\" -map \"[volume]\"";
                        }
                    } else {
                        if (FFPROBE.channels > 1) {
                            i = 0;
                            while (i < FFPROBE.channels) {
                                channels = String.valueOf(channels) + "[0:a:" + i + "]showvolume=f=0.001:b=4:w=1080:h=12[a" + i + "];";
                                audioOutput = String.valueOf(audioOutput) + "[a" + i + "]";
                                ++i;
                            }
                            audioOutput = String.valueOf(audioOutput) + "vstack=" + (i + 1) + "[volume]" + '\"' + " -map " + '\"' + "[volume]" + '\"';
                        } else if (FFPROBE.channels == 1) {
                            channels = "[0:a:0]showvolume=f=0.001:b=4:w=1080:h=12[a0];";
                            audioOutput = "[a0]vstack[volume]\" -map \"[volume]\"";
                        }
                        videoOutput = "[0:v]scale=1080:-1[v];" + channels + "[v]";
                        if (FFPROBE.channels == 0) {
                            videoOutput = "scale=1080:-1\"";
                            audioOutput = "";
                        }
                    }
                    File fichier = new File(videoPath);
                    String extension = videoPath.substring(videoPath.lastIndexOf("."));
                    String sortie = new File(videoPath).getParent();
                    String concat = "";
                    if (comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                        concat = FFMPEG.setConcat(fichier, sortie);
                        fichier = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.getName().replace(extension, ".txt"));
                    }
                    String cmd = " -filter_complex \"" + videoOutput + audioOutput + " -c:v rawvideo -map a? -f nut pipe:play |";
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    FFMPEG.toFFPLAY(String.valueOf(FFMPEG.inPoint) + concat + " -i " + '\"' + fichier + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd);
                    if (FFMPEG.isRunning) {
                        do {
                            if (FFMPEG.error) {
                                JOptionPane.showConfirmDialog(frame, Shutter.language.getProperty("cantReadFile"), Shutter.language.getProperty("menuItemVisualiser"), -1, 0);
                                break;
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFMPEG.isRunning || FFMPEG.error);
                    }
                    if (comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                        File listeBAB = new File(String.valueOf(sortie.replace("\\", "/")) + "/" + fichier.getName().replace(extension, ".txt"));
                        listeBAB.delete();
                    }
                    if (FFMPEG.isRunning) {
                        FFMPEG.process.destroy();
                    }
                    Shutter.enableAll();
                    Shutter.progressBar1.setValue(0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        lblVideo = new JLabel();
        lblVideo.setVisible(false);
        lblVideo.setFont(new Font("SansSerif", 1, 13));
        lblVideo.setForeground(Utils.themeColor);
        lblVideo.setHorizontalAlignment(0);
        lblVideo.setBounds(this.btnCaptureIn.getLocation().x + this.btnCaptureIn.getSize().width + 6, this.topPanel.getSize().height + 12, VideoPlayer.frame.getSize().width - (this.btnCaptureIn.getLocation().x + this.btnCaptureIn.getSize().width + 6 + this.btnPreview.getSize().width + 12), 16);
        frame.getContentPane().add(lblVideo);
        VideoPlayer.setMedia();
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException dim) {
                // empty catch block
            }
        } while (FFPROBE.isRunning);
        this.players();
        this.buttons();
        this.grpIn();
        this.grpOut();
        this.sliders();
        if (FFPROBE.audioOnly) {
            this.btnCaptureIn.setEnabled(false);
        } else {
            this.btnCaptureIn.setEnabled(true);
        }
        lblDuree = new JLabel();
        lblDuree.setHorizontalAlignment(0);
        lblDuree.setFont(new Font("Montserrat", 0, 13));
        lblDuree.setForeground(Utils.themeColor);
        lblDuree.setBounds(0, VideoPlayer.frame.getSize().height - 16 - 12, frame.getWidth(), 16);
        frame.getContentPane().add(lblDuree);
        VideoPlayer.totalDuration();
        drag = false;
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (VideoPlayer.frame.getSize().width >= 636 && VideoPlayer.frame.getSize().height >= 619 && e.getX() >= 636 && e.getY() >= 619 && drag) {
                    frame.setExtendedState(0);
                    frame.setSize(e.getX() + 20, e.getY() + 20);
                    VideoPlayer.this.resizeAll();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseInfo.getPointerInfo().getLocation().x - VideoPlayer.frame.getLocation().x > VideoPlayer.frame.getSize().width - 20 || MouseInfo.getPointerInfo().getLocation().y - VideoPlayer.frame.getLocation().y > VideoPlayer.frame.getSize().height - 20) {
                    frame.setCursor(Cursor.getPredefinedCursor(5));
                } else if (!drag) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor().getType() == 5) {
                    drag = true;
                    if (waveform.exists()) {
                        if (waveformLeft != null && !FFPROBE.audioOnly) {
                            waveformLeft.setVisible(false);
                        }
                        if (waveformRight != null && !FFPROBE.audioOnly) {
                            waveformRight.setVisible(false);
                        }
                        sliderIn.setVisible(true);
                        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                            sliderOut.setVisible(true);
                        }
                    }
                    if (mediaPlayerComponentLeft != null) {
                        mediaPlayerComponentLeft.getMediaPlayer().stop();
                        playerLeft.remove(videoSurfaceLeft);
                        playerLeft.revalidate();
                        playerLeft.repaint();
                    }
                    if (mediaPlayerComponentRight != null) {
                        mediaPlayerComponentRight.getMediaPlayer().stop();
                        playerRight.remove(videoSurfaceRight);
                        playerRight.revalidate();
                        playerRight.repaint();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (drag) {
                    if (VideoPlayer.frame.getSize().width < 646 && VideoPlayer.frame.getSize().height < 629) {
                        frame.setExtendedState(0);
                        frame.setSize(646, 629);
                    }
                    if (mediaPlayerComponentLeft != null) {
                        videoSurfaceLeft.setBounds(0, 0, width, height);
                        if (mediaPlayerComponentLeft.getMediaPlayer().getMediaState() != null) {
                            VideoPlayer.this.updateVideoSurfaceLeft();
                        }
                    }
                    if (mediaPlayerComponentRight != null) {
                        videoSurfaceRight.setBounds(0, 0, width, height);
                        if (mediaPlayerComponentRight.getMediaPlayer().getMediaState() != null) {
                            VideoPlayer.this.updateVideoSurfaceRight();
                        }
                    }
                }
                VideoPlayer.this.resizeAll();
                VideoPlayer.this.setVideoPlayersTimeOnResize();
                drag = false;
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (frame.getCursor().getType() == 5) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                if (VideoPlayer.this.isFullScreen) {
                    frame.setExtendedState(6);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                frame.toFront();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (!drag) {
                    VideoPlayer.this.resizeAll();
                    VideoPlayer.this.setVideoPlayersTimeOnResize();
                }
            }
        });
        if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
            File video = new File(Shutter.liste.firstElement());
            String videoWithoutExt = video.getName().substring(0, video.getName().lastIndexOf("."));
            Subtitles.srt = new File(String.valueOf(video.getParent()) + "/" + videoWithoutExt + ".srt");
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(VideoPlayer.frame.getLocation().x, dim.height / 3 - frame.getHeight() / 2);
            if (Subtitles.frame == null) {
                new Subtitles(dim.width / 2 - 500, VideoPlayer.frame.getLocation().y + frame.getHeight() + 7);
            } else {
                Subtitles.frame.setVisible(true);
                Subtitles.subtitlesNumber();
            }
            sliderVolume.setValue(sliderVolume.getMaximum());
        }
        width = VideoPlayer.playerLeft.getSize().width;
        height = VideoPlayer.playerLeft.getSize().height;
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 107) {
                    sliderVolume.setValue(sliderVolume.getValue() + 2);
                }
                if (e.getKeyCode() == 109) {
                    sliderVolume.setValue(sliderVolume.getValue() - 2);
                }
                if (mediaPlayerComponentLeft != null && mediaPlayerComponentLeft.getMediaPlayer().getMediaState() != null) {
                    if (e.getKeyCode() == 37) {
                        leftPrevious.doClick();
                    }
                    if (e.getKeyCode() == 39) {
                        leftNext.doClick();
                    }
                }
                if (mediaPlayerComponentRight != null && mediaPlayerComponentRight.getMediaPlayer().getMediaState() != null) {
                    if (e.getKeyCode() == 38) {
                        VideoPlayer.this.rightNext.doClick();
                    }
                    if (e.getKeyCode() == 40) {
                        VideoPlayer.this.rightPrevious.doClick();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        Component[] componentArray = frame.getContentPane().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.addKeyListener(keyListener);
            ++n2;
        }
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                shape1.add(shape2);
                frame.setShape(shape1);
            }
        });
        leftPlay.doClick();
    }

    public static void setMedia() {
        if (Shutter.caseInAndOut.isSelected()) {
            if (Shutter.liste.getSize() != 0) {
                videoPath = Shutter.liste.firstElement();
                if (Shutter.scanIsRunning) {
                    File dir = new File(Shutter.liste.firstElement());
                    File[] fileArray = dir.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (!f.isHidden() && f.isFile()) {
                            videoPath = f.toString();
                            break;
                        }
                        ++n2;
                    }
                }
                if (frame.isVisible() && !lblVideo.getText().equals(new File(videoPath).getName()) && panelWaveformLeft.isVisible() && panelWaveformRight.isVisible() && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    waveformLeft.setVisible(false);
                    waveformRight.setVisible(false);
                    sliderIn.setVisible(true);
                    sliderOut.setVisible(true);
                    if (waveform.exists()) {
                        waveform.delete();
                    }
                    if (FFMPEG.isRunning) {
                        FFMPEG.process.destroy();
                    }
                    leftStop.doClick();
                }
                if (!lblVideo.isVisible() || !lblVideo.getText().equals(new File(videoPath).getName())) {
                    if (!FFPROBE.isRunning) {
                        FFPROBE.Data(videoPath);
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException dir) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                    }
                    lblVideo.setText(new File(videoPath).getName());
                    lblVideo.setVisible(true);
                }
            } else {
                leftStop.doClick();
                videoPath = null;
                lblVideo.setVisible(false);
                mediaPlayerComponentLeft.getMediaPlayer().stop();
                sliderIn.setValue(0);
                playerLeft.remove(videoSurfaceLeft);
                playerLeft.revalidate();
                playerLeft.repaint();
                mediaPlayerComponentRight.getMediaPlayer().stop();
                sliderOut.setValue(sliderOut.getMaximum());
                playerRight.remove(videoSurfaceRight);
                playerRight.revalidate();
                playerRight.repaint();
                leftPlay.setText(Shutter.language.getProperty("btnPlay"));
                rightPlay.setText(Shutter.language.getProperty("btnPlay"));
            }
            Thread sliders = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!frame.isVisible());
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        grpOut.setVisible(false);
                        sliderOut.setVisible(false);
                    } else {
                        grpOut.setVisible(true);
                        if (sliderIn.isVisible()) {
                            sliderOut.setVisible(true);
                        } else {
                            sliderOut.setVisible(false);
                        }
                    }
                }
            });
            sliders.start();
        }
    }

    private void addVideo() {
        videoSurfaceLeft = new VideoSurfacePanelLeft();
        videoSurfaceLeft.setBounds(0, 0, width, height);
        playerLeft.add(videoSurfaceLeft);
        playerLeft.revalidate();
        playerLeft.repaint();
        videoSurfaceRight = new VideoSurfacePanelRight();
        videoSurfaceRight.setBounds(0, 0, width, height);
        playerRight.add(videoSurfaceRight);
        playerRight.revalidate();
        playerRight.repaint();
        imageLeft = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height);
        imageRight = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height);
        BufferFormatCallback bufferFormatCallbackLeft = new BufferFormatCallback(){

            @Override
            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                return new RV32BufferFormat(width, height);
            }
        };
        BufferFormatCallback bufferFormatCallbackRight = new BufferFormatCallback(){

            @Override
            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                return new RV32BufferFormat(width, height);
            }
        };
        mediaPlayerComponentLeft = new DirectMediaPlayerComponent(bufferFormatCallbackLeft){

            @Override
            protected RenderCallback onGetRenderCallback() {
                return new RenderCallbackAdapterLeft();
            }

            @Override
            public void playing(MediaPlayer mediaPlayer) {
                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    Thread cursor = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            do {
                                if (System.currentTimeMillis() - Subtitles.currentTime < 40L) continue;
                                int posX = 40;
                                Subtitles.currentCursorPosition = (float)((double)Subtitles.setTime(posX) * Subtitles.zoom);
                                Subtitles.cursor.setLocation((int)((double)Subtitles.cursor.getX() + Subtitles.currentCursorPosition), Subtitles.cursor.getY());
                                Subtitles.currentTime = System.currentTimeMillis();
                                if (Math.round(mediaPlayerComponentLeft.getMediaPlayer().getTime() / 10L) * 10 - Subtitles.cursor.getX() * 10 <= 40) continue;
                                Subtitles.cursor.setLocation(Math.round(mediaPlayerComponentLeft.getMediaPlayer().getTime() / 10L), Subtitles.cursor.getY());
                            } while (mediaPlayerComponentLeft.getMediaPlayer().isPlaying());
                        }
                    });
                    cursor.start();
                }
            }

            @Override
            public void paused(MediaPlayer mediaPlayer) {
                VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
            }

            @Override
            public void stopped(MediaPlayer mediaPlayer) {
            }

            @Override
            public void finished(MediaPlayer mediaPlayer) {
            }

            @Override
            public void timeChanged(MediaPlayer mediaPlayer, long newTime) {
                VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
            }
        };
        mediaPlayerComponentRight = new DirectMediaPlayerComponent(bufferFormatCallbackRight){

            @Override
            protected RenderCallback onGetRenderCallback() {
                return new RenderCallbackAdapterRight();
            }

            @Override
            public void playing(MediaPlayer mediaPlayer) {
            }

            @Override
            public void paused(MediaPlayer mediaPlayer) {
                VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
            }

            @Override
            public void stopped(MediaPlayer mediaPlayer) {
            }

            @Override
            public void finished(MediaPlayer mediaPlayer) {
            }

            @Override
            public void timeChanged(MediaPlayer mediaPlayer, long newTime) {
                VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
            }
        };
        mediaPlayerComponentLeft.getMediaPlayer().setVolume(50);
        mediaPlayerComponentRight.getMediaPlayer().setVolume(50);
    }

    public static void addWaveform(final boolean newWaveform) {
        addWaveformIsRunning = true;
        Thread addWaveform = new Thread(new Runnable(){

            @Override
            public void run() {
                block38: {
                    if (FFMPEG.isRunning || mediaPlayerComponentLeft == null && !frame.isVisible()) {
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFMPEG.isRunning && mediaPlayerComponentLeft == null && !frame.isVisible());
                    }
                    if (!FFMPEG.isRunning && FFPROBE.hasAudio) {
                        if (newWaveform || !waveform.exists()) {
                            String border = "";
                            long size = FFPROBE.totalLength / 10;
                            String start = "";
                            String duration = "";
                            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                                if (Subtitles.waveform == null) {
                                    Subtitles.waveform = new JLabel();
                                }
                                long time = (long)((double)Subtitles.setTime(Subtitles.timelineScrollBar.getValue()) / Subtitles.zoom);
                                DecimalFormat formatter = new DecimalFormat("00");
                                DecimalFormat toMs = new DecimalFormat("000");
                                String h = formatter.format(time / 3600000L);
                                String m = formatter.format(time / 60000L % 60L);
                                String s = formatter.format(time / 1000L % 60L);
                                String f = toMs.format(time % 1000L);
                                start = " -ss " + h + ":" + m + ":" + s + "." + f;
                                duration = "atrim=duration=" + Subtitles.frame.getWidth() * 2 / 100 + ",";
                                size = (long)((double)(Subtitles.frame.getWidth() * 2 * 10) * Subtitles.zoom);
                            } else {
                                border = ",drawbox=c=0x505050";
                            }
                            if (size > 549944L) {
                                size = 549944L;
                            }
                            FFMPEG.run(String.valueOf(start) + " -i " + '\"' + Shutter.liste.firstElement() + '\"' + " -f lavfi -i color=s=" + size + "x360:c=0x323232" + border + " -filter:a aresample=8000 -filter_complex " + '\"' + "[0:a]" + duration + "aformat=channel_layouts=mono,compand,showwavespic=size=" + size + "x360:colors=green|green[w];[1:v][w]overlay" + '\"' + " -pix_fmt rgb24 -vn -frames:v 1 -y " + '\"' + waveform + '\"');
                            Shutter.enableAll();
                            if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                            } else {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                            }
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            do {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (!waveform.exists() || FFMPEG.isRunning);
                        }
                        if (Shutter.caseInAndOut.isSelected()) {
                            try {
                                try {
                                    float largeurMax = (float)VideoPlayer.frame.getSize().width / (float)VideoPlayer.frame.getSize().height;
                                    int largeur = (int)((float)VideoPlayer.frame.getSize().width / largeurMax);
                                    BufferedImage imageBMP = ImageIO.read(waveform);
                                    ImageIcon resizedWaveform = Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) ? new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance((int)((double)(Subtitles.frame.getWidth() * 2 * 10) * Subtitles.zoom), Subtitles.timeline.getHeight(), 16)) : (sliderOut.getValue() == sliderOut.getMaximum() ? (FFPROBE.audioOnly ? new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance(largeur - 12, (int)((float)(largeur - 12) / ratio), 16)) : new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance(sliderIn.getWidth(), grpIn.getHeight(), 16))) : (FFPROBE.audioOnly ? new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance(VideoPlayer.frame.getSize().width / 2 - 6, (int)((float)(VideoPlayer.frame.getSize().width / 2 - 6) / ratio), 16)) : new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance(sliderIn.getWidth(), grpIn.getHeight(), 16))));
                                    if (waveformLeft == null || waveformRight == null) {
                                        do {
                                            try {
                                                Thread.sleep(10L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                        } while (waveformLeft == null || waveformRight == null);
                                    }
                                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                                        Subtitles.waveform.setIcon(resizedWaveform);
                                        Subtitles.waveform.setBounds(Subtitles.setTime(Subtitles.timelineScrollBar.getValue()), Subtitles.waveform.getY(), (int)((double)(Subtitles.frame.getWidth() * 2 * 10) * Subtitles.zoom), Subtitles.timeline.getHeight());
                                    } else {
                                        waveformLeft.setIcon(resizedWaveform);
                                        waveformRight.setIcon(resizedWaveform);
                                    }
                                    if (FFPROBE.audioOnly) {
                                        waveformLeft.setBounds(playerLeft.getBounds());
                                        waveformRight.setBounds(playerRight.getBounds());
                                    } else {
                                        waveformLeft.setSize(sliderIn.getWidth(), grpIn.getHeight());
                                        waveformLeft.setLocation(sliderIn.getLocation());
                                        waveformRight.setSize(sliderOut.getWidth(), grpIn.getHeight());
                                        waveformRight.setLocation(sliderOut.getLocation());
                                    }
                                    panelWaveformLeft.setBounds((int)((long)VideoPlayer.waveformLeft.getSize().width * (long)sliderIn.getValue() / (long)sliderIn.getMaximum()), 0, 2, VideoPlayer.waveformLeft.getSize().height);
                                    if (sliderOut.getValue() != sliderOut.getMaximum() && panelWaveformRight != null) {
                                        panelWaveformRight.setBounds((int)((long)VideoPlayer.waveformRight.getSize().width * (long)sliderOut.getValue() / (long)sliderOut.getMaximum()), 0, 2, VideoPlayer.waveformRight.getSize().height);
                                    } else if (panelWaveformRight != null) {
                                        panelWaveformRight.setLocation(waveformRight.getWidth() - 2, VideoPlayer.panelWaveformRight.getLocation().y);
                                        sliderOut.setValue(sliderOut.getMaximum());
                                    }
                                    if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !FFPROBE.audioOnly) {
                                        sliderIn.setVisible(false);
                                        sliderOut.setVisible(false);
                                    }
                                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) break block38;
                                    waveformLeft.setVisible(true);
                                    if (!FFPROBE.audioOnly || FFPROBE.audioOnly && sliderOut.getValue() != sliderOut.getMaximum()) {
                                        waveformRight.setVisible(true);
                                        break block38;
                                    }
                                    waveformRight.setVisible(false);
                                }
                                catch (Exception e) {
                                    System.out.println(e);
                                    if (panelWaveformLeft != null) {
                                        panelWaveformLeft.repaint();
                                    }
                                    if (panelWaveformRight != null) {
                                        panelWaveformRight.repaint();
                                    }
                                    addWaveformIsRunning = false;
                                    frame.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                            finally {
                                if (panelWaveformLeft != null) {
                                    panelWaveformLeft.repaint();
                                }
                                if (panelWaveformRight != null) {
                                    panelWaveformRight.repaint();
                                }
                                addWaveformIsRunning = false;
                                frame.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                    }
                }
            }
        });
        addWaveform.start();
    }

    private void buttons() {
        this.rightPrevious = new JButton("<");
        this.rightPrevious.setFont(new Font("Montserrat", 0, 12));
        this.rightPrevious.setBounds(VideoPlayer.playerRight.getLocation().x + VideoPlayer.playerRight.getSize().width / 2 - 21 - 4, VideoPlayer.playerRight.getLocation().y + VideoPlayer.playerRight.getSize().height + 10, 22, 21);
        this.rightPrevious.setVisible(false);
        frame.getContentPane().add(this.rightPrevious);
        this.rightPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                calculOut = true;
                frameControl = true;
                if (mediaPlayerComponentRight.getMediaPlayer().getMediaState() != null) {
                    if (rightPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                        rightPlay.doClick();
                    }
                    timeOut = (long)((float)timeOut - 1000.0f / FFPROBE.currentFPS);
                    mediaPlayerComponentRight.getMediaPlayer().setTime(timeOut);
                    rightPlay.setText(Shutter.language.getProperty("btnResume"));
                    VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundOut();
                }
            }
        });
        this.rightNext = new JButton(">");
        this.rightNext.setFont(new Font("Montserrat", 0, 12));
        this.rightNext.setBounds(VideoPlayer.playerRight.getLocation().x + VideoPlayer.playerRight.getSize().width / 2 + 4, this.rightPrevious.getLocation().y, 22, 21);
        this.rightNext.setVisible(false);
        frame.getContentPane().add(this.rightNext);
        this.rightNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                calculOut = true;
                frameControl = true;
                if (mediaPlayerComponentRight.getMediaPlayer().getMediaState() != null) {
                    if (rightPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                        rightPlay.doClick();
                    }
                    timeOut = (long)((float)timeOut + 1000.0f / FFPROBE.currentFPS);
                    mediaPlayerComponentRight.getMediaPlayer().setTime(timeOut);
                    rightPlay.setText(Shutter.language.getProperty("btnResume"));
                    VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundOut();
                }
            }
        });
        rightPlay = new JButton(Shutter.language.getProperty("btnPlay"));
        rightPlay.setFont(new Font("Montserrat", 0, 12));
        rightPlay.setMargin(new Insets(0, 0, 0, 0));
        rightPlay.setBounds(this.rightPrevious.getLocation().x - 80 - 4, this.rightPrevious.getLocation().y, 80, 21);
        rightPlay.setVisible(false);
        frame.getContentPane().add(rightPlay);
        rightPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                calculOut = true;
                if (rightPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                    mediaPlayerComponentRight.getMediaPlayer().pause();
                    rightPlay.setText(Shutter.language.getProperty("btnResume"));
                } else if (rightPlay.getText().equals(Shutter.language.getProperty("btnResume"))) {
                    mediaPlayerComponentRight.getMediaPlayer().play();
                    rightPlay.setText(Shutter.language.getProperty("btnPause"));
                }
            }
        });
        rightStop = new JButton(Shutter.language.getProperty("btnCancel"));
        rightStop.setFont(new Font("Montserrat", 0, 12));
        rightStop.setMargin(new Insets(0, 0, 0, 0));
        rightStop.setBounds(this.rightNext.getLocation().x + this.rightNext.getSize().width + 4, this.rightNext.getLocation().y, 80, 21);
        rightStop.setVisible(false);
        frame.getContentPane().add(rightStop);
        rightStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (mediaPlayerComponentRight.getMediaPlayer().getMediaState() != null) {
                    if (rightPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                        rightPlay.doClick();
                    }
                    mediaPlayerComponentRight.getMediaPlayer().setTime(VideoPlayer.formatTime(FFPROBE.totalLength));
                    if (panelWaveformRight != null) {
                        panelWaveformRight.setLocation(waveformRight.getWidth() - 2, VideoPlayer.panelWaveformRight.getLocation().y);
                    }
                    sliderOut.setValue(sliderOut.getMaximum());
                }
                rightPlay.setText(Shutter.language.getProperty("btnPlay"));
                mediaPlayerComponentLeft.getMediaPlayer().stop();
                playerLeft.remove(videoSurfaceLeft);
                playerLeft.revalidate();
                playerLeft.repaint();
                mediaPlayerComponentRight.getMediaPlayer().stop();
                playerRight.remove(videoSurfaceRight);
                playerRight.revalidate();
                playerRight.repaint();
                VideoPlayer.this.resizeAll();
                VideoPlayer.this.updateVideoSurfaceLeft();
                VideoPlayer.this.updateVideoSurfaceRight();
                videoSurfaceRight.setVisible(false);
                playerRight.setVisible(false);
                if (FFPROBE.audioOnly) {
                    waveformRight.setVisible(false);
                    panelWaveformRight.setVisible(false);
                }
                VideoPlayer.this.rightPrevious.setVisible(false);
                VideoPlayer.this.rightNext.setVisible(false);
                rightPlay.setVisible(false);
                rightStop.setVisible(false);
                long temps = FFPROBE.totalLength;
                DecimalFormat formatter = new DecimalFormat("00");
                caseOutH.setText(formatter.format(temps / 1000L / 3600L));
                caseOutM.setText(formatter.format(temps / 1000L / 60L % 60L));
                caseOutS.setText(formatter.format(temps / 1000L % 60L));
                caseOutF.setText(formatter.format((int)((float)temps / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
            }
        });
        leftPrevious = new JButton("<");
        leftPrevious.setFont(new Font("Montserrat", 0, 12));
        leftPrevious.setEnabled(false);
        leftPrevious.setBounds(VideoPlayer.playerLeft.getLocation().x + VideoPlayer.playerLeft.getSize().width / 2 - 21 - 4, VideoPlayer.playerLeft.getLocation().y + VideoPlayer.playerLeft.getSize().height + 10, 22, 21);
        frame.getContentPane().add(leftPrevious);
        leftPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                calculIn = true;
                frameControl = true;
                if (mediaPlayerComponentLeft.getMediaPlayer().getMediaState() != null) {
                    if (leftPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                        leftPlay.doClick();
                    }
                    timeIn = (long)((float)timeIn - 1000.0f / FFPROBE.currentFPS);
                    mediaPlayerComponentLeft.getMediaPlayer().setTime(timeIn);
                    leftPlay.setText(Shutter.language.getProperty("btnResume"));
                }
                VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundIn();
            }
        });
        leftNext = new JButton(">");
        leftNext.setFont(new Font("Montserrat", 0, 12));
        leftNext.setEnabled(false);
        leftNext.setBounds(VideoPlayer.playerLeft.getLocation().x + VideoPlayer.playerLeft.getSize().width / 2 + 4, VideoPlayer.leftPrevious.getLocation().y, 22, 21);
        frame.getContentPane().add(leftNext);
        leftNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                calculIn = true;
                frameControl = true;
                if (mediaPlayerComponentLeft.getMediaPlayer().getMediaState() != null) {
                    if (leftPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                        leftPlay.doClick();
                    }
                    timeIn = (long)((float)timeIn + 1000.0f / FFPROBE.currentFPS);
                    mediaPlayerComponentLeft.getMediaPlayer().setTime(timeIn);
                    leftPlay.setText(Shutter.language.getProperty("btnResume"));
                    VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundIn();
                }
            }
        });
        leftPlay = new JButton(Shutter.language.getProperty("btnPlay"));
        leftPlay.setFont(new Font("Montserrat", 0, 12));
        leftPlay.setMargin(new Insets(0, 0, 0, 0));
        leftPlay.setBounds(VideoPlayer.leftPrevious.getLocation().x - 80 - 4, VideoPlayer.leftPrevious.getLocation().y, 80, 21);
        frame.getContentPane().add(leftPlay);
        leftPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                calculIn = true;
                calculOut = true;
                if (leftPlay.getText().equals(Shutter.language.getProperty("btnPlay")) && Shutter.liste.getSize() != 0) {
                    try {
                        VideoPlayer.this.addVideo();
                        caseTcInterne.setEnabled(true);
                        leftPrevious.setEnabled(true);
                        leftNext.setEnabled(true);
                    }
                    catch (Exception er) {
                        Console.consoleFFMPEG.append(String.valueOf(er.toString()) + System.lineSeparator() + System.lineSeparator());
                    }
                    Shutter.frame.setCursor(Cursor.getPredefinedCursor(3));
                    mediaPlayerComponentLeft.getMediaPlayer().setVolume(sliderVolume.getValue());
                    mediaPlayerComponentLeft.getMediaPlayer().playMedia(videoPath, new String[0]);
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException er) {
                            // empty catch block
                        }
                    } while (!mediaPlayerComponentLeft.getMediaPlayer().getMediaState().toString().equals("libvlc_NothingSpecial") && (!mediaPlayerComponentLeft.getMediaPlayer().isPlaying() || FFPROBE.isRunning));
                    caseInH.setEnabled(true);
                    caseInM.setEnabled(true);
                    caseInS.setEnabled(true);
                    caseInF.setEnabled(true);
                    Utils.changeFrameVisibility(frame, false);
                    Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                    leftPlay.setText(Shutter.language.getProperty("btnPause"));
                    sliderIn.setEnabled(true);
                    sliderOut.setEnabled(true);
                    long temps = VideoPlayer.formatTime(FFPROBE.totalLength);
                    DecimalFormat formatter = new DecimalFormat("00");
                    caseOutH.setText(formatter.format(temps / 1000L / 3600L));
                    caseOutM.setText(formatter.format(temps / 1000L / 60L % 60L));
                    caseOutS.setText(formatter.format(temps / 1000L % 60L));
                    caseOutF.setText(formatter.format((int)((float)temps / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
                    sliderIn.setMaximum((int)VideoPlayer.formatTime(FFPROBE.totalLength));
                    sliderOut.setMaximum((int)VideoPlayer.formatTime(FFPROBE.totalLength));
                    sliderOut.setValue(sliderOut.getMaximum());
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        Subtitles.timelineScrollBar.setMaximum(sliderIn.getMaximum());
                    }
                } else if (leftPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                    mediaPlayerComponentLeft.getMediaPlayer().pause();
                    leftPlay.setText(Shutter.language.getProperty("btnResume"));
                } else if (leftPlay.getText().equals(Shutter.language.getProperty("btnResume"))) {
                    mediaPlayerComponentLeft.getMediaPlayer().play();
                    leftPlay.setText(Shutter.language.getProperty("btnPause"));
                }
            }
        });
        leftStop = new JButton(Shutter.language.getProperty("btnStop"));
        leftStop.setFont(new Font("Montserrat", 0, 12));
        leftStop.setMargin(new Insets(0, 0, 0, 0));
        leftStop.setBounds(VideoPlayer.leftNext.getLocation().x + VideoPlayer.leftNext.getSize().width + 4, VideoPlayer.leftNext.getLocation().y, 80, 21);
        frame.getContentPane().add(leftStop);
        leftStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (mediaPlayerComponentLeft.getMediaPlayer().getMediaState() != null) {
                    caseInH.setEnabled(false);
                    caseInM.setEnabled(false);
                    caseInS.setEnabled(false);
                    caseInF.setEnabled(false);
                    mediaPlayerComponentLeft.getMediaPlayer().stop();
                    sliderIn.setValue(0);
                    playerLeft.remove(videoSurfaceLeft);
                    playerLeft.revalidate();
                    playerLeft.repaint();
                    mediaPlayerComponentRight.getMediaPlayer().stop();
                    sliderOut.setValue(sliderOut.getMaximum());
                    playerRight.remove(videoSurfaceRight);
                    playerRight.revalidate();
                    playerRight.repaint();
                    VideoPlayer.this.resizeAll();
                    videoSurfaceRight.setVisible(false);
                    playerRight.setVisible(false);
                    if (FFPROBE.audioOnly) {
                        waveformRight.setVisible(false);
                        panelWaveformRight.setVisible(false);
                    }
                    VideoPlayer.this.rightPrevious.setVisible(false);
                    VideoPlayer.this.rightNext.setVisible(false);
                    rightPlay.setVisible(false);
                    rightStop.setVisible(false);
                    leftPlay.setText(Shutter.language.getProperty("btnPlay"));
                    caseInH.setText("00");
                    caseInM.setText("00");
                    caseInS.setText("00");
                    caseInF.setText("00");
                    caseOutH.setText("00");
                    caseOutH.setText("00");
                    caseOutH.setText("00");
                    caseOutH.setText("00");
                    caseTcInterne.setEnabled(false);
                    caseTcInterne.setSelected(false);
                    leftPrevious.setEnabled(false);
                    leftNext.setEnabled(false);
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        Subtitles.actualSubOut = 0L;
                    }
                }
            }
        });
    }

    protected void playSoundIn() {
        if (this.casePlaySound.isSelected()) {
            boolean tcInterne = false;
            try {
                if (caseTcInterne.isSelected()) {
                    caseTcInterne.doClick();
                    tcInterne = true;
                }
                File file = new File(Shutter.liste.firstElement());
                FFMPEG.fonctionInOut();
                DecimalFormat toMs = new DecimalFormat("000");
                if (FFPLAY.isRunning) {
                    FFPLAY.process.destroy();
                }
                String Ms = caseInF.getText().equals("24") ? "000" : toMs.format((float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                FFPLAY.audioOnly("-ss " + caseInH.getText() + ":" + caseInM.getText() + ":" + caseInS.getText() + "." + Ms + " -i " + '\"' + file.toString() + '\"' + " -t 00:00:00.080 -vn -c:a pcm_s16le -af volume=" + (double)sliderVolume.getValue() / 100.0 + " -f nut pipe:play");
                if (tcInterne) {
                    caseTcInterne.doClick();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void playSoundOut() {
        if (this.casePlaySound.isSelected()) {
            boolean tcInterne = false;
            try {
                if (caseTcInterne.isSelected()) {
                    caseTcInterne.doClick();
                    tcInterne = true;
                }
                File file = new File(Shutter.liste.firstElement());
                FFMPEG.fonctionInOut();
                DecimalFormat toMs = new DecimalFormat("000");
                if (FFPLAY.isRunning) {
                    FFPLAY.process.destroy();
                }
                String Ms = caseOutF.getText().equals("24") ? "000" : toMs.format((float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                FFPLAY.audioOnly("-ss " + caseOutH.getText() + ":" + caseOutM.getText() + ":" + caseOutS.getText() + "." + Ms + " -i " + '\"' + file.toString() + '\"' + " -t 00:00:00.080 -vn -c:a pcm_s16le -af volume=" + (double)sliderVolume.getValue() / 100.0 + " -f nut pipe:play");
                if (tcInterne) {
                    caseTcInterne.doClick();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void sliders() {
        sliderIn = new JSlider();
        sliderIn.setPaintLabels(true);
        sliderIn.setValue(0);
        sliderIn.setBounds(VideoPlayer.grpIn.getLocation().x + VideoPlayer.grpIn.getSize().width + 12, VideoPlayer.grpIn.getLocation().y, VideoPlayer.frame.getSize().width - (VideoPlayer.grpIn.getLocation().x + VideoPlayer.grpIn.getSize().width + 12) - 12, 60);
        frame.getContentPane().add(sliderIn);
        sliderIn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                calculIn = true;
                if (mediaPlayerComponentLeft.getMediaPlayer().getMediaState() != null && sliderInChange) {
                    if (sliderIn.getValue() > 0) {
                        mediaPlayerComponentLeft.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderIn.getValue()));
                    } else {
                        mediaPlayerComponentLeft.getMediaPlayer().setTime(0L);
                    }
                    if (sliderIn.getValue() > sliderOut.getValue()) {
                        try {
                            sliderOut.setValue(sliderIn.getValue());
                            panelWaveformRight.setLocation((int)((long)VideoPlayer.waveformRight.getSize().width * (long)sliderOut.getValue() / (long)sliderOut.getMaximum()), 0);
                            mediaPlayerComponentRight.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderOut.getValue()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (FFPROBE.hasAudio && panelWaveformLeft != null) {
                        panelWaveformLeft.setLocation((int)((long)VideoPlayer.waveformLeft.getSize().width * (long)sliderIn.getValue() / (long)sliderIn.getMaximum()), 0);
                    }
                }
                if (leftPlay.getText().equals(Shutter.language.getProperty("btnResume"))) {
                    VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                }
            }
        });
        sliderIn.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                sliderInChange = true;
                if (leftPlay.getText().equals(Shutter.language.getProperty("btnPlay"))) {
                    leftPlay.doClick();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                sliderInChange = false;
                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && leftPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                    leftPlay.doClick();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    leftPlay.doClick();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        sliderOut = new JSlider();
        sliderOut.setPaintLabels(true);
        sliderOut.setValue(100);
        sliderOut.setBounds(VideoPlayer.grpOut.getLocation().x + VideoPlayer.grpOut.getSize().width + 12, VideoPlayer.grpOut.getLocation().y, VideoPlayer.frame.getSize().width - (VideoPlayer.grpOut.getLocation().x + VideoPlayer.grpOut.getSize().width + 12) - 12, 60);
        frame.getContentPane().add(sliderOut);
        sliderOut.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                calculOut = true;
                if (rightPlay.getText().equals(Shutter.language.getProperty("btnPlay"))) {
                    rightPlay.doClick();
                }
                if (sliderOut.getValue() != sliderOut.getMaximum()) {
                    if (leftPlay.getText().equals(Shutter.language.getProperty("btnPlay"))) {
                        leftPlay.setText(Shutter.language.getProperty("btnResume"));
                        caseInH.setEnabled(true);
                        caseInM.setEnabled(true);
                        caseInS.setEnabled(true);
                        caseInF.setEnabled(true);
                    }
                    caseOutH.setEnabled(true);
                    caseOutM.setEnabled(true);
                    caseOutS.setEnabled(true);
                    caseOutF.setEnabled(true);
                    if (sliderOutChange) {
                        VideoPlayer.this.rightPrevious.setVisible(true);
                        VideoPlayer.this.rightNext.setVisible(true);
                        rightPlay.setVisible(true);
                        rightStop.setVisible(true);
                        if (mediaPlayerComponentRight.getMediaPlayer().getTime() == -1L || mediaPlayerComponentRight.getMediaPlayer().getTime() == (long)FFPROBE.totalLength) {
                            if (mediaPlayerComponentLeft != null) {
                                mediaPlayerComponentLeft.getMediaPlayer().stop();
                                playerLeft.remove(videoSurfaceLeft);
                                playerLeft.revalidate();
                                playerLeft.repaint();
                            }
                            if (mediaPlayerComponentRight != null) {
                                mediaPlayerComponentRight.getMediaPlayer().stop();
                                playerRight.remove(videoSurfaceRight);
                                playerRight.revalidate();
                                playerRight.repaint();
                            }
                            VideoPlayer.this.resizeAll();
                            if (mediaPlayerComponentLeft != null) {
                                VideoPlayer.this.updateVideoSurfaceLeft();
                            }
                            if (mediaPlayerComponentRight != null) {
                                VideoPlayer.this.updateVideoSurfaceRight();
                            }
                        }
                        if (FFPROBE.hasAudio && waveform.exists()) {
                            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                                panelWaveformLeft.setLocation((int)((long)VideoPlayer.waveformLeft.getSize().width * (long)sliderIn.getValue() / (long)sliderIn.getMaximum()), 0);
                            } else {
                                if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && waveformRight != null) {
                                    if (!FFPROBE.audioOnly || FFPROBE.audioOnly && sliderOut.getValue() != sliderOut.getMaximum()) {
                                        waveformRight.setVisible(true);
                                    } else {
                                        waveformRight.setVisible(false);
                                    }
                                }
                                if (panelWaveformLeft != null) {
                                    panelWaveformLeft.setLocation((int)((long)VideoPlayer.waveformLeft.getSize().width * (long)sliderIn.getValue() / (long)sliderIn.getMaximum()), 0);
                                }
                                if (panelWaveformRight != null) {
                                    panelWaveformRight.setVisible(true);
                                    panelWaveformRight.setLocation((int)((long)VideoPlayer.waveformRight.getSize().width * (long)sliderOut.getValue() / (long)sliderOut.getMaximum()), 0);
                                }
                            }
                        }
                        if (!FFPROBE.audioOnly) {
                            playerRight.setVisible(true);
                        }
                        if (mediaPlayerComponentRight != null && mediaPlayerComponentRight.getMediaPlayer().getMediaState() != null && sliderOutChange) {
                            mediaPlayerComponentRight.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderOut.getValue()));
                        }
                        VideoPlayer.this.setVideoPlayersTimeOnResize();
                        if (sliderOut.getValue() < sliderIn.getValue()) {
                            try {
                                sliderIn.setValue(sliderOut.getValue());
                                panelWaveformLeft.setLocation((int)((long)VideoPlayer.waveformLeft.getSize().width * (long)sliderIn.getValue() / (long)sliderIn.getMaximum()), 0);
                                mediaPlayerComponentLeft.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderIn.getValue()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (rightPlay.getText().equals(Shutter.language.getProperty("btnResume"))) {
                        VideoPlayer.getTimeOutPoint(sliderOut.getValue());
                    }
                } else {
                    if (sliderOutChange) {
                        rightStop.doClick();
                    }
                    caseOutH.setEnabled(false);
                    caseOutM.setEnabled(false);
                    caseOutS.setEnabled(false);
                    caseOutF.setEnabled(false);
                }
            }
        });
        sliderOut.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                sliderOutChange = true;
                if (mediaPlayerComponentRight.getMediaPlayer() == null) {
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (mediaPlayerComponentRight.getMediaPlayer() == null);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                sliderOutChange = false;
                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && rightPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                    rightPlay.doClick();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    rightPlay.doClick();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        sliderVolume = new JSlider();
        sliderVolume.setName("sliderVolume");
        sliderVolume.setValue(Settings.videoPlayerVolume);
        sliderVolume.setBounds(VideoPlayer.frame.getSize().width - 12 - 111, VideoPlayer.sliderIn.getLocation().y - 33, 111, 22);
        frame.getContentPane().add(sliderVolume);
        sliderVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (mediaPlayerComponentLeft != null) {
                    mediaPlayerComponentLeft.getMediaPlayer().setVolume(sliderVolume.getValue());
                }
                if (mediaPlayerComponentRight != null) {
                    mediaPlayerComponentRight.getMediaPlayer().setVolume(sliderVolume.getValue());
                }
                Settings.videoPlayerVolume = sliderVolume.getValue();
            }
        });
        this.lblVolume = new JLabel(String.valueOf(Shutter.language.getProperty("volume")) + " ");
        this.lblVolume.setFont(new Font("FreeSans", 0, 13));
        this.lblVolume.setBounds(VideoPlayer.sliderVolume.getLocation().x - 61, VideoPlayer.sliderIn.getLocation().y - 30, 61, 16);
        frame.getContentPane().add(this.lblVolume);
        VideoPlayer.addWaveform(true);
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.topPanel.setBounds(0, 0, VideoPlayer.frame.getSize().width, 52);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(VideoPlayer.frame.getSize().width - 24, 0, 21, 21);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                block26: {
                    int reply = JOptionPane.showConfirmDialog(frame, Shutter.language.getProperty("areYouSure"), Shutter.language.getProperty("frameLecteurVideo"), 0, -1);
                    if (!this.accept || reply != 0) break block26;
                    if (waveform.exists()) {
                        waveform.delete();
                    }
                    if (FFMPEG.isRunning) {
                        FFMPEG.process.destroy();
                    }
                    Shutter.caseInAndOut.setSelected(false);
                    if (mediaPlayerComponentLeft != null) {
                        mediaPlayerComponentLeft.getMediaPlayer().stop();
                    }
                    if (mediaPlayerComponentRight != null) {
                        mediaPlayerComponentRight.getMediaPlayer().stop();
                    }
                    frame.getContentPane().removeAll();
                    Utils.changeFrameVisibility(frame, true);
                    switch (Shutter.comboFonctions.getSelectedItem().toString()) {
                        case "OGV": 
                        case "WMV": 
                        case "MPEG": 
                        case "WebM": 
                        case "Xvid": 
                        case "H.264": 
                        case "H.265": 
                        case "MJPEG": {
                            FFPROBE.CalculH264();
                        }
                    }
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        Shutter.caseInAndOut.setSelected(false);
                        Subtitles.frame.dispose();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoPlayer.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        this.fullscreen = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max2.png")));
        this.fullscreen.setHorizontalAlignment(0);
        this.fullscreen.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        this.fullscreen.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept && frame.getExtendedState() == 0) {
                    VideoPlayer.this.isFullScreen = true;
                    frame.setExtendedState(6);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (this.accept) {
                    VideoPlayer.this.isFullScreen = false;
                    frame.setExtendedState(0);
                    frame.setSize(646, 629);
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    frame.setLocation(dim.width / 2 - VideoPlayer.frame.getSize().width / 2, dim.height / 2 - VideoPlayer.frame.getSize().height / 2);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (mediaPlayerComponentLeft != null) {
                    mediaPlayerComponentLeft.getMediaPlayer().stop();
                    playerLeft.remove(videoSurfaceLeft);
                    playerLeft.revalidate();
                    playerLeft.repaint();
                }
                if (mediaPlayerComponentRight != null) {
                    mediaPlayerComponentRight.getMediaPlayer().stop();
                    playerRight.remove(videoSurfaceRight);
                    playerRight.revalidate();
                    playerRight.repaint();
                }
                if (waveform.exists()) {
                    if (waveformLeft != null && !FFPROBE.audioOnly) {
                        waveformLeft.setVisible(false);
                    }
                    if (waveformRight != null && !FFPROBE.audioOnly) {
                        waveformRight.setVisible(false);
                    }
                    sliderIn.setVisible(true);
                    if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        sliderOut.setVisible(true);
                    }
                }
                VideoPlayer.this.resizeAll();
                if (mediaPlayerComponentLeft != null) {
                    VideoPlayer.this.updateVideoSurfaceLeft();
                }
                if (mediaPlayerComponentRight != null) {
                    VideoPlayer.this.updateVideoSurfaceRight();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoPlayer.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max2.png")));
                this.accept = false;
            }
        });
        this.reduce = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce2.png")));
        this.reduce.setHorizontalAlignment(0);
        this.reduce.setBounds(this.fullscreen.getLocation().x - 21, 0, 21, 21);
        this.reduce.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    frame.setState(1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoPlayer.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce2.png")));
                this.accept = false;
            }
        });
        this.bottomImage = new JLabel();
        ImageIcon imageIcon = new ImageIcon(this.header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 16));
        this.bottomImage.setIcon(imageIcon);
        this.bottomImage.setBounds(0, 0, VideoPlayer.frame.getSize().width, 52);
        this.bottomImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
                if (down.getClickCount() == 2) {
                    if (frame.getExtendedState() == 0) {
                        frame.setExtendedState(6);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        frame.setExtendedState(0);
                        frame.setSize(646, 629);
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        frame.setLocation(dim.width / 2 - VideoPlayer.frame.getSize().width / 2, dim.height / 2 - VideoPlayer.frame.getSize().height / 2);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (mediaPlayerComponentLeft != null) {
                        mediaPlayerComponentLeft.getMediaPlayer().stop();
                        playerLeft.remove(videoSurfaceLeft);
                        playerLeft.revalidate();
                        playerLeft.repaint();
                    }
                    if (mediaPlayerComponentRight != null) {
                        mediaPlayerComponentRight.getMediaPlayer().stop();
                        playerRight.remove(videoSurfaceRight);
                        playerRight.revalidate();
                        playerRight.repaint();
                    }
                    if (waveform.exists()) {
                        if (waveformLeft != null && !FFPROBE.audioOnly) {
                            waveformLeft.setVisible(false);
                        }
                        if (waveformRight != null && !FFPROBE.audioOnly) {
                            waveformRight.setVisible(false);
                        }
                        sliderIn.setVisible(true);
                        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                            sliderOut.setVisible(true);
                        }
                    }
                    VideoPlayer.this.resizeAll();
                    if (mediaPlayerComponentLeft != null) {
                        VideoPlayer.this.updateVideoSurfaceLeft();
                    }
                    if (mediaPlayerComponentRight != null) {
                        VideoPlayer.this.updateVideoSurfaceRight();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
                frame.toFront();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.bottomImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.title.setHorizontalAlignment(0);
        this.title.setBounds(0, 0, frame.getWidth(), 52);
        this.title.setFont(new Font("Magneto", 0, 26));
        this.topPanel.add(this.title);
        this.topImage = new JLabel();
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(this.title.getBounds());
        this.topPanel.add(this.reduce);
        this.topPanel.add(this.fullscreen);
        this.topPanel.add(this.quit);
        this.topPanel.add(this.topImage);
        this.topPanel.add(this.bottomImage);
        frame.getContentPane().add(this.topPanel);
    }

    private void players() {
        float largeurMax = (float)VideoPlayer.frame.getSize().width / (float)VideoPlayer.frame.getSize().height;
        final int largeur = (int)((float)VideoPlayer.frame.getSize().width / largeurMax);
        playerLeft = new JPanel();
        playerLeft.setLayout(null);
        playerLeft.setBackground(Color.BLACK);
        if (ratio < 1.77f) {
            playerLeft.setSize((int)((float)(frame.getHeight() - 269 - 12) * ratio), frame.getHeight() - 269 - 12);
        } else {
            playerLeft.setSize(largeur - 12, (int)((float)(largeur - 12) / ratio));
        }
        playerLeft.setLocation((int)((float)(VideoPlayer.frame.getSize().width - VideoPlayer.playerLeft.getSize().width)) / 2, (int)((double)(VideoPlayer.frame.getSize().height / 2) - (double)VideoPlayer.playerLeft.getSize().height / 1.55));
        frame.getContentPane().add(playerLeft);
        playerRight = new JPanel();
        playerRight.setLayout(null);
        playerRight.setBackground(Color.BLACK);
        playerRight.setBounds(VideoPlayer.playerLeft.getLocation().x + VideoPlayer.playerLeft.getSize().width, VideoPlayer.playerLeft.getLocation().y, VideoPlayer.playerLeft.getSize().width, VideoPlayer.playerLeft.getSize().height);
        playerRight.setVisible(false);
        frame.getContentPane().add(playerRight);
        waveformLeft = new JLabel();
        waveformRight = new JLabel();
        panelWaveformLeft = new JPanel();
        panelWaveformLeft.setBackground(Color.RED);
        waveformLeft.add(panelWaveformLeft);
        waveformLeft.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (leftPlay.getText().equals(Shutter.language.getProperty("btnPlay"))) {
                    leftPlay.doClick();
                }
                if (e.getX() >= 0 && e.getX() <= waveformLeft.getWidth() - 2) {
                    sliderInChange = true;
                    panelWaveformLeft.setLocation(e.getX(), VideoPlayer.panelWaveformLeft.getLocation().y);
                    sliderIn.setValue((int)((long)sliderIn.getMaximum() * (long)VideoPlayer.panelWaveformLeft.getLocation().x / (long)VideoPlayer.waveformLeft.getSize().width));
                } else if (e.getX() < 0) {
                    sliderInChange = true;
                    panelWaveformLeft.setLocation(0, VideoPlayer.panelWaveformLeft.getLocation().y);
                    sliderIn.setValue((int)((long)sliderIn.getMaximum() * (long)VideoPlayer.panelWaveformLeft.getLocation().x / (long)VideoPlayer.waveformLeft.getSize().width));
                } else if (e.getX() <= waveformLeft.getWidth() - 2) {
                    sliderInChange = true;
                    panelWaveformLeft.setLocation(waveformLeft.getWidth() - 2, VideoPlayer.panelWaveformLeft.getLocation().y);
                    sliderIn.setValue((int)((long)sliderIn.getMaximum() * (long)VideoPlayer.panelWaveformLeft.getLocation().x / (long)VideoPlayer.waveformLeft.getSize().width));
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                sliderInChange = false;
            }
        });
        waveformLeft.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getX() >= 0 && e.getX() <= waveformLeft.getWidth() - 2) {
                    sliderInChange = true;
                    panelWaveformLeft.setLocation(e.getX(), VideoPlayer.panelWaveformLeft.getLocation().y);
                    sliderIn.setValue((int)((long)sliderIn.getMaximum() * (long)VideoPlayer.panelWaveformLeft.getLocation().x / (long)VideoPlayer.waveformLeft.getSize().width));
                } else if (e.getX() < 0) {
                    sliderInChange = true;
                    panelWaveformLeft.setLocation(0, VideoPlayer.panelWaveformLeft.getLocation().y);
                    sliderIn.setValue((int)((long)sliderIn.getMaximum() * (long)VideoPlayer.panelWaveformLeft.getLocation().x / (long)VideoPlayer.waveformLeft.getSize().width));
                } else if (e.getX() <= waveformLeft.getWidth() - 2) {
                    sliderInChange = true;
                    panelWaveformLeft.setLocation(waveformLeft.getWidth() - 2, VideoPlayer.panelWaveformLeft.getLocation().y);
                    sliderIn.setValue((int)((long)sliderIn.getMaximum() * (long)VideoPlayer.panelWaveformLeft.getLocation().x / (long)VideoPlayer.waveformLeft.getSize().width));
                }
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        panelWaveformRight = new JPanel();
        panelWaveformRight.setBackground(Color.RED);
        waveformRight.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (rightPlay.getText().equals(Shutter.language.getProperty("btnPlay"))) {
                    rightPlay.doClick();
                }
                if (e.getX() >= 0 && e.getX() <= waveformRight.getWidth() - 2) {
                    sliderOutChange = true;
                    panelWaveformRight.setLocation(e.getX(), VideoPlayer.panelWaveformRight.getLocation().y);
                    sliderOut.setValue((int)((long)sliderOut.getMaximum() * (long)VideoPlayer.panelWaveformRight.getLocation().x / (long)VideoPlayer.waveformRight.getSize().width));
                } else if (e.getX() < 0) {
                    sliderOutChange = true;
                    panelWaveformRight.setLocation(0, VideoPlayer.panelWaveformRight.getLocation().y);
                    sliderOut.setValue((int)((long)sliderOut.getMaximum() * (long)VideoPlayer.panelWaveformRight.getLocation().x / (long)VideoPlayer.waveformRight.getSize().width));
                } else if (e.getX() > waveformRight.getWidth() - 2) {
                    sliderOutChange = true;
                    panelWaveformRight.setLocation(waveformRight.getWidth() - 2, VideoPlayer.panelWaveformRight.getLocation().y);
                    sliderOut.setValue(sliderOut.getMaximum());
                }
                if (mediaPlayerComponentRight.getMediaPlayer() == null) {
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (mediaPlayerComponentRight.getMediaPlayer() == null);
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                sliderOutChange = false;
            }
        });
        waveformRight.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!leftPlay.getText().equals(Shutter.language.getProperty("btnPlay"))) {
                    if (e.getX() >= 0 && e.getX() <= waveformRight.getWidth() - 2) {
                        sliderOutChange = true;
                        panelWaveformRight.setLocation(e.getX(), VideoPlayer.panelWaveformRight.getLocation().y);
                        sliderOut.setValue((int)((long)sliderOut.getMaximum() * (long)VideoPlayer.panelWaveformRight.getLocation().x / (long)VideoPlayer.waveformRight.getSize().width));
                    } else if (e.getX() < 0) {
                        sliderOutChange = true;
                        panelWaveformRight.setLocation(0, VideoPlayer.panelWaveformRight.getLocation().y);
                        sliderOut.setValue((int)((long)sliderOut.getMaximum() * (long)VideoPlayer.panelWaveformRight.getLocation().x / (long)VideoPlayer.waveformRight.getSize().width));
                    } else if (e.getX() > waveformRight.getWidth() - 2) {
                        sliderOutChange = true;
                        panelWaveformRight.setLocation(waveformRight.getWidth() - 2, VideoPlayer.panelWaveformRight.getLocation().y);
                        sliderOut.setValue(sliderOut.getMaximum());
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        if (FFPROBE.hasAudio || !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
            Thread addWaveform = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        do {
                            Thread.sleep(10L);
                        } while (!waveform.exists());
                        if (waveform.exists()) {
                            BufferedImage imageBMP = ImageIO.read(waveform);
                            ImageIcon resizedWaveform = Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) ? new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance(largeur - 12, (int)((float)(largeur - 12) / 12.0f), 16)) : (FFPROBE.audioOnly ? new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance(largeur - 12, (int)((float)(largeur - 12) / ratio), 16)) : new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance(sliderIn.getWidth(), grpIn.getHeight(), 16)));
                            waveformLeft.setIcon(resizedWaveform);
                            waveformRight.setIcon(resizedWaveform);
                            if (FFPROBE.audioOnly) {
                                waveformLeft.setBounds(playerLeft.getBounds());
                                waveformRight.setBounds(playerRight.getBounds());
                            } else {
                                waveformLeft.setSize(sliderIn.getWidth(), grpIn.getHeight());
                                waveformLeft.setLocation(sliderIn.getLocation());
                                waveformRight.setSize(sliderOut.getWidth(), grpIn.getHeight());
                                waveformRight.setLocation(sliderOut.getLocation());
                            }
                            frame.getContentPane().add(waveformLeft);
                            frame.getContentPane().add(waveformRight);
                            frame.getContentPane().repaint();
                            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                                waveformLeft.setVisible(false);
                                waveformRight.setVisible(false);
                            }
                            if (sliderOut.getValue() == sliderOut.getMaximum()) {
                                panelWaveformRight.setBounds(VideoPlayer.waveformRight.getSize().width - 2, 0, 2, VideoPlayer.waveformRight.getSize().height);
                            } else {
                                panelWaveformRight.setBounds((int)((long)VideoPlayer.waveformRight.getSize().width * (long)sliderOut.getValue() / (long)sliderOut.getMaximum()), 0, 2, VideoPlayer.waveformRight.getSize().height);
                            }
                            waveformRight.add(panelWaveformRight);
                            if (FFPROBE.audioOnly) {
                                playerLeft.setVisible(false);
                                waveformRight.setVisible(false);
                                panelWaveformRight.setVisible(false);
                            } else {
                                playerLeft.setVisible(true);
                            }
                            panelWaveformLeft.repaint();
                            panelWaveformRight.repaint();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            addWaveform.start();
        }
        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void grpIn() {
        grpIn = new JPanel();
        grpIn.setLayout(null);
        grpIn.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(80, 80, 80), 1), String.valueOf(Shutter.language.getProperty("grpIn")) + " ", 0, 0, new Font("Montserrat", 0, 12), Color.WHITE));
        grpIn.setBackground(new Color(50, 50, 50));
        grpIn.setBounds(6, VideoPlayer.frame.getSize().height - 147, 156, 52);
        frame.getContentPane().add(grpIn);
        caseInH = new JTextField();
        caseInH.setName("caseInH");
        caseInH.setText("00");
        caseInH.setHorizontalAlignment(0);
        caseInH.setFont(new Font("FreeSans", 0, 14));
        caseInH.setColumns(10);
        caseInH.setBounds(6, 17, 36, 26);
        grpIn.add(caseInH);
        caseInM = new JTextField();
        caseInM.setName("caseInM");
        caseInM.setText("00");
        caseInM.setHorizontalAlignment(0);
        caseInM.setFont(new Font("FreeSans", 0, 14));
        caseInM.setColumns(10);
        caseInM.setBounds(42, 17, 36, 26);
        grpIn.add(caseInM);
        caseInS = new JTextField();
        caseInS.setName("caseInS");
        caseInS.setText("00");
        caseInS.setHorizontalAlignment(0);
        caseInS.setFont(new Font("FreeSans", 0, 14));
        caseInS.setColumns(10);
        caseInS.setBounds(78, 17, 36, 26);
        grpIn.add(caseInS);
        caseInF = new JTextField();
        caseInF.setName("caseInF");
        caseInF.setText("00");
        caseInF.setHorizontalAlignment(0);
        caseInF.setFont(new Font("FreeSans", 0, 14));
        caseInF.setColumns(10);
        caseInF.setBounds(114, 17, 36, 26);
        grpIn.add(caseInF);
        this.casePlaySound = new JRadioButton(Shutter.language.getProperty("casePlaySound"));
        this.casePlaySound.setBounds(14, VideoPlayer.grpIn.getLocation().y - 36, 195, 23);
        this.casePlaySound.setFont(new Font("FreeSans", 0, 12));
        this.casePlaySound.setSelected(false);
        frame.getContentPane().add(this.casePlaySound);
        caseTcInterne = new JRadioButton(Shutter.language.getProperty("caseTcInterne"));
        caseTcInterne.setEnabled(false);
        caseTcInterne.setFont(new Font("FreeSans", 0, 12));
        caseTcInterne.setBounds(14, frame.getHeight() - 31, 195, 23);
        if (FFPROBE.audioOnly || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
            caseTcInterne.setVisible(false);
        } else {
            caseTcInterne.setVisible(true);
        }
        frame.getContentPane().add(caseTcInterne);
        comboMode.setName("comboMode");
        comboMode.setFont(new Font("FreeSans", 0, 11));
        comboMode.setMaximumRowCount(20);
        comboMode.setSize(76, 22);
        comboMode.setLocation(frame.getWidth() - comboMode.getWidth() - 12, VideoPlayer.frame.getSize().height - 16 - 12 - 1);
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
            frame.getContentPane().add(comboMode);
        }
        comboMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode")) && showInfoMessage) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("mayNotWorkWithGOP"), String.valueOf(Shutter.language.getProperty("mode")) + " " + Shutter.language.getProperty("removeMode"), 1);
                    showInfoMessage = false;
                }
                VideoPlayer.totalDuration();
            }
        });
        lblMode = new JLabel(Shutter.language.getProperty("mode"));
        lblMode.setHorizontalAlignment(4);
        lblMode.setFont(new Font("FreeSans", 0, 13));
        lblMode.setBounds(comboMode.getX() - VideoPlayer.lblMode.getPreferredSize().width - 4, VideoPlayer.frame.getSize().height - 16 - 12 + 2, VideoPlayer.lblMode.getPreferredSize().width, 16);
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
            frame.getContentPane().add(lblMode);
        }
        caseTcInterne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseTcInterne.isSelected()) {
                    FFPROBE.Data(videoPath);
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (FFPROBE.isRunning);
                    if (FFPROBE.timecode1 != "") {
                        offset = Integer.valueOf(FFPROBE.timecode1) * 3600000 + Integer.valueOf(FFPROBE.timecode2) * 60000 + Integer.valueOf(FFPROBE.timecode3) * 1000 + Integer.valueOf(FFPROBE.timecode4) * (int)(1000.0f / FFPROBE.currentFPS);
                    }
                } else {
                    offset = 0;
                }
                DecimalFormat formatter = new DecimalFormat("00");
                long tempsIn = mediaPlayerComponentLeft.getMediaPlayer().getTime();
                if ((float)tempsIn % (1000.0f / FFPROBE.currentFPS) != 0.0f) {
                    tempsIn = (long)((float)tempsIn + 1000.0f / FFPROBE.currentFPS);
                }
                caseInH.setText(formatter.format((tempsIn += (long)offset) / 3600000L));
                caseInM.setText(formatter.format(tempsIn / 60000L % 60L));
                caseInS.setText(formatter.format(tempsIn / 1000L % 60L));
                caseInF.setText(formatter.format((int)((float)tempsIn / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
                long tempOut = mediaPlayerComponentLeft.getMediaPlayer().getTime();
                if ((float)tempOut % (1000.0f / FFPROBE.currentFPS) != 0.0f) {
                    tempOut = (long)((float)tempOut + 1000.0f / FFPROBE.currentFPS);
                }
                tempOut += (long)offset;
                tempOut = sliderOut.getValue() < sliderOut.getMaximum() ? mediaPlayerComponentRight.getMediaPlayer().getTime() : (long)FFPROBE.totalLength;
                caseOutH.setText(formatter.format((tempOut += (long)offset) / 3600000L));
                caseOutM.setText(formatter.format(tempOut / 60000L % 60L));
                caseOutS.setText(formatter.format(tempOut / 1000L % 60L));
                caseOutF.setText(formatter.format((int)((float)tempOut / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
            }
        });
        caseInH.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInH.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInH.setText(String.valueOf(Integer.parseInt(caseInH.getText()) + 1));
                        if (caseInH.getText().length() == 1) {
                            caseInH.setText("0" + caseInH.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInH.setText(String.valueOf(Integer.parseInt(caseInH.getText()) - 1));
                        if (caseInH.getText().length() == 1) {
                            caseInH.setText("0" + caseInH.getText());
                        }
                    }
                }
                if (caseInH.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInH.getText().length() == 1) {
                        caseInH.setText("0" + caseInH.getText());
                    }
                    calculIn = true;
                    timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                    mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                    VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundIn();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInH.getText().length() >= 2) {
                    caseInH.setText("");
                }
            }
        });
        caseInH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInH.getText().length() == 1) {
                    caseInH.setText("0" + caseInH.getText());
                }
                calculIn = true;
                timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundIn();
            }
        });
        caseInM.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInM.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInM.setText(String.valueOf(Integer.parseInt(caseInM.getText()) + 1));
                        if (caseInM.getText().length() == 1) {
                            caseInM.setText("0" + caseInM.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInM.setText(String.valueOf(Integer.parseInt(caseInM.getText()) - 1));
                        if (caseInM.getText().length() == 1) {
                            caseInM.setText("0" + caseInM.getText());
                        }
                    }
                }
                if (caseInM.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInM.getText().length() == 1) {
                        caseInM.setText("0" + caseInM.getText());
                    }
                    calculIn = true;
                    timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                    mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                    VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundIn();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInM.getText().length() >= 2) {
                    caseInM.setText("");
                }
            }
        });
        caseInM.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInM.getText().length() == 1) {
                    caseInM.setText("0" + caseInM.getText());
                }
                calculIn = true;
                timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundIn();
            }
        });
        caseInS.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInS.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInS.setText(String.valueOf(Integer.parseInt(caseInS.getText()) + 1));
                        if (caseInS.getText().length() == 1) {
                            caseInS.setText("0" + caseInS.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInS.setText(String.valueOf(Integer.parseInt(caseInS.getText()) - 1));
                        if (caseInS.getText().length() == 1) {
                            caseInS.setText("0" + caseInS.getText());
                        }
                    }
                }
                if (caseInS.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInS.getText().length() == 1) {
                        caseInS.setText("0" + caseInS.getText());
                    }
                    calculIn = true;
                    timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                    mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                    VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundIn();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInS.getText().length() >= 2) {
                    caseInS.setText("");
                }
            }
        });
        caseInS.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInS.getText().length() == 1) {
                    caseInS.setText("0" + caseInS.getText());
                }
                calculIn = true;
                timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundIn();
            }
        });
        caseInF.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInF.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInF.setText(String.valueOf(Integer.parseInt(caseInF.getText()) + 1));
                        if (caseInF.getText().length() == 1) {
                            caseInF.setText("0" + caseInF.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInF.setText(String.valueOf(Integer.parseInt(caseInF.getText()) - 1));
                        if (caseInF.getText().length() == 1) {
                            caseInF.setText("0" + caseInF.getText());
                        }
                    }
                }
                if (caseInF.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInF.getText().length() == 1) {
                        caseInF.setText("0" + caseInF.getText());
                    }
                    calculIn = true;
                    timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                    mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                    VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundIn();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInF.getText().length() >= 2) {
                    caseInF.setText("");
                }
            }
        });
        caseInF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInF.getText().length() == 1) {
                    caseInF.setText("0" + caseInF.getText());
                }
                calculIn = true;
                timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundIn();
            }
        });
    }

    private void grpOut() {
        grpOut = new JPanel();
        grpOut.setLayout(null);
        grpOut.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(80, 80, 80), 1), String.valueOf(Shutter.language.getProperty("grpOut")) + " ", 0, 0, new Font("Montserrat", 0, 12), Color.WHITE));
        grpOut.setBackground(new Color(50, 50, 50));
        grpOut.setBounds(6, VideoPlayer.frame.getSize().height - 86, 156, 52);
        frame.getContentPane().add(grpOut);
        caseOutH = new JTextField();
        caseOutH.setName("caseOutH");
        caseOutH.setText("00");
        caseOutH.setEnabled(false);
        caseOutH.setHorizontalAlignment(0);
        caseOutH.setFont(new Font("FreeSans", 0, 14));
        caseOutH.setColumns(10);
        caseOutH.setBounds(6, 17, 36, 26);
        grpOut.add(caseOutH);
        caseOutM = new JTextField();
        caseOutM.setName("caseOutM");
        caseOutM.setText("00");
        caseOutM.setEnabled(false);
        caseOutM.setHorizontalAlignment(0);
        caseOutM.setFont(new Font("FreeSans", 0, 14));
        caseOutM.setColumns(10);
        caseOutM.setBounds(42, 17, 36, 26);
        grpOut.add(caseOutM);
        caseOutS = new JTextField();
        caseOutS.setName("caseOutS");
        caseOutS.setText("00");
        caseOutS.setEnabled(false);
        caseOutS.setHorizontalAlignment(0);
        caseOutS.setFont(new Font("FreeSans", 0, 14));
        caseOutS.setColumns(10);
        caseOutS.setBounds(78, 17, 36, 26);
        grpOut.add(caseOutS);
        caseOutF = new JTextField();
        caseOutF.setName("caseOutF");
        caseOutF.setText("00");
        caseOutF.setEnabled(false);
        caseOutF.setHorizontalAlignment(0);
        caseOutF.setFont(new Font("FreeSans", 0, 14));
        caseOutF.setColumns(10);
        caseOutF.setBounds(114, 17, 36, 26);
        grpOut.add(caseOutF);
        caseOutH.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutH.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutH.setText(String.valueOf(Integer.parseInt(caseOutH.getText()) + 1));
                        if (caseOutH.getText().length() == 1) {
                            caseOutH.setText("0" + caseOutH.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutH.setText(String.valueOf(Integer.parseInt(caseOutH.getText()) - 1));
                        if (caseOutH.getText().length() == 1) {
                            caseOutH.setText("0" + caseOutH.getText());
                        }
                    }
                }
                if (caseOutH.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutH.getText().length() == 1) {
                        caseOutH.setText("0" + caseOutH.getText());
                    }
                    calculOut = true;
                    timeOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)((int)(1000.0f / FFPROBE.currentFPS)) - (long)offset;
                    mediaPlayerComponentRight.getMediaPlayer().setTime((long)((float)timeOut - FFPROBE.currentFPS / 1000.0f));
                    VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundOut();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutH.getText().length() >= 2) {
                    caseOutH.setText("");
                }
            }
        });
        caseOutH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutH.getText().length() == 1) {
                    caseOutH.setText("0" + caseOutH.getText());
                }
                calculOut = true;
                timeOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)((int)(1000.0f / FFPROBE.currentFPS)) - (long)offset;
                mediaPlayerComponentRight.getMediaPlayer().setTime((long)((float)timeOut - FFPROBE.currentFPS / 1000.0f));
                VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundOut();
            }
        });
        caseOutM.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutM.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutM.setText(String.valueOf(Integer.parseInt(caseOutM.getText()) + 1));
                        if (caseOutM.getText().length() == 1) {
                            caseOutM.setText("0" + caseOutM.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutM.setText(String.valueOf(Integer.parseInt(caseOutM.getText()) - 1));
                        if (caseOutM.getText().length() == 1) {
                            caseOutM.setText("0" + caseOutM.getText());
                        }
                    }
                }
                if (caseOutM.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutM.getText().length() == 1) {
                        caseOutM.setText("0" + caseOutM.getText());
                    }
                    calculOut = true;
                    timeOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)((int)(1000.0f / FFPROBE.currentFPS)) - (long)offset;
                    mediaPlayerComponentRight.getMediaPlayer().setTime((long)((float)timeOut - FFPROBE.currentFPS / 1000.0f));
                    VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundOut();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutM.getText().length() >= 2) {
                    caseOutM.setText("");
                }
            }
        });
        caseOutM.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutM.getText().length() == 1) {
                    caseOutM.setText("0" + caseOutM.getText());
                }
                calculOut = true;
                timeOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)((int)(1000.0f / FFPROBE.currentFPS)) - (long)offset;
                mediaPlayerComponentRight.getMediaPlayer().setTime((long)((float)timeOut - FFPROBE.currentFPS / 1000.0f));
                VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundOut();
            }
        });
        caseOutS.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutS.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutS.setText(String.valueOf(Integer.parseInt(caseOutS.getText()) + 1));
                        if (caseOutS.getText().length() == 1) {
                            caseOutS.setText("0" + caseOutS.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutS.setText(String.valueOf(Integer.parseInt(caseOutS.getText()) - 1));
                        if (caseOutS.getText().length() == 1) {
                            caseOutS.setText("0" + caseOutS.getText());
                        }
                    }
                }
                if (caseOutS.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutS.getText().length() == 1) {
                        caseOutS.setText("0" + caseOutS.getText());
                    }
                    calculOut = true;
                    timeOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)((int)(1000.0f / FFPROBE.currentFPS)) - (long)offset;
                    mediaPlayerComponentRight.getMediaPlayer().setTime((long)((float)timeOut - FFPROBE.currentFPS / 1000.0f));
                    VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundOut();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutS.getText().length() >= 2) {
                    caseOutS.setText("");
                }
            }
        });
        caseOutS.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutS.getText().length() == 1) {
                    caseOutS.setText("0" + caseOutS.getText());
                }
                calculOut = true;
                timeOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)((int)(1000.0f / FFPROBE.currentFPS)) - (long)offset;
                mediaPlayerComponentRight.getMediaPlayer().setTime((long)((float)timeOut - FFPROBE.currentFPS / 1000.0f));
                VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundOut();
            }
        });
        caseOutF.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutF.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutF.setText(String.valueOf(Integer.parseInt(caseOutF.getText()) + 1));
                        if (caseOutF.getText().length() == 1) {
                            caseOutF.setText("0" + caseOutF.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutF.setText(String.valueOf(Integer.parseInt(caseOutF.getText()) - 1));
                        if (caseOutF.getText().length() == 1) {
                            caseOutF.setText("0" + caseOutF.getText());
                        }
                    }
                }
                if (caseOutF.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutF.getText().length() == 1) {
                        caseOutF.setText("0" + caseOutF.getText());
                    }
                    calculOut = true;
                    timeOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)((int)(1000.0f / FFPROBE.currentFPS)) - (long)offset;
                    mediaPlayerComponentRight.getMediaPlayer().setTime((long)((float)timeOut - FFPROBE.currentFPS / 1000.0f));
                    VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                    VideoPlayer.this.playSoundOut();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutF.getText().length() >= 2) {
                    caseOutF.setText("");
                }
            }
        });
        caseOutF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutF.getText().length() == 1) {
                    caseOutF.setText("0" + caseOutF.getText());
                }
                calculOut = true;
                timeOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)((int)(1000.0f / FFPROBE.currentFPS)) - (long)offset;
                mediaPlayerComponentRight.getMediaPlayer().setTime((long)((float)timeOut - FFPROBE.currentFPS / 1000.0f));
                VideoPlayer.getTimeOutPoint(mediaPlayerComponentRight.getMediaPlayer().getTime());
                VideoPlayer.this.playSoundOut();
            }
        });
    }

    private void resizeAll() {
        this.topPanel.setBounds(0, 0, VideoPlayer.frame.getSize().width, 52);
        this.topImage.setLocation(VideoPlayer.frame.getSize().width / 2 - this.topImage.getSize().width / 2, 0);
        this.quit.setBounds(VideoPlayer.frame.getSize().width - 24, 0, 21, 21);
        this.fullscreen.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        this.reduce.setBounds(this.fullscreen.getLocation().x - 21, 0, 21, 21);
        ImageIcon imageIcon = new ImageIcon(this.header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 16));
        this.bottomImage.setIcon(imageIcon);
        this.bottomImage.setBounds(0, 0, VideoPlayer.frame.getSize().width, 52);
        this.btnCaptureIn.setBounds(8, this.topPanel.getSize().height + 10, 130, 21);
        this.btnPreview.setBounds(VideoPlayer.frame.getSize().width - 6 - 130 - 4, this.topPanel.getSize().height + 10, 130, 21);
        lblVideo.setBounds(this.btnCaptureIn.getLocation().x + this.btnCaptureIn.getSize().width + 6, this.topPanel.getSize().height + 12, VideoPlayer.frame.getSize().width - (this.btnCaptureIn.getLocation().x + this.btnCaptureIn.getSize().width + 6 + this.btnPreview.getSize().width + 12), 16);
        grpIn.setBounds(6, VideoPlayer.frame.getSize().height - 147, 156, 52);
        grpOut.setBounds(6, VideoPlayer.frame.getSize().height - 86, 156, 52);
        this.casePlaySound.setBounds(14, VideoPlayer.grpIn.getLocation().y - 36, 195, 23);
        caseTcInterne.setBounds(14, frame.getHeight() - 31, 195, 23);
        comboMode.setLocation(frame.getWidth() - comboMode.getWidth() - 12, VideoPlayer.frame.getSize().height - 16 - 12 - 1);
        lblMode.setBounds(comboMode.getX() - VideoPlayer.lblMode.getPreferredSize().width - 4, VideoPlayer.frame.getSize().height - 16 - 12 + 2, VideoPlayer.lblMode.getPreferredSize().width, 16);
        sliderIn.setBounds(VideoPlayer.grpIn.getLocation().x + VideoPlayer.grpIn.getSize().width + 12, VideoPlayer.grpIn.getLocation().y, VideoPlayer.frame.getSize().width - (VideoPlayer.grpIn.getLocation().x + VideoPlayer.grpIn.getSize().width + 12) - 12, 60);
        sliderOut.setBounds(VideoPlayer.grpOut.getLocation().x + VideoPlayer.grpOut.getSize().width + 12, VideoPlayer.grpOut.getLocation().y, VideoPlayer.frame.getSize().width - (VideoPlayer.grpOut.getLocation().x + VideoPlayer.grpOut.getSize().width + 12) - 12, 60);
        sliderVolume.setBounds(VideoPlayer.frame.getSize().width - 12 - 111, VideoPlayer.sliderIn.getLocation().y - 33, 111, 22);
        this.lblVolume.setBounds(VideoPlayer.sliderVolume.getLocation().x - 61, VideoPlayer.sliderIn.getLocation().y - 30, 61, 16);
        if (sliderOut.getValue() == sliderOut.getMaximum()) {
            float largeurMax = (float)VideoPlayer.frame.getSize().width / (float)VideoPlayer.frame.getSize().height;
            int largeur = (int)((float)VideoPlayer.frame.getSize().width / largeurMax);
            if (ratio < 1.77f) {
                playerLeft.setSize((int)((float)(frame.getHeight() - 269 - 12) * ratio), frame.getHeight() - 269 - 12);
                playerLeft.setLocation((int)((float)(VideoPlayer.frame.getSize().width - VideoPlayer.playerLeft.getSize().width)) / 2, playerLeft.getY());
            } else {
                playerLeft.setSize(largeur - 12, (int)((float)(largeur - 12) / ratio));
                playerLeft.setLocation((int)((float)(VideoPlayer.frame.getSize().width - VideoPlayer.playerLeft.getSize().width)) / 2, (int)((double)(VideoPlayer.frame.getSize().height / 2) - (double)VideoPlayer.playerLeft.getSize().height / 1.55));
            }
        } else {
            float largeurMax = (float)VideoPlayer.frame.getSize().width / (float)VideoPlayer.frame.getSize().height;
            int positionY = (int)((double)VideoPlayer.frame.getSize().height / (2.5 + (double)largeurMax));
            if (ratio < 1.77f) {
                playerLeft.setSize((int)((float)(frame.getHeight() - 269 - 12) * ratio), frame.getHeight() - 269 - 12);
                playerLeft.setLocation(VideoPlayer.frame.getSize().width / 2 - playerLeft.getWidth(), playerLeft.getY());
            } else {
                playerLeft.setBounds(6, positionY, VideoPlayer.frame.getSize().width / 2 - 6, (int)((float)(VideoPlayer.frame.getSize().width / 2 - 6) / ratio));
            }
        }
        playerRight.setBounds(VideoPlayer.playerLeft.getLocation().x + VideoPlayer.playerLeft.getSize().width, VideoPlayer.playerLeft.getLocation().y, VideoPlayer.playerLeft.getSize().width, VideoPlayer.playerLeft.getSize().height);
        this.rightPrevious.setBounds(VideoPlayer.playerRight.getLocation().x + VideoPlayer.playerRight.getSize().width / 2 - 21 - 4, VideoPlayer.playerRight.getLocation().y + VideoPlayer.playerRight.getSize().height + 10, 22, 21);
        this.rightNext.setBounds(VideoPlayer.playerRight.getLocation().x + VideoPlayer.playerRight.getSize().width / 2 + 4, this.rightPrevious.getLocation().y, 22, 21);
        rightPlay.setBounds(this.rightPrevious.getLocation().x - 80 - 4, this.rightPrevious.getLocation().y, 80, 21);
        rightStop.setBounds(this.rightNext.getLocation().x + this.rightNext.getSize().width + 4, this.rightNext.getLocation().y, 80, 21);
        leftPrevious.setBounds(VideoPlayer.playerLeft.getLocation().x + VideoPlayer.playerLeft.getSize().width / 2 - 21 - 4, VideoPlayer.playerLeft.getLocation().y + VideoPlayer.playerLeft.getSize().height + 10, 22, 21);
        leftNext.setBounds(VideoPlayer.playerLeft.getLocation().x + VideoPlayer.playerLeft.getSize().width / 2 + 4, VideoPlayer.leftPrevious.getLocation().y, 22, 21);
        leftPlay.setBounds(VideoPlayer.leftPrevious.getLocation().x - 80 - 4, VideoPlayer.leftPrevious.getLocation().y, 80, 21);
        leftStop.setBounds(VideoPlayer.leftNext.getLocation().x + VideoPlayer.leftNext.getSize().width + 4, VideoPlayer.leftNext.getLocation().y, 80, 21);
        lblDuree.setBounds(0, VideoPlayer.frame.getSize().height - 16 - 12, frame.getWidth(), 16);
        width = VideoPlayer.playerLeft.getSize().width;
        height = VideoPlayer.playerLeft.getSize().height;
        this.title.setBounds(0, 0, frame.getWidth(), 52);
        if (!drag) {
            VideoPlayer.addWaveform(false);
        }
    }

    public static void totalDuration() {
        block29: {
            try {
                long totalIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long totalOut = (long)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long sommeTotal = totalOut - totalIn;
                if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode"))) {
                    sommeTotal = (long)FFPROBE.totalLength - sommeTotal;
                }
                dureeHeures = (int)(sommeTotal / 3600000L);
                dureeMinutes = (int)(sommeTotal / 60000L % 60L);
                dureeSecondes = (int)(sommeTotal / 1000L % 60L);
                dureeImages = (int)((float)sommeTotal / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS);
                lblDuree.setText(String.valueOf(Shutter.language.getProperty("lblDuree")) + " " + dureeHeures + "h " + dureeMinutes + "min " + dureeSecondes + "sec " + dureeImages + "i" + " | " + Shutter.language.getProperty("lblTotalFrames") + " " + (int)((float)sommeTotal / (1000.0f / FFPROBE.currentFPS)));
                if (sommeTotal <= 0L) {
                    lblDuree.setVisible(false);
                    break block29;
                }
                lblDuree.setVisible(true);
                switch (Shutter.comboFonctions.getSelectedItem().toString()) {
                    case "AV1": 
                    case "OGV": 
                    case "VP9": 
                    case "WMV": 
                    case "MPEG": 
                    case "Xvid": 
                    case "H.264": 
                    case "H.265": 
                    case "MJPEG": 
                    case "Blu-ray": {
                        DecimalFormat formatter = new DecimalFormat("00");
                        int secondes = (int)(sommeTotal / 1000L % 60L);
                        int minutes = (int)(sommeTotal / 1000L / 60L % 60L);
                        int heures = (int)(sommeTotal / 1000L / 3600L);
                        Shutter.textH.setText(formatter.format(heures));
                        Shutter.textMin.setText(formatter.format(minutes));
                        Shutter.textSec.setText(formatter.format(secondes));
                        FFPROBE.setTailleH264();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static long formatTime(long value) {
        if (FFPROBE.isRunning) {
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (FFPROBE.isRunning);
        }
        float framerate = 1000.0f / FFPROBE.currentFPS;
        long frameToMs = (long)((float)value / framerate % FFPROBE.currentFPS * framerate);
        long time = (long)(Math.round(value / 1000L) * 1000) + frameToMs;
        return time;
    }

    private void updateVideoSurfaceLeft() {
        this.addVideo();
        mediaPlayerComponentLeft.getMediaPlayer().playMedia(videoPath, new String[0]);
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!mediaPlayerComponentLeft.getMediaPlayer().isPlaying());
        mediaPlayerComponentLeft.getMediaPlayer().pause();
        mediaPlayerComponentLeft.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderIn.getValue()));
        playerLeft.repaint();
        videoSurfaceLeft.repaint();
        if (leftPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
            mediaPlayerComponentLeft.getMediaPlayer().play();
        }
    }

    private void updateVideoSurfaceRight() {
        if (!rightPlay.getText().equals(Shutter.language.getProperty("btnPlay"))) {
            mediaPlayerComponentRight.getMediaPlayer().playMedia(videoPath, new String[0]);
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!mediaPlayerComponentRight.getMediaPlayer().isPlaying());
            mediaPlayerComponentRight.getMediaPlayer().pause();
            mediaPlayerComponentRight.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderOut.getValue()));
            playerRight.repaint();
            videoSurfaceRight.repaint();
            if (rightPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                mediaPlayerComponentRight.getMediaPlayer().play();
            }
        }
    }

    protected void setVideoPlayersTimeOnResize() {
        if (mediaPlayerComponentLeft.getMediaPlayer().getMediaState() == null) {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            mediaPlayerComponentLeft.getMediaPlayer().playMedia(videoPath, new String[0]);
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!mediaPlayerComponentLeft.getMediaPlayer().isPlaying());
            mediaPlayerComponentLeft.getMediaPlayer().pause();
            mediaPlayerComponentLeft.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderIn.getValue()));
            leftPlay.setText(Shutter.language.getProperty("btnResume"));
            videoSurfaceLeft.setVisible(true);
            playerLeft.repaint();
            videoSurfaceLeft.repaint();
            frame.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (mediaPlayerComponentRight.getMediaPlayer().getMediaState() == null && sliderOut.getValue() != sliderOut.getMaximum()) {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            mediaPlayerComponentRight.getMediaPlayer().playMedia(videoPath, new String[0]);
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!mediaPlayerComponentRight.getMediaPlayer().isPlaying());
            mediaPlayerComponentRight.getMediaPlayer().pause();
            mediaPlayerComponentRight.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderOut.getValue()));
            rightPlay.setText(Shutter.language.getProperty("btnResume"));
            videoSurfaceRight.setVisible(true);
            playerRight.repaint();
            videoSurfaceRight.repaint();
            frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static void getTimeInPoint(long temps) {
        if ((float)temps % (1000.0f / FFPROBE.currentFPS) != 0.0f) {
            temps = (long)((float)temps + 1000.0f / FFPROBE.currentFPS);
        }
        if (caseTcInterne.isSelected()) {
            temps += (long)offset;
        }
        if (mediaPlayerComponentLeft.getMediaPlayer().getMediaState() != null && calculIn && temps < (long)FFPROBE.totalLength) {
            mediaPlayerComponentLeft.getMediaPlayer().setVolume(sliderVolume.getValue());
            if (mediaPlayerComponentLeft.getMediaPlayer().getTime() >= mediaPlayerComponentRight.getMediaPlayer().getTime() && sliderOut.getValue() != sliderOut.getMaximum() && mediaPlayerComponentLeft.getMediaPlayer().isPlaying()) {
                mediaPlayerComponentLeft.getMediaPlayer().setTime(0L);
            }
            DecimalFormat formatter = new DecimalFormat("00");
            caseInH.setText(formatter.format(temps / 3600000L));
            caseInM.setText(formatter.format(temps / 60000L % 60L));
            caseInS.setText(formatter.format(temps / 1000L % 60L));
            caseInF.setText(formatter.format((int)((float)temps / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
            if (sliderIn.getValue() == 0) {
                caseInF.setText("00");
            }
            if (!(sliderOutChange || sliderInChange || drag)) {
                sliderIn.setValue((int)VideoPlayer.formatTime(mediaPlayerComponentLeft.getMediaPlayer().getTime()));
                if (FFPROBE.hasAudio && panelWaveformLeft != null) {
                    panelWaveformLeft.setLocation((int)((long)VideoPlayer.waveformLeft.getSize().width * (long)sliderIn.getValue() / (long)sliderIn.getMaximum()), 0);
                }
                if (sliderIn.getValue() > sliderOut.getValue()) {
                    sliderInChange = true;
                    try {
                        sliderOut.setValue(sliderIn.getValue());
                        panelWaveformRight.setLocation((int)((long)VideoPlayer.waveformRight.getSize().width * (long)sliderOut.getValue() / (long)sliderOut.getMaximum()), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sliderInChange = false;
                }
            }
            if (leftPlay.getText().equals(Shutter.language.getProperty("btnResume"))) {
                timeIn = VideoPlayer.formatTime(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                calculIn = false;
                if (!frameControl && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    mediaPlayerComponentLeft.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderIn.getValue()));
                }
                frameControl = false;
            }
            VideoPlayer.totalDuration();
        }
    }

    private static void getTimeOutPoint(long temps) {
        temps = (float)temps % (1000.0f / FFPROBE.currentFPS) != 0.0f ? (long)((float)temps + 1000.0f / FFPROBE.currentFPS * 2.0f) : (long)((float)temps + 1000.0f / FFPROBE.currentFPS);
        if (caseTcInterne.isSelected()) {
            temps += (long)offset;
        }
        if (temps >= (long)FFPROBE.totalLength) {
            sliderOutChange = true;
            sliderOut.setValue(sliderOut.getMaximum());
            sliderOutChange = false;
        }
        if (mediaPlayerComponentRight.getMediaPlayer().getMediaState() != null && calculOut && mediaPlayerComponentRight.getMediaPlayer().getTime() != -1L) {
            mediaPlayerComponentRight.getMediaPlayer().setVolume(sliderVolume.getValue());
            if (mediaPlayerComponentRight.getMediaPlayer().getTime() >= (long)FFPROBE.totalLength && mediaPlayerComponentRight.getMediaPlayer().isPlaying()) {
                mediaPlayerComponentRight.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderIn.getValue()));
            }
            DecimalFormat formatter = new DecimalFormat("00");
            caseOutH.setText(formatter.format(temps / 3600000L));
            caseOutM.setText(formatter.format(temps / 60000L % 60L));
            caseOutS.setText(formatter.format(temps / 1000L % 60L));
            caseOutF.setText(formatter.format((int)((float)temps / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
            if (!(sliderInChange || sliderOutChange || drag)) {
                sliderOut.setValue((int)VideoPlayer.formatTime(mediaPlayerComponentRight.getMediaPlayer().getTime()));
                if (FFPROBE.hasAudio && panelWaveformRight != null) {
                    panelWaveformRight.setLocation((int)((long)VideoPlayer.waveformRight.getSize().width * (long)sliderOut.getValue() / (long)sliderOut.getMaximum()), 0);
                }
                if (sliderOut.getValue() < sliderIn.getValue()) {
                    sliderOutChange = true;
                    try {
                        sliderIn.setValue(sliderOut.getValue());
                        panelWaveformLeft.setLocation((int)((long)VideoPlayer.waveformLeft.getSize().width * (long)sliderIn.getValue() / (long)sliderIn.getMaximum()), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sliderOutChange = false;
                }
            }
            if (rightPlay.getText().equals(Shutter.language.getProperty("btnResume"))) {
                timeOut = VideoPlayer.formatTime(mediaPlayerComponentRight.getMediaPlayer().getTime());
                calculOut = false;
                if (!frameControl) {
                    mediaPlayerComponentRight.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderOut.getValue()));
                }
                frameControl = false;
            }
            VideoPlayer.totalDuration();
        }
    }

    public static void loadSettings(final File encFile) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Component p;
                    int n;
                    int n2;
                    Component[] componentArray;
                    Component c;
                    int n3;
                    int n4;
                    Component[] componentArray2;
                    Element eElement;
                    Node nNode;
                    do {
                        Thread.sleep(10L);
                    } while (leftPlay == null);
                    do {
                        Thread.sleep(10L);
                    } while (leftPlay.getText().equals(Shutter.language.getProperty("btnPlay")));
                    leftPlay.doClick();
                    boolean changeInPoint = false;
                    boolean changeOutPoint = false;
                    File fXmlFile = encFile;
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(fXmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("Component");
                    int temp = 0;
                    while (temp < nList.getLength()) {
                        nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            eElement = (Element)nNode;
                            componentArray2 = frame.getContentPane().getComponents();
                            n4 = componentArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                c = componentArray2[n3];
                                if (c instanceof JPanel) {
                                    componentArray = ((JPanel)c).getComponents();
                                    n2 = componentArray.length;
                                    n = 0;
                                    while (n < n2) {
                                        p = componentArray[n];
                                        if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                            if (p.getName().contains("caseIn")) {
                                                changeInPoint = true;
                                            }
                                            if (p.getName().contains("caseOut")) {
                                                changeOutPoint = true;
                                            }
                                            do {
                                                Thread.sleep(10L);
                                            } while (mediaPlayerComponentLeft.getMediaPlayer().isPlaying());
                                            if (p instanceof JTextField) {
                                                ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                                ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                                ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                            }
                                        }
                                        ++n;
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++temp;
                    }
                    if (changeInPoint) {
                        calculIn = true;
                        timeIn = (long)((float)(Integer.parseInt(caseInH.getText()) * 3600000 + Integer.parseInt(caseInM.getText()) * 60000 + Integer.parseInt(caseInS.getText()) * 1000) + (float)Integer.parseInt(caseInF.getText()) * (1000.0f / FFPROBE.currentFPS)) - (long)offset;
                        mediaPlayerComponentLeft.getMediaPlayer().setTime((long)((float)timeIn - FFPROBE.currentFPS / 1000.0f));
                        VideoPlayer.getTimeInPoint(mediaPlayerComponentLeft.getMediaPlayer().getTime());
                    }
                    if (changeOutPoint) {
                        sliderOutChange = true;
                        sliderOut.setValue((int)((float)(Integer.parseInt(caseOutH.getText()) * 3600000 + Integer.parseInt(caseOutM.getText()) * 60000 + Integer.parseInt(caseOutS.getText()) * 1000) + (float)Integer.parseInt(caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS) - (float)((int)((double)(1000.0f / FFPROBE.currentFPS) * 1.5)) - (float)offset));
                        sliderOutChange = false;
                        mediaPlayerComponentRight.getMediaPlayer().setTime(VideoPlayer.formatTime(sliderOut.getValue()));
                    }
                    temp = 0;
                    while (temp < nList.getLength()) {
                        nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            eElement = (Element)nNode;
                            componentArray2 = frame.getContentPane().getComponents();
                            n4 = componentArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                c = componentArray2[n3];
                                if (c instanceof JPanel) {
                                    componentArray = ((JPanel)c).getComponents();
                                    n2 = componentArray.length;
                                    n = 0;
                                    while (n < n2) {
                                        p = componentArray[n];
                                        if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                            do {
                                                Thread.sleep(10L);
                                            } while (mediaPlayerComponentLeft.getMediaPlayer().isPlaying());
                                            if (p instanceof JTextField) {
                                                ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                                ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                                ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                            }
                                        }
                                        ++n;
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++temp;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }

    private class RenderCallbackAdapterLeft
    extends RenderCallbackAdapter {
        private RenderCallbackAdapterLeft() {
            super(new int[width * height]);
        }

        @Override
        protected void onDisplay(DirectMediaPlayer mediaPlayer, int[] rgbBuffer) {
            imageLeft.setRGB(0, 0, width, height, rgbBuffer, 0, width);
            videoSurfaceLeft.repaint();
        }
    }

    private class RenderCallbackAdapterRight
    extends RenderCallbackAdapter {
        private RenderCallbackAdapterRight() {
            super(new int[width * height]);
        }

        @Override
        protected void onDisplay(DirectMediaPlayer mediaPlayer, int[] rgbBuffer) {
            imageRight.setRGB(0, 0, width, height, rgbBuffer, 0, width);
            videoSurfaceRight.repaint();
        }
    }

    private class VideoSurfacePanelLeft
    extends JPanel {
        private VideoSurfacePanelLeft() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(imageLeft, null, 0, 0);
            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                Subtitles.refreshData();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                String[] text = Subtitles.txtSubtitles.getText().replace("<i>", "").replace("</i>", "").replace("<b>", "").replace("</b>", "").split("\\r?\\n");
                if (Subtitles.txtSubtitles.getText().contains("<i>") && Subtitles.txtSubtitles.getText().contains("<b>")) {
                    g2.setFont(new Font("SansSerif", 3, (int)Math.floor(height / 16)));
                } else if (Subtitles.txtSubtitles.getText().contains("<i>")) {
                    g2.setFont(new Font("SansSerif", 2, (int)Math.floor(height / 16)));
                } else if (Subtitles.txtSubtitles.getText().contains("<b>")) {
                    g2.setFont(new Font("SansSerif", 1, (int)Math.floor(height / 16)));
                } else {
                    g2.setFont(new Font("SansSerif", 0, (int)Math.floor(height / 16)));
                }
                FontMetrics metrics = g.getFontMetrics(g2.getFont());
                int x = videoSurfaceLeft.getX() + (videoSurfaceLeft.getWidth() - metrics.stringWidth(text[0])) / 2;
                int y = height - height / 24;
                if (text.length > 1 && text[1].length() > 0) {
                    y = height - (int)((double)height / 9.5);
                    g2.setColor(Color.BLACK);
                    g2.drawString(text[0], this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                    g2.drawString(text[0], this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                    g2.drawString(text[0], this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                    g2.drawString(text[0], this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                    g2.setColor(Color.WHITE);
                    g2.drawString(text[0], x, y);
                    x = videoSurfaceLeft.getX() + (videoSurfaceLeft.getWidth() - metrics.stringWidth(text[1])) / 2;
                    y = height - height / 24;
                    g2.setColor(Color.BLACK);
                    g2.drawString(text[1], this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                    g2.drawString(text[1], this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                    g2.drawString(text[1], this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                    g2.drawString(text[1], this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                    g2.setColor(Color.WHITE);
                    g2.drawString(text[1], x, y);
                } else if (text[0].length() > 0) {
                    g2.setColor(Color.BLACK);
                    g2.drawString(text[0], this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                    g2.drawString(text[0], this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                    g2.drawString(text[0], this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                    g2.drawString(text[0], this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                    g2.setColor(Color.WHITE);
                    g2.drawString(text[0], x, y);
                }
            }
        }

        int ShiftNorth(int p, int distance) {
            return p - distance;
        }

        int ShiftSouth(int p, int distance) {
            return p + distance;
        }

        int ShiftEast(int p, int distance) {
            return p + distance;
        }

        int ShiftWest(int p, int distance) {
            return p - distance;
        }
    }

    private class VideoSurfacePanelRight
    extends JPanel {
        private VideoSurfacePanelRight() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(imageRight, null, 0, 0);
        }
    }
}

