/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class Update {
    public static JDialog frame;
    private static final JProgressBar progressBar;
    private final JLabel lblNewVersion = new JLabel(Shutter.language.getProperty("lblNewVersion"));
    private static JPanel topPanel;
    private static JLabel quit;
    private static boolean cancelled;

    static {
        progressBar = new JProgressBar();
        cancelled = false;
    }

    private Update() {
        frame = new JDialog();
        frame.setFont(new Font("Montserrat", 0, 12));
        frame.setResizable(false);
        frame.setModal(false);
        frame.setAlwaysOnTop(true);
        frame.setDefaultCloseOperation(2);
        frame.setSize(346, 59);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setTitle(Shutter.language.getProperty("frameUpdate"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            frame.setShape(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth() + 15, frame.getHeight(), 15.0, 15.0));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        }
        this.content();
        GraphicsConfiguration config = Shutter.frame.getGraphicsConfiguration();
        GraphicsDevice myScreen = config.getDevice();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allScreens = env.getScreenDevices();
        int screenIndex = -1;
        int i = 0;
        while (i < allScreens.length) {
            if (allScreens[i].equals(myScreen)) {
                screenIndex = i;
                break;
            }
            ++i;
        }
        if (System.getProperty("os.name").contains("Windows")) {
            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDefaultConfiguration().getBounds().width - Update.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().height - 99);
        } else {
            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDisplayMode().getWidth() - Update.frame.getSize().width, allScreens[screenIndex].getDisplayMode().getHeight() - 99);
        }
        frame.setVisible(true);
    }

    private void content() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBackground(new Color(50, 50, 50));
        quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        quit.setHorizontalAlignment(0);
        quit.setBounds(Update.frame.getSize().width - 24, 0, 21, 21);
        topPanel.add(quit);
        topPanel.setBounds(0, 0, 346, 59);
        quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    cancelled = true;
                    frame.dispose();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        progressBar.setBounds(6, 29, 334, 23);
        topPanel.add(progressBar);
        this.lblNewVersion.setFont(new Font("Montserrat", 0, 12));
        this.lblNewVersion.setBounds(6, 11, 295, 16);
        topPanel.add(this.lblNewVersion);
        topPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        topPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(Update.frame.getLocation().x, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        frame.getContentPane().add(topPanel);
    }

    public static void newVersion() {
        cancelled = false;
        try {
            JLabel news = new JLabel(Shutter.language.getProperty("wantToDownload"));
            try {
                Document changelog = Jsoup.connect("https://www.shutterencoder.com/changelog.txt").get();
                changelog.outputSettings().prettyPrint(false);
                String[] versions = changelog.select("body").toString().split("Version");
                news = new JLabel("<html>Version" + versions[1].replace(System.lineSeparator(), "<br>") + Shutter.language.getProperty("wantToDownload") + "</html>");
            }
            catch (Exception changelog) {
                // empty catch block
            }
            Document doc = Jsoup.connect("https://www.shutterencoder.com").get();
            for (Element file : doc.select("a")) {
                int q;
                String[] s2;
                int newVersion;
                if (System.getProperty("os.name").contains("Windows")) {
                    try {
                        if (!file.attr("href").contains("Shutter Encoder (PC Version") || (newVersion = Integer.parseInt((s2 = file.attr("href").substring(file.attr("href").lastIndexOf(" ") + 1).split("\\)"))[0].replace(".", ""))) <= Integer.parseInt(Shutter.actualVersion.replace(".", "")) || (q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[0] + ")", 0, 3)) != 0) continue;
                        Update.runProcess(file.attr("href"));
                        new Update();
                    }
                    catch (Exception s2) {}
                    continue;
                }
                if (System.getProperty("os.name").contains("Mac")) {
                    try {
                        if (!file.attr("href").contains("Shutter Encoder (MAC Version") || (newVersion = Integer.parseInt((s2 = file.attr("href").substring(file.attr("href").lastIndexOf(" ") + 1).split("\\)"))[0].replace(".", ""))) <= Integer.parseInt(Shutter.actualVersion.replace(".", "")) || (q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[0] + ")", 0, 3)) != 0) continue;
                        Update.runProcess(file.attr("href"));
                        new Update();
                    }
                    catch (Exception s3) {}
                    continue;
                }
                try {
                    if (!file.attr("href").contains("Shutter Encoder (Linux Version") || (newVersion = Integer.parseInt((s2 = file.attr("href").substring(file.attr("href").lastIndexOf(" ") + 1).split("\\)"))[0].replace(".", ""))) <= Integer.parseInt(Shutter.actualVersion.replace(".", "")) || (q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[0] + ")", 0, 3)) != 0) continue;
                    Desktop.getDesktop().browse(new URI("https://www.shutterencoder.com/en/#downloads"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void runProcess(final String newVersion) {
        Thread download = new Thread(new Runnable(){

            @Override
            public void run() {
                Update.HTTPDownload("https://www.shutterencoder.com/" + newVersion, String.valueOf(System.getProperty("user.home")) + "/Desktop/" + newVersion);
                if (!cancelled) {
                    int q = JOptionPane.showConfirmDialog(Shutter.frame, Shutter.language.getProperty("installNewVersion"), Shutter.language.getProperty("downloadEnded"), 0, 3);
                    if (q == 0) {
                        try {
                            Desktop.getDesktop().open(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop/" + newVersion));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        System.exit(0);
                    } else {
                        JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("newVersionOnDesktop"), Shutter.language.getProperty("downloadEnded"), 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("downloadStopped"), Shutter.language.getProperty("downloadCancelled"), 0);
                    File toDelete = new File(String.valueOf(System.getProperty("user.home")) + "/Desktop/" + newVersion);
                    toDelete.delete();
                }
            }
        });
        download.start();
    }

    private static void HTTPDownload(String adresse, String destination) {
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        try {
            try {
                int numRead;
                URL url = new URL(adresse);
                out = new BufferedOutputStream(new FileOutputStream(destination));
                conn = url.openConnection();
                in = conn.getInputStream();
                byte[] buffer = new byte[1024];
                progressBar.setMaximum(conn.getContentLength());
                long numWritten = 0L;
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    progressBar.setValue((int)(numWritten += (long)numRead));
                    if (!cancelled) continue;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("downloadFailed"), Shutter.language.getProperty("downloadError"), 0);
                try {
                    File toDelete = new File(destination);
                    toDelete.delete();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static class MousePosition {
        static int mouseY;

        private MousePosition() {
        }
    }
}

