/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.Functions;
import application.RenderQueue;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import library.FFMPEG;
import library.FFPROBE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubtitlesWindow {
    public static JDialog frame;
    private static JPanel image;
    private JLabel quit;
    private JPanel topPanel;
    private JLabel topImage;
    private JButton btnOK;
    public static int ImageWidth;
    public static int ImageHeight;
    public static int finalWidth;
    public static int finalHeight;
    public static int containerWidth;
    public static int containerHeight;
    private static JPanel panelColor;
    private static JPanel panelColor2;
    public static Color fontColor;
    public static Color backgroundColor;
    public static String hex;
    public static String hex2;
    public static String alpha;
    public static JComboBox<String> comboFont;
    public static JButton btnI;
    public static JButton btnG;
    public static JSlider positionVideo;
    public static JSpinner spinnerSize;
    public static JSpinner spinnerOpacity;
    public static JSpinner spinnerSubtitle;
    public static JSpinner spinnerSubtitlesPosition;
    public static JTextField textWidth;
    public static JLabel lblBackground;
    public static String subtitlesFile;

    static {
        image = new JPanel();
        containerWidth = 640;
        containerHeight = 360;
        panelColor = new JPanel();
        panelColor2 = new JPanel();
        hex = "FFFFFF";
        hex2 = "000000";
        alpha = "7F";
        positionVideo = new JSlider();
        spinnerSubtitle = new JSpinner();
        spinnerSubtitlesPosition = new JSpinner(new SpinnerNumberModel((Number)0, null, null, (Number)-1));
        textWidth = new JTextField();
    }

    public SubtitlesWindow() {
        frame = new JDialog();
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameAddSubtitles"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(665, 500);
        frame.setResizable(false);
        if (Functions.frame != null && Functions.frame.isVisible()) {
            frame.setModal(false);
        } else {
            frame.setModal(true);
        }
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - SubtitlesWindow.frame.getSize().width / 2, dim.height / 2 - SubtitlesWindow.frame.getSize().height / 2);
        }
        this.topPanel();
        this.boutons();
        image.setLayout(null);
        image.setOpaque(false);
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(SubtitlesWindow.frame.getSize().width - 24, 0, 21, 21);
        this.topPanel.add(this.quit);
        this.topPanel.setBounds(0, 0, 1000, 52);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SubtitlesWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                    Shutter.caseSubtitles.setSelected(false);
                    Utils.changeDialogVisibility(frame, true);
                    Shutter.frame.setOpacity(1.0f);
                    Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SubtitlesWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SubtitlesWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        JLabel title = new JLabel(Shutter.language.getProperty("frameAddSubtitles"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 52);
        title.setFont(new Font("Magneto", 0, 26));
        this.topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.topPanel.add(this.topImage);
        this.topPanel.setBounds(0, 0, 1000, 52);
        frame.getContentPane().add(this.topPanel);
        image.setBounds(12, 58, 640, 360);
        frame.getContentPane().add(image);
        this.topImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.topImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void boutons() {
        JLabel lblFont = new JLabel(Shutter.language.getProperty("lblFont"));
        lblFont.setAlignmentX(4.0f);
        lblFont.setFont(new Font("FreeSans", 0, 13));
        lblFont.setBounds(12, 435, lblFont.getPreferredSize().width, 16);
        frame.getContentPane().add(lblFont);
        final String[] Fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        comboFont = new JComboBox<String>(Fonts);
        comboFont.setName("comboFont");
        comboFont.setSelectedItem("Arial");
        comboFont.setFont(new Font("Arial", 0, 11));
        comboFont.setRenderer(new ComboRenderer(comboFont));
        comboFont.setEditable(true);
        comboFont.setBounds(65, 431, 120, 22);
        frame.getContentPane().add(comboFont);
        comboFont.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){
            String text = "";

            @Override
            public void keyReleased(KeyEvent e) {
                if (comboFont.getEditor().toString().length() <= 1) {
                    this.text = String.valueOf(e.getKeyChar());
                }
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    comboFont.setModel(new DefaultComboBoxModel<String>(Fonts));
                    this.text = String.valueOf(this.text) + e.getKeyChar();
                    ArrayList<String> newList = new ArrayList<String>();
                    int i = 0;
                    while (i < comboFont.getItemCount()) {
                        if (Fonts[i].toString().length() >= this.text.length() && Fonts[i].toString().toLowerCase().substring(0, this.text.length()).contains(this.text) && !Fonts[i].toString().contains(":")) {
                            newList.add(Fonts[i].toString());
                        }
                        ++i;
                    }
                    comboFont.getEditor().setItem(this.text);
                    if (!newList.isEmpty()) {
                        comboFont.setModel(new DefaultComboBoxModel<Object>(newList.toArray()));
                        comboFont.showPopup();
                    }
                } else if (e.getKeyCode() == 8 || e.getKeyCode() == 27) {
                    comboFont.setModel(new DefaultComboBoxModel<String>(Fonts));
                    comboFont.getEditor().setItem("");
                    comboFont.hidePopup();
                    this.text = "";
                } else if (e.getKeyCode() == 40) {
                    e.consume();
                } else {
                    comboFont.hidePopup();
                }
            }
        });
        comboFont.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                comboFont.setFont(new Font(comboFont.getSelectedItem().toString(), 0, 11));
                SubtitlesWindow.sliderChange(false);
            }
        });
        btnG = new JButton(Shutter.language.getProperty("btnG"));
        btnG.setFont(new Font("Montserrat", 0, 13));
        btnG.setForeground(Color.BLACK);
        btnG.setName("btnG");
        btnG.setBounds(SubtitlesWindow.comboFont.getLocation().x + comboFont.getWidth() + 4, 431, 22, 22);
        frame.getContentPane().add(btnG);
        btnG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (btnG.getForeground() == Color.BLACK) {
                    btnG.setForeground(Utils.themeColor);
                } else {
                    btnG.setForeground(Color.BLACK);
                }
                SubtitlesWindow.sliderChange(false);
            }
        });
        btnI = new JButton("I");
        btnI.setFont(new Font("Courier New", 2, 13));
        btnI.setForeground(Color.BLACK);
        btnI.setName("btnI");
        btnI.setBounds(SubtitlesWindow.btnG.getLocation().x + btnG.getWidth() + 2, 431, 22, 22);
        frame.getContentPane().add(btnI);
        btnI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (btnI.getForeground() == Color.BLACK) {
                    btnI.setForeground(Utils.themeColor);
                } else {
                    btnI.setForeground(Color.BLACK);
                }
                SubtitlesWindow.sliderChange(false);
            }
        });
        JLabel lblSubtitlesPosition = new JLabel(Shutter.language.getProperty("lblSubtitlesPosition"));
        lblSubtitlesPosition.setAlignmentX(4.0f);
        lblSubtitlesPosition.setFont(new Font("FreeSans", 0, 13));
        lblSubtitlesPosition.setBounds(SubtitlesWindow.btnI.getLocation().x + btnI.getWidth() + 6, 434, lblSubtitlesPosition.getPreferredSize().width, 16);
        frame.getContentPane().add(lblSubtitlesPosition);
        spinnerSubtitlesPosition.setName("spinnerSubtitlesPosition");
        spinnerSubtitlesPosition.setFont(new Font("FreeSans", 0, 11));
        spinnerSubtitlesPosition.setValue(0);
        spinnerSubtitlesPosition.setBounds(lblSubtitlesPosition.getLocation().x + lblSubtitlesPosition.getWidth() + 5, lblSubtitlesPosition.getLocation().y - 3, 58, 22);
        frame.getContentPane().add(spinnerSubtitlesPosition);
        spinnerSubtitlesPosition.addChangeListener(new ChangeListener(){
            String[] s = FFPROBE.imageResolution.split("x");
            int h;
            int alphaHeight = this.h = Integer.parseInt(this.s[1]);

            @Override
            public void stateChanged(ChangeEvent arg0) {
                int v = Integer.parseInt(spinnerSubtitlesPosition.getValue().toString());
                int sz = Integer.parseInt(spinnerSize.getValue().toString());
                spinnerSize.setValue(Math.round((float)sz * ((float)this.alphaHeight / (float)(this.h + v))));
                SubtitlesWindow.changeSubtitle();
                this.alphaHeight = this.h + v;
            }
        });
        JLabel lblWidth = new JLabel(Shutter.language.getProperty("lblWidth"));
        lblWidth.setFont(new Font("FreeSans", 0, 13));
        lblWidth.setAlignmentX(4.0f);
        lblWidth.setBounds(SubtitlesWindow.spinnerSubtitlesPosition.getLocation().x + spinnerSubtitlesPosition.getWidth() + 9, 434, lblWidth.getPreferredSize().width, 16);
        frame.getContentPane().add(lblWidth);
        textWidth.setText(String.valueOf(ImageWidth));
        textWidth.setName("textWidth");
        textWidth.setBounds(lblWidth.getX() + lblWidth.getWidth() + 5, lblWidth.getLocation().y, 34, 16);
        textWidth.setHorizontalAlignment(4);
        textWidth.setFont(new Font("FreeSans", 0, 12));
        frame.getContentPane().add(textWidth);
        textWidth.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textWidth.getText().length() > 0 && e.getKeyCode() == 10) {
                    SubtitlesWindow.sliderChange(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textWidth.getText().length() >= 4) {
                    textWidth.setText("");
                }
            }
        });
        textWidth.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textWidth.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textWidth.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textWidth.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseSubSize.mouseX = e.getX();
                MouseSubSize.offsetX = Integer.parseInt(textWidth.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SubtitlesWindow.sliderChange(false);
            }
        });
        textWidth.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textWidth.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textWidth.setText(String.valueOf(MouseSubSize.offsetX + (e.getX() - MouseSubSize.mouseX)));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel lblsubtitleNumber = new JLabel(Shutter.language.getProperty("lblsubtitleNumber"));
        lblsubtitleNumber.setAlignmentX(4.0f);
        lblsubtitleNumber.setFont(new Font("FreeSans", 0, 13));
        lblsubtitleNumber.setBounds(SubtitlesWindow.textWidth.getLocation().x + textWidth.getWidth() + 9, 434, lblsubtitleNumber.getPreferredSize().width, 16);
        frame.getContentPane().add(lblsubtitleNumber);
        spinnerSubtitle.setFont(new Font("FreeSans", 0, 11));
        spinnerSubtitle.setValue(1);
        spinnerSubtitle.setBounds(lblsubtitleNumber.getLocation().x + lblsubtitleNumber.getWidth() + 5, lblsubtitleNumber.getLocation().y - 3, 50, 22);
        frame.getContentPane().add(spinnerSubtitle);
        spinnerSubtitle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if ((Integer)spinnerSubtitle.getValue() < 1) {
                    spinnerSubtitle.setValue(1);
                } else {
                    SubtitlesWindow.changeSubtitle();
                }
            }
        });
        positionVideo.setFont(new Font("FreeSans", 0, 11));
        positionVideo.setBounds(SubtitlesWindow.spinnerSubtitle.getLocation().x + spinnerSubtitle.getWidth() + 9, SubtitlesWindow.comboFont.getLocation().y, frame.getWidth() - (SubtitlesWindow.spinnerSubtitle.getLocation().x + spinnerSubtitle.getWidth() + 7) - 12, 22);
        frame.getContentPane().add(positionVideo);
        positionVideo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SubtitlesWindow.sliderChange(false);
            }
        });
        JLabel lblColor = new JLabel(Shutter.language.getProperty("lblColor"));
        lblColor.setAlignmentX(4.0f);
        lblColor.setFont(new Font("FreeSans", 0, 13));
        lblColor.setBounds(12, 470, lblColor.getPreferredSize().width + 4, 16);
        frame.getContentPane().add(lblColor);
        panelColor = new JPanel();
        panelColor.setName("panelColor");
        panelColor.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        panelColor.setBackground(Color.WHITE);
        panelColor.setBounds(lblColor.getLocation().x + 62, lblColor.getLocation().y - 7, 41, 29);
        frame.getContentPane().add(panelColor);
        panelColor.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                fontColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), Color.WHITE);
                if (fontColor != null) {
                    panelColor.setBackground(fontColor);
                    SubtitlesWindow.sliderChange(false);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JLabel lblSize = new JLabel(Shutter.language.getProperty("lblSize"));
        lblSize.setFont(new Font("FreeSans", 0, 13));
        lblSize.setAlignmentX(4.0f);
        lblSize.setBounds(lblColor.getLocation().x + 113, lblColor.getLocation().y, lblSize.getPreferredSize().width, 16);
        frame.getContentPane().add(lblSize);
        spinnerSize = new JSpinner(new SpinnerNumberModel(18, 1, 999, 1));
        spinnerSize.setName("spinnerSize");
        spinnerSize.setFont(new Font("FreeSans", 0, 11));
        spinnerSize.setBounds(SubtitlesWindow.panelColor.getLocation().x + 99, lblColor.getLocation().y - 3, 50, 22);
        frame.getContentPane().add(spinnerSize);
        spinnerSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                SubtitlesWindow.sliderChange(false);
            }
        });
        JLabel lblColor2 = new JLabel(Shutter.language.getProperty("lblColor"));
        lblColor2.setAlignmentX(4.0f);
        lblColor2.setFont(new Font("FreeSans", 0, 13));
        lblColor2.setBounds(SubtitlesWindow.spinnerSize.getLocation().x + spinnerSize.getWidth() + 92, 470, lblColor2.getPreferredSize().width + 4, 16);
        frame.getContentPane().add(lblColor2);
        panelColor2 = new JPanel();
        panelColor2.setName("panelColor2");
        panelColor2.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        panelColor2.setBackground(Color.BLACK);
        panelColor2.setBounds(lblColor2.getLocation().x + 62, lblColor2.getLocation().y - 7, 41, 29);
        frame.getContentPane().add(panelColor2);
        panelColor2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                backgroundColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), Color.WHITE);
                if (backgroundColor != null) {
                    panelColor2.setBackground(backgroundColor);
                    SubtitlesWindow.sliderChange(false);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JLabel lblOpacity = new JLabel(Shutter.language.getProperty("lblOpacity"));
        lblOpacity.setFont(new Font("FreeSans", 0, 13));
        lblOpacity.setAlignmentX(4.0f);
        lblOpacity.setBounds(lblColor2.getLocation().x + 113, lblColor2.getLocation().y, lblOpacity.getPreferredSize().width, 16);
        frame.getContentPane().add(lblOpacity);
        spinnerOpacity = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
        spinnerOpacity.setName("spinnerOpacity");
        spinnerOpacity.setFont(new Font("FreeSans", 0, 11));
        spinnerOpacity.setBounds(lblOpacity.getLocation().x + lblOpacity.getWidth() + 11, lblColor2.getLocation().y - 3, 54, 22);
        frame.getContentPane().add(spinnerOpacity);
        spinnerOpacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                SubtitlesWindow.sliderChange(false);
            }
        });
        lblBackground = new JLabel(Shutter.language.getProperty("lblBackgroundOff"));
        lblBackground.setName("lblBackground");
        lblBackground.setBackground(new Color(80, 80, 80));
        lblBackground.setHorizontalAlignment(0);
        lblBackground.setOpaque(true);
        lblBackground.setFont(new Font("Montserrat", 0, 11));
        lblBackground.setBounds(SubtitlesWindow.spinnerSize.getLocation().x + spinnerSize.getWidth() + 11, SubtitlesWindow.spinnerSize.getLocation().y + 3, 70, 16);
        frame.getContentPane().add(lblBackground);
        lblBackground.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOff"))) {
                    lblBackground.setText(Shutter.language.getProperty("lblBackgroundOn"));
                    spinnerOpacity.setValue(50);
                } else {
                    lblBackground.setText(Shutter.language.getProperty("lblBackgroundOff"));
                    spinnerOpacity.setValue(100);
                }
                SubtitlesWindow.changeSubtitle();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.btnOK = new JButton("OK");
        this.btnOK.setFont(new Font("Montserrat", 0, 12));
        this.btnOK.setBounds(SubtitlesWindow.spinnerOpacity.getLocation().x + spinnerOpacity.getWidth() + 13, 468, frame.getWidth() - (SubtitlesWindow.spinnerOpacity.getLocation().x + spinnerOpacity.getWidth() + 7) - 20, 21);
        frame.getContentPane().add(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                try {
                    String line;
                    BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(subtitlesFile.toString(), new String[0]), StandardCharsets.UTF_8);
                    BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(Shutter.subtitlesFile.toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                    while ((line = bufferedReader.readLine()) != null) {
                        if (!(line.contains("-->") || line.matches("[0-9]+") || line.isEmpty())) {
                            if (line.contains("1") && line.length() == 2) {
                                bufferedWriter.write("1");
                            } else if (lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                                bufferedWriter.write(" \\h" + line + " \\h");
                            } else {
                                bufferedWriter.write(line);
                            }
                            bufferedWriter.newLine();
                            continue;
                        }
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                    }
                    bufferedReader.close();
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Utils.changeDialogVisibility(frame, true);
                Shutter.frame.setOpacity(1.0f);
                Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                if (Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("chooseFunction"), Shutter.language.getProperty("subtitles"), 1);
                }
            }
        });
        SubtitlesWindow.sliderChange(true);
    }

    public static void changeSubtitle() {
        try {
            String line;
            BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(subtitlesFile.toString(), new String[0]), StandardCharsets.UTF_8);
            BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(Shutter.subtitlesFile.toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
            boolean start = false;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.matches("[0-9]+") && line.equals(spinnerSubtitle.getValue().toString())) {
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                    start = true;
                }
                if (!start) continue;
                if (line.contains("-->")) {
                    bufferedWriter.write("00:00:00,000 --> 10:00:00,000");
                    bufferedWriter.newLine();
                    String[] split = line.split("-->");
                    String[] inTimecode = split[0].replace(",", ":").replace(" ", "").split(":");
                    String[] outTimecode = split[1].replace(",", ":").replace(" ", "").split(":");
                    int inH = Integer.parseInt(inTimecode[0]) * 3600000;
                    int inM = Integer.parseInt(inTimecode[1]) * 60000;
                    int inS = Integer.parseInt(inTimecode[2]) * 1000;
                    int inF = Integer.parseInt(inTimecode[3]);
                    int outH = Integer.parseInt(outTimecode[0]) * 3600000;
                    int outM = Integer.parseInt(outTimecode[1]) * 60000;
                    int outS = Integer.parseInt(outTimecode[2]) * 1000;
                    int outF = Integer.parseInt(outTimecode[3]);
                    positionVideo.setMinimum(inH + inM + inS + inF);
                    positionVideo.setMaximum(outH + outM + outS + outF);
                    positionVideo.setValue(positionVideo.getMinimum());
                } else if (!(line.contains("-->") || line.matches("[0-9]+") || line.isEmpty())) {
                    if (lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                        bufferedWriter.write(" \\h" + line + " \\h");
                    } else {
                        bufferedWriter.write(line);
                    }
                    bufferedWriter.newLine();
                }
                if (line.isEmpty()) break;
            }
            bufferedReader.close();
            bufferedWriter.close();
            if (start) {
                SubtitlesWindow.sliderChange(false);
            } else if ((Integer)spinnerSubtitle.getValue() > 1) {
                spinnerSubtitle.setValue((Integer)spinnerSubtitle.getValue() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sliderChange(final boolean analyze) {
        Thread runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                DecimalFormat tc = new DecimalFormat("00");
                String h = String.valueOf(tc.format(positionVideo.getValue() / 3600000));
                String m = String.valueOf(tc.format(positionVideo.getValue() / 60000 % 60));
                String s = String.valueOf(tc.format(positionVideo.getValue() / 1000 % 60));
                String f = String.valueOf(tc.format((int)((float)positionVideo.getValue() / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
                SubtitlesWindow.loadImage(h, m, s, f, analyze);
            }
        });
        runProcess.start();
    }

    public static void loadImage(final String h, final String m, final String s, String f, final boolean analyze) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block29: {
                    try {
                        try {
                            String c;
                            File file;
                            String fichier = Shutter.liste.firstElement();
                            if (Shutter.scanIsRunning) {
                                File dir = new File(Shutter.liste.firstElement());
                                File[] fileArray = dir.listFiles();
                                int n = fileArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File f = fileArray[n2];
                                    if (!f.isHidden() && f.isFile()) {
                                        fichier = f.toString();
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            if ((file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp")).exists()) {
                                file.delete();
                            }
                            Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("tempFolder") + " " + Shutter.dirTemp + System.lineSeparator() + System.lineSeparator());
                            if (fontColor != null) {
                                c = Integer.toHexString(fontColor.getRGB()).substring(2);
                                hex = String.valueOf(c.substring(4, 6)) + c.substring(2, 4) + c.substring(0, 2);
                            }
                            if (backgroundColor != null) {
                                c = Integer.toHexString(backgroundColor.getRGB()).substring(2);
                                hex2 = String.valueOf(c.substring(4, 6)) + c.substring(2, 4) + c.substring(0, 2);
                            }
                            int o = (int)(255.0f - (float)((Integer)spinnerOpacity.getValue() * 255) / 100.0f);
                            alpha = Integer.toHexString(o);
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            String background = "";
                            background = lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn")) ? ",BorderStyle=4,BackColour=&H" + alpha + hex2 + "&,Outline=0" : ",OutlineColour=&H" + alpha + hex2 + "&";
                            if (btnG.getForeground() != Color.BLACK) {
                                background = String.valueOf(background) + ",Bold=1";
                            }
                            if (btnI.getForeground() != Color.BLACK) {
                                background = String.valueOf(background) + ",Italic=1";
                            }
                            String[] size = FFPROBE.imageResolution.split("x");
                            if (analyze) {
                                FFPROBE.Data(fichier);
                                do {
                                    Thread.sleep(100L);
                                } while (FFPROBE.isRunning);
                            }
                            String crop = "";
                            String pad = "";
                            if (Shutter.caseRognage.isSelected()) {
                                if (Shutter.lblPad.getText().equals(Shutter.language.getProperty("lblCrop"))) {
                                    String[] c2 = Shutter.comboH264Taille.getSelectedItem().toString().split("x");
                                    ImageWidth = Integer.parseInt(c2[0]);
                                    ImageHeight = Integer.parseInt(c2[1]);
                                    size[0] = String.valueOf(FFPROBE.cropHeight);
                                    size[1] = String.valueOf(FFPROBE.cropWidth);
                                }
                                crop = "crop=" + FFPROBE.cropHeight + ":" + FFPROBE.cropWidth + ":" + FFPROBE.cropPixelsWidth + ":" + FFPROBE.cropPixelsHeight + "[c];[c]";
                                if (Shutter.lblPad.getText().equals(Shutter.language.getProperty("lblPad"))) {
                                    pad = "pad=" + FFPROBE.imageResolution.replace("x", ":") + ":(ow-iw)*0.5:(oh-ih)*0.5[p];[p]";
                                }
                            }
                            String[] i = FFPROBE.imageResolution.split("x");
                            boolean infRatio = false;
                            if (Shutter.caseRognage.isSelected() && Shutter.lblPad.getText().equals(Shutter.language.getProperty("lblCrop"))) {
                                i = Shutter.comboH264Taille.getSelectedItem().toString().split("x");
                                infRatio = true;
                            }
                            if (analyze) {
                                textWidth.setText(i[0]);
                            }
                            if ((float)ImageWidth / (float)ImageHeight >= 1.7777778f) {
                                containerHeight = (int)Math.floor(640.0f / ((float)ImageWidth / (float)ImageHeight));
                                containerWidth = 640;
                            } else {
                                containerWidth = (int)Math.floor((float)ImageWidth / (float)ImageHeight * 360.0f);
                                containerHeight = 360;
                            }
                            FFMPEG.run(" -ss " + h + ":" + m + ":" + s + ".0 -i " + '\"' + fichier + '\"' + " -f lavfi -i " + '\"' + "color=black@0.0,format=rgba,scale=" + textWidth.getText() + ":" + size[1] + "+" + spinnerSubtitlesPosition.getValue() + ",subtitles='" + Shutter.subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + comboFont.getSelectedItem().toString() + ",FontSize=" + spinnerSize.getValue() + ",PrimaryColour=&H" + hex + "&" + background + "'" + '\"' + " -vframes 1 -filter_complex [0:v]" + crop + pad + "[1:v]overlay=x=" + (Integer.parseInt(i[0]) - Integer.parseInt(textWidth.getText())) / 2 + ",scale=" + containerWidth + ":" + containerHeight + " -an -y " + '\"' + Shutter.dirTemp + "preview.bmp" + '\"');
                            do {
                                Thread.sleep(100L);
                            } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error);
                            frame.setCursor(Cursor.getPredefinedCursor(0));
                            if (FFMPEG.error) {
                                JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                            }
                            image.removeAll();
                            BufferedImage imageBMP = ImageIO.read(new File(String.valueOf(Shutter.dirTemp) + "preview.bmp"));
                            ImageIcon imageIcon = new ImageIcon(imageBMP);
                            JLabel newImage = new JLabel(imageIcon);
                            imageIcon.getImage().flush();
                            newImage.setHorizontalAlignment(0);
                            image.setLocation(12 + (640 - containerWidth) / 2, 58 + (int)((float)(360 - containerHeight) / 2.0f));
                            image.setSize(containerWidth, containerHeight);
                            imageIcon = new ImageIcon(imageBMP);
                            newImage = new JLabel(imageIcon);
                            newImage.setSize(containerWidth, containerHeight);
                            JPanel borderWidth = new JPanel();
                            int outputHeight = Integer.parseInt(i[1]);
                            if (infRatio) {
                                String[] out = Shutter.comboH264Taille.getSelectedItem().toString().split("x");
                                outputHeight = Integer.parseInt(out[1]);
                            }
                            borderWidth.setSize((int)((float)Integer.parseInt(textWidth.getText()) / ((float)outputHeight / (float)newImage.getHeight())), (int)((float)newImage.getHeight() + (float)Integer.parseInt(spinnerSubtitlesPosition.getValue().toString()) / ((float)outputHeight / (float)newImage.getHeight())));
                            borderWidth.setLocation(newImage.getX() + (newImage.getWidth() - borderWidth.getWidth()) / 2, newImage.getY());
                            borderWidth.setBorder(BorderFactory.createDashedBorder(Color.WHITE, 4.0f, 4.0f));
                            borderWidth.setOpaque(true);
                            borderWidth.setBackground(new Color(0, 0, 0, 0));
                            image.add(borderWidth);
                            image.add(newImage);
                            image.repaint();
                            if (!frame.isVisible()) {
                                Utils.changeDialogVisibility(frame, false);
                            }
                            Shutter.tempsRestant.setVisible(false);
                            Shutter.progressBar1.setValue(0);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                            Shutter.tempsRestant.setVisible(false);
                            Shutter.enableAll();
                            if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                                break block29;
                            }
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                        }
                    }
                    finally {
                        Shutter.tempsRestant.setVisible(false);
                        Shutter.enableAll();
                        if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        } else {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                        }
                    }
                }
            }
        });
        thread.start();
    }

    public static void loadSettings(final File encFile) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        Thread.sleep(100L);
                    } while (frame == null && !frame.isVisible());
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    File fXmlFile = encFile;
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(fXmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("Component");
                    int temp = 0;
                    while (temp < nList.getLength()) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            Element eElement = (Element)nNode;
                            Component[] componentArray = frame.getContentPane().getComponents();
                            int n = componentArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Component p = componentArray[n2];
                                if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                    String[] s2;
                                    String[] s;
                                    if (p instanceof JPanel) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        s = eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().replace("]", "").replace("r=", "").replace("g=", "").replace("b=", "").split("\\[");
                                        s2 = s[1].split(",");
                                        ((JPanel)p).setBackground(new Color(Integer.valueOf(s2[0]), Integer.valueOf(s2[1]), Integer.valueOf(s2[2])));
                                        if (p.getName().equals("panelColor")) {
                                            fontColor = panelColor.getBackground();
                                        } else if (p.getName().equals("panelColor2")) {
                                            backgroundColor = panelColor2.getBackground();
                                        }
                                        SubtitlesWindow.sliderChange(false);
                                    }
                                    if (p instanceof JButton) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        s = eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().replace("]", "").replace("r=", "").replace("g=", "").replace("b=", "").split("\\[");
                                        s2 = s[1].split(",");
                                        ((JButton)p).setForeground(new Color(Integer.valueOf(s2[0]), Integer.valueOf(s2[1]), Integer.valueOf(s2[2])));
                                    } else if (p instanceof JLabel) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        ((JLabel)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                        ((JLabel)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JLabel)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JComboBox) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        ((JComboBox)p).setSelectedItem(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                        ((JComboBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JComboBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JTextField) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                        ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JSpinner) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        ((JSpinner)p).setValue(Integer.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()));
                                        ((JSpinner)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JSpinner)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    }
                                }
                                ++n2;
                            }
                        }
                        ++temp;
                    }
                    SubtitlesWindow.sliderChange(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    private class ComboRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;
        private JComboBox comboBox;
        final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private int row;

        private ComboRenderer(JComboBox fontsBox) {
            this.comboBox = fontsBox;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (list.getModel().getSize() > 0) {
                Accessible accessible = this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
            }
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, this.row, isSelected, cellHasFocus);
            Object fntObj = value;
            String fontFamilyName = (String)fntObj;
            this.setFont(new Font(fontFamilyName, 0, 16));
            return this;
        }
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }

    private static class MouseSubSize {
        static int mouseX;
        static int offsetX;

        private MouseSubSize() {
        }
    }
}

