/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import application.Subtitles;
import application.Utils;
import application.VideoPlayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class SubtitlesEdit {
    private static JDialog frame;
    private final JButton btnAppliquer = new JButton(Shutter.language.getProperty("btnApply"));
    private final JButton btnCancel = new JButton(Shutter.language.getProperty("btnCancel"));
    static int textPosition;
    private JScrollBar scrollBar;
    int scrollValue = 0;
    private final JPanel panelHide;

    public SubtitlesEdit(int numberOfSubs) {
        textPosition = 12;
        frame = new JDialog();
        frame.setModal(true);
        frame.setResizable(false);
        frame.getContentPane().setLayout(null);
        frame.setSize(620, 670);
        frame.setAlwaysOnTop(true);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameSubtitlesEdit"));
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(dim.width / 2 - SubtitlesEdit.frame.getSize().width / 2, dim.height / 2 - SubtitlesEdit.frame.getSize().height / 2);
        this.btnAppliquer.setFont(new Font("Montserrat", 0, 12));
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
            this.btnAppliquer.setBounds(frame.getWidth() / 2 - 2, frame.getHeight() - 52, frame.getWidth() / 2 - 2, 21);
        } else {
            this.btnAppliquer.setBounds(frame.getWidth() / 2 - 2, frame.getHeight() - 67, frame.getWidth() / 2 - 18, 21);
        }
        frame.getContentPane().add(this.btnAppliquer);
        this.btnAppliquer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                BufferedWriter writer = null;
                try {
                    try {
                        writer = Files.newBufferedWriter(Paths.get(Subtitles.srt.toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                        boolean isInPoint = true;
                        Component[] componentArray = frame.getContentPane().getComponents();
                        int n = componentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component c = componentArray[n2];
                            if (c instanceof JLabel) {
                                if (((JLabel)c).getText().matches("[0-9]+")) {
                                    if (((JLabel)c).getText().equals("1")) {
                                        writer.write(String.valueOf(((JLabel)c).getText()) + System.lineSeparator());
                                    } else {
                                        writer.write(String.valueOf(System.lineSeparator()) + System.lineSeparator() + ((JLabel)c).getText() + System.lineSeparator());
                                    }
                                }
                            } else if (c instanceof JTextField) {
                                if (isInPoint) {
                                    writer.write(String.valueOf(((JTextField)c).getText()) + " --> ");
                                    isInPoint = false;
                                } else {
                                    writer.write(String.valueOf(((JTextField)c).getText()) + System.lineSeparator());
                                    isInPoint = true;
                                }
                            } else if (c instanceof JTextPane) {
                                writer.write(((JTextPane)c).getText());
                            }
                            ++n2;
                        }
                    }
                    catch (IOException iOException) {
                        block30: {
                            try {
                                try {
                                    writer.close();
                                }
                                catch (IOException iOException2) {
                                    Subtitles.timeline.removeAll();
                                    Subtitles.setSubtitles(Subtitles.srt);
                                    VideoPlayer.mediaPlayerComponentLeft.getMediaPlayer().setSubTitleFile(Subtitles.srt);
                                    frame.dispose();
                                    break block30;
                                }
                            }
                            catch (Throwable throwable) {
                                Subtitles.timeline.removeAll();
                                Subtitles.setSubtitles(Subtitles.srt);
                                VideoPlayer.mediaPlayerComponentLeft.getMediaPlayer().setSubTitleFile(Subtitles.srt);
                                frame.dispose();
                                throw throwable;
                            }
                            Subtitles.timeline.removeAll();
                            Subtitles.setSubtitles(Subtitles.srt);
                            VideoPlayer.mediaPlayerComponentLeft.getMediaPlayer().setSubTitleFile(Subtitles.srt);
                            frame.dispose();
                        }
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                finally {
                    block32: {
                        try {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {
                                Subtitles.timeline.removeAll();
                                Subtitles.setSubtitles(Subtitles.srt);
                                VideoPlayer.mediaPlayerComponentLeft.getMediaPlayer().setSubTitleFile(Subtitles.srt);
                                frame.dispose();
                                break block32;
                            }
                        }
                        catch (Throwable throwable) {
                            Subtitles.timeline.removeAll();
                            Subtitles.setSubtitles(Subtitles.srt);
                            VideoPlayer.mediaPlayerComponentLeft.getMediaPlayer().setSubTitleFile(Subtitles.srt);
                            frame.dispose();
                            throw throwable;
                        }
                        Subtitles.timeline.removeAll();
                        Subtitles.setSubtitles(Subtitles.srt);
                        VideoPlayer.mediaPlayerComponentLeft.getMediaPlayer().setSubTitleFile(Subtitles.srt);
                        frame.dispose();
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.btnCancel.setFont(new Font("Montserrat", 0, 12));
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
            this.btnCancel.setBounds(3, frame.getHeight() - 52, frame.getWidth() / 2 - 2, 21);
        } else {
            this.btnCancel.setBounds(3, frame.getHeight() - 67, frame.getWidth() / 2 - 12, 21);
        }
        frame.getContentPane().add(this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        this.panelHide = new JPanel();
        this.panelHide.setBounds(0, 610, frame.getWidth(), 38);
        this.panelHide.setBackground(new Color(50, 50, 50));
        frame.getContentPane().add(this.panelHide);
        SubtitlesEdit.addSubtitles();
        this.scrollBar = new JScrollBar();
        this.scrollBar.setBackground(new Color(50, 50, 50));
        this.scrollBar.setOrientation(1);
        if (numberOfSubs > 10) {
            this.scrollBar.setVisible(true);
        } else {
            this.scrollBar.setVisible(false);
        }
        this.scrollBar.setMaximum(60 * (numberOfSubs + 1) - 648);
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
            this.scrollBar.setBounds(frame.getWidth() - 17, 0, 17, frame.getHeight() - 60);
        } else {
            this.scrollBar.setBounds(frame.getWidth() - 34, 0, 17, frame.getHeight() - 65);
        }
        frame.getContentPane().add(this.scrollBar);
        frame.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                SubtitlesEdit.this.scrollBar.setValue(SubtitlesEdit.this.scrollBar.getValue() + e.getWheelRotation() * 10);
            }
        });
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                Subtitles.setSubtitles(Subtitles.srt);
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                int scrollIncrement = SubtitlesEdit.this.scrollBar.getValue() - SubtitlesEdit.this.scrollValue;
                Component[] componentArray = frame.getContentPane().getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (!(c instanceof JButton || c instanceof JScrollBar || c instanceof JPanel)) {
                        c.setLocation(c.getLocation().x, c.getLocation().y - scrollIncrement);
                    }
                    ++n2;
                }
                SubtitlesEdit.this.scrollValue = SubtitlesEdit.this.scrollBar.getValue();
            }
        });
        frame.setVisible(true);
    }

    private static JTextPane addText(String subContent) {
        JTextPane text = new JTextPane();
        text.setText(subContent);
        text.setCaretColor(Color.BLACK);
        text.setBounds(176, textPosition, 400, 48);
        textPosition += 60;
        return text;
    }

    private static JTextField addInPoint(String subIn) {
        JTextField in = new JTextField();
        in.setText(subIn);
        in.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255, 50)));
        in.setForeground(Utils.themeColor);
        in.setFont(new Font("Montserrat", 0, 12));
        in.setBounds(82, textPosition - 2, 90, 25);
        in.setBackground(new Color(50, 50, 50));
        in.setHorizontalAlignment(0);
        return in;
    }

    private static JTextField addOutPoint(String subOut) {
        JTextField out = new JTextField();
        out.setText(subOut);
        out.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255, 50)));
        out.setForeground(Utils.themeColor);
        out.setFont(new Font("Montserrat", 0, 12));
        out.setBounds(82, textPosition + 24, 90, 25);
        out.setBackground(new Color(50, 50, 50));
        out.setHorizontalAlignment(0);
        return out;
    }

    private static JLabel addNumber(int number) {
        JLabel nb = new JLabel(String.valueOf(number));
        nb.setFont(new Font("Montserrat", 0, 12));
        nb.setHorizontalAlignment(0);
        nb.setBounds(9, textPosition + 16, 61, 16);
        return nb;
    }

    private static void addSubtitles() {
        BufferedReader reader = null;
        try {
            try {
                if (Subtitles.srt.exists()) {
                    String line;
                    reader = Files.newBufferedReader(Paths.get(Subtitles.srt.toString(), new String[0]), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        if (line.matches("[0-9]+")) {
                            frame.getContentPane().add(SubtitlesEdit.addNumber(Integer.valueOf(line)));
                            continue;
                        }
                        if (line.isEmpty()) continue;
                        String[] s = line.split(" ");
                        frame.getContentPane().add(SubtitlesEdit.addInPoint(s[0]));
                        frame.getContentPane().add(SubtitlesEdit.addOutPoint(s[2]));
                        StringBuilder subContent = new StringBuilder();
                        while ((line = reader.readLine()) != null && !line.isEmpty()) {
                            subContent.append(String.valueOf(line) + System.lineSeparator());
                        }
                        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                            frame.getContentPane().add(SubtitlesEdit.addText(subContent.toString().substring(0, subContent.length() - 1)));
                            continue;
                        }
                        frame.getContentPane().add(SubtitlesEdit.addText(subContent.toString().substring(0, subContent.length() - 2)));
                    }
                }
            }
            catch (Exception exception) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

