/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.OutputTransferHandler1;
import application.OutputTransferHandler2;
import application.OutputTransferHandler3;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Settings {
    public static JFrame frame = new JFrame();
    private JLabel quit;
    private JLabel reduce;
    private JLabel help;
    private JPanel topPanel;
    private JLabel topImage;
    public static File settingsXML = new File(Shutter.documents + "/settings.xml");
    private JLabel lblThreads = new JLabel(Shutter.language.getProperty("lblThreads"));
    public static JTextField txtThreads = new JTextField();
    private JLabel lblScreenRecord = new JLabel(Shutter.language.getProperty("lblScreenRecord"));
    public static JTextField txtScreenRecord = new JTextField();
    private JLabel lblInputDevice = new JLabel(Shutter.language.getProperty("lblInputDevice"));
    public static JTextField txtInputDevice = new JTextField();
    private JLabel lblImageToVideo = new JLabel(Shutter.language.getProperty("lblImageToVideo"));
    public static JTextField txtImageDuration = new JTextField();
    private JLabel lblGpuDecoding = new JLabel(Shutter.language.getProperty("lblGpuDecoding"));
    public static JComboBox<String> comboGPU;
    private JLabel lblScaleMode = new JLabel(Shutter.language.getProperty("lblScaleMode"));
    public static JComboBox<String> comboScale;
    private JLabel lblBlackDetection = new JLabel(Shutter.language.getProperty("lblBlackDetection"));
    private JLabel lblLanguage = new JLabel(Shutter.language.getProperty("lblLanguage"));
    private JLabel lblTheme = new JLabel(Shutter.language.getProperty("lblTheme"));
    private JLabel lblColor = new JLabel(Shutter.language.getProperty("lblColor"));
    private static JPanel accentColor;
    public static JComboBox<String> comboLanguage;
    public static JComboBox<String> comboTheme;
    public static JTextField txtBlackDetection;
    public static JRadioButton btnSetBab;
    public static JRadioButton btnOpenGOP;
    public static JRadioButton btnExtension;
    public static JRadioButton btnWaitFileComplete;
    public static JRadioButton btnEmptyListAtEnd;
    public static JRadioButton btnEndingAction;
    public static JComboBox<String> comboAction;
    public static JRadioButton btnDisableAnimations;
    public static JRadioButton btnDisableSound;
    public static JRadioButton btnDisableUpdate;
    public static JTextField txtExtension;
    public static JLabel lblDestination1;
    public static JLabel lblDestination2;
    public static JLabel lblDestination3;
    private JLabel defaultOutput1 = new JLabel(String.valueOf(Shutter.language.getProperty("output")) + "1 " + Shutter.language.getProperty("toDefault"));
    private JLabel defaultOutput2 = new JLabel(String.valueOf(Shutter.language.getProperty("output")) + "2 " + Shutter.language.getProperty("toDefault"));
    private JLabel defaultOutput3 = new JLabel(String.valueOf(Shutter.language.getProperty("output")) + "3 " + Shutter.language.getProperty("toDefault"));
    public static JRadioButton lastUsedOutput1;
    public static JRadioButton lastUsedOutput2;
    public static JRadioButton lastUsedOutput3;
    public static int videoPlayerVolume;

    static {
        comboScale = new JComboBox<String>(new String[]{"fast_bilinear", "bilinear", "bicubic", "neighbor", "area", "gauss", "sinc", "lanczos", "spline"});
        accentColor = new JPanel();
        comboLanguage = new JComboBox<String>(new String[]{"Fran\u00e7ais", "English", "Italiano"});
        comboTheme = new JComboBox<String>(new String[]{Shutter.language.getProperty("clearTheme"), Shutter.language.getProperty("darkTheme")});
        txtBlackDetection = new JTextField();
        btnSetBab = new JRadioButton(Shutter.language.getProperty("btnSetBab"));
        btnOpenGOP = new JRadioButton(Shutter.language.getProperty("btnOpenGOP"));
        btnExtension = new JRadioButton(Shutter.language.getProperty("btnExtension"));
        btnWaitFileComplete = new JRadioButton(Shutter.language.getProperty("btnWaitFileComplete"));
        btnEmptyListAtEnd = new JRadioButton(Shutter.language.getProperty("btnEmptyListAtEnd"));
        btnEndingAction = new JRadioButton(Shutter.language.getProperty("btnEndingAction"));
        comboAction = new JComboBox();
        btnDisableAnimations = new JRadioButton(Shutter.language.getProperty("btnDisableAnimations"));
        btnDisableSound = new JRadioButton(Shutter.language.getProperty("btnDisableSound"));
        btnDisableUpdate = new JRadioButton(Shutter.language.getProperty("btnDisableUpdate"));
        txtExtension = new JTextField();
        lblDestination1 = new JLabel();
        lblDestination2 = new JLabel();
        lblDestination3 = new JLabel();
        lastUsedOutput1 = new JRadioButton(Shutter.language.getProperty("lastUsed"));
        lastUsedOutput2 = new JRadioButton(Shutter.language.getProperty("lastUsed"));
        lastUsedOutput3 = new JRadioButton(Shutter.language.getProperty("lastUsed"));
        videoPlayerVolume = 50;
    }

    public Settings() {
        btnOpenGOP.setName("btnOpenGOP");
        btnExtension.setName("btnExtension");
        txtExtension.setName("txtExtension");
        btnWaitFileComplete.setName("btnWaitFileComplete");
        btnDisableAnimations.setName("btnDisableAnimations");
        btnDisableSound.setName("btnDisableSound");
        btnDisableUpdate.setName("btnDisableUpdate");
        btnEmptyListAtEnd.setName("btnEmptyListAtEnd");
        lblDestination1.setName("lblDestination1");
        lblDestination2.setName("lblDestination2");
        lblDestination3.setName("lblDestination3");
        lastUsedOutput1.setName("lastUsedOutput1");
        lastUsedOutput2.setName("lastUsedOutput2");
        lastUsedOutput3.setName("lastUsedOutput3");
        comboGPU.setName("comboGPU");
        comboScale.setName("comboScale");
        txtThreads.setName("txtThreads");
        txtScreenRecord.setName("txtScreenRecord");
        txtInputDevice.setName("txtInputDevice");
        txtImageDuration.setName("txtImageDuration");
        txtBlackDetection.setName("txtBlackDetection");
        comboLanguage.setName("comboLanguage");
        comboTheme.setName("comboTheme");
        frame.setSize(332, 725);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(1);
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.setTitle(Shutter.language.getProperty("frameSettings"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setResizable(false);
        frame.setUndecorated(true);
        Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
        Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
        shape1.add(shape2);
        frame.setShape(shape1);
        frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.setLocation(Shutter.frame.getLocation().x - Settings.frame.getSize().width - 20, Shutter.frame.getLocation().y);
        this.topPanel();
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblDestination1.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 0));
                lblDestination2.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 0));
                lblDestination3.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 0));
            }
        });
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (txtThreads.getText().isEmpty() || txtThreads.getText() == null) {
                    txtThreads.setText("0");
                }
                Settings.saveSettings();
            }
        });
        btnWaitFileComplete.setFont(new Font("FreeSans", 0, 12));
        btnWaitFileComplete.setBounds(12, 56, Settings.btnWaitFileComplete.getPreferredSize().width, 16);
        frame.getContentPane().add(btnWaitFileComplete);
        btnExtension.setFont(new Font("FreeSans", 0, 12));
        btnExtension.setBounds(12, Settings.btnWaitFileComplete.getLocation().y + btnWaitFileComplete.getHeight() + 10, Settings.btnExtension.getPreferredSize().width, 16);
        frame.getContentPane().add(btnExtension);
        btnExtension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (btnExtension.isSelected()) {
                    txtExtension.setEnabled(true);
                } else {
                    txtExtension.setEnabled(false);
                }
                Utils.textFieldBackground();
            }
        });
        if (btnExtension.isSelected()) {
            txtExtension.setEnabled(true);
        } else {
            txtExtension.setEnabled(false);
        }
        txtExtension.setColumns(10);
        txtExtension.setFont(new Font("SansSerif", 0, 12));
        txtExtension.setBounds(Settings.btnExtension.getLocation().x + btnExtension.getWidth() + 6, Settings.btnExtension.getLocation().y - 2, frame.getWidth() - (Settings.btnExtension.getLocation().x + btnExtension.getWidth()) - 32, 21);
        frame.getContentPane().add(txtExtension);
        btnSetBab.setFont(new Font("FreeSans", 0, 12));
        btnSetBab.setBounds(12, Settings.btnExtension.getLocation().y + btnExtension.getHeight() + 10, Settings.btnSetBab.getPreferredSize().width, 16);
        frame.getContentPane().add(btnSetBab);
        btnOpenGOP.setFont(new Font("FreeSans", 0, 12));
        btnOpenGOP.setBounds(12, Settings.btnSetBab.getLocation().y + btnSetBab.getHeight() + 10, Settings.btnOpenGOP.getPreferredSize().width, 16);
        frame.getContentPane().add(btnOpenGOP);
        btnDisableAnimations.setFont(new Font("FreeSans", 0, 12));
        btnDisableAnimations.setBounds(12, Settings.btnOpenGOP.getLocation().y + btnOpenGOP.getHeight() + 10, Settings.btnDisableAnimations.getPreferredSize().width, 16);
        frame.getContentPane().add(btnDisableAnimations);
        btnDisableSound.setFont(new Font("FreeSans", 0, 12));
        btnDisableSound.setBounds(12, Settings.btnDisableAnimations.getLocation().y + btnDisableAnimations.getHeight() + 10, Settings.btnDisableSound.getPreferredSize().width, 16);
        frame.getContentPane().add(btnDisableSound);
        btnDisableUpdate.setFont(new Font("FreeSans", 0, 12));
        btnDisableUpdate.setBounds(12, Settings.btnDisableSound.getLocation().y + btnDisableSound.getHeight() + 10, Settings.btnDisableUpdate.getPreferredSize().width, 16);
        frame.getContentPane().add(btnDisableUpdate);
        btnEmptyListAtEnd.setFont(new Font("FreeSans", 0, 12));
        btnEmptyListAtEnd.setBounds(12, Settings.btnDisableUpdate.getLocation().y + btnDisableUpdate.getHeight() + 10, Settings.btnEmptyListAtEnd.getPreferredSize().width, 16);
        frame.getContentPane().add(btnEmptyListAtEnd);
        btnEndingAction.setFont(new Font("FreeSans", 0, 12));
        btnEndingAction.setBounds(12, Settings.btnEmptyListAtEnd.getLocation().y + btnEmptyListAtEnd.getHeight() + 10, Settings.btnEndingAction.getPreferredSize().width, 16);
        frame.getContentPane().add(btnEndingAction);
        btnEndingAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (btnEndingAction.isSelected()) {
                    comboAction.setEnabled(true);
                } else {
                    comboAction.setEnabled(false);
                }
            }
        });
        if (comboAction.getModel().getSize() == 0) {
            comboAction.setModel(new DefaultComboBoxModel<String>(new String[]{Shutter.language.getProperty("lblActionClose"), Shutter.language.getProperty("lblActionShutdown")}));
            comboAction.setSelectedIndex(1);
            comboAction.setFont(new Font("FreeSans", 0, 10));
            comboAction.setEditable(false);
            comboAction.setBounds(btnEndingAction.getX() + btnEndingAction.getWidth() + 6, Settings.btnEndingAction.getLocation().y - 4, frame.getWidth() - (Settings.btnEndingAction.getLocation().x + btnEndingAction.getWidth()) - 32, 22);
            comboAction.setMaximumRowCount(10);
        }
        comboAction.setEnabled(false);
        frame.getContentPane().add(comboAction);
        this.defaultOutput1.setFont(new Font("FreeSans", 0, 12));
        this.defaultOutput1.setBounds(12, Settings.btnEndingAction.getLocation().y + btnEndingAction.getHeight() + 14, this.defaultOutput1.getPreferredSize().width, this.defaultOutput1.getPreferredSize().height);
        frame.getContentPane().add(this.defaultOutput1);
        if (lastUsedOutput1.isSelected()) {
            lblDestination1.setForeground(Color.LIGHT_GRAY);
        } else {
            lblDestination1.setForeground(Utils.themeColor);
        }
        lblDestination1.setBorder(BorderFactory.createEmptyBorder());
        lblDestination1.setFont(new Font("SansSerif", 0, 12));
        lblDestination1.setBackground(new Color(50, 50, 50));
        if (lblDestination1.getText() == "") {
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                lblDestination1.setText(String.valueOf(System.getProperty("user.home")) + "/Desktop");
            } else {
                lblDestination1.setText(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
            }
        }
        lblDestination1.setBounds(12, this.defaultOutput1.getLocation().y + this.defaultOutput1.getHeight() + 6, frame.getWidth() - 36, Settings.lblDestination1.getPreferredSize().height);
        frame.getContentPane().add(lblDestination1);
        lblDestination1.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!lastUsedOutput1.isSelected()) {
                    File destination = null;
                    if (System.getProperty("os.name").contains("Mac")) {
                        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseDestinationFolder"), 0);
                        dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setLocation(Settings.frame.getLocation().x - 50, Settings.frame.getLocation().y + 50);
                        dialog.setAlwaysOnTop(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "true");
                        dialog.setVisible(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "false");
                        if (dialog.getDirectory() != null) {
                            destination = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                        }
                    } else if (System.getProperty("os.name").contains("Linux")) {
                        JFileChooser dialog = new JFileChooser(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setDialogTitle(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFileSelectionMode(1);
                        if (lblDestination1.getText() != "" && new File(lblDestination1.getText()).exists()) {
                            dialog.setSelectedFile(new File(lblDestination1.getText()));
                        } else {
                            dialog.setSelectedFile(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop"));
                        }
                        int result = dialog.showOpenDialog(frame);
                        if (result == 0) {
                            destination = new File(dialog.getSelectedFile().toString());
                        }
                    } else {
                        Shell shell = new Shell(16384);
                        shell.setSize(Settings.frame.getSize().width, Settings.frame.getSize().height);
                        shell.setLocation(Settings.frame.getLocation().x, Settings.frame.getLocation().y);
                        shell.setAlpha(0);
                        shell.open();
                        DirectoryDialog dialog = new DirectoryDialog(shell);
                        dialog.setText(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFilterPath(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                        try {
                            destination = new File(dialog.open());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.dispose();
                    }
                    if (destination != null) {
                        if (System.getProperty("os.name").contains("Windows") && destination.toString().substring(0, 2).equals("\\\\")) {
                            destination = Utils.UNCPath(destination);
                        }
                        if (destination.isFile()) {
                            lblDestination1.setText(destination.getParent());
                        } else {
                            lblDestination1.setText(destination.toString());
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (!lastUsedOutput1.isSelected()) {
                    lblDestination1.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                lblDestination1.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        lastUsedOutput1.setFont(new Font("FreeSans", 0, 12));
        lastUsedOutput1.setBounds(this.defaultOutput1.getX() + this.defaultOutput1.getWidth() + 10, this.defaultOutput1.getLocation().y, Settings.lastUsedOutput1.getPreferredSize().width, 16);
        frame.getContentPane().add(lastUsedOutput1);
        lastUsedOutput1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (lastUsedOutput1.isSelected()) {
                    lblDestination1.setForeground(Color.LIGHT_GRAY);
                } else {
                    lblDestination1.setForeground(Utils.themeColor);
                }
            }
        });
        this.defaultOutput2.setFont(new Font("FreeSans", 0, 12));
        this.defaultOutput2.setBounds(12, Settings.lblDestination1.getLocation().y + lblDestination1.getHeight() + 10, this.defaultOutput2.getPreferredSize().width, this.defaultOutput2.getPreferredSize().height);
        frame.getContentPane().add(this.defaultOutput2);
        if (lastUsedOutput2.isSelected()) {
            lblDestination2.setForeground(Color.LIGHT_GRAY);
        } else {
            lblDestination2.setForeground(Utils.themeColor);
        }
        lblDestination2.setBorder(BorderFactory.createEmptyBorder());
        lblDestination2.setFont(new Font("SansSerif", 0, 12));
        lblDestination2.setBackground(new Color(50, 50, 50));
        if (lblDestination2.getText() == "") {
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                lblDestination2.setText(String.valueOf(System.getProperty("user.home")) + "/Desktop");
            } else {
                lblDestination2.setText(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
            }
        }
        lblDestination2.setBounds(12, this.defaultOutput2.getLocation().y + this.defaultOutput2.getHeight() + 6, frame.getWidth() - 36, Settings.lblDestination2.getPreferredSize().height);
        frame.getContentPane().add(lblDestination2);
        lblDestination2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!lastUsedOutput2.isSelected()) {
                    File destination = null;
                    if (System.getProperty("os.name").contains("Mac")) {
                        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseDestinationFolder"), 0);
                        dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setLocation(Settings.frame.getLocation().x - 50, Settings.frame.getLocation().y + 50);
                        dialog.setAlwaysOnTop(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "true");
                        dialog.setVisible(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "false");
                        if (dialog.getDirectory() != null) {
                            destination = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                        }
                    } else if (System.getProperty("os.name").contains("Linux")) {
                        JFileChooser dialog = new JFileChooser(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setDialogTitle(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFileSelectionMode(1);
                        if (lblDestination1.getText() != "" && new File(lblDestination1.getText()).exists()) {
                            dialog.setSelectedFile(new File(lblDestination1.getText()));
                        } else {
                            dialog.setSelectedFile(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop"));
                        }
                        int result = dialog.showOpenDialog(frame);
                        if (result == 0) {
                            destination = new File(dialog.getSelectedFile().toString());
                        }
                    } else {
                        Shell shell = new Shell(16384);
                        shell.setSize(Settings.frame.getSize().width, Settings.frame.getSize().height);
                        shell.setLocation(Settings.frame.getLocation().x, Settings.frame.getLocation().y);
                        shell.setAlpha(0);
                        shell.open();
                        DirectoryDialog dialog = new DirectoryDialog(shell);
                        dialog.setText(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFilterPath(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                        try {
                            destination = new File(dialog.open());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.dispose();
                    }
                    if (destination != null) {
                        if (System.getProperty("os.name").contains("Windows") && destination.toString().substring(0, 2).equals("\\\\")) {
                            destination = Utils.UNCPath(destination);
                        }
                        if (destination.isFile()) {
                            lblDestination2.setText(destination.getParent());
                        } else {
                            lblDestination2.setText(destination.toString());
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (!lastUsedOutput2.isSelected()) {
                    lblDestination2.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                lblDestination2.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        lastUsedOutput2.setFont(new Font("FreeSans", 0, 12));
        lastUsedOutput2.setBounds(this.defaultOutput2.getX() + this.defaultOutput2.getWidth() + 10, this.defaultOutput2.getLocation().y, Settings.lastUsedOutput2.getPreferredSize().width, 16);
        frame.getContentPane().add(lastUsedOutput2);
        lastUsedOutput2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (lastUsedOutput2.isSelected()) {
                    lblDestination2.setForeground(Color.LIGHT_GRAY);
                } else {
                    lblDestination2.setForeground(Utils.themeColor);
                }
            }
        });
        this.defaultOutput3.setFont(new Font("FreeSans", 0, 12));
        this.defaultOutput3.setBounds(12, Settings.lblDestination2.getLocation().y + lblDestination2.getHeight() + 10, this.defaultOutput3.getPreferredSize().width, this.defaultOutput3.getPreferredSize().height);
        frame.getContentPane().add(this.defaultOutput3);
        if (lastUsedOutput3.isSelected()) {
            lblDestination3.setForeground(Color.LIGHT_GRAY);
        } else {
            lblDestination3.setForeground(Utils.themeColor);
        }
        lblDestination3.setBorder(BorderFactory.createEmptyBorder());
        lblDestination3.setFont(new Font("SansSerif", 0, 12));
        lblDestination3.setBackground(new Color(50, 50, 50));
        if (lblDestination3.getText() == "") {
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                lblDestination3.setText(String.valueOf(System.getProperty("user.home")) + "/Desktop");
            } else {
                lblDestination3.setText(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
            }
        }
        lblDestination3.setBounds(12, this.defaultOutput3.getLocation().y + this.defaultOutput3.getHeight() + 6, frame.getWidth() - 36, Settings.lblDestination3.getPreferredSize().height);
        frame.getContentPane().add(lblDestination3);
        lblDestination3.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!lastUsedOutput3.isSelected()) {
                    File destination = null;
                    if (System.getProperty("os.name").contains("Mac")) {
                        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseDestinationFolder"), 0);
                        dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setLocation(Settings.frame.getLocation().x - 50, Settings.frame.getLocation().y + 50);
                        dialog.setAlwaysOnTop(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "true");
                        dialog.setVisible(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "false");
                        if (dialog.getDirectory() != null) {
                            destination = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                        }
                    } else if (System.getProperty("os.name").contains("Linux")) {
                        JFileChooser dialog = new JFileChooser(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setDialogTitle(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFileSelectionMode(1);
                        if (lblDestination1.getText() != "" && new File(lblDestination1.getText()).exists()) {
                            dialog.setSelectedFile(new File(lblDestination1.getText()));
                        } else {
                            dialog.setSelectedFile(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop"));
                        }
                        int result = dialog.showOpenDialog(frame);
                        if (result == 0) {
                            destination = new File(dialog.getSelectedFile().toString());
                        }
                    } else {
                        Shell shell = new Shell(16384);
                        shell.setSize(Settings.frame.getSize().width, Settings.frame.getSize().height);
                        shell.setLocation(Settings.frame.getLocation().x, Settings.frame.getLocation().y);
                        shell.setAlpha(0);
                        shell.open();
                        DirectoryDialog dialog = new DirectoryDialog(shell);
                        dialog.setText(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFilterPath(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                        try {
                            destination = new File(dialog.open());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.dispose();
                    }
                    if (destination != null) {
                        if (System.getProperty("os.name").contains("Windows") && destination.toString().substring(0, 2).equals("\\\\")) {
                            destination = Utils.UNCPath(destination);
                        }
                        if (destination.isFile()) {
                            lblDestination3.setText(destination.getParent());
                        } else {
                            lblDestination3.setText(destination.toString());
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (!lastUsedOutput3.isSelected()) {
                    lblDestination3.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                lblDestination3.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        lastUsedOutput3.setFont(new Font("FreeSans", 0, 12));
        lastUsedOutput3.setBounds(this.defaultOutput3.getX() + this.defaultOutput3.getWidth() + 10, this.defaultOutput3.getLocation().y, Settings.lastUsedOutput3.getPreferredSize().width, 16);
        frame.getContentPane().add(lastUsedOutput3);
        lastUsedOutput3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (lastUsedOutput3.isSelected()) {
                    lblDestination3.setForeground(Color.LIGHT_GRAY);
                } else {
                    lblDestination3.setForeground(Utils.themeColor);
                }
            }
        });
        lblDestination1.setTransferHandler(new OutputTransferHandler1());
        lblDestination2.setTransferHandler(new OutputTransferHandler2());
        lblDestination3.setTransferHandler(new OutputTransferHandler3());
        this.lblGpuDecoding.setFont(new Font("FreeSans", 0, 12));
        this.lblGpuDecoding.setBounds(12, Settings.lblDestination3.getLocation().y + lblDestination3.getHeight() + 10, this.lblGpuDecoding.getPreferredSize().width, 16);
        frame.getContentPane().add(this.lblGpuDecoding);
        comboGPU.setFont(new Font("FreeSans", 0, 10));
        comboGPU.setEditable(false);
        comboGPU.setSelectedItem(Shutter.language.getProperty("aucun"));
        comboGPU.setBounds(this.lblGpuDecoding.getX() + this.lblGpuDecoding.getWidth() + 6, this.lblGpuDecoding.getLocation().y - 4, Settings.comboGPU.getPreferredSize().width, 22);
        comboGPU.setMaximumRowCount(10);
        frame.getContentPane().add(comboGPU);
        this.lblScaleMode.setFont(new Font("FreeSans", 0, 12));
        this.lblScaleMode.setBounds(12, this.lblGpuDecoding.getLocation().y + this.lblGpuDecoding.getHeight() + 10, this.lblScaleMode.getPreferredSize().width, 16);
        frame.getContentPane().add(this.lblScaleMode);
        comboScale.setFont(new Font("FreeSans", 0, 10));
        comboScale.setEditable(false);
        comboScale.setSelectedItem("bicubic");
        comboScale.setBounds(this.lblScaleMode.getX() + this.lblScaleMode.getWidth() + 6, this.lblScaleMode.getLocation().y - 4, Settings.comboScale.getPreferredSize().width, 22);
        comboScale.setMaximumRowCount(10);
        frame.getContentPane().add(comboScale);
        this.lblScreenRecord.setFont(new Font("FreeSans", 0, 12));
        this.lblScreenRecord.setBounds(12, this.lblScaleMode.getLocation().y + this.lblScaleMode.getHeight() + 10, this.lblScreenRecord.getPreferredSize().width, this.lblScreenRecord.getPreferredSize().height);
        frame.getContentPane().add(this.lblScreenRecord);
        txtScreenRecord.setHorizontalAlignment(0);
        txtScreenRecord.setFont(new Font("FreeSans", 0, 12));
        txtScreenRecord.setText("25");
        txtScreenRecord.setColumns(10);
        txtScreenRecord.setBounds(this.lblScreenRecord.getLocation().x + this.lblScreenRecord.getWidth() + 6, this.lblScreenRecord.getLocation().y - 4, 40, 21);
        frame.getContentPane().add(txtScreenRecord);
        txtScreenRecord.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (txtScreenRecord.getText().length() >= 3) {
                    txtScreenRecord.setText("");
                }
            }
        });
        this.lblInputDevice.setFont(new Font("FreeSans", 0, 12));
        this.lblInputDevice.setBounds(12, this.lblScreenRecord.getLocation().y + this.lblScreenRecord.getHeight() + 10, this.lblInputDevice.getPreferredSize().width, this.lblInputDevice.getPreferredSize().height);
        frame.getContentPane().add(this.lblInputDevice);
        txtInputDevice.setHorizontalAlignment(0);
        txtInputDevice.setFont(new Font("FreeSans", 0, 12));
        txtInputDevice.setText("25");
        txtInputDevice.setColumns(10);
        txtInputDevice.setBounds(Settings.txtScreenRecord.getLocation().x, this.lblInputDevice.getLocation().y - 4, 40, 21);
        frame.getContentPane().add(txtInputDevice);
        txtInputDevice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' && caracter != '.' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (txtInputDevice.getText().length() >= 5) {
                    txtInputDevice.setText("");
                }
            }
        });
        this.lblThreads.setFont(new Font("FreeSans", 0, 12));
        this.lblThreads.setBounds(12, this.lblInputDevice.getLocation().y + this.lblInputDevice.getHeight() + 10, this.lblThreads.getPreferredSize().width, this.lblThreads.getPreferredSize().height);
        frame.getContentPane().add(this.lblThreads);
        txtThreads.setHorizontalAlignment(0);
        txtThreads.setFont(new Font("FreeSans", 0, 12));
        txtThreads.setColumns(10);
        txtThreads.setBounds(this.lblThreads.getLocation().x + this.lblThreads.getWidth() + 6, this.lblThreads.getLocation().y - 4, 36, 21);
        frame.getContentPane().add(txtThreads);
        txtThreads.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (txtThreads.getText().length() >= 3) {
                    txtThreads.setText("");
                }
            }
        });
        this.lblImageToVideo.setFont(new Font("FreeSans", 0, 12));
        this.lblImageToVideo.setBounds(12, this.lblThreads.getLocation().y + this.lblThreads.getHeight() + 10, this.lblImageToVideo.getPreferredSize().width, this.lblImageToVideo.getPreferredSize().height);
        frame.getContentPane().add(this.lblImageToVideo);
        txtImageDuration.setHorizontalAlignment(0);
        txtImageDuration.setFont(new Font("FreeSans", 0, 12));
        txtImageDuration.setColumns(10);
        txtImageDuration.setBounds(this.lblImageToVideo.getLocation().x + this.lblImageToVideo.getWidth() + 6, this.lblImageToVideo.getLocation().y - 4, 36, 21);
        frame.getContentPane().add(txtImageDuration);
        JLabel lblSec = new JLabel("sec");
        lblSec.setFont(new Font("FreeSans", 0, 12));
        lblSec.setBounds(Settings.txtImageDuration.getLocation().x + txtImageDuration.getWidth() + 4, this.lblImageToVideo.getLocation().y, 34, this.lblImageToVideo.getPreferredSize().height);
        frame.getContentPane().add(lblSec);
        txtImageDuration.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (txtImageDuration.getText().length() >= 3) {
                    txtImageDuration.setText("");
                }
            }
        });
        this.lblBlackDetection.setFont(new Font("FreeSans", 0, 12));
        this.lblBlackDetection.setBounds(12, this.lblImageToVideo.getLocation().y + this.lblImageToVideo.getHeight() + 10, this.lblImageToVideo.getPreferredSize().width, this.lblImageToVideo.getPreferredSize().height);
        frame.getContentPane().add(this.lblBlackDetection);
        txtBlackDetection.setHorizontalAlignment(0);
        txtBlackDetection.setFont(new Font("FreeSans", 0, 12));
        txtBlackDetection.setColumns(10);
        txtBlackDetection.setBounds(txtImageDuration.getX(), this.lblBlackDetection.getLocation().y - 4, 36, 21);
        frame.getContentPane().add(txtBlackDetection);
        JLabel lblFrame = new JLabel(Shutter.language.getProperty("lblFrames"));
        lblFrame.setFont(new Font("FreeSans", 0, 12));
        lblFrame.setBounds(Settings.txtBlackDetection.getLocation().x + txtBlackDetection.getWidth() + 4, this.lblBlackDetection.getY(), lblFrame.getPreferredSize().width, this.lblBlackDetection.getPreferredSize().height);
        frame.getContentPane().add(lblFrame);
        txtBlackDetection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (txtBlackDetection.getText().length() >= 3) {
                    txtBlackDetection.setText("");
                }
            }
        });
        this.lblTheme.setFont(new Font("FreeSans", 0, 12));
        this.lblTheme.setBounds(12, this.lblBlackDetection.getLocation().y + this.lblBlackDetection.getHeight() + 10, this.lblTheme.getPreferredSize().width + 4, this.lblImageToVideo.getPreferredSize().height);
        frame.getContentPane().add(this.lblTheme);
        comboTheme.setFont(new Font("FreeSans", 0, 10));
        comboTheme.setEditable(false);
        comboTheme.setBounds(this.lblTheme.getX() + this.lblTheme.getWidth() + 6, this.lblTheme.getLocation().y - 4, Settings.comboTheme.getPreferredSize().width, 22);
        comboTheme.setMaximumRowCount(10);
        frame.getContentPane().add(comboTheme);
        comboTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (frame.isVisible()) {
                    Settings.saveSettings();
                    try {
                        if (System.getProperty("os.name").contains("Windows")) {
                            String newShutter = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            newShutter = String.valueOf('\"') + newShutter.substring(1, newShutter.length()).replace("%20", " ") + '\"';
                            String[] arguments = new String[]{newShutter};
                            Process process = new ProcessBuilder(arguments).start();
                        } else if (System.getProperty("os.name").contains("Mac")) {
                            String newShutter = Shutter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                            newShutter = newShutter.substring(0, newShutter.length() - 1);
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/"));
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/"));
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/")).replace(" ", "\\ ");
                            String[] arguments = new String[]{"/bin/bash", "-c", "open -n " + newShutter};
                            Process process = new ProcessBuilder(arguments).start();
                        } else {
                            String[] arguments = new String[]{"/bin/bash", "-c", "shutter-encoder"};
                            Process process = new ProcessBuilder(arguments).start();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        });
        this.lblColor.setFont(new Font("FreeSans", 0, 12));
        this.lblColor.setBounds(comboTheme.getX() + comboTheme.getWidth() + 12, this.lblTheme.getLocation().y, this.lblColor.getPreferredSize().width, this.lblImageToVideo.getPreferredSize().height);
        frame.getContentPane().add(this.lblColor);
        accentColor = new JPanel();
        accentColor.setName("accentColor");
        accentColor.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        accentColor.setBackground(Utils.themeColor);
        accentColor.setBounds(this.lblColor.getLocation().x + this.lblColor.getWidth() + 12, this.lblColor.getLocation().y - 4, 41, 22);
        frame.getContentPane().add(accentColor);
        accentColor.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Utils.themeColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), new Color(71, 163, 236));
                if (Utils.themeColor != null) {
                    accentColor.setBackground(Utils.themeColor);
                    Settings.saveSettings();
                    try {
                        if (System.getProperty("os.name").contains("Windows")) {
                            String newShutter = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            newShutter = String.valueOf('\"') + newShutter.substring(1, newShutter.length()).replace("%20", " ") + '\"';
                            String[] arguments = new String[]{newShutter};
                            Process process = new ProcessBuilder(arguments).start();
                        } else if (System.getProperty("os.name").contains("Mac")) {
                            String newShutter = Shutter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                            newShutter = newShutter.substring(0, newShutter.length() - 1);
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/"));
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/"));
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/")).replace(" ", "\\ ");
                            String[] arguments = new String[]{"/bin/bash", "-c", "open -n " + newShutter};
                            Process process = new ProcessBuilder(arguments).start();
                        } else {
                            String[] arguments = new String[]{"/bin/bash", "-c", "shutter-encoder"};
                            Process process = new ProcessBuilder(arguments).start();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.lblLanguage.setFont(new Font("FreeSans", 0, 12));
        this.lblLanguage.setBounds(12, this.lblTheme.getLocation().y + this.lblTheme.getHeight() + 10, this.lblLanguage.getPreferredSize().width, this.lblImageToVideo.getPreferredSize().height);
        frame.getContentPane().add(this.lblLanguage);
        comboLanguage.setFont(new Font("FreeSans", 0, 10));
        comboLanguage.setEditable(false);
        if (Shutter.getLanguage.equals("Fran\u00e7ais")) {
            comboLanguage.setSelectedItem("Fran\u00e7ais");
        } else if (Shutter.getLanguage.equals("English")) {
            comboLanguage.setSelectedItem("English");
        } else if (Shutter.getLanguage.equals("Italiano")) {
            comboLanguage.setSelectedItem("Italiano");
        }
        comboLanguage.setBounds(btnEndingAction.getX() + this.lblLanguage.getWidth() + 6, this.lblLanguage.getLocation().y - 4, Settings.comboLanguage.getPreferredSize().width, 22);
        comboLanguage.setMaximumRowCount(10);
        frame.getContentPane().add(comboLanguage);
        comboLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (frame.isVisible()) {
                    Settings.saveSettings();
                    try {
                        if (System.getProperty("os.name").contains("Windows")) {
                            String newShutter = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            newShutter = String.valueOf('\"') + newShutter.substring(1, newShutter.length()).replace("%20", " ") + '\"';
                            String[] arguments = new String[]{newShutter};
                            Process process = new ProcessBuilder(arguments).start();
                        } else if (System.getProperty("os.name").contains("Mac")) {
                            String newShutter = Shutter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                            newShutter = newShutter.substring(0, newShutter.length() - 1);
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/"));
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/"));
                            newShutter = newShutter.substring(0, newShutter.lastIndexOf("/")).replace(" ", "\\ ");
                            String[] arguments = new String[]{"/bin/bash", "-c", "open -n " + newShutter};
                            Process process = new ProcessBuilder(arguments).start();
                        } else {
                            String[] arguments = new String[]{"/bin/bash", "-c", "shutter-encoder"};
                            Process process = new ProcessBuilder(arguments).start();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        });
        JLabel donate = comboLanguage.getSelectedItem().equals("Fran\u00e7ais") ? new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/donate_FR.png"))) : new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/donate_EN.png")));
        donate.setHorizontalAlignment(0);
        donate.setSize(donate.getPreferredSize());
        donate.setLocation((frame.getWidth() - donate.getWidth()) / 2 - 6, this.lblLanguage.getLocation().y + this.lblLanguage.getHeight() + 14);
        frame.getContentPane().add(donate);
        donate.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                try {
                    if (comboLanguage.getSelectedItem().equals("Fran\u00e7ais")) {
                        Desktop.getDesktop().browse(new URI("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=paulpacifico%40free.fr&item_name=Shutter+Encoder&currency_code=EUR"));
                    } else {
                        Desktop.getDesktop().browse(new URI("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=paulpacifico%40free.fr&item_name=Shutter+Encoder&currency_code=USD"));
                    }
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        Settings.readSettings();
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(Settings.frame.getSize().width - 24, 0, 21, 21);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Settings.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    Settings.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                    Utils.changeFrameVisibility(frame, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Settings.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Settings.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        this.reduce = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce2.png")));
        this.reduce.setHorizontalAlignment(0);
        this.reduce.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        this.reduce.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Settings.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    frame.setState(1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Settings.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Settings.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce2.png")));
                this.accept = false;
            }
        });
        this.help = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/help2.png")));
        this.help.setHorizontalAlignment(0);
        this.help.setBounds(this.reduce.getLocation().x - 21, 0, 21, 21);
        this.topPanel.add(this.help);
        this.help.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Settings.this.help.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/help3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://www.shutterencoder.com/documentation.html#Settings-icon"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Settings.this.help.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/help.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Settings.this.help.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/help2.png")));
                this.accept = false;
            }
        });
        this.topPanel.add(this.quit);
        this.topPanel.add(this.reduce);
        this.topPanel.add(this.help);
        this.topPanel.setBounds(0, 0, frame.getWidth(), 44);
        JLabel title = new JLabel(Shutter.language.getProperty("frameSettings"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 44);
        title.setFont(new Font("Magneto", 0, 26));
        this.topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.topPanel.add(this.topImage);
        frame.getContentPane().add(this.topPanel);
        this.topImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.topImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public static void readSettings() {
        try {
            if (settingsXML.exists()) {
                File fXmlFile = settingsXML;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(fXmlFile);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("Component");
                int temp = 0;
                while (temp < nList.getLength()) {
                    Node nNode = nList.item(temp);
                    if (nNode.getNodeType() == 1) {
                        Element eElement = (Element)nNode;
                        Component[] componentArray = frame.getContentPane().getComponents();
                        int n = componentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component p = componentArray[n2];
                            if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                if (p instanceof JPanel) {
                                    String[] s = eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().replace("]", "").replace("r=", "").replace("g=", "").replace("b=", "").split("\\[");
                                    String[] s2 = s[1].split(",");
                                    ((JPanel)p).setBackground(new Color(Integer.valueOf(s2[0]), Integer.valueOf(s2[1]), Integer.valueOf(s2[2])));
                                    if (p.getName().equals("accentColor")) {
                                        Utils.themeColor = accentColor.getBackground();
                                    }
                                } else if (p instanceof JRadioButton) {
                                    if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                        if (!((JRadioButton)p).isSelected()) {
                                            ((JRadioButton)p).doClick();
                                        }
                                    } else if (((JRadioButton)p).isSelected()) {
                                        ((JRadioButton)p).doClick();
                                    }
                                    ((JRadioButton)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                    ((JRadioButton)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                } else if (p instanceof JLabel) {
                                    ((JLabel)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    ((JLabel)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                    ((JLabel)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                } else if (p instanceof JComboBox) {
                                    if (p.getName().equals(comboTheme.getName())) {
                                        if (eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().equals(Shutter.language.getProperty("clearTheme"))) {
                                            ((JComboBox)p).setSelectedIndex(0);
                                        } else if (eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().equals(Shutter.language.getProperty("darkTheme"))) {
                                            ((JComboBox)p).setSelectedIndex(1);
                                        } else {
                                            ((JComboBox)p).setSelectedIndex(Integer.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()));
                                        }
                                    } else {
                                        ((JComboBox)p).setSelectedItem(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    }
                                    ((JComboBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                    ((JComboBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                } else if (p instanceof JTextField) {
                                    ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                    ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                }
                            }
                            ++n2;
                        }
                        if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("sliderVolume")) {
                            videoPlayerVolume = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                        }
                    }
                    ++temp;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveSettings() {
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element root = document.createElement("Settings");
            document.appendChild(root);
            Component[] componentArray = frame.getContentPane().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component p = componentArray[n2];
                if (p.getName() != "" && p.getName() != null) {
                    Element cVisible;
                    Element cState;
                    Element cValue;
                    Element cName;
                    Element cType;
                    Element component;
                    if (p instanceof JRadioButton) {
                        component = document.createElement("Component");
                        cType = document.createElement("Type");
                        cType.appendChild(document.createTextNode("JRadioButton"));
                        component.appendChild(cType);
                        cName = document.createElement("Name");
                        cName.appendChild(document.createTextNode(p.getName()));
                        component.appendChild(cName);
                        cValue = document.createElement("Value");
                        cValue.appendChild(document.createTextNode(String.valueOf(((JRadioButton)p).isSelected())));
                        component.appendChild(cValue);
                        cState = document.createElement("Enable");
                        cState.appendChild(document.createTextNode(String.valueOf(p.isEnabled())));
                        component.appendChild(cState);
                        cVisible = document.createElement("Visible");
                        cVisible.appendChild(document.createTextNode(String.valueOf(p.isVisible())));
                        component.appendChild(cVisible);
                        root.appendChild(component);
                    } else if (p instanceof JLabel) {
                        component = document.createElement("Component");
                        cType = document.createElement("Type");
                        cType.appendChild(document.createTextNode("JLabel"));
                        component.appendChild(cType);
                        cName = document.createElement("Name");
                        cName.appendChild(document.createTextNode(p.getName()));
                        component.appendChild(cName);
                        cValue = document.createElement("Value");
                        cValue.appendChild(document.createTextNode(((JLabel)p).getText()));
                        component.appendChild(cValue);
                        cState = document.createElement("Enable");
                        cState.appendChild(document.createTextNode(String.valueOf(p.isEnabled())));
                        component.appendChild(cState);
                        cVisible = document.createElement("Visible");
                        cVisible.appendChild(document.createTextNode(String.valueOf(p.isVisible())));
                        component.appendChild(cVisible);
                        root.appendChild(component);
                    } else if (p instanceof JComboBox) {
                        component = document.createElement("Component");
                        cType = document.createElement("Type");
                        cType.appendChild(document.createTextNode("JComboBox"));
                        component.appendChild(cType);
                        cName = document.createElement("Name");
                        cName.appendChild(document.createTextNode(p.getName()));
                        component.appendChild(cName);
                        cValue = document.createElement("Value");
                        if (p.getName().equals(comboTheme.getName())) {
                            cValue.appendChild(document.createTextNode(String.valueOf(((JComboBox)p).getSelectedIndex())));
                        } else {
                            cValue.appendChild(document.createTextNode(((JComboBox)p).getSelectedItem().toString()));
                        }
                        component.appendChild(cValue);
                        cState = document.createElement("Enable");
                        cState.appendChild(document.createTextNode(String.valueOf(p.isEnabled())));
                        component.appendChild(cState);
                        cVisible = document.createElement("Visible");
                        cVisible.appendChild(document.createTextNode(String.valueOf(p.isVisible())));
                        component.appendChild(cVisible);
                        root.appendChild(component);
                    } else if (p instanceof JTextField && ((JTextField)p).getText().length() > 0) {
                        component = document.createElement("Component");
                        cType = document.createElement("Type");
                        cType.appendChild(document.createTextNode("JTextField"));
                        component.appendChild(cType);
                        cName = document.createElement("Name");
                        cName.appendChild(document.createTextNode(p.getName()));
                        component.appendChild(cName);
                        cValue = document.createElement("Value");
                        cValue.appendChild(document.createTextNode(((JTextField)p).getText().toString()));
                        component.appendChild(cValue);
                        cState = document.createElement("Enable");
                        cState.appendChild(document.createTextNode(String.valueOf(p.isEnabled())));
                        component.appendChild(cState);
                        cVisible = document.createElement("Visible");
                        cVisible.appendChild(document.createTextNode(String.valueOf(p.isVisible())));
                        component.appendChild(cVisible);
                        root.appendChild(component);
                    } else if (p instanceof JPanel) {
                        component = document.createElement("Component");
                        cType = document.createElement("Type");
                        cType.appendChild(document.createTextNode("JPanel"));
                        component.appendChild(cType);
                        cName = document.createElement("Name");
                        cName.appendChild(document.createTextNode(p.getName()));
                        component.appendChild(cName);
                        cValue = document.createElement("Value");
                        cValue.appendChild(document.createTextNode(String.valueOf(((JPanel)p).getBackground())));
                        component.appendChild(cValue);
                        cState = document.createElement("Enable");
                        cState.appendChild(document.createTextNode(String.valueOf(p.isEnabled())));
                        component.appendChild(cState);
                        cVisible = document.createElement("Visible");
                        cVisible.appendChild(document.createTextNode(String.valueOf(p.isVisible())));
                        component.appendChild(cVisible);
                        root.appendChild(component);
                    }
                }
                ++n2;
            }
            Element component = document.createElement("Component");
            Element cType = document.createElement("Type");
            cType.appendChild(document.createTextNode("JSlider"));
            component.appendChild(cType);
            Element cName = document.createElement("Name");
            cName.appendChild(document.createTextNode("sliderVolume"));
            component.appendChild(cName);
            Element cValue = document.createElement("Value");
            if (VideoPlayer.sliderVolume != null) {
                cValue.appendChild(document.createTextNode(String.valueOf(VideoPlayer.sliderVolume.getValue())));
            } else {
                cValue.appendChild(document.createTextNode(String.valueOf(videoPlayerVolume)));
            }
            component.appendChild(cValue);
            root.appendChild(component);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(settingsXML);
            transformer.transform(domSource, streamResult);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }
}

