/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import library.FFMPEG;
import library.FFPROBE;

public class SceneDetection {
    public static JFrame frame;
    private static JPanel topPanel;
    private boolean drag;
    private JLabel quit;
    private JLabel reduce;
    private JLabel topImage;
    private JLabel bottomImage;
    private static JLabel lblFlecheBas;
    private static JButton btnEDL;
    private static JButton btnExport;
    public static JLabel lblEdit;
    public static JTable table;
    public static DefaultTableModel tableRow;
    private static JSpinner tolerance;
    public static JButton btnAnalyse;
    public static JScrollPane scrollPane;
    public static File sortieDossier;
    public static File sortieFichier;
    public static boolean isRunning;
    private static StringBuilder errorList;
    private static int complete;

    static {
        isRunning = false;
        errorList = new StringBuilder();
    }

    public SceneDetection(boolean runAnalyse) {
        frame = new JFrame();
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameDetectionCoupe"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(400, 600);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            frame.setLocation(Shutter.frame.getLocation().x - SceneDetection.frame.getSize().width - 20, Shutter.frame.getLocation().y);
        }
        this.topPanel();
        this.contenu();
        this.drag = false;
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SceneDetection.this.drag && SceneDetection.frame.getSize().height > 90) {
                    frame.setSize(SceneDetection.frame.getSize().width, e.getY() + 10);
                    scrollPane.setSize(SceneDetection.scrollPane.getSize().width, SceneDetection.frame.getSize().height - 160);
                    lblFlecheBas.setLocation(0, SceneDetection.frame.getSize().height - SceneDetection.lblFlecheBas.getSize().height);
                    btnEDL.setBounds(9, 89 + scrollPane.getHeight() + 4, 186, 21);
                    btnExport.setBounds(204, 89 + scrollPane.getHeight() + 4, 186, 21);
                    lblEdit.setBounds(frame.getWidth() / 2 - 119, 89 + scrollPane.getHeight() + 32, 245, 15);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseInfo.getPointerInfo().getLocation().y - SceneDetection.frame.getLocation().y > SceneDetection.frame.getSize().height - 20) {
                    frame.setCursor(Cursor.getPredefinedCursor(9));
                } else if (!SceneDetection.this.drag) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor().getType() == 9) {
                    SceneDetection.this.drag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SceneDetection.this.drag = false;
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SceneDetection.frame.getSize().height <= 90) {
                    frame.setSize(SceneDetection.frame.getSize().width, 100);
                    lblFlecheBas.setLocation(0, SceneDetection.frame.getSize().height - SceneDetection.lblFlecheBas.getSize().height);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (frame.getCursor().getType() == 9) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent we) {
                frame.toFront();
            }
        });
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                shape1.add(shape2);
                frame.setShape(shape1);
            }
        });
        Utils.changeFrameVisibility(frame, false);
        if (runAnalyse) {
            btnAnalyse.doClick();
        }
    }

    private void topPanel() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBounds(0, 0, SceneDetection.frame.getSize().width, 51);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setBounds(SceneDetection.frame.getSize().width - 24, 0, 21, 21);
        ImageIcon image = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        Image scaledImage = image.getImage().getScaledInstance(SceneDetection.topPanel.getSize().width, SceneDetection.topPanel.getSize().height, 4);
        ImageIcon header = new ImageIcon(scaledImage);
        this.bottomImage = new JLabel(header);
        this.bottomImage.setBounds(0, 0, SceneDetection.frame.getSize().width, 51);
        JLabel title = new JLabel(Shutter.language.getProperty("frameDetectionCoupe"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 52);
        title.setFont(new Font("Magneto", 0, 26));
        topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(SceneDetection.topPanel.getSize().width, SceneDetection.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.reduce = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce2.png")));
        this.reduce.setHorizontalAlignment(0);
        this.reduce.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        this.reduce.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SceneDetection.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    frame.setState(1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SceneDetection.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SceneDetection.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce2.png")));
                this.accept = false;
            }
        });
        topPanel.add(this.quit);
        topPanel.add(this.reduce);
        topPanel.add(this.topImage);
        topPanel.add(this.bottomImage);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SceneDetection.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    if (FFMPEG.runProcess.isAlive()) {
                        Shutter.btnCancel.doClick();
                    }
                    if (!Shutter.btnCancel.isEnabled()) {
                        if (sortieDossier.exists()) {
                            SceneDetection.deleteDirectory(sortieDossier);
                        }
                        Utils.changeFrameVisibility(frame, true);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SceneDetection.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SceneDetection.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        topPanel.setBounds(0, 0, SceneDetection.frame.getSize().width, 51);
        frame.getContentPane().add(topPanel);
        this.bottomImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.bottomImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void contenu() {
        scrollPane = new JScrollPane();
        scrollPane.setBounds(9, 89, 380, SceneDetection.frame.getSize().height - 160);
        frame.getContentPane().add(scrollPane);
        JLabel lblPourcentage = new JLabel("%");
        lblPourcentage.setFont(new Font("FreeSans", 0, 12));
        lblPourcentage.setBounds(143, 63, 11, 15);
        frame.getContentPane().add(lblPourcentage);
        btnAnalyse = new JButton(Shutter.language.getProperty("btnAnalyse"));
        btnAnalyse.setFont(new Font("Montserrat", 0, 12));
        btnAnalyse.setBounds(164, 59, 223, 21);
        frame.getContentPane().add(btnAnalyse);
        btnAnalyse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                tolerance.setEnabled(false);
                btnAnalyse.setEnabled(false);
                btnEDL.setEnabled(false);
                btnExport.setEnabled(false);
                lblEdit.setVisible(false);
                if (sortieDossier != null && sortieDossier.exists()) {
                    SceneDetection.deleteDirectory(sortieDossier);
                }
                if (tableRow != null) {
                    tableRow.setRowCount(0);
                }
                SceneDetection.runAnalyse();
            }
        });
        JLabel lblSensibilit = new JLabel(Shutter.language.getProperty("lblSensibility"));
        lblSensibilit.setFont(new Font("FreeSans", 0, 12));
        lblSensibilit.setBounds(10, 62, 64, 15);
        frame.getContentPane().add(lblSensibilit);
        tolerance = new JSpinner(new SpinnerNumberModel(80, 0, 100, 10));
        tolerance.setBounds(86, 59, 55, 21);
        frame.getContentPane().add(tolerance);
        lblFlecheBas = new JLabel("\u25b2\u25bc");
        lblFlecheBas.setHorizontalAlignment(0);
        lblFlecheBas.setFont(new Font("FreeSans", 0, 20));
        lblFlecheBas.setSize(new Dimension(SceneDetection.frame.getSize().width, 20));
        lblFlecheBas.setLocation(0, SceneDetection.frame.getSize().height - SceneDetection.lblFlecheBas.getSize().height);
        lblFlecheBas.setVisible(true);
        frame.getContentPane().add(lblFlecheBas);
        btnEDL = new JButton(Shutter.language.getProperty("btnEDL"));
        btnEDL.setFont(new Font("Montserrat", 0, 12));
        btnEDL.setEnabled(false);
        btnEDL.setBounds(9, 89 + scrollPane.getHeight() + 4, 186, 21);
        frame.getContentPane().add(btnEDL);
        btnEDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                frame.setVisible(false);
                final FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("saveEDL"), 1);
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                } else {
                    dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                }
                dialog.setLocation(SceneDetection.frame.getLocation().x - 50, SceneDetection.frame.getLocation().y + 50);
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                frame.setCursor(Cursor.getPredefinedCursor(0));
                frame.setVisible(true);
                frame.toFront();
                if (dialog.getFile() != null) {
                    Thread runProcess = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PrintWriter writer = null;
                            try {
                                writer = new PrintWriter(String.valueOf(dialog.getDirectory()) + dialog.getFile().replace(".edl", "") + ".edl", "UTF-8");
                                DecimalFormat formatEDL = new DecimalFormat("000000");
                                writer.println("TITLE : " + dialog.getFile());
                                int countItemsEDL = 0;
                                int i = 0;
                                while (i < tableRow.getRowCount()) {
                                    int preTcOutVideo;
                                    int tcEndToMS;
                                    String timecodeStart = String.valueOf(tableRow.getValueAt(i, 2));
                                    String[] tcStart = timecodeStart.split(":");
                                    int tcStartToMs = (int)((float)(Integer.valueOf(tcStart[0]) * 3600000 + Integer.valueOf(tcStart[1]) * 60000 + Integer.valueOf(tcStart[2]) * 1000) + (float)Integer.valueOf(tcStart[3]).intValue() * (1000.0f / FFPROBE.currentFPS));
                                    DecimalFormat formatter = new DecimalFormat("00");
                                    String tcInTimeLine = String.valueOf(formatter.format(tcStartToMs / 3600000)) + ":" + formatter.format(tcStartToMs / 60000 % 60) + ":" + formatter.format(tcStartToMs / 1000 % 60) + ":" + formatter.format((int)((float)tcStartToMs / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS));
                                    int preTcMs = FFPROBE.timecode1 != "" && FFPROBE.timecode2 != "" && FFPROBE.timecode3 != "" && FFPROBE.timecode4 != "" ? (int)((float)(Integer.parseInt(FFPROBE.timecode1) * 3600000 + Integer.parseInt(FFPROBE.timecode2) * 60000 + Integer.parseInt(FFPROBE.timecode3) * 1000) + (float)Integer.parseInt(FFPROBE.timecode4) * (1000.0f / FFPROBE.currentFPS)) : 0;
                                    int preTcInVideo = (int)((float)(Integer.parseInt(tcStart[0]) * 3600000 + Integer.parseInt(tcStart[1]) * 60000 + Integer.parseInt(tcStart[2]) * 1000) + (float)Integer.parseInt(tcStart[3]) * (1000.0f / FFPROBE.currentFPS));
                                    int totalTcIn = preTcMs + preTcInVideo;
                                    String tcInVideo = String.valueOf(formatter.format(totalTcIn / 3600000)) + ":" + formatter.format(totalTcIn / 60000 % 60) + ":" + formatter.format(totalTcIn / 1000 % 60) + ":" + formatter.format((int)((float)totalTcIn / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS));
                                    if (i < tableRow.getRowCount() - 1) {
                                        String timecodeEnd = String.valueOf(tableRow.getValueAt(i + 1, 2));
                                        String[] tcEnd = timecodeEnd.split(":");
                                        tcEndToMS = (int)((float)(Integer.valueOf(tcEnd[0]) * 3600000 + Integer.valueOf(tcEnd[1]) * 60000 + Integer.valueOf(tcEnd[2]) * 1000) + (float)Integer.valueOf(tcEnd[3]).intValue() * (1000.0f / FFPROBE.currentFPS));
                                        preTcOutVideo = (int)((float)(Integer.parseInt(tcEnd[0]) * 3600000 + Integer.parseInt(tcEnd[1]) * 60000 + Integer.parseInt(tcEnd[2]) * 1000) + (float)Integer.parseInt(tcEnd[3]) * (1000.0f / FFPROBE.currentFPS));
                                    } else {
                                        String[] tc = FFPROBE.getVideoLengthTC.split(":");
                                        int h = Integer.valueOf(tc[0]) * 3600000;
                                        int m = Integer.valueOf(tc[1]) * 60000;
                                        int s = Integer.valueOf(tc[2]) * 1000;
                                        int f = Integer.valueOf(tc[3]) * 10;
                                        preTcOutVideo = tcEndToMS = h + m + s + f;
                                    }
                                    int totalTcOut = preTcMs + preTcOutVideo;
                                    String tcOutVideo = String.valueOf(formatter.format(totalTcOut / 3600000)) + ":" + formatter.format(totalTcOut / 60000 % 60) + ":" + formatter.format(totalTcOut / 1000 % 60) + ":" + formatter.format((int)((float)totalTcOut / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS));
                                    String tcOutTimeLine = String.valueOf(formatter.format(tcEndToMS / 3600000)) + ":" + formatter.format(tcEndToMS / 60000 % 60) + ":" + formatter.format(tcEndToMS / 1000 % 60) + ":" + formatter.format((int)((float)tcEndToMS / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS));
                                    String ext = sortieFichier.toString().substring(sortieFichier.toString().lastIndexOf("."));
                                    String cutName = i % 2 == 0 ? sortieFichier.toString().replace(" ", "_") : sortieFichier.toString().replace(" ", "_").replace(ext, "_" + Shutter.language.getProperty("cut") + ext);
                                    writer.println(String.valueOf(formatEDL.format(countItemsEDL + 1)) + "  " + cutName + " V     C        " + tcInVideo + " " + tcOutVideo + " " + tcInTimeLine + " " + tcOutTimeLine);
                                    writer.println(String.valueOf(formatEDL.format(countItemsEDL + 2)) + "  " + cutName + " A     C        " + tcInVideo + " " + tcOutVideo + " " + tcInTimeLine + " " + tcOutTimeLine);
                                    writer.println(String.valueOf(formatEDL.format(countItemsEDL + 3)) + "  " + cutName + " A2    C        " + tcInVideo + " " + tcOutVideo + " " + tcInTimeLine + " " + tcOutTimeLine);
                                    countItemsEDL += 3;
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                System.out.println(e);
                            }
                            writer.close();
                            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("fileCreated"), "EDL", 1);
                        }
                    });
                    runProcess.start();
                }
            }
        });
        btnExport = new JButton(Shutter.language.getProperty("btnExport"));
        btnExport.setFont(new Font("Montserrat", 0, 12));
        btnExport.setBounds(204, 89 + scrollPane.getHeight() + 4, 186, 21);
        btnExport.setEnabled(false);
        frame.getContentPane().add(btnExport);
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                frame.setVisible(false);
                FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseFileName"), 1);
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                } else {
                    dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                }
                dialog.setLocation(SceneDetection.frame.getLocation().x - 50, SceneDetection.frame.getLocation().y + 50);
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                frame.setCursor(Cursor.getPredefinedCursor(0));
                frame.setVisible(true);
                frame.toFront();
                if (dialog.getFile() != null) {
                    final File sortieFolder = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                    sortieFolder.mkdir();
                    Thread runProcess = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            isRunning = true;
                            int i = 0;
                            while (i < tableRow.getRowCount()) {
                                try {
                                    if (i == 0) {
                                        Utils.changeFrameVisibility(frame, true);
                                        Shutter.comboFonctions.setSelectedItem(Shutter.language.getProperty("functionCut"));
                                        Shutter.caseChangeFolder1.setSelected(true);
                                        Shutter.caseOpenFolderAtEnd1.setSelected(false);
                                        Shutter.lblDestination1.setText(sortieFolder.toString());
                                        Shutter.caseInAndOut.doClick();
                                        do {
                                            Thread.sleep(100L);
                                        } while (!VideoPlayer.frame.isVisible());
                                        VideoPlayer.frame.setVisible(false);
                                        do {
                                            Thread.sleep(100L);
                                        } while (!VideoPlayer.leftPlay.getText().equals(Shutter.language.getProperty("btnPause")));
                                        VideoPlayer.leftPlay.doClick();
                                    }
                                    String timecodeStart = String.valueOf(tableRow.getValueAt(i, 2));
                                    String[] tcStart = timecodeStart.split(":");
                                    int tcStartToMS = (int)((float)(Integer.valueOf(tcStart[0]) * 3600000 + Integer.valueOf(tcStart[1]) * 60000 + Integer.valueOf(tcStart[2]) * 1000) + (float)Integer.valueOf(tcStart[3]).intValue() * (1000.0f / FFPROBE.currentFPS));
                                    VideoPlayer.sliderIn.setValue(tcStartToMS);
                                    VideoPlayer.caseInH.setText(tcStart[0]);
                                    VideoPlayer.caseInM.setText(tcStart[1]);
                                    VideoPlayer.caseInS.setText(tcStart[2]);
                                    VideoPlayer.caseInF.setText(tcStart[3]);
                                    if (i < tableRow.getRowCount() - 1) {
                                        String timecodeEnd = String.valueOf(tableRow.getValueAt(i + 1, 2));
                                        String[] tcEnd = timecodeEnd.split(":");
                                        int tcEndToMS = (int)((float)(Integer.valueOf(tcEnd[0]) * 3600000 + Integer.valueOf(tcEnd[1]) * 60000 + Integer.valueOf(tcEnd[2]) * 1000) + (float)Integer.valueOf(tcEnd[3]).intValue() * (1000.0f / FFPROBE.currentFPS));
                                        VideoPlayer.sliderOut.setValue(tcEndToMS);
                                        VideoPlayer.caseOutH.setText(tcEnd[0]);
                                        VideoPlayer.caseOutM.setText(tcEnd[1]);
                                        VideoPlayer.caseOutS.setText(tcEnd[2]);
                                        VideoPlayer.caseOutF.setText(tcEnd[3]);
                                        VideoPlayer.totalDuration();
                                    } else {
                                        VideoPlayer.sliderOut.setValue(VideoPlayer.sliderOut.getMaximum());
                                    }
                                    Shutter.btnStart.doClick();
                                    do {
                                        Thread.sleep(100L);
                                    } while (Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnStartFunction")));
                                    do {
                                        Thread.sleep(100L);
                                    } while (!Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnStartFunction")));
                                }
                                catch (Exception timecodeStart) {
                                    // empty catch block
                                }
                                ++i;
                            }
                            isRunning = false;
                            int comboItem = 0;
                            while (comboItem < Shutter.comboFonctions.getModel().getSize()) {
                                Object element = Shutter.comboFonctions.getModel().getElementAt(comboItem);
                                if (element.toString().equals(Shutter.language.getProperty("functionSceneDetection"))) {
                                    Shutter.comboFonctions.setSelectedIndex(comboItem);
                                    break;
                                }
                                ++comboItem;
                            }
                            Utils.changeFrameVisibility(frame, false);
                            Shutter.caseInAndOut.setSelected(false);
                            if (VideoPlayer.mediaPlayerComponentLeft != null) {
                                VideoPlayer.mediaPlayerComponentLeft.getMediaPlayer().stop();
                            }
                            if (VideoPlayer.mediaPlayerComponentRight != null) {
                                VideoPlayer.mediaPlayerComponentRight.getMediaPlayer().stop();
                            }
                            VideoPlayer.frame.getContentPane().removeAll();
                        }
                    });
                    runProcess.start();
                }
            }
        });
        lblEdit = new JLabel(Shutter.language.getProperty("lblEdit"));
        lblEdit.setForeground(Utils.themeColor);
        lblEdit.setHorizontalAlignment(0);
        lblEdit.setFont(new Font("Montserrat", 0, 13));
        lblEdit.setBounds(frame.getWidth() / 2 - 119, 89 + scrollPane.getHeight() + 32, 245, 15);
        lblEdit.setVisible(false);
        frame.getContentPane().add(lblEdit);
    }

    private static void newTable() {
        ImageIcon imageIcon = new ImageIcon(String.valueOf(sortieDossier.toString()) + "/0.png");
        ImageIcon icon = new ImageIcon(imageIcon.getImage().getScaledInstance(142, 80, 1));
        Object[][] firstImage = new Object[][]{{"1", icon, "00:00:00:00"}};
        tableRow = new DefaultTableModel(firstImage, new String[]{"N\u00b0", "Plans", "Timecode"});
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        table = new JTable(tableRow){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        table.getColumnModel().getColumn(0).setCellRenderer(centerRenderer);
        table.getColumnModel().getColumn(2).setCellRenderer(centerRenderer);
        table.setShowVerticalLines(false);
        table.setSelectionMode(0);
        table.setRowHeight(80);
        table.getColumnModel().getColumn(0).setPreferredWidth(18);
        table.getColumnModel().getColumn(1).setPreferredWidth(table.getColumnModel().getColumn(1).getPreferredWidth());
        table.setBounds(9, 89, 380, frame.getHeight() - 134);
        scrollPane.setViewportView(table);
        table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(e.getKeyCode() != 127 && e.getKeyCode() != 8 || FFMPEG.isRunning || table.getSelectedRowCount() <= 0)) {
                    File imageToDelete = new File(String.valueOf(sortieDossier.toString()) + "/" + table.getSelectedRow() + ".png");
                    imageToDelete.delete();
                    int i = 0;
                    File[] fileArray = sortieDossier.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.toString().substring(file.toString().lastIndexOf(".")).equals(".png")) {
                            file.renameTo(new File(String.valueOf(sortieDossier.toString()) + "/" + i + ".png"));
                        }
                        ++i;
                        ++n2;
                    }
                    tableRow.removeRow(table.getSelectedRow());
                    int n3 = 0;
                    while (n3 < tableRow.getRowCount()) {
                        table.getModel().setValueAt(String.valueOf(n3 + 1), n3, 0);
                        ++n3;
                    }
                    table.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        final JPopupMenu popupListe = new JPopupMenu();
        JMenuItem visualiser = new JMenuItem(Shutter.language.getProperty("menuItemVisualiser"));
        JMenuItem ouvrirDossier = new JMenuItem(Shutter.language.getProperty("menuItemOuvrirDossier"));
        JMenuItem copieTimeCode = new JMenuItem(Shutter.language.getProperty("menuItemCopyTimecode"));
        visualiser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().open(new File(sortieDossier + "/" + table.getSelectedRow() + ".png"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        ouvrirDossier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().open(sortieDossier);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        copieTimeCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String timecode = tableRow.getValueAt(table.getSelectedRow(), 2).toString();
                StringSelection stringSelection = new StringSelection(timecode);
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }
        });
        popupListe.add(visualiser);
        popupListe.add(ouvrirDossier);
        popupListe.add(copieTimeCode);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1 && table.getSelectedRowCount() == 1) {
                    try {
                        Desktop.getDesktop().open(new File(sortieDossier + "/" + table.getSelectedRow() + ".png"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (e.getButton() == 3 || (e.getModifiersEx() & 0x80) == 2 && e.getButton() == 1) {
                    popupListe.show(table, e.getX() - 30, e.getY());
                }
            }
        });
    }

    public static void runAnalyse() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                complete = 0;
                Shutter.lblTermine.setText(Utils.completedFiles(complete));
                int i = 0;
                while (i < Shutter.liste.getSize()) {
                    File file = new File(Shutter.liste.getElementAt(i));
                    if (i > 0) {
                        new SceneDetection(false);
                    }
                    try {
                        FFPROBE.Data(file.toString());
                        do {
                            Thread.sleep(100L);
                        } while (FFPROBE.isRunning);
                        String fichier = file.getName();
                        Shutter.lblEncodageEnCours.setText(fichier);
                        String sortie = file.getParent();
                        String extension = fichier.substring(fichier.lastIndexOf("."));
                        sortieDossier = new File(String.valueOf(sortie) + "/" + fichier.replace(extension, ""));
                        sortieDossier.mkdir();
                        sortieFichier = new File(file.getName());
                        String cmd = " -f image2 -vframes 1 ";
                        FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd + "-y " + '\"' + sortieDossier.toString() + "/0.png" + '\"');
                        do {
                            Thread.sleep(100L);
                        } while (FFMPEG.runProcess.isAlive());
                        SceneDetection.newTable();
                        String tol = String.valueOf((float)(100 - Integer.valueOf(tolerance.getValue().toString())) / 100.0f);
                        cmd = " -vf select=\"gt(scene\\," + tol + ")" + '\"' + ",showinfo -vsync 2 -f image2 ";
                        FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd + "-y " + '\"' + sortieDossier.toString() + "/%01d.png" + '\"');
                        do {
                            Thread.sleep(100L);
                        } while (FFMPEG.runProcess.isAlive());
                        SceneDetection.actionsDeFin();
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (errorList.length() != 0) {
                    JOptionPane.showMessageDialog(Shutter.frame, String.valueOf(Shutter.language.getProperty("notProcessedFiles")) + " " + '\n' + '\n' + errorList.toString(), Shutter.language.getProperty("encodingError"), 0);
                }
                errorList.setLength(0);
                FFMPEG.enfOfFunction();
            }
        });
        thread.start();
    }

    private static void actionsDeFin() {
        if (FFMPEG.error) {
            errorList.append(System.lineSeparator());
        }
        if (!FFMPEG.cancelled && !FFMPEG.error) {
            Shutter.lblTermine.setText(Utils.completedFiles(++complete));
        }
        tolerance.setEnabled(true);
        btnAnalyse.setEnabled(true);
        btnEDL.setEnabled(true);
        btnExport.setEnabled(true);
        lblEdit.setVisible(true);
    }

    public static boolean deleteDirectory(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        String[] files = dir.list();
        int i = 0;
        int len = files.length;
        while (i < len) {
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                SceneDetection.deleteDirectory(f);
            } else {
                f.delete();
            }
            ++i;
        }
        return dir.delete();
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }
}

