/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.Normalizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Renamer {
    public static JDialog frame;
    private JLabel lblRemplacer;
    private JTextField txtRemplacer;
    private JLabel lblPar;
    private JTextField txtPar;
    private JButton Renommer;
    private JLabel lblExemple;
    private JRadioButton btnLimit;
    private JSpinner spinnerLimit;
    private JRadioButton btnIncrementer;
    private JSpinner spinnerIncrementer;
    private JRadioButton btnAjouterAvant;
    private JTextField txtAjouterAvant;
    private JRadioButton btnAjouterApres;
    private JTextField txtAjouterApres;
    private JRadioButton convertToLower;
    private JRadioButton convertToUpper;
    private JRadioButton removeSpecialCharacters;
    private static StringBuilder errorList;
    private String fichier;
    private String ext;

    public Renamer() {
        frame = new JDialog();
        frame.getContentPane().setLayout(null);
        frame.setResizable(false);
        frame.setModal(true);
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
            frame.setSize(511, 153);
        } else {
            frame.setSize(521, 163);
        }
        frame.setTitle(Shutter.language.getProperty("frameRenommage"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.setDefaultCloseOperation(2);
        frame.setLocation(Shutter.frame.getLocation().x - 85, Shutter.frame.getLocation().y + 200);
        String fullName = new File(Shutter.fileList.getSelectedValuesList().get(0)).getName();
        this.ext = fullName.substring(fullName.lastIndexOf("."));
        this.fichier = new File(fullName).getName().replace(this.ext, "");
        this.btnLimit = new JRadioButton(Shutter.language.getProperty("btnLimit"));
        this.btnLimit.setFont(new Font("FreeSans", 0, 12));
        this.btnLimit.setBounds(7, 12, 211, 16);
        frame.getContentPane().add(this.btnLimit);
        this.btnLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.btnLimit.isSelected()) {
                    Renamer.this.spinnerLimit.setEnabled(true);
                } else {
                    Renamer.this.spinnerLimit.setEnabled(false);
                }
            }
        });
        this.spinnerLimit = new JSpinner(new SpinnerNumberModel(this.fichier.length(), 1, this.fichier.length(), 1));
        this.spinnerLimit.setFont(new Font("FreeSans", 0, 11));
        this.spinnerLimit.setEnabled(false);
        this.spinnerLimit.setBounds(226, 10, 46, 20);
        frame.getContentPane().add(this.spinnerLimit);
        this.btnIncrementer = new JRadioButton(Shutter.language.getProperty("btnIncrementer"));
        this.btnIncrementer.setFont(new Font("FreeSans", 0, 12));
        this.btnIncrementer.setBounds(7, 34, this.btnIncrementer.getPreferredSize().width, 16);
        frame.getContentPane().add(this.btnIncrementer);
        this.btnIncrementer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.btnIncrementer.isSelected()) {
                    Renamer.this.spinnerIncrementer.setEnabled(true);
                } else {
                    Renamer.this.spinnerIncrementer.setEnabled(false);
                }
            }
        });
        this.spinnerIncrementer = new JSpinner(new SpinnerNumberModel(0, 0, 99999999, 1));
        this.spinnerIncrementer.setFont(new Font("FreeSans", 0, 11));
        this.spinnerIncrementer.setEnabled(false);
        this.spinnerIncrementer.setBounds(166, 33, 106, 20);
        frame.getContentPane().add(this.spinnerIncrementer);
        this.lblRemplacer = new JLabel(Shutter.language.getProperty("lblRemplacer"));
        this.lblRemplacer.setFont(new Font("FreeSans", 0, 12));
        this.lblRemplacer.setBounds(12, 80, 70, 14);
        frame.getContentPane().add(this.lblRemplacer);
        this.txtRemplacer = new JTextField();
        this.txtRemplacer.setColumns(10);
        this.txtRemplacer.setFont(new Font("SansSerif", 0, 12));
        this.txtRemplacer.setBounds(84, 77, 135, 21);
        frame.getContentPane().add(this.txtRemplacer);
        this.lblPar = new JLabel(Shutter.language.getProperty("lblPar"));
        this.lblPar.setFont(new Font("FreeSans", 0, 12));
        this.lblPar.setBounds(226, 80, 29, 14);
        frame.getContentPane().add(this.lblPar);
        this.txtPar = new JTextField();
        this.txtPar.setColumns(10);
        this.txtPar.setFont(new Font("SansSerif", 0, 12));
        this.txtPar.setBounds(257, 77, this.txtRemplacer.getWidth(), 21);
        frame.getContentPane().add(this.txtPar);
        this.lblExemple = new JLabel(String.valueOf(Shutter.language.getProperty("lblExemple")) + " " + this.fichier + this.ext);
        this.lblExemple.setForeground(Utils.themeColor);
        this.lblExemple.setFont(new Font("SansSerif", 0, 12));
        this.lblExemple.setBounds(12, 104, 481, 14);
        frame.getContentPane().add(this.lblExemple);
        this.Renommer = new JButton(Shutter.language.getProperty("renommer"));
        this.Renommer.setBounds(400, 77, 98, 21);
        this.Renommer.setMargin(new Insets(0, 0, 0, 0));
        this.Renommer.setFont(new Font("Montserrat", 0, 12));
        frame.getContentPane().add(this.Renommer);
        this.btnAjouterAvant = new JRadioButton(Shutter.language.getProperty("btnAjouterAvant"));
        this.btnAjouterAvant.setFont(new Font("FreeSans", 0, 12));
        this.btnAjouterAvant.setBounds(280, 12, 115, 16);
        frame.getContentPane().add(this.btnAjouterAvant);
        this.btnAjouterAvant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.btnAjouterAvant.isSelected()) {
                    Renamer.this.txtAjouterAvant.setEnabled(true);
                } else {
                    Renamer.this.txtAjouterAvant.setEnabled(false);
                }
            }
        });
        this.txtAjouterAvant = new JTextField();
        this.txtAjouterAvant.setEnabled(false);
        this.txtAjouterAvant.setFont(new Font("SansSerif", 0, 12));
        this.txtAjouterAvant.setColumns(10);
        this.txtAjouterAvant.setBounds(390, 10, 108, 21);
        frame.getContentPane().add(this.txtAjouterAvant);
        this.btnAjouterApres = new JRadioButton(Shutter.language.getProperty("btnAjouterApres"));
        this.btnAjouterApres.setFont(new Font("FreeSans", 0, 12));
        this.btnAjouterApres.setBounds(280, 34, 115, 16);
        frame.getContentPane().add(this.btnAjouterApres);
        this.btnAjouterApres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.btnAjouterApres.isSelected()) {
                    Renamer.this.txtAjouterApres.setEnabled(true);
                } else {
                    Renamer.this.txtAjouterApres.setEnabled(false);
                }
            }
        });
        this.txtAjouterApres = new JTextField();
        this.txtAjouterApres.setEnabled(false);
        this.txtAjouterApres.setFont(new Font("SansSerif", 0, 12));
        this.txtAjouterApres.setColumns(10);
        this.txtAjouterApres.setBounds(390, 32, 108, 21);
        frame.getContentPane().add(this.txtAjouterApres);
        this.convertToLower = new JRadioButton(Shutter.language.getProperty("convertToLower"));
        this.convertToLower.setFont(new Font("FreeSans", 0, 12));
        this.convertToLower.setBounds(7, 57, this.convertToLower.getPreferredSize().width, 16);
        frame.getContentPane().add(this.convertToLower);
        this.convertToLower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.convertToLower.isSelected()) {
                    Renamer.this.convertToUpper.setSelected(false);
                }
                Renamer.this.update();
            }
        });
        this.convertToUpper = new JRadioButton(Shutter.language.getProperty("convertToUpper"));
        this.convertToUpper.setFont(new Font("FreeSans", 0, 12));
        this.convertToUpper.setBounds(this.convertToLower.getWidth() + this.convertToLower.getLocation().x + 7, 57, this.convertToUpper.getPreferredSize().width, 16);
        frame.getContentPane().add(this.convertToUpper);
        this.convertToUpper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.convertToUpper.isSelected()) {
                    Renamer.this.convertToLower.setSelected(false);
                }
                Renamer.this.update();
            }
        });
        this.removeSpecialCharacters = new JRadioButton(Shutter.language.getProperty("removeSpecialCharacters"));
        this.removeSpecialCharacters.setFont(new Font("FreeSans", 0, 12));
        this.removeSpecialCharacters.setBounds(this.convertToUpper.getWidth() + this.convertToUpper.getLocation().x + 7, 57, this.removeSpecialCharacters.getPreferredSize().width, 16);
        frame.getContentPane().add(this.removeSpecialCharacters);
        this.removeSpecialCharacters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Renamer.this.update();
            }
        });
        KeyAdapter key = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                Renamer.this.update();
            }
        };
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Renamer.this.update();
            }
        };
        ChangeListener change = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Renamer.this.update();
            }
        };
        this.txtRemplacer.addKeyListener(key);
        this.txtPar.addKeyListener(key);
        this.txtAjouterAvant.addKeyListener(key);
        this.txtAjouterApres.addKeyListener(key);
        this.btnAjouterAvant.addActionListener(action);
        this.btnAjouterApres.addActionListener(action);
        this.btnIncrementer.addActionListener(action);
        this.btnLimit.addActionListener(action);
        this.spinnerLimit.addChangeListener(change);
        this.spinnerIncrementer.addChangeListener(change);
        this.Renommer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                errorList = new StringBuilder();
                String count = String.valueOf(Shutter.fileList.getSelectedIndices().length);
                String format = "";
                int i = 0;
                while (i < count.length()) {
                    format = String.valueOf(format) + "0";
                    ++i;
                }
                final DecimalFormat formatter = new DecimalFormat(format);
                Thread rename = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int number = (Integer)(this).Renamer.this.spinnerIncrementer.getValue();
                        block0: for (String item : Shutter.fileList.getSelectedValuesList()) {
                            (this).Renamer.this.ext = item.substring(item.lastIndexOf("."));
                            (this).Renamer.this.fichier = new File(item).getName().replace((this).Renamer.this.ext, "");
                            String newName = (this).Renamer.this.btnLimit.isSelected() ? (this).Renamer.this.fichier.replace((this).Renamer.this.txtRemplacer.getText(), (this).Renamer.this.txtPar.getText()).substring(0, (Integer)(this).Renamer.this.spinnerLimit.getValue()) : (this).Renamer.this.fichier.replace((this).Renamer.this.txtRemplacer.getText(), (this).Renamer.this.txtPar.getText());
                            if ((this).Renamer.this.btnAjouterAvant.isSelected()) {
                                newName = String.valueOf((this).Renamer.this.txtAjouterAvant.getText()) + newName;
                            }
                            if ((this).Renamer.this.btnAjouterApres.isSelected()) {
                                newName = String.valueOf(newName) + (this).Renamer.this.txtAjouterApres.getText();
                            }
                            if ((this).Renamer.this.btnIncrementer.isSelected()) {
                                newName = String.valueOf(newName) + formatter.format(number);
                            }
                            if ((this).Renamer.this.convertToLower.isSelected()) {
                                newName = newName.toLowerCase();
                            }
                            if ((this).Renamer.this.convertToUpper.isSelected()) {
                                newName = newName.toUpperCase();
                            }
                            if ((this).Renamer.this.removeSpecialCharacters.isSelected()) {
                                newName = Normalizer.normalize(newName, Normalizer.Form.NFD).replace(" ", "_").replaceAll("[^\\w\\s]+", "");
                            }
                            newName = String.valueOf(newName) + (this).Renamer.this.ext;
                            ++number;
                            File file = new File(item);
                            File newFile = new File(String.valueOf(file.getParent()) + "/" + newName);
                            if (newFile.exists() && !(this).Renamer.this.convertToLower.isSelected() && !(this).Renamer.this.convertToUpper.isSelected()) {
                                if (file.toString().equals(newFile.toString())) continue;
                                errorList.append(file.getName());
                                errorList.append(System.lineSeparator());
                                continue;
                            }
                            file.renameTo(newFile);
                            (this).Renamer.this.lblExemple.setText(newFile.getName());
                            int i = 0;
                            while (i < Shutter.liste.getSize()) {
                                if (Shutter.liste.getElementAt(i).equals(item)) {
                                    Shutter.liste.add(i, newFile.toString());
                                    Shutter.liste.remove(i + 1);
                                    continue block0;
                                }
                                ++i;
                            }
                        }
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        if (errorList.length() != 0) {
                            JOptionPane.showMessageDialog(Shutter.frame, String.valueOf(Shutter.language.getProperty("notProcessedFiles")) + " " + '\n' + '\n' + errorList.toString(), Shutter.language.getProperty("filesAlreadyExists"), 1);
                        }
                        errorList.setLength(0);
                        Shutter.lblFichiers.setText(Utils.filesNumber());
                        frame.dispose();
                    }
                });
                rename.start();
            }
        });
        frame.setVisible(true);
    }

    private void update() {
        String count = String.valueOf(Shutter.fileList.getSelectedIndices().length);
        String format = "";
        int i = 0;
        while (i < count.length()) {
            format = String.valueOf(format) + "0";
            ++i;
        }
        DecimalFormat formatter = new DecimalFormat(format);
        String exemple = String.valueOf(Shutter.language.getProperty("lblExemple")) + " ";
        if (this.btnLimit.isSelected()) {
            this.lblExemple.setText(this.fichier.replace(this.txtRemplacer.getText(), this.txtPar.getText()).substring(0, (Integer)this.spinnerLimit.getValue()));
        } else {
            this.lblExemple.setText(this.fichier.replace(this.txtRemplacer.getText(), this.txtPar.getText()));
        }
        if (this.btnAjouterAvant.isSelected()) {
            this.lblExemple.setText(String.valueOf(this.txtAjouterAvant.getText()) + this.lblExemple.getText());
        }
        if (this.btnAjouterApres.isSelected()) {
            this.lblExemple.setText(String.valueOf(this.lblExemple.getText()) + this.txtAjouterApres.getText());
        }
        if (this.btnIncrementer.isSelected()) {
            this.lblExemple.setText(String.valueOf(this.lblExemple.getText()) + formatter.format(this.spinnerIncrementer.getValue()));
        }
        if (this.convertToLower.isSelected()) {
            this.lblExemple.setText(this.lblExemple.getText().toLowerCase());
        }
        if (this.convertToUpper.isSelected()) {
            this.lblExemple.setText(this.lblExemple.getText().toUpperCase());
        }
        if (this.removeSpecialCharacters.isSelected()) {
            this.lblExemple.setText(Normalizer.normalize(this.lblExemple.getText(), Normalizer.Form.NFD).replace(" ", "_").replaceAll("[^\\w\\s]+", ""));
        }
        this.lblExemple.setText(String.valueOf(exemple) + this.lblExemple.getText());
        this.lblExemple.setText(String.valueOf(this.lblExemple.getText()) + this.ext);
    }
}

