/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ColorImage;
import application.CropImage;
import application.CropVideo;
import application.OverlayWindow;
import application.Settings;
import application.Shutter;
import application.SubtitlesWindow;
import application.Utils;
import application.WatermarkWindow;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import library.FFMPEG;
import library.FFPROBE;

public class RecordInputDevice {
    public static JDialog frame;
    static JComboBox<String> comboScreenVideo;
    static JComboBox<String> comboScreenAudio;
    static JComboBox<String> comboInputVideo;
    static JComboBox<String> comboInputAudio;
    public static Integer videoDeviceIndex;
    public static Integer audioDeviceIndex;
    public static Integer overlayAudioDeviceIndex;
    public static Integer screenWidth;
    public static Integer screenHeigth;
    public static String inputDeviceResolution;

    static {
        videoDeviceIndex = 0;
        audioDeviceIndex = -1;
        overlayAudioDeviceIndex = -1;
        screenWidth = 0;
        screenHeigth = 0;
        inputDeviceResolution = "";
    }

    public RecordInputDevice() {
        frame = new JDialog();
        frame.getContentPane().setLayout(null);
        frame.setResizable(false);
        frame.setModal(true);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.setSize(350, 210);
        } else {
            frame.setSize(330, 130);
        }
        frame.setTitle(Shutter.language.getProperty("menuItemInputDevice"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.setDefaultCloseOperation(2);
        frame.setLocation(Shutter.frame.getLocation().x + Shutter.frame.getWidth() / 2 - frame.getWidth() / 2, Shutter.frame.getLocation().y + Shutter.frame.getHeight() / 3 - frame.getHeight() / 2);
        RecordInputDevice.devices();
        frame.setVisible(true);
    }

    private static void devices() {
        JLabel screenVideo = new JLabel(String.valueOf(Shutter.language.getProperty("video")) + Shutter.language.getProperty("colon"));
        screenVideo.setFont(new Font("FreeSans", 0, 12));
        screenVideo.setBounds(12, 12, 40, 14);
        frame.getContentPane().add(screenVideo);
        String[] firstInput = new String[FFMPEG.videoDevices.toString().split(":").length];
        int i = 0;
        String[] stringArray = FFMPEG.videoDevices.toString().split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String videoDevice = stringArray[n2];
            firstInput[i] = videoDevice.replace(Shutter.language.getProperty("noVideo"), "Capture.current.screen");
            ++i;
            ++n2;
        }
        comboScreenVideo = new JComboBox<String>(firstInput);
        comboScreenVideo.setFont(new Font("FreeSans", 0, 10));
        comboScreenVideo.setEditable(false);
        comboScreenVideo.setMaximumRowCount(20);
        comboScreenVideo.setLocation(screenVideo.getX() + screenVideo.getWidth() + 4, screenVideo.getLocation().y - 3);
        if (System.getProperty("os.name").contains("Windows")) {
            comboScreenVideo.setSize(frame.getWidth() - screenVideo.getX() - screenVideo.getWidth() - 32, 22);
        } else {
            comboScreenVideo.setSize(frame.getWidth() - screenVideo.getX() - screenVideo.getWidth() - 22, 22);
        }
        frame.getContentPane().add(comboScreenVideo);
        comboScreenVideo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!comboScreenVideo.getSelectedItem().equals("Capture.current.screen")) {
                    comboInputVideo.setEnabled(false);
                    comboInputVideo.setSelectedIndex(0);
                    comboInputAudio.setEnabled(false);
                    comboInputAudio.setSelectedIndex(0);
                } else {
                    if (comboScreenAudio.getSelectedIndex() > 0) {
                        comboInputAudio.setEnabled(true);
                    }
                    comboInputVideo.setEnabled(true);
                }
            }
        });
        JLabel screenAudio = new JLabel(String.valueOf(Shutter.language.getProperty("audio")) + Shutter.language.getProperty("colon"));
        screenAudio.setFont(new Font("FreeSans", 0, 12));
        screenAudio.setBounds(12, screenVideo.getY() + screenVideo.getHeight() + 14, 40, 14);
        frame.getContentPane().add(screenAudio);
        comboScreenAudio = new JComboBox<String>(FFMPEG.audioDevices.toString().split(":"));
        comboScreenAudio.setFont(new Font("FreeSans", 0, 10));
        comboScreenAudio.setEditable(false);
        comboScreenAudio.setMaximumRowCount(20);
        comboScreenAudio.setBounds(comboScreenVideo.getX(), screenAudio.getLocation().y - 3, comboScreenVideo.getWidth(), 22);
        frame.getContentPane().add(comboScreenAudio);
        comboScreenAudio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (comboScreenAudio.getSelectedIndex() == 0 || !comboScreenVideo.getSelectedItem().equals("Capture.current.screen")) {
                    comboInputAudio.setEnabled(false);
                    comboInputAudio.setSelectedIndex(0);
                } else {
                    comboInputAudio.setEnabled(true);
                }
                if (comboScreenAudio.getSelectedIndex() >= 0 && System.getProperty("os.name").contains("Mac")) {
                    try {
                        String pathToSwitchAudioSource = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        pathToSwitchAudioSource = pathToSwitchAudioSource.substring(0, pathToSwitchAudioSource.length() - 1);
                        pathToSwitchAudioSource = String.valueOf(pathToSwitchAudioSource.substring(0, pathToSwitchAudioSource.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/SwitchAudioSource";
                        ProcessBuilder switchAudioSource = new ProcessBuilder("/bin/bash", "-c", String.valueOf(pathToSwitchAudioSource) + " -t input -s " + '\"' + comboScreenAudio.getSelectedItem().toString() + '\"');
                        switchAudioSource.start();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        JLabel inputVideo = new JLabel(String.valueOf(Shutter.language.getProperty("video")) + Shutter.language.getProperty("colon"));
        inputVideo.setFont(new Font("FreeSans", 0, 12));
        inputVideo.setBounds(12, screenAudio.getY() + screenAudio.getHeight() + 25, 40, 14);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(inputVideo);
        }
        comboInputVideo = new JComboBox<String>(FFMPEG.videoDevices.toString().split(":"));
        comboInputVideo.setFont(new Font("FreeSans", 0, 10));
        comboInputVideo.setEditable(false);
        comboInputVideo.setEnabled(true);
        comboInputVideo.setMaximumRowCount(20);
        comboInputVideo.setBounds(comboScreenVideo.getX(), inputVideo.getLocation().y - 3, comboScreenVideo.getWidth(), 22);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(comboInputVideo);
        }
        JLabel inputAudio = new JLabel(String.valueOf(Shutter.language.getProperty("audio")) + Shutter.language.getProperty("colon"));
        inputAudio.setFont(new Font("FreeSans", 0, 12));
        inputAudio.setBounds(12, inputVideo.getY() + inputVideo.getHeight() + 14, 40, 14);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(inputAudio);
        }
        comboInputAudio = new JComboBox<String>(FFMPEG.audioDevices.toString().split(":"));
        comboInputAudio.setFont(new Font("FreeSans", 0, 10));
        comboInputAudio.setEditable(false);
        comboInputAudio.setEnabled(false);
        comboInputAudio.setMaximumRowCount(20);
        comboInputAudio.setBounds(comboScreenVideo.getX(), inputAudio.getLocation().y - 3, comboScreenVideo.getWidth(), 22);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(comboInputAudio);
        }
        JButton btnOK = new JButton("OK");
        btnOK.setFont(new Font("Montserrat", 0, 12));
        btnOK.setSize(screenVideo.getWidth() + comboScreenVideo.getWidth() + 4, 21);
        if (System.getProperty("os.name").contains("Windows")) {
            btnOK.setLocation(12, comboInputAudio.getY() + comboInputAudio.getHeight() + 14);
        } else {
            btnOK.setLocation(12, comboScreenAudio.getY() + comboScreenAudio.getHeight() + 14);
        }
        frame.getContentPane().add(btnOK);
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Shutter.liste.removeAllElements();
                if (comboScreenVideo.getSelectedItem().toString().equals("Capture.current.screen")) {
                    Shutter.liste.addElement("Capture.current.screen");
                    if (comboInputVideo.getSelectedIndex() > 0 && System.getProperty("os.name").contains("Windows")) {
                        videoDeviceIndex = comboInputVideo.getSelectedIndex();
                    }
                } else {
                    Shutter.liste.addElement("Capture.input.device");
                    videoDeviceIndex = System.getProperty("os.name").contains("Windows") ? Integer.valueOf(comboInputVideo.getSelectedIndex() + 1) : Integer.valueOf(comboInputVideo.getSelectedIndex());
                }
                Shutter.inputDeviceIsRunning = true;
                if (comboInputVideo.getSelectedIndex() > 0) {
                    Shutter.overlayDeviceIsRunning = true;
                }
                audioDeviceIndex = comboScreenAudio.getSelectedIndex() > 0 ? Integer.valueOf(comboScreenAudio.getSelectedIndex()) : Integer.valueOf(-1);
                overlayAudioDeviceIndex = comboInputAudio.getSelectedIndex() > 0 ? Integer.valueOf(comboInputAudio.getSelectedIndex()) : Integer.valueOf(-1);
                RecordInputDevice.setInputDevices();
                inputDeviceResolution = "";
                if (comboInputVideo.getSelectedIndex() > 0 || !comboScreenVideo.getSelectedItem().toString().equals("Capture.current.screen")) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        FFPROBE.Data("Capture.input.device");
                        do {
                            Thread.sleep(100L);
                        } while (FFPROBE.isRunning);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                inputDeviceResolution = FFPROBE.imageResolution;
                if (FFPROBE.entrelaced == null) {
                    FFPROBE.entrelaced = "0";
                }
                if (comboInputVideo.getSelectedIndex() > 0) {
                    if (!Shutter.caseLogo.isSelected()) {
                        Shutter.caseLogo.setSelected(true);
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    Shutter.caseLogo.setSelected(true);
                    if (WatermarkWindow.frame == null) {
                        new WatermarkWindow();
                    } else {
                        WatermarkWindow.loadImage("0", "0", "0", true, -1, true);
                        Utils.changeDialogVisibility(WatermarkWindow.frame, false);
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                Shutter.addToList.setVisible(false);
                Shutter.case2pass.setSelected(false);
                if (Shutter.caseDisplay.isEnabled()) {
                    Shutter.caseDisplay.setSelected(true);
                }
                if (!Shutter.caseChangeFolder1.isSelected()) {
                    if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                        Shutter.lblDestination1.setText(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                    } else {
                        Shutter.lblDestination1.setText(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                    }
                }
                Shutter.caseChangeFolder1.setSelected(true);
                Shutter.changeFilters();
                frame.dispose();
            }
        });
    }

    public static String setInputDevices() {
        String videoDevice = "";
        if (Shutter.liste.getElementAt(0).equals("Capture.input.device")) {
            String[] getVideoDevices = FFMPEG.videoDevices.toString().split(":");
            videoDevice = getVideoDevices[videoDeviceIndex];
        }
        String setAudio = RecordInputDevice.setAudioDevice();
        String setSecondAudio = "";
        if (videoDeviceIndex == 0 && System.getProperty("os.name").contains("Windows") && overlayAudioDeviceIndex > 0) {
            setSecondAudio = " -thread_queue_size 4096 -f dshow -i " + RecordInputDevice.setOverlayAudioDevice();
        }
        GraphicsConfiguration config = frame.getGraphicsConfiguration();
        GraphicsDevice myScreen = config.getDevice();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allScreens = env.getScreenDevices();
        int screenIndex = -1;
        int i = 0;
        while (i < allScreens.length) {
            if (allScreens[i].equals(myScreen)) {
                screenIndex = i;
                break;
            }
            ++i;
        }
        AffineTransform transform = allScreens[screenIndex].getDefaultConfiguration().getDefaultTransform();
        if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
            screenWidth = allScreens[screenIndex].getDisplayMode().getWidth() * 2;
            screenHeigth = allScreens[screenIndex].getDisplayMode().getHeight() * 2;
        } else {
            screenWidth = allScreens[screenIndex].getDisplayMode().getWidth();
            screenHeigth = allScreens[screenIndex].getDisplayMode().getHeight();
        }
        Integer screenPositionX = allScreens[screenIndex].getDefaultConfiguration().getBounds().x;
        Integer screenPositionY = allScreens[screenIndex].getDefaultConfiguration().getBounds().y;
        if (Shutter.liste.getElementAt(0).equals("Capture.current.screen")) {
            CropVideo.ImageWidth = screenWidth;
            CropVideo.ImageHeight = screenHeigth;
            CropImage.ImageWidth = screenWidth;
            CropImage.ImageHeight = screenHeigth;
            WatermarkWindow.ImageWidth = screenWidth;
            WatermarkWindow.ImageHeight = screenHeigth;
            OverlayWindow.ImageWidth = screenWidth;
            OverlayWindow.ImageHeight = screenHeigth;
            SubtitlesWindow.ImageWidth = screenWidth;
            SubtitlesWindow.ImageHeight = screenHeigth;
            ColorImage.ImageWidth = screenWidth;
            ColorImage.ImageHeight = screenHeigth;
            FFPROBE.imageResolution = screenWidth + "x" + screenHeigth;
            FFPROBE.entrelaced = "0";
        }
        FFPROBE.audioOnly = false;
        if (System.getProperty("os.name").contains("Mac")) {
            if (Shutter.liste.getElementAt(0).equals("Capture.current.screen")) {
                if (setAudio != "") {
                    return String.valueOf(setAudio) + " -thread_queue_size 4096 -f avfoundation -pixel_format uyvy422 -probesize 100M -rtbufsize 100M -capture_cursor 1 -framerate " + Settings.txtScreenRecord.getText() + " -i " + '\"' + (FFMPEG.firstScreenIndex - screenIndex) + '\"';
                }
                return "-thread_queue_size 4096 -f avfoundation -pixel_format uyvy422 -probesize 100M -rtbufsize 100M -capture_cursor 1 -framerate " + Settings.txtScreenRecord.getText() + " -i " + '\"' + (FFMPEG.firstScreenIndex - screenIndex) + '\"';
            }
            return String.valueOf(setAudio) + " -thread_queue_size 4096 -f avfoundation -pixel_format uyvy422 -probesize 100M -rtbufsize 100M -framerate " + Settings.txtInputDevice.getText() + " -i " + '\"' + videoDeviceIndex + '\"';
        }
        if (System.getProperty("os.name").contains("Windows")) {
            if (Shutter.liste.getElementAt(0).equals("Capture.current.screen")) {
                if (setAudio != "") {
                    return "-thread_queue_size 4096 -f dshow -i " + setAudio + " -thread_queue_size 4096 -f gdigrab -draw_mouse 1 -framerate " + Settings.txtScreenRecord.getText() + " -offset_x " + screenPositionX + " -offset_y " + screenPositionY + " -video_size " + screenWidth + "x" + screenHeigth + " -probesize 100M -rtbufsize 100M -i " + '\"' + "desktop" + '\"' + setSecondAudio;
                }
                return "-thread_queue_size 4096 -f gdigrab -draw_mouse 1 -framerate " + Settings.txtScreenRecord.getText() + " -offset_x " + screenPositionX + " -offset_y " + screenPositionY + " -video_size " + screenWidth + "x" + screenHeigth + " -probesize 100M -rtbufsize 100M -i " + '\"' + "desktop" + '\"';
            }
            if (setAudio != "" && videoDeviceIndex > 0) {
                setAudio = ":" + setAudio;
            }
            if (videoDeviceIndex > 0) {
                return "-thread_queue_size 4096 -f dshow -probesize 100M -rtbufsize 100M -framerate " + Settings.txtInputDevice.getText() + " -i video=" + '\"' + videoDevice + '\"' + setAudio;
            }
            return "-thread_queue_size 4096 -f dshow -probesize 100M -rtbufsize 100M -framerate " + Settings.txtInputDevice.getText() + " -i " + setAudio;
        }
        return "-thread_queue_size 4096 -f x11grab -framerate " + Settings.txtScreenRecord.getText() + " -video_size " + screenWidth + "x" + screenHeigth + " -probesize 100M -rtbufsize 100M -i :0.0+" + screenPositionX + "," + screenPositionY + setAudio;
    }

    public static String setOverlayDevice() {
        String[] getVideoDevices = FFMPEG.videoDevices.toString().split(":");
        String videoDevice = getVideoDevices[videoDeviceIndex];
        if (inputDeviceResolution != "") {
            FFPROBE.imageResolution = inputDeviceResolution;
            String[] splitx = inputDeviceResolution.split("x");
            int deviceWidth = Integer.parseInt(splitx[0]);
            int deviceHeight = Integer.parseInt(splitx[1]);
            WatermarkWindow.ImageWidth = deviceWidth;
            WatermarkWindow.ImageHeight = deviceHeight;
        }
        FFPROBE.audioOnly = false;
        if (System.getProperty("os.name").contains("Mac")) {
            return "-thread_queue_size 4096 -f avfoundation -pixel_format uyvy422 -probesize 100M -rtbufsize 100M -framerate " + Settings.txtInputDevice.getText() + " -i " + '\"' + videoDeviceIndex + '\"';
        }
        if (System.getProperty("os.name").contains("Windows")) {
            String setAudio = RecordInputDevice.setOverlayAudioDevice();
            if (setAudio != "") {
                setAudio = ":" + setAudio;
            }
            return "-thread_queue_size 4096 -f dshow -probesize 100M -rtbufsize 100M -framerate " + Settings.txtInputDevice.getText() + " -i video=" + '\"' + videoDevice + '\"' + setAudio;
        }
        return "";
    }

    public static String setAudioDevice() {
        String setAudio = "";
        FFPROBE.channels = 0;
        FFPROBE.stereo = false;
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Windows")) {
            String[] getAudioDevices = FFMPEG.audioDevices.toString().split(":");
            if (audioDeviceIndex > 0) {
                String audioDevice = getAudioDevices[audioDeviceIndex];
                if (System.getProperty("os.name").contains("Mac")) {
                    setAudio = "-thread_queue_size 4096 -f openal -sample_rate 48k -i \"" + audioDevice + '\"';
                } else if (System.getProperty("os.name").contains("Windows")) {
                    setAudio = "audio=\"" + audioDevice + '\"';
                }
                FFPROBE.channels = 1;
                FFPROBE.stereo = true;
            }
        }
        return setAudio;
    }

    public static String setOverlayAudioDevice() {
        String setAudio = "";
        FFPROBE.channels = 0;
        FFPROBE.stereo = false;
        String[] getAudioDevices = FFMPEG.audioDevices.toString().split(":");
        if (overlayAudioDeviceIndex > 0) {
            String audioDevice = getAudioDevices[overlayAudioDeviceIndex];
            if (System.getProperty("os.name").contains("Windows")) {
                setAudio = "audio=\"" + audioDevice + '\"';
            }
            FFPROBE.channels = audioDeviceIndex > 0 ? 2 : 1;
        } else if (audioDeviceIndex > 0) {
            FFPROBE.channels = 1;
        }
        FFPROBE.stereo = FFPROBE.channels == 1;
        return setAudio;
    }
}

