/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.Functions;
import application.RecordInputDevice;
import application.RenderQueue;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import library.FFMPEG;
import library.FFPROBE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OverlayWindow {
    public static JDialog frame;
    private static JPanel image;
    private static JLabel changePositions;
    private static JPanel timecode;
    private static JPanel fileName;
    private JLabel quit;
    private JPanel topPanel;
    private JLabel topImage;
    private JButton btnOK;
    public static int ImageWidth;
    public static int ImageHeight;
    public static int finalWidth;
    public static int finalHeight;
    public static int containerWidth;
    public static int containerHeight;
    public static String hexTc;
    public static String hexAlphaTc;
    public static String hexName;
    public static String hexAlphaName;
    public static float imageRatio;
    private int tcPosX = 0;
    private int tcPosY = 0;
    private static int tcLocX;
    private static int tcLocY;
    private static int filePosX;
    private static int filePosY;
    private static int fileLocX;
    private static int fileLocY;
    public static JTextField textTcPosX;
    public static JTextField textTcPosY;
    public static JTextField textNamePosX;
    public static JTextField textNamePosY;
    public static JSlider positionVideo;
    public static JSpinner spinnerSizeTC;
    public static JSpinner spinnerSizeName;
    public static JSpinner spinnerOpacityTC;
    public static JSpinner spinnerOpacityName;
    public static JRadioButton caseAddTimecode;
    public static JLabel lblTimecode;
    public static JTextField TC1;
    public static JTextField TC2;
    public static JTextField TC3;
    public static JTextField TC4;
    public static JTextField text;
    private static long textTime;
    private static Thread changeText;
    public static JRadioButton caseShowTimecode;
    public static JRadioButton caseShowFileName;
    public static JRadioButton caseShowText;
    public static JComboBox<String> comboFont;
    public static JLabel lblBackground;
    private static JPanel panelColor;
    private static JPanel panelColor2;
    public static String font;
    public static Color fontColor;
    public static Color backgroundColor;
    public static String hex;
    public static String hex2;
    public static String alpha;

    static {
        image = new JPanel();
        changePositions = new JLabel("<html>Timecode<br>&nbsp;&nbsp;&nbsp;&nbsp;Text</html>");
        containerWidth = 640;
        containerHeight = 360;
        hexTc = "ff";
        hexAlphaTc = "ff";
        hexName = "ff";
        hexAlphaName = "ff";
        imageRatio = 3.0f;
        tcLocX = 0;
        tcLocY = 0;
        filePosX = 0;
        filePosY = 0;
        fileLocX = 0;
        fileLocY = 0;
        caseAddTimecode = new JRadioButton(Shutter.language.getProperty("caseAddTimecode"));
        lblTimecode = new JLabel(Shutter.language.getProperty("lblTimecode"));
        TC1 = new JTextField("00");
        TC2 = new JTextField("00");
        TC3 = new JTextField("00");
        TC4 = new JTextField("00");
        text = new JTextField("");
        textTime = System.currentTimeMillis();
        caseShowTimecode = new JRadioButton(Shutter.language.getProperty("caseShowTimecode"));
        caseShowFileName = new JRadioButton(Shutter.language.getProperty("caseShowFileName"));
        caseShowText = new JRadioButton(Shutter.language.getProperty("caseShowText"));
        panelColor = new JPanel();
        panelColor2 = new JPanel();
        hex = "FFFFFF";
        hex2 = "000000";
        alpha = "7F";
    }

    public OverlayWindow() {
        frame = new JDialog();
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("grpOverlay"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(665, 550);
        frame.setResizable(false);
        if (Functions.frame != null && Functions.frame.isVisible()) {
            frame.setModal(false);
        } else {
            frame.setModal(true);
        }
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - OverlayWindow.frame.getSize().width / 2, dim.height / 2 - OverlayWindow.frame.getSize().height / 2);
        }
        this.topPanel();
        this.boutons();
        image.setLayout(null);
        image.setOpaque(false);
        OverlayWindow.loadImage("0", "0", "0", true);
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(OverlayWindow.frame.getSize().width - 24, 0, 21, 21);
        this.topPanel.add(this.quit);
        this.topPanel.setBounds(0, 0, 1000, 52);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                OverlayWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                    Utils.changeDialogVisibility(frame, true);
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    Shutter.caseAddOverlay.setSelected(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OverlayWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OverlayWindow.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        JLabel title = new JLabel(Shutter.language.getProperty("grpOverlay"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 52);
        title.setFont(new Font("Magneto", 0, 26));
        this.topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.topPanel.add(this.topImage);
        this.topPanel.setBounds(0, 0, 1000, 52);
        frame.getContentPane().add(this.topPanel);
        image.setBounds(12, 58, 640, 360);
        frame.getContentPane().add(image);
        this.topImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.topImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void boutons() {
        timecode = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                String[] sp = FFPROBE.imageResolution.split("x");
                imageRatio = (float)Integer.parseInt(sp[0]) / (float)containerWidth;
                g2.setFont(new Font(comboFont.getSelectedItem().toString(), 0, Math.round((float)Integer.parseInt(spinnerSizeTC.getValue().toString()) / imageRatio)));
                String str = "00:00:00:00";
                if (caseAddTimecode.isSelected() || caseShowTimecode.isSelected()) {
                    if (FFPROBE.isRunning) {
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                    }
                    long tcH = 0L;
                    long tcM = 0L;
                    long tcS = 0L;
                    long tcI = 0L;
                    if (!(!caseAddTimecode.isSelected() || TC1.getText().isEmpty() || TC2.getText().isEmpty() || TC3.getText().isEmpty() || TC4.getText().isEmpty())) {
                        tcH = Integer.valueOf(TC1.getText()).intValue();
                        tcM = Integer.valueOf(TC2.getText()).intValue();
                        tcS = Integer.valueOf(TC3.getText()).intValue();
                        tcI = Integer.valueOf(TC4.getText()).intValue();
                    } else if (caseShowTimecode.isSelected()) {
                        tcH = Integer.valueOf(FFPROBE.timecode1).intValue();
                        tcM = Integer.valueOf(FFPROBE.timecode2).intValue();
                        tcS = Integer.valueOf(FFPROBE.timecode3).intValue();
                        tcI = Integer.valueOf(FFPROBE.timecode4).intValue();
                    }
                    long offset = (long)positionVideo.getValue() + (tcH *= 3600000L) + (tcM *= 60000L) + (tcS *= 1000L);
                    DecimalFormat formatter = new DecimalFormat("00");
                    String heures = formatter.format(offset / 1000L / 3600L);
                    String minutes = formatter.format(offset / 1000L / 60L % 60L);
                    String secondes = formatter.format(offset / 1000L % 60L);
                    String images = formatter.format(tcI);
                    str = caseAddTimecode.isSelected() && lblTimecode.getText().equals(Shutter.language.getProperty("lblFrameNumber")) ? String.format("%.0f", Float.valueOf((float)(Integer.parseInt(heures) * 3600) * FFPROBE.currentFPS + (float)(Integer.parseInt(minutes) * 60) * FFPROBE.currentFPS + (float)Integer.parseInt(secondes) * FFPROBE.currentFPS + (float)Integer.parseInt(images))) : String.valueOf(heures) + ":" + minutes + ":" + secondes + ":" + images;
                }
                Rectangle bounds = this.getStringBounds(g2, str, 0.0f, 0.0f);
                if (lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                    g2.setColor(new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), (int)((float)(Integer.parseInt(spinnerOpacityTC.getValue().toString()) * 255) / 100.0f)));
                } else {
                    g2.setColor(new Color(0, 0, 0, 0));
                }
                GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                AffineTransform transform = gfxConfig.getDefaultTransform();
                if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
                    g2.fillRect(0, 0, bounds.width, bounds.height / 2);
                } else {
                    g2.fillRect(0, 0, bounds.width, bounds.height);
                }
                if (lblBackground.getText().equals(Shutter.language.getProperty("aucun"))) {
                    g2.setColor(new Color(fontColor.getRed(), fontColor.getGreen(), fontColor.getBlue(), (int)((float)(Integer.parseInt(spinnerOpacityTC.getValue().toString()) * 255) / 100.0f)));
                } else {
                    g2.setColor(fontColor);
                }
                if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
                    Integer offset = bounds.height + (int)bounds.getY();
                    g2.drawString(str, 0, bounds.height / 2 - offset / 2);
                } else {
                    Integer offset = bounds.height + (int)bounds.getY();
                    g2.drawString(str, 0, bounds.height - offset);
                }
                image.repaint();
                timecode.repaint();
            }

            private Rectangle getStringBounds(Graphics2D g2, String str, float x, float y) {
                FontRenderContext frc = g2.getFontRenderContext();
                GlyphVector gv = g2.getFont().createGlyphVector(frc, str);
                return gv.getPixelBounds(null, x, y);
            }
        };
        timecode.setLayout(null);
        timecode.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OverlayWindow.this.tcPosX = e.getLocationOnScreen().x;
                OverlayWindow.this.tcPosY = e.getLocationOnScreen().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    if (changePositions.getText().equals("<html>Timecode<br>&nbsp;&nbsp;&nbsp;&nbsp;Text</html>")) {
                        tcLocX = Math.round(image.getWidth() / 2 - timecode.getWidth() / 2);
                        tcLocY = timecode.getHeight();
                        timecode.setLocation(MouseInfo.getPointerInfo().getLocation().x - OverlayWindow.this.tcPosX + tcLocX, MouseInfo.getPointerInfo().getLocation().y - OverlayWindow.this.tcPosY + tcLocY);
                    } else {
                        tcLocX = Math.round(image.getWidth() / 2 - timecode.getWidth() / 2);
                        tcLocY = containerHeight - timecode.getHeight() * 2;
                        timecode.setLocation(MouseInfo.getPointerInfo().getLocation().x - OverlayWindow.this.tcPosX + tcLocX, MouseInfo.getPointerInfo().getLocation().y - OverlayWindow.this.tcPosY + tcLocY);
                    }
                    textTcPosX.setText(String.valueOf(Math.round((float)OverlayWindow.timecode.getLocation().x * imageRatio)));
                    textTcPosY.setText(String.valueOf(Math.round((float)OverlayWindow.timecode.getLocation().y * imageRatio)));
                } else {
                    tcLocX = OverlayWindow.timecode.getLocation().x;
                    tcLocY = OverlayWindow.timecode.getLocation().y;
                }
            }
        });
        timecode.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                timecode.setLocation(MouseInfo.getPointerInfo().getLocation().x - OverlayWindow.this.tcPosX + tcLocX, MouseInfo.getPointerInfo().getLocation().y - OverlayWindow.this.tcPosY + tcLocY);
                textTcPosX.setText(String.valueOf(Math.round((float)OverlayWindow.timecode.getLocation().x * imageRatio)));
                textTcPosY.setText(String.valueOf(Math.round((float)OverlayWindow.timecode.getLocation().y * imageRatio)));
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        fileName = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Integer offset;
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                String[] sp = FFPROBE.imageResolution.split("x");
                imageRatio = (float)Integer.parseInt(sp[0]) / (float)containerWidth;
                g2.setFont(new Font(comboFont.getSelectedItem().toString(), 0, Math.round((float)Integer.parseInt(spinnerSizeName.getValue().toString()) / imageRatio)));
                String fichier = Shutter.liste.firstElement();
                if (Shutter.scanIsRunning) {
                    File dir = new File(Shutter.liste.firstElement());
                    File[] fileArray = dir.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (!f.isHidden() && f.isFile()) {
                            fichier = f.toString();
                            break;
                        }
                        ++n2;
                    }
                }
                String str = new File(fichier).getName();
                if (caseShowText.isSelected()) {
                    str = text.getText();
                }
                Rectangle bounds = this.getStringBounds(g2, str, 0.0f, 0.0f);
                if (lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                    g2.setColor(new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), (int)((float)(Integer.parseInt(spinnerOpacityName.getValue().toString()) * 255) / 100.0f)));
                } else {
                    g2.setColor(new Color(0, 0, 0, 0));
                }
                GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                AffineTransform transform = gfxConfig.getDefaultTransform();
                if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
                    g2.fillRect(0, 0, bounds.width, bounds.height / 2);
                } else {
                    g2.fillRect(0, 0, bounds.width, bounds.height);
                }
                if (lblBackground.getText().equals(Shutter.language.getProperty("aucun"))) {
                    g2.setColor(new Color(fontColor.getRed(), fontColor.getGreen(), fontColor.getBlue(), (int)((float)(Integer.parseInt(spinnerOpacityName.getValue().toString()) * 255) / 100.0f)));
                } else {
                    g2.setColor(fontColor);
                }
                if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
                    offset = bounds.height + (int)bounds.getY();
                    g2.drawString(str, 0, bounds.height / 2 - offset / 2);
                } else {
                    offset = bounds.height + (int)bounds.getY();
                    g2.drawString(str, 0, bounds.height - offset);
                }
                image.repaint();
                fileName.repaint();
            }

            private Rectangle getStringBounds(Graphics2D g2, String str, float x, float y) {
                FontRenderContext frc = g2.getFontRenderContext();
                GlyphVector gv = g2.getFont().createGlyphVector(frc, str);
                return gv.getPixelBounds(null, x, y);
            }
        };
        fileName.setLayout(null);
        fileName.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                filePosX = e.getLocationOnScreen().x;
                filePosY = e.getLocationOnScreen().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    if (changePositions.getText().equals("<html>Timecode<br>&nbsp;&nbsp;&nbsp;&nbsp;Text</html>")) {
                        fileLocX = Math.round(image.getWidth() / 2 - fileName.getWidth() / 2);
                        fileLocY = containerHeight - fileName.getHeight() * 2;
                        fileName.setLocation(MouseInfo.getPointerInfo().getLocation().x - filePosX + fileLocX, MouseInfo.getPointerInfo().getLocation().y - filePosY + fileLocY);
                    } else {
                        fileLocX = Math.round(image.getWidth() / 2 - fileName.getWidth() / 2);
                        fileLocY = fileName.getHeight();
                        fileName.setLocation(MouseInfo.getPointerInfo().getLocation().x - filePosX + fileLocX, MouseInfo.getPointerInfo().getLocation().y - filePosY + fileLocY);
                    }
                    textNamePosX.setText(String.valueOf(Math.round((float)OverlayWindow.fileName.getLocation().x * imageRatio)));
                    textNamePosY.setText(String.valueOf(Math.round((float)OverlayWindow.fileName.getLocation().y * imageRatio)));
                } else {
                    fileLocX = OverlayWindow.fileName.getLocation().x;
                    fileLocY = OverlayWindow.fileName.getLocation().y;
                }
            }
        });
        fileName.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                fileName.setLocation(MouseInfo.getPointerInfo().getLocation().x - filePosX + fileLocX, MouseInfo.getPointerInfo().getLocation().y - filePosY + fileLocY);
                textNamePosX.setText(String.valueOf(Math.round((float)OverlayWindow.fileName.getLocation().x * imageRatio)));
                textNamePosY.setText(String.valueOf(Math.round((float)OverlayWindow.fileName.getLocation().y * imageRatio)));
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        timecode.setBackground(new Color(0, 0, 0, 0));
        fileName.setBackground(new Color(0, 0, 0, 0));
        JLabel lblFont = new JLabel(Shutter.language.getProperty("lblFont"));
        lblFont.setAlignmentX(4.0f);
        lblFont.setFont(new Font("FreeSans", 0, 13));
        lblFont.setBounds(12, frame.getHeight() - 124, lblFont.getPreferredSize().width, 16);
        frame.getContentPane().add(lblFont);
        final String[] Fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        comboFont = new JComboBox<String>(Fonts);
        comboFont.setName("comboFont");
        comboFont.setSelectedItem("Arial");
        comboFont.setFont(new Font("Arial", 0, 11));
        comboFont.setRenderer(new ComboRendererOverlay(comboFont));
        comboFont.setEditable(true);
        comboFont.setBounds(lblFont.getX() + lblFont.getWidth() + 7, lblFont.getY() - 4, 153, 22);
        frame.getContentPane().add(comboFont);
        comboFont.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){
            String text = "";

            @Override
            public void keyReleased(KeyEvent e) {
                if (comboFont.getEditor().toString().length() <= 1) {
                    this.text = String.valueOf(e.getKeyChar());
                }
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    comboFont.setModel(new DefaultComboBoxModel<String>(Fonts));
                    this.text = String.valueOf(this.text) + e.getKeyChar();
                    ArrayList<String> newList = new ArrayList<String>();
                    int i = 0;
                    while (i < comboFont.getItemCount()) {
                        if (Fonts[i].toString().length() >= this.text.length() && Fonts[i].toString().toLowerCase().substring(0, this.text.length()).contains(this.text) && !Fonts[i].toString().contains(":")) {
                            newList.add(Fonts[i].toString());
                        }
                        ++i;
                    }
                    comboFont.getEditor().setItem(this.text);
                    if (!newList.isEmpty()) {
                        comboFont.setModel(new DefaultComboBoxModel<Object>(newList.toArray()));
                        comboFont.showPopup();
                    }
                } else if (e.getKeyCode() == 8 || e.getKeyCode() == 27) {
                    comboFont.setModel(new DefaultComboBoxModel<String>(Fonts));
                    comboFont.getEditor().setItem("");
                    comboFont.hidePopup();
                    this.text = "";
                } else if (e.getKeyCode() == 40) {
                    e.consume();
                } else {
                    comboFont.hidePopup();
                }
            }
        });
        comboFont.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                comboFont.setFont(new Font(comboFont.getSelectedItem().toString(), 0, 11));
                OverlayWindow.sliderChange(false);
            }
        });
        JLabel lblColor = new JLabel(Shutter.language.getProperty("lblColor"));
        lblColor.setAlignmentX(4.0f);
        lblColor.setFont(new Font("FreeSans", 0, 13));
        lblColor.setBounds(comboFont.getX() + comboFont.getWidth() + 7, lblFont.getY(), lblColor.getPreferredSize().width + 4, 16);
        frame.getContentPane().add(lblColor);
        panelColor = new JPanel();
        panelColor.setName("panelColor");
        panelColor.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        panelColor.setBackground(Color.WHITE);
        panelColor.setBounds(lblColor.getLocation().x + lblColor.getWidth() + 7, OverlayWindow.comboFont.getLocation().y, 41, 22);
        frame.getContentPane().add(panelColor);
        panelColor.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                fontColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), Color.WHITE);
                if (fontColor != null) {
                    panelColor.setBackground(fontColor);
                    OverlayWindow.sliderChange(false);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        lblBackground = new JLabel(Shutter.language.getProperty("lblBackgroundOn"));
        lblBackground.setName("lblBackground");
        lblBackground.setBackground(new Color(80, 80, 80));
        lblBackground.setHorizontalAlignment(0);
        lblBackground.setOpaque(true);
        lblBackground.setFont(new Font("Montserrat", 0, 11));
        lblBackground.setBounds(OverlayWindow.panelColor.getLocation().x + panelColor.getWidth() + 11, lblColor.getLocation().y, 70, 16);
        frame.getContentPane().add(lblBackground);
        lblBackground.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                    lblBackground.setText(Shutter.language.getProperty("aucun"));
                    spinnerOpacityTC.setValue(100);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    spinnerOpacityName.setValue(100);
                } else {
                    lblBackground.setText(Shutter.language.getProperty("lblBackgroundOn"));
                    spinnerOpacityTC.setValue(50);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    spinnerOpacityName.setValue(50);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JLabel lblColor2 = new JLabel(Shutter.language.getProperty("lblColor"));
        lblColor2.setAlignmentX(4.0f);
        lblColor2.setFont(new Font("FreeSans", 0, 13));
        lblColor2.setBounds(OverlayWindow.lblBackground.getLocation().x + lblBackground.getWidth() + 11, lblFont.getY(), lblColor2.getPreferredSize().width + 4, 16);
        frame.getContentPane().add(lblColor2);
        panelColor2 = new JPanel();
        panelColor2.setName("panelColor2");
        panelColor2.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        panelColor2.setBackground(Color.BLACK);
        panelColor2.setBounds(lblColor2.getLocation().x + lblColor2.getWidth() + 7, OverlayWindow.comboFont.getLocation().y, 41, 22);
        frame.getContentPane().add(panelColor2);
        panelColor2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                backgroundColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), Color.WHITE);
                if (backgroundColor != null) {
                    panelColor2.setBackground(backgroundColor);
                    OverlayWindow.sliderChange(false);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        caseAddTimecode.setName("caseAddTimecode");
        caseAddTimecode.setFont(new Font("FreeSans", 0, 12));
        caseAddTimecode.setSize(OverlayWindow.caseAddTimecode.getPreferredSize().width, 23);
        caseAddTimecode.setLocation(12, frame.getHeight() - 102);
        frame.add(caseAddTimecode);
        caseAddTimecode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (caseAddTimecode.isSelected()) {
                    TC1.setEnabled(true);
                    TC2.setEnabled(true);
                    TC3.setEnabled(true);
                    TC4.setEnabled(true);
                    caseShowTimecode.setSelected(false);
                } else {
                    FFPROBE.timecode1 = "";
                    FFPROBE.timecode2 = "";
                    FFPROBE.timecode3 = "";
                    FFPROBE.timecode4 = "";
                    TC1.setEnabled(false);
                    TC2.setEnabled(false);
                    TC3.setEnabled(false);
                    TC4.setEnabled(false);
                }
                OverlayWindow.sliderChange(false);
            }
        });
        lblTimecode.setName("lblTimecode");
        lblTimecode.setBackground(new Color(80, 80, 80));
        lblTimecode.setHorizontalAlignment(0);
        lblTimecode.setOpaque(true);
        lblTimecode.setFont(new Font("Montserrat", 0, 11));
        lblTimecode.setBounds(OverlayWindow.caseAddTimecode.getLocation().x + caseAddTimecode.getWidth() + 2, OverlayWindow.caseAddTimecode.getLocation().y + 3, 70, 16);
        frame.add(lblTimecode);
        lblTimecode.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (lblTimecode.getText().equals(Shutter.language.getProperty("lblTimecode"))) {
                    lblTimecode.setText(Shutter.language.getProperty("lblFrameNumber"));
                } else {
                    lblTimecode.setText(Shutter.language.getProperty("lblTimecode"));
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        TC1.setName("TC1");
        TC1.setEnabled(false);
        TC1.setText("00");
        TC1.setHorizontalAlignment(0);
        TC1.setFont(new Font("FreeSans", 0, 14));
        TC1.setColumns(10);
        TC1.setBounds(lblTimecode.getX() + lblTimecode.getWidth() + 7, caseAddTimecode.getY(), 32, 21);
        frame.add(TC1);
        TC2.setName("TC2");
        TC2.setEnabled(false);
        TC2.setText("00");
        TC2.setHorizontalAlignment(0);
        TC2.setFont(new Font("FreeSans", 0, 14));
        TC2.setColumns(10);
        TC2.setBounds(TC1.getX() + 36, TC1.getY(), 32, 21);
        frame.add(TC2);
        TC3.setName("TC3");
        TC3.setEnabled(false);
        TC3.setText("00");
        TC3.setHorizontalAlignment(0);
        TC3.setFont(new Font("FreeSans", 0, 14));
        TC3.setColumns(10);
        TC3.setBounds(TC2.getX() + 36, TC1.getY(), 32, 21);
        frame.add(TC3);
        TC4.setName("TC4");
        TC4.setEnabled(false);
        TC4.setText("00");
        TC4.setHorizontalAlignment(0);
        TC4.setFont(new Font("FreeSans", 0, 14));
        TC4.setColumns(10);
        TC4.setBounds(TC3.getX() + 36, TC1.getY(), 32, 21);
        frame.add(TC4);
        TC1.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC1.getText().length() >= 2) {
                    TC1.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OverlayWindow.sliderChange(false);
            }
        });
        TC2.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC2.getText().length() >= 2) {
                    TC2.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OverlayWindow.sliderChange(false);
            }
        });
        TC3.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC3.getText().length() >= 2) {
                    TC3.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OverlayWindow.sliderChange(false);
            }
        });
        TC4.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC4.getText().length() >= 2) {
                    TC4.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OverlayWindow.sliderChange(false);
            }
        });
        caseShowTimecode.setName("caseShowTimecode");
        caseShowTimecode.setFont(new Font("FreeSans", 0, 12));
        caseShowTimecode.setEnabled(true);
        caseShowTimecode.setSize(OverlayWindow.caseShowTimecode.getPreferredSize().width, 23);
        caseShowTimecode.setLocation(caseAddTimecode.getX(), caseAddTimecode.getY() + caseAddTimecode.getHeight());
        frame.add(caseShowTimecode);
        caseShowTimecode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (caseShowTimecode.isSelected()) {
                    TC1.setEnabled(false);
                    TC2.setEnabled(false);
                    TC3.setEnabled(false);
                    TC4.setEnabled(false);
                    caseAddTimecode.setSelected(false);
                }
                OverlayWindow.sliderChange(true);
            }
        });
        positionVideo = new JSlider();
        if (Shutter.scanIsRunning) {
            File dir = new File(Shutter.liste.firstElement());
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.isHidden() && f.isFile()) {
                    FFPROBE.Data(f.toString());
                }
                ++n2;
            }
        } else if (!Utils.inputDeviceIsRunning) {
            FFPROBE.Data(Shutter.liste.firstElement());
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException dir) {
                // empty catch block
            }
        } while (FFPROBE.totalLength == 0 && FFPROBE.isRunning);
        String[] sp = FFPROBE.imageResolution.split("x");
        imageRatio = (float)Integer.parseInt(sp[0]) / (float)containerWidth;
        positionVideo.setMaximum(FFPROBE.totalLength);
        positionVideo.setValue(0);
        positionVideo.setFont(new Font("FreeSans", 0, 11));
        positionVideo.setLocation(panelColor2.getX() + panelColor2.getWidth() + 6, panelColor2.getY());
        positionVideo.setSize(frame.getWidth() - positionVideo.getX() - 12, 22);
        Component[] components = frame.getContentPane().getComponents();
        boolean addToFrame = true;
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JSlider) {
                addToFrame = false;
            }
            ++i;
        }
        if (addToFrame) {
            frame.getContentPane().add(positionVideo);
        }
        positionVideo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                OverlayWindow.sliderChange(true);
            }
        });
        JLabel lblSizeTC = new JLabel(Shutter.language.getProperty("lblSize"));
        lblSizeTC.setFont(new Font("FreeSans", 0, 13));
        lblSizeTC.setAlignmentX(4.0f);
        lblSizeTC.setBounds(12, caseShowTimecode.getY() + caseShowTimecode.getHeight() + 11, lblSizeTC.getPreferredSize().width, 16);
        frame.getContentPane().add(lblSizeTC);
        spinnerSizeTC = new JSpinner(new SpinnerNumberModel(Math.round(27.0f * imageRatio), 1, 999, Math.round(imageRatio)));
        spinnerSizeTC.setName("spinnerSizeTC");
        spinnerSizeTC.setFont(new Font("FreeSans", 0, 11));
        spinnerSizeTC.setBounds(lblSizeTC.getLocation().x + lblSizeTC.getWidth() + 11, lblSizeTC.getLocation().y - 3, 54, 22);
        frame.getContentPane().add(spinnerSizeTC);
        spinnerSizeTC.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                OverlayWindow.sliderChange(false);
            }
        });
        JLabel lblOpacityTC = new JLabel(Shutter.language.getProperty("lblOpacity"));
        lblOpacityTC.setFont(new Font("FreeSans", 0, 13));
        lblOpacityTC.setAlignmentX(4.0f);
        lblOpacityTC.setBounds(OverlayWindow.spinnerSizeTC.getLocation().x + spinnerSizeTC.getWidth() + 11, lblSizeTC.getLocation().y, lblOpacityTC.getPreferredSize().width, 16);
        frame.getContentPane().add(lblOpacityTC);
        spinnerOpacityTC = new JSpinner(new SpinnerNumberModel(50, 0, 100, 1));
        spinnerOpacityTC.setName("spinnerOpacityTC");
        spinnerOpacityTC.setFont(new Font("FreeSans", 0, 11));
        spinnerOpacityTC.setBounds(lblOpacityTC.getLocation().x + lblOpacityTC.getWidth() + 11, lblSizeTC.getLocation().y - 3, spinnerSizeTC.getWidth(), 22);
        frame.getContentPane().add(spinnerOpacityTC);
        spinnerOpacityTC.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                OverlayWindow.sliderChange(false);
            }
        });
        JLabel posX = new JLabel(Shutter.language.getProperty("pX"));
        posX.setHorizontalAlignment(2);
        posX.setFont(new Font("FreeSans", 0, 12));
        posX.setForeground(Utils.themeColor);
        posX.setAlignmentX(4.0f);
        posX.setBounds(lblSizeTC.getX(), lblSizeTC.getY() + lblSizeTC.getHeight() + 6, lblOpacityTC.getPreferredSize().width + 2, 16);
        frame.getContentPane().add(posX);
        textTcPosX = new JTextField(String.valueOf((Object)Math.round((float)OverlayWindow.timecode.getLocation().x * imageRatio)));
        textTcPosX.setName("textTcPosX");
        textTcPosX.setBounds(OverlayWindow.spinnerSizeTC.getLocation().x, posX.getLocation().y, spinnerSizeTC.getWidth(), 16);
        textTcPosX.setHorizontalAlignment(4);
        textTcPosX.setFont(new Font("FreeSans", 0, 12));
        frame.getContentPane().add(textTcPosX);
        textTcPosX.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textTcPosX.getText().length() > 0) {
                    timecode.setLocation(Math.round((float)Integer.valueOf(textTcPosX.getText()).intValue() / imageRatio), OverlayWindow.timecode.getLocation().y);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textTcPosX.getText().length() >= 4) {
                    textTcPosX.setText("");
                }
            }
        });
        textTcPosX.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textTcPosX.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textTcPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textTcPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseTcPosition.mouseX = e.getX();
                MouseTcPosition.offsetX = Integer.parseInt(textTcPosX.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textTcPosX.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textTcPosX.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textTcPosX.setText(String.valueOf(MouseTcPosition.offsetX + (e.getX() - MouseTcPosition.mouseX)));
                    timecode.setLocation(Math.round((float)Integer.valueOf(textTcPosX.getText()).intValue() / imageRatio), OverlayWindow.timecode.getLocation().y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel posY = new JLabel(Shutter.language.getProperty("pY"));
        posY.setFont(new Font("FreeSans", 0, 12));
        posY.setForeground(Utils.themeColor);
        posY.setAlignmentX(4.0f);
        posY.setBounds(lblOpacityTC.getX(), posX.getLocation().y, lblOpacityTC.getPreferredSize().width, 16);
        frame.getContentPane().add(posY);
        textTcPosY = new JTextField(String.valueOf((Object)Math.round((float)OverlayWindow.timecode.getLocation().y * imageRatio)));
        textTcPosY.setName("textTcPosY");
        textTcPosY.setBounds(OverlayWindow.spinnerOpacityTC.getLocation().x, posY.getLocation().y, spinnerOpacityTC.getWidth(), 16);
        textTcPosY.setHorizontalAlignment(4);
        textTcPosY.setFont(new Font("FreeSans", 0, 12));
        frame.getContentPane().add(textTcPosY);
        textTcPosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textTcPosY.getText().length() > 0) {
                    timecode.setLocation(OverlayWindow.timecode.getLocation().x, Math.round((float)Integer.valueOf(textTcPosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textTcPosY.getText().length() >= 4) {
                    textTcPosY.setText("");
                }
            }
        });
        textTcPosY.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textTcPosY.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textTcPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textTcPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseTcPosition.mouseY = e.getY();
                MouseTcPosition.offsetY = Integer.parseInt(textTcPosY.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textTcPosY.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textTcPosY.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textTcPosY.setText(String.valueOf(MouseTcPosition.offsetY + (e.getY() - MouseTcPosition.mouseY)));
                    timecode.setLocation(OverlayWindow.timecode.getLocation().x, Math.round((float)Integer.valueOf(textTcPosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        textNamePosY = new JTextField(String.valueOf((Object)Math.round((float)OverlayWindow.fileName.getLocation().y * imageRatio)));
        textNamePosY.setName("textNamePosY");
        textNamePosY.setBounds(frame.getWidth() - spinnerOpacityTC.getWidth() - 13, posY.getLocation().y, spinnerOpacityTC.getWidth(), 16);
        textNamePosY.setHorizontalAlignment(4);
        textNamePosY.setFont(new Font("FreeSans", 0, 12));
        frame.getContentPane().add(textNamePosY);
        textNamePosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textNamePosY.getText().length() > 0) {
                    fileName.setLocation(OverlayWindow.fileName.getLocation().x, Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textNamePosY.getText().length() >= 4) {
                    textNamePosY.setText("");
                }
            }
        });
        textNamePosY.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textNamePosY.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textNamePosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textNamePosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseNamePosition.mouseY = e.getY();
                MouseNamePosition.offsetY = Integer.parseInt(textNamePosY.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textNamePosY.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textNamePosY.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textNamePosY.setText(String.valueOf(MouseNamePosition.offsetY + (e.getY() - MouseNamePosition.mouseY)));
                    fileName.setLocation(OverlayWindow.fileName.getLocation().x, Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel posY2 = new JLabel(Shutter.language.getProperty("pY"));
        posY2.setFont(new Font("FreeSans", 0, 12));
        posY2.setForeground(Utils.themeColor);
        posY2.setAlignmentX(4.0f);
        posY2.setBounds(textNamePosY.getX() - lblOpacityTC.getPreferredSize().width - 11, posY.getLocation().y, lblOpacityTC.getPreferredSize().width, 16);
        frame.getContentPane().add(posY2);
        spinnerOpacityName = new JSpinner(new SpinnerNumberModel(50, 0, 100, 1));
        spinnerOpacityName.setName("spinnerOpacityName");
        spinnerOpacityName.setFont(new Font("FreeSans", 0, 11));
        spinnerOpacityName.setBounds(textNamePosY.getX(), OverlayWindow.spinnerOpacityTC.getLocation().y, spinnerOpacityTC.getWidth(), 22);
        frame.getContentPane().add(spinnerOpacityName);
        spinnerOpacityName.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textNamePosY.getText().length() > 0) {
                    fileName.setLocation(OverlayWindow.fileName.getLocation().x, Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textNamePosY.getText().length() >= 4) {
                    textNamePosY.setText("");
                }
            }
        });
        spinnerOpacityName.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                OverlayWindow.sliderChange(false);
            }
        });
        JLabel lblOpacityName = new JLabel(Shutter.language.getProperty("lblOpacity"));
        lblOpacityName.setFont(new Font("FreeSans", 0, 13));
        lblOpacityName.setAlignmentX(4.0f);
        lblOpacityName.setBounds(OverlayWindow.spinnerOpacityName.getLocation().x - lblOpacityTC.getPreferredSize().width - 11, lblOpacityTC.getLocation().y, lblOpacityName.getPreferredSize().width, 16);
        frame.getContentPane().add(lblOpacityName);
        spinnerSizeName = new JSpinner(new SpinnerNumberModel(Math.round(27.0f * imageRatio), 1, 999, Math.round(imageRatio)));
        spinnerSizeName.setName("spinnerSizeName");
        spinnerSizeName.setFont(new Font("FreeSans", 0, 11));
        spinnerSizeName.setBounds(lblOpacityName.getLocation().x - spinnerSizeTC.getWidth() - 15, lblOpacityTC.getLocation().y - 3, spinnerSizeTC.getWidth(), 22);
        frame.getContentPane().add(spinnerSizeName);
        spinnerSizeName.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                OverlayWindow.sliderChange(false);
            }
        });
        JLabel lblSizeName = new JLabel(Shutter.language.getProperty("lblSize"));
        lblSizeName.setFont(new Font("FreeSans", 0, 13));
        lblSizeName.setAlignmentX(4.0f);
        lblSizeName.setBounds(spinnerSizeName.getX() - lblSizeTC.getWidth() - 11, lblSizeTC.getY(), lblSizeName.getPreferredSize().width, 16);
        frame.getContentPane().add(lblSizeName);
        textNamePosX = new JTextField(String.valueOf((Object)Math.round((float)OverlayWindow.fileName.getLocation().x * imageRatio)));
        textNamePosX.setName("textNamePosX");
        textNamePosX.setBounds(posY2.getLocation().x - textNamePosY.getWidth() - 15, posY2.getLocation().y, textNamePosY.getWidth(), 16);
        textNamePosX.setHorizontalAlignment(4);
        textNamePosX.setFont(new Font("FreeSans", 0, 12));
        frame.getContentPane().add(textNamePosX);
        textNamePosX.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textNamePosX.getText().length() > 0) {
                    fileName.setLocation(Math.round((float)Integer.valueOf(textNamePosX.getText()).intValue() / imageRatio), OverlayWindow.fileName.getLocation().y);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textNamePosX.getText().length() >= 4) {
                    textNamePosX.setText("");
                }
            }
        });
        textNamePosX.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textNamePosX.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textNamePosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textNamePosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseNamePosition.mouseX = e.getX();
                MouseNamePosition.offsetX = Integer.parseInt(textNamePosX.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textNamePosX.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textNamePosX.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textNamePosX.setText(String.valueOf(MouseNamePosition.offsetX + (e.getX() - MouseNamePosition.mouseX)));
                    fileName.setLocation(Math.round((float)Integer.valueOf(textNamePosX.getText()).intValue() / imageRatio), OverlayWindow.fileName.getLocation().y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel posX2 = new JLabel(Shutter.language.getProperty("pX"));
        posX2.setHorizontalAlignment(2);
        posX2.setFont(new Font("FreeSans", 0, 12));
        posX2.setForeground(Utils.themeColor);
        posX2.setAlignmentX(4.0f);
        posX2.setBounds(lblSizeName.getX(), posX.getY(), posX.getPreferredSize().width, 16);
        frame.getContentPane().add(posX2);
        this.btnOK = new JButton(Shutter.language.getProperty("btnApply"));
        this.btnOK.setFont(new Font("Montserrat", 0, 12));
        this.btnOK.setBounds(textTcPosY.getX() + textTcPosY.getWidth() + 9, textTcPosY.getY() - 4, frame.getWidth() - (textTcPosY.getX() + textTcPosY.getWidth()) - (frame.getWidth() - posX2.getX()) - 18, 21);
        frame.getContentPane().add(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Shutter.tempsRestant.setVisible(false);
                Shutter.progressBar1.setValue(0);
                Utils.changeDialogVisibility(frame, true);
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                if (lblBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                    hexTc = Integer.toHexString((int)((float)((Integer)spinnerOpacityTC.getValue() * 255)) / 100);
                    hexAlphaTc = "ff";
                    hexName = Integer.toHexString((int)((float)((Integer)spinnerOpacityName.getValue() * 255)) / 100);
                    hexAlphaName = "ff";
                } else {
                    hexTc = "0";
                    hexAlphaTc = Integer.toHexString((int)((float)((Integer)spinnerOpacityTC.getValue() * 255)) / 100);
                    hexName = "0";
                    hexAlphaName = Integer.toHexString((int)((float)((Integer)spinnerOpacityName.getValue() * 255)) / 100);
                }
                if (hexTc.length() < 2) {
                    hexTc = "0" + hexTc;
                }
                if (hexName.length() < 2) {
                    hexName = "0" + hexName;
                }
                if (hexAlphaTc.length() < 2) {
                    hexAlphaTc = "0" + hexAlphaTc;
                }
                if (hexAlphaName.length() < 2) {
                    hexAlphaName = "0" + hexAlphaName;
                }
                if (System.getProperty("os.name").contains("Mac")) {
                    font = "";
                    File[] fontFolder = new File("/Library/Fonts").listFiles();
                    int i = 0;
                    while (i < fontFolder.length) {
                        if (fontFolder[i].isFile() && fontFolder[i].toString().toLowerCase().replace(" ", "").contains(comboFont.getSelectedItem().toString().toLowerCase().replace(" ", ""))) {
                            font = fontFolder[i].getAbsolutePath();
                        }
                        ++i;
                    }
                    if (font == "") {
                        fontFolder = new File("/System/Library/Fonts").listFiles();
                        i = 0;
                        while (i < fontFolder.length) {
                            if (fontFolder[i].isFile() && fontFolder[i].toString().toLowerCase().replace(" ", "").contains(comboFont.getSelectedItem().toString().toLowerCase().replace(" ", ""))) {
                                font = fontFolder[i].getAbsolutePath();
                            }
                            ++i;
                        }
                    }
                    if (font == "") {
                        fontFolder = new File(String.valueOf(System.getProperty("user.home")) + "/Library/Fonts").listFiles();
                        i = 0;
                        while (i < fontFolder.length) {
                            if (fontFolder[i].isFile() && fontFolder[i].toString().toLowerCase().replace(" ", "").contains(comboFont.getSelectedItem().toString().toLowerCase().replace(" ", ""))) {
                                font = fontFolder[i].getAbsolutePath();
                            }
                            ++i;
                        }
                    }
                } else {
                    font = "font=" + comboFont.getSelectedItem().toString();
                }
            }
        });
        caseShowFileName.setName("caseShowFileName");
        caseShowFileName.setFont(new Font("FreeSans", 0, 12));
        caseShowFileName.setSize(OverlayWindow.caseShowFileName.getPreferredSize().width, 23);
        caseShowFileName.setLocation(lblSizeName.getX(), caseShowTimecode.getY());
        frame.add(caseShowFileName);
        caseShowFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseShowFileName.isSelected()) {
                    caseShowText.setSelected(false);
                    text.setEnabled(false);
                }
                OverlayWindow.sliderChange(false);
            }
        });
        caseShowText.setName("caseShowText");
        caseShowText.setFont(new Font("FreeSans", 0, 12));
        caseShowText.setSize(OverlayWindow.caseShowText.getPreferredSize().width + 4, 23);
        caseShowText.setLocation(caseShowFileName.getX(), caseAddTimecode.getY());
        frame.add(caseShowText);
        caseShowText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseShowText.isSelected()) {
                    caseShowFileName.setSelected(false);
                    text.setEnabled(true);
                } else {
                    text.setEnabled(false);
                }
                OverlayWindow.sliderChange(false);
            }
        });
        text.setName("text");
        text.setEnabled(false);
        text.setLocation(OverlayWindow.caseShowText.getLocation().x + caseShowText.getWidth() + 7, OverlayWindow.caseShowText.getLocation().y + 1);
        text.setSize(frame.getWidth() - text.getX() - 13, 21);
        text.setHorizontalAlignment(2);
        text.setFont(new Font("SansSerif", 0, 12));
        frame.getContentPane().add(text);
        text.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                textTime = System.currentTimeMillis();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (changeText == null || !changeText.isAlive()) {
                    changeText = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            do {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (System.currentTimeMillis() - textTime < 500L);
                            OverlayWindow.sliderChange(false);
                        }
                    });
                    changeText.start();
                }
            }
        });
        changePositions.setBackground(new Color(80, 80, 80));
        changePositions.setOpaque(true);
        changePositions.setHorizontalAlignment(0);
        changePositions.setFont(new Font("Montserrat", 0, 12));
        changePositions.setSize(changePositions.getPreferredSize());
        changePositions.setLocation(this.btnOK.getX() + this.btnOK.getWidth() / 2 - changePositions.getWidth() / 2, this.btnOK.getY() - changePositions.getHeight() - 14);
        changePositions.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (changePositions.getText().equals("<html>Timecode<br>&nbsp;&nbsp;&nbsp;&nbsp;Text</html>")) {
                    changePositions.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Text<br>Timecode</html>");
                    fileName.setLocation(image.getWidth() / 2 - fileName.getWidth() / 2, fileName.getHeight());
                    timecode.setLocation(image.getWidth() / 2 - timecode.getWidth() / 2, containerHeight - timecode.getHeight() * 2);
                } else {
                    changePositions.setText("<html>Timecode<br>&nbsp;&nbsp;&nbsp;&nbsp;Text</html>");
                    timecode.setLocation(image.getWidth() / 2 - timecode.getWidth() / 2, timecode.getHeight());
                    fileName.setLocation(image.getWidth() / 2 - fileName.getWidth() / 2, containerHeight - fileName.getHeight() * 2);
                }
                fileLocX = OverlayWindow.fileName.getLocation().x;
                fileLocY = OverlayWindow.fileName.getLocation().y;
                tcLocX = OverlayWindow.timecode.getLocation().x;
                tcLocY = OverlayWindow.timecode.getLocation().y;
                textNamePosX.setText(String.valueOf(Math.round((float)OverlayWindow.fileName.getLocation().x * imageRatio)));
                textNamePosY.setText(String.valueOf(Math.round((float)OverlayWindow.fileName.getLocation().y * imageRatio)));
                textTcPosX.setText(String.valueOf(Math.round((float)OverlayWindow.timecode.getLocation().x * imageRatio)));
                textTcPosY.setText(String.valueOf(Math.round((float)OverlayWindow.timecode.getLocation().y * imageRatio)));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        frame.getContentPane().add(changePositions);
    }

    public static void sliderChange(boolean loadImage) {
        DecimalFormat tc = new DecimalFormat("00");
        String h = String.valueOf(tc.format(positionVideo.getValue() / 3600000));
        String m = String.valueOf(tc.format(positionVideo.getValue() / 60000 % 60));
        String s = String.valueOf(tc.format(positionVideo.getValue() / 1000 % 60));
        OverlayWindow.loadImage(h, m, s, loadImage);
    }

    public static void loadImage(String h, String m, String s, boolean loadImage) {
        block47: {
            try {
                try {
                    String c;
                    String fichier = Shutter.liste.firstElement();
                    if (Shutter.scanIsRunning) {
                        File dir = new File(Shutter.liste.firstElement());
                        File[] fileArray = dir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (!f.isHidden() && f.isFile()) {
                                fichier = f.toString();
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (loadImage) {
                        File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                        if (file.exists()) {
                            file.delete();
                        }
                        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("tempFolder") + " " + Shutter.dirTemp + System.lineSeparator() + System.lineSeparator());
                        if (!Utils.inputDeviceIsRunning) {
                            FFPROBE.Data(fichier);
                        }
                        do {
                            Thread.sleep(100L);
                        } while (FFPROBE.isRunning);
                        if (caseShowTimecode.isSelected() && FFPROBE.timecode1 == "") {
                            caseShowTimecode.setSelected(false);
                            caseShowTimecode.setEnabled(false);
                            caseAddTimecode.setSelected(true);
                            TC1.setEnabled(true);
                            TC2.setEnabled(true);
                            TC3.setEnabled(true);
                            TC4.setEnabled(true);
                        }
                        if ((float)ImageWidth / (float)ImageHeight >= 1.7777778f) {
                            containerHeight = (int)Math.floor(640.0f / ((float)ImageWidth / (float)ImageHeight));
                            containerWidth = 640;
                        } else {
                            containerWidth = (int)Math.floor((float)ImageWidth / (float)ImageHeight * 360.0f);
                            containerHeight = 360;
                        }
                        if (Shutter.inputDeviceIsRunning) {
                            FFMPEG.run(" " + RecordInputDevice.setInputDevices() + " -vframes 1 -an -vf scale=" + containerWidth + ":" + containerHeight + " -y " + '\"' + Shutter.dirTemp + "preview.bmp" + '\"');
                        } else {
                            FFMPEG.run(" -ss " + h + ":" + m + ":" + s + ".0 -i " + '\"' + fichier + '\"' + " -vframes 1 -an -vf scale=" + containerWidth + ":" + containerHeight + " -y " + '\"' + Shutter.dirTemp + "preview.bmp" + '\"');
                        }
                        do {
                            Thread.sleep(100L);
                        } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error);
                    }
                    image.removeAll();
                    BufferedImage imageBMP = ImageIO.read(new File(String.valueOf(Shutter.dirTemp) + "preview.bmp"));
                    ImageIcon imageIcon = new ImageIcon(imageBMP);
                    JLabel newImage = new JLabel(imageIcon);
                    if (loadImage) {
                        imageIcon.getImage().flush();
                    }
                    newImage.setHorizontalAlignment(0);
                    newImage.setLocation(0, 0);
                    newImage.setSize(containerWidth, containerHeight);
                    String[] sp = FFPROBE.imageResolution.split("x");
                    imageRatio = (float)Integer.parseInt(sp[0]) / (float)containerWidth;
                    int tcPreviousSizeWidth = timecode.getWidth();
                    int tcPreviousSizeHeight = timecode.getHeight();
                    int namePreviousSizeWidth = fileName.getWidth();
                    int namePreviousSizeHeight = fileName.getHeight();
                    if (fontColor != null) {
                        c = Integer.toHexString(fontColor.getRGB()).substring(2);
                        hex = String.valueOf(c.substring(0, 2)) + c.substring(2, 4) + c.substring(4, 6);
                    } else {
                        fontColor = new Color(255, 255, 255);
                    }
                    if (backgroundColor != null) {
                        c = Integer.toHexString(backgroundColor.getRGB()).substring(2);
                        hex2 = String.valueOf(c.substring(0, 2)) + c.substring(2, 4) + c.substring(4, 6);
                    } else {
                        backgroundColor = new Color(0, 0, 0);
                    }
                    fileName.removeAll();
                    JLabel addText = new JLabel(new File(fichier).getName());
                    if (caseShowText.isSelected() && !text.getText().isEmpty()) {
                        addText.setText(text.getText());
                    }
                    fileName.add(addText);
                    addText.setAlignmentX(0.0f);
                    addText.setAlignmentY(1.0f);
                    addText.setFont(new Font(comboFont.getSelectedItem().toString(), 0, Math.round((float)Integer.parseInt(spinnerSizeName.getValue().toString()) / imageRatio)));
                    fileName.setSize(addText.getPreferredSize().width, addText.getPreferredSize().height);
                    fileLocX = OverlayWindow.fileName.getLocation().x;
                    fileLocY = OverlayWindow.fileName.getLocation().y;
                    if (caseShowFileName.isSelected() || caseShowText.isSelected()) {
                        image.add(fileName);
                        int newPosX = Math.round(fileName.getWidth() - namePreviousSizeWidth) / 2;
                        int newPosY = Math.round(fileName.getHeight() - namePreviousSizeHeight) / 2;
                        fileName.setLocation(OverlayWindow.fileName.getLocation().x - newPosX, OverlayWindow.fileName.getLocation().y - newPosY);
                        fileLocX = OverlayWindow.fileName.getLocation().x;
                        fileLocY = OverlayWindow.fileName.getLocation().y;
                        textNamePosX.setText(String.valueOf(Math.round((float)OverlayWindow.fileName.getLocation().x * imageRatio)));
                        textNamePosY.setText(String.valueOf(Math.round((float)OverlayWindow.fileName.getLocation().y * imageRatio)));
                    } else {
                        if (changePositions.getText().equals("<html>Timecode<br>&nbsp;&nbsp;&nbsp;&nbsp;Text</html>")) {
                            fileName.setLocation(image.getWidth() / 2 - fileName.getWidth() / 2, containerHeight - fileName.getHeight() * 2);
                        } else {
                            fileName.setLocation(image.getWidth() / 2 - fileName.getWidth() / 2, fileName.getHeight());
                        }
                        textNamePosX.setText("0");
                        textNamePosY.setText("0");
                    }
                    timecode.removeAll();
                    JLabel addTimecode = new JLabel("00:00:00:00");
                    timecode.add(addTimecode);
                    addTimecode.setAlignmentX(0.0f);
                    addTimecode.setAlignmentY(1.0f);
                    addTimecode.setFont(new Font(comboFont.getSelectedItem().toString(), 0, Math.round((float)Integer.parseInt(spinnerSizeTC.getValue().toString()) / imageRatio)));
                    timecode.setSize(addTimecode.getPreferredSize().width, addTimecode.getPreferredSize().height);
                    tcLocX = OverlayWindow.timecode.getLocation().x;
                    tcLocY = OverlayWindow.timecode.getLocation().y;
                    if (caseAddTimecode.isSelected() || caseShowTimecode.isSelected()) {
                        if (FFPROBE.isRunning) {
                            do {
                                Thread.sleep(100L);
                            } while (FFPROBE.isRunning);
                        }
                        long tcH = 0L;
                        long tcM = 0L;
                        long tcS = 0L;
                        long tcI = 0L;
                        if (!(!caseAddTimecode.isSelected() || TC1.getText().isEmpty() || TC2.getText().isEmpty() || TC3.getText().isEmpty() || TC4.getText().isEmpty())) {
                            tcH = Integer.valueOf(TC1.getText()).intValue();
                            tcM = Integer.valueOf(TC2.getText()).intValue();
                            tcS = Integer.valueOf(TC3.getText()).intValue();
                            tcI = Integer.valueOf(TC4.getText()).intValue();
                        } else if (caseShowTimecode.isSelected()) {
                            tcH = Integer.valueOf(FFPROBE.timecode1).intValue();
                            tcM = Integer.valueOf(FFPROBE.timecode2).intValue();
                            tcS = Integer.valueOf(FFPROBE.timecode3).intValue();
                            tcI = Integer.valueOf(FFPROBE.timecode4).intValue();
                        }
                        long offset = (long)positionVideo.getValue() + (tcH *= 3600000L) + (tcM *= 60000L) + (tcS *= 1000L);
                        DecimalFormat formatter = new DecimalFormat("00");
                        String heures = formatter.format(offset / 1000L / 3600L);
                        String minutes = formatter.format(offset / 1000L / 60L % 60L);
                        String secondes = formatter.format(offset / 1000L % 60L);
                        String images = formatter.format(tcI);
                        if (caseAddTimecode.isSelected() && lblTimecode.getText().equals(Shutter.language.getProperty("lblFrameNumber"))) {
                            addTimecode.setText(String.format("%.0f", Float.valueOf((float)(Integer.parseInt(heures) * 3600) * FFPROBE.currentFPS + (float)(Integer.parseInt(minutes) * 60) * FFPROBE.currentFPS + (float)Integer.parseInt(secondes) * FFPROBE.currentFPS + (float)Integer.parseInt(images))));
                        } else {
                            addTimecode.setText(String.valueOf(heures) + ":" + minutes + ":" + secondes + ":" + images);
                        }
                        image.add(timecode);
                        int newPosX = Math.round(timecode.getWidth() - tcPreviousSizeWidth) / 2;
                        int newPosY = Math.round(timecode.getHeight() - tcPreviousSizeHeight) / 2;
                        timecode.setLocation(OverlayWindow.timecode.getLocation().x - newPosX, OverlayWindow.timecode.getLocation().y - newPosY);
                        tcLocX = OverlayWindow.timecode.getLocation().x;
                        tcLocY = OverlayWindow.timecode.getLocation().y;
                        textTcPosX.setText(String.valueOf(Math.round((float)OverlayWindow.timecode.getLocation().x * imageRatio)));
                        textTcPosY.setText(String.valueOf(Math.round((float)OverlayWindow.timecode.getLocation().y * imageRatio)));
                    } else {
                        if (changePositions.getText().equals("<html>Timecode<br>&nbsp;&nbsp;&nbsp;&nbsp;Text</html>")) {
                            timecode.setLocation(image.getWidth() / 2 - timecode.getWidth() / 2, timecode.getHeight());
                        } else {
                            timecode.setLocation(image.getWidth() / 2 - timecode.getWidth() / 2, containerHeight - timecode.getHeight() * 2);
                        }
                        textTcPosX.setText("0");
                        textTcPosY.setText("0");
                    }
                    image.setLocation(12 + (640 - containerWidth) / 2, 58 + (int)((float)(360 - containerHeight) / 2.0f));
                    image.setSize(newImage.getSize());
                    imageIcon = new ImageIcon(imageBMP);
                    newImage = new JLabel(imageIcon);
                    newImage.setSize(containerWidth, containerHeight);
                    JPanel topBorder = new JPanel();
                    topBorder.setBackground(Color.BLACK);
                    topBorder.setVisible(false);
                    topBorder.setOpaque(true);
                    JPanel bottomBorder = new JPanel();
                    bottomBorder.setBackground(Color.BLACK);
                    bottomBorder.setVisible(false);
                    bottomBorder.setOpaque(true);
                    JPanel leftBorder = new JPanel();
                    leftBorder.setBackground(Color.BLACK);
                    leftBorder.setVisible(false);
                    leftBorder.setOpaque(true);
                    JPanel rightBorder = new JPanel();
                    rightBorder.setBackground(Color.BLACK);
                    rightBorder.setVisible(false);
                    rightBorder.setOpaque(true);
                    if (Shutter.caseRognage.isSelected()) {
                        String[] i = FFPROBE.imageResolution.split("x");
                        String original = String.valueOf((float)Integer.parseInt(i[0]) / (float)Integer.parseInt(i[1]));
                        String[] o = Shutter.comboH264Taille.getSelectedItem().toString().split("x");
                        String output = String.valueOf((float)Integer.parseInt(o[0]) / (float)Integer.parseInt(o[1]));
                        if (original.length() > 4) {
                            original = original.substring(0, 4);
                        }
                        if (Float.parseFloat(output) < Float.parseFloat(original)) {
                            int crop = Integer.parseInt(o[0]);
                            int borderWidth = (int)Math.floor(((float)containerWidth - (float)newImage.getHeight() / ((float)ImageHeight / (float)crop)) / 2.0f);
                            leftBorder.setSize(borderWidth, newImage.getHeight());
                            rightBorder.setSize(borderWidth, newImage.getHeight());
                            rightBorder.setLocation(containerWidth - rightBorder.getWidth(), 0);
                            leftBorder.setVisible(true);
                            rightBorder.setVisible(true);
                            newImage.add(leftBorder);
                            newImage.add(rightBorder);
                        } else {
                            int crop = Integer.parseInt(o[1]);
                            int borderHeight = (int)Math.floor(((float)containerHeight - (float)newImage.getWidth() / ((float)ImageWidth / (float)crop)) / 2.0f);
                            topBorder.setSize(newImage.getWidth(), borderHeight);
                            bottomBorder.setSize(newImage.getWidth(), borderHeight);
                            bottomBorder.setLocation(0, containerHeight - bottomBorder.getHeight());
                            topBorder.setVisible(true);
                            bottomBorder.setVisible(true);
                            newImage.add(topBorder);
                            newImage.add(bottomBorder);
                        }
                    }
                    image.add(newImage);
                    image.repaint();
                    fileName.repaint();
                    timecode.repaint();
                    if (!frame.isVisible()) {
                        Utils.changeDialogVisibility(frame, false);
                    }
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                    Shutter.enableAll();
                    if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        break block47;
                    }
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
            finally {
                Shutter.enableAll();
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        }
    }

    public static void loadSettings(final File encFile) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        Thread.sleep(100L);
                    } while (frame == null && !frame.isVisible());
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    File fXmlFile = encFile;
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(fXmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("Component");
                    int temp = 0;
                    while (temp < nList.getLength()) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            Element eElement = (Element)nNode;
                            Component[] componentArray = frame.getContentPane().getComponents();
                            int n = componentArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Component p = componentArray[n2];
                                if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                    if (p instanceof JPanel) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        String[] s = eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().replace("]", "").replace("r=", "").replace("g=", "").replace("b=", "").split("\\[");
                                        String[] s2 = s[1].split(",");
                                        ((JPanel)p).setBackground(new Color(Integer.valueOf(s2[0]), Integer.valueOf(s2[1]), Integer.valueOf(s2[2])));
                                        if (p.getName().equals("panelColor")) {
                                            fontColor = panelColor.getBackground();
                                        } else if (p.getName().equals("panelColor2")) {
                                            backgroundColor = panelColor2.getBackground();
                                        }
                                        OverlayWindow.sliderChange(false);
                                    }
                                    if (p instanceof JRadioButton) {
                                        if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                            if (!((JRadioButton)p).isSelected()) {
                                                ((JRadioButton)p).doClick();
                                            }
                                        } else if (((JRadioButton)p).isSelected()) {
                                            ((JRadioButton)p).doClick();
                                        }
                                        ((JRadioButton)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JRadioButton)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JLabel) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        ((JLabel)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                        ((JLabel)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JLabel)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JComboBox) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        ((JComboBox)p).setSelectedItem(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                        ((JComboBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JComboBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JTextField) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                        ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        if (p.getName().equals("textNamePosX") && textNamePosX.getText().length() > 0) {
                                            fileName.setLocation(Math.round((float)Integer.valueOf(textNamePosX.getText()).intValue() / imageRatio), OverlayWindow.fileName.getLocation().y);
                                        }
                                        if (p.getName().equals("textNamePosY") && textNamePosY.getText().length() > 0) {
                                            fileName.setLocation(OverlayWindow.fileName.getLocation().x, Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
                                        }
                                        if (p.getName().equals("textTcPosY") && textTcPosY.getText().length() > 0) {
                                            timecode.setLocation(OverlayWindow.timecode.getLocation().x, Math.round((float)Integer.valueOf(textTcPosY.getText()).intValue() / imageRatio));
                                        }
                                        if (p.getName().equals("textTcPosX") && textTcPosX.getText().length() > 0) {
                                            timecode.setLocation(Math.round((float)Integer.valueOf(textTcPosX.getText()).intValue() / imageRatio), OverlayWindow.timecode.getLocation().y);
                                        }
                                    } else if (p instanceof JSpinner) {
                                        do {
                                            Thread.sleep(100L);
                                        } while (!file.exists());
                                        ((JSpinner)p).setValue(Integer.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()));
                                        ((JSpinner)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JSpinner)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    }
                                }
                                ++n2;
                            }
                        }
                        ++temp;
                    }
                    OverlayWindow.sliderChange(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    private class ComboRendererOverlay
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;
        private JComboBox comboBox;
        final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private int row;

        private ComboRendererOverlay(JComboBox fontsBox) {
            this.comboBox = fontsBox;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (list.getModel().getSize() > 0) {
                Accessible accessible = this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
            }
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, this.row, isSelected, cellHasFocus);
            Object fntObj = value;
            String fontFamilyName = (String)fntObj;
            this.setFont(new Font(fontFamilyName, 0, 16));
            return this;
        }
    }

    private static class MouseNamePosition {
        static int mouseX;
        static int offsetX;
        static int mouseY;
        static int offsetY;

        private MouseNamePosition() {
        }
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }

    private static class MouseTcPosition {
        static int mouseX;
        static int offsetX;
        static int mouseY;
        static int offsetY;

        private MouseTcPosition() {
        }
    }
}

