/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ComboBoxRenderer;
import application.Shutter;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextPane;

public class Help {
    public static JFrame frame;
    private String pathToFonctions;
    private JTextPane txtFonctions;
    private JComboBox<String[]> comboFonctions;
    private JButton btnVideoDePresentation;
    private JButton btnDoc;

    public Help() {
        frame = new JFrame();
        frame.getContentPane().setLayout(null);
        frame.setResizable(false);
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
            frame.setSize(640, 64);
        } else {
            frame.setSize(640, 74);
        }
        frame.setTitle(Shutter.language.getProperty("frameAstuces"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.setDefaultCloseOperation(2);
        frame.setLocation(Shutter.frame.getLocation().x + Shutter.frame.getSize().width + 20, Shutter.frame.getLocation().y);
        this.loadFonctions();
        frame.setVisible(true);
        try {
            this.txtFonctions.setText(this.readFile(String.valueOf(this.pathToFonctions) + "/" + this.comboFonctions.getSelectedItem().toString() + ".txt"));
            if (this.txtFonctions.getText().length() > 0) {
                this.txtFonctions.setSize(572, this.txtFonctions.getPreferredSize().height);
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    frame.setSize(640, this.txtFonctions.getHeight() + 56);
                } else {
                    frame.setSize(640, this.txtFonctions.getHeight() + 66);
                }
            }
        }
        catch (IOException e) {
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                frame.setSize(640, 64);
            }
            frame.setSize(640, 74);
        }
    }

    private void loadFonctions() {
        this.pathToFonctions = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        this.pathToFonctions = System.getProperty("os.name").contains("Windows") ? this.pathToFonctions.substring(1, this.pathToFonctions.length() - 1) : this.pathToFonctions.substring(0, this.pathToFonctions.length() - 1);
        this.pathToFonctions = Shutter.getLanguage.equals("Fran\u00e7ais") ? String.valueOf(this.pathToFonctions.substring(0, this.pathToFonctions.lastIndexOf("/")).replace("%20", " ")) + "/Help/fr" : (Shutter.getLanguage.equals("Italiano") ? String.valueOf(this.pathToFonctions.substring(0, this.pathToFonctions.lastIndexOf("/")).replace("%20", " ")) + "/Help/it" : String.valueOf(this.pathToFonctions.substring(0, this.pathToFonctions.lastIndexOf("/")).replace("%20", " ")) + "/Help/en");
        JLabel lblFonctions = new JLabel(Shutter.language.getProperty("lblFonctions"));
        lblFonctions.setForeground(Color.WHITE);
        lblFonctions.setFont(new Font("FreeSans", 0, 12));
        lblFonctions.setBounds(6, 11, lblFonctions.getPreferredSize().width, 15);
        frame.getContentPane().add(lblFonctions);
        this.comboFonctions = new JComboBox();
        this.comboFonctions.setModel(Shutter.comboFonctions.getModel());
        this.comboFonctions.setFont(new Font("FreeSans", 0, 11));
        this.comboFonctions.setEditable(true);
        this.comboFonctions.setMaximumRowCount(Toolkit.getDefaultToolkit().getScreenSize().height / 33);
        this.comboFonctions.setBounds(133, 8, 168, 22);
        this.comboFonctions.setRenderer(new ComboBoxRenderer());
        frame.getContentPane().add(this.comboFonctions);
        if (!Shutter.comboFonctions.isEnabled()) {
            this.comboFonctions.setEnabled(false);
        } else {
            this.comboFonctions.setEnabled(true);
        }
        this.btnDoc = new JButton(Shutter.language.getProperty("btnDoc"));
        this.btnDoc.setFont(new Font("Montserrat", 0, 12));
        this.btnDoc.setMargin(new Insets(0, 0, 0, 0));
        this.btnDoc.setBounds(310, 9, 143, 21);
        frame.getContentPane().add(this.btnDoc);
        this.btnVideoDePresentation = new JButton(Shutter.language.getProperty("btnVideoDePresentation"));
        this.btnVideoDePresentation.setFont(new Font("Montserrat", 0, 12));
        this.btnVideoDePresentation.setMargin(new Insets(0, 0, 0, 0));
        this.btnVideoDePresentation.setBounds(this.btnDoc.getX() + this.btnDoc.getWidth() + 6, 9, 156, 21);
        frame.getContentPane().add(this.btnVideoDePresentation);
        this.txtFonctions = new JTextPane();
        this.txtFonctions.setFont(new Font("FreeSans", 0, 14));
        this.txtFonctions.setLocation(10, 38);
        this.txtFonctions.setForeground(Color.WHITE);
        this.txtFonctions.setSize(572, this.txtFonctions.getPreferredSize().height);
        this.txtFonctions.setBackground(new Color(50, 50, 50));
        this.txtFonctions.setEditable(false);
        frame.getContentPane().add(this.txtFonctions);
        this.comboFonctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Help.this.txtFonctions.setText(Help.this.readFile(String.valueOf(Help.this.pathToFonctions) + "/" + Help.this.comboFonctions.getSelectedItem().toString() + ".txt"));
                    if (Help.this.txtFonctions.getText().length() > 0) {
                        Help.this.txtFonctions.setSize(572, Help.this.txtFonctions.getPreferredSize().height);
                        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                            frame.setSize(640, Help.this.txtFonctions.getHeight() + 56);
                        } else {
                            frame.setSize(640, Help.this.txtFonctions.getHeight() + 66);
                        }
                    }
                }
                catch (IOException e) {
                    if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                        frame.setSize(640, 64);
                    }
                    frame.setSize(640, 74);
                }
            }
        });
        this.btnVideoDePresentation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.youtube.com/results?search_query=Shutter+Encoder"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btnDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.shutterencoder.com/documentation.html"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private String readFile(String fileName) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), StandardCharsets.ISO_8859_1));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }
}

