/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.Functions;
import application.RecordInputDevice;
import application.RenderQueue;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import library.FFMPEG;
import library.FFPROBE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CropVideo {
    public static JDialog frame;
    private static JPanel image;
    public static JComboBox<String> comboPreset;
    private JLabel quit;
    private JPanel topPanel;
    private JLabel topImage;
    private static JPanel haut;
    private static JPanel bas;
    private static JPanel gauche;
    private static JPanel droit;
    private JButton btnOK;
    private JLabel lblPresets;
    private static JRadioButton caseManuel;
    private static JLabel lblRatio;
    private JSlider positionVideo;
    public static boolean sliderChange;
    private int x;
    private static int y;
    public static int ImageWidth;
    public static int ImageHeight;
    public static int containerWidth;
    public static int containerHeight;

    static {
        image = new JPanel();
        comboPreset = new JComboBox();
        caseManuel = new JRadioButton(Shutter.language.getProperty("caseManuel"));
        lblRatio = new JLabel();
        sliderChange = false;
        containerWidth = 640;
        containerHeight = 360;
    }

    public CropVideo() {
        frame = new JDialog();
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameCropVideo"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(665, 465);
        frame.setResizable(false);
        if (Functions.frame != null && Functions.frame.isVisible()) {
            frame.setModal(false);
        } else {
            frame.setModal(true);
        }
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - CropVideo.frame.getSize().width / 2, dim.height / 2 - CropVideo.frame.getSize().height / 2);
        }
        this.topPanel();
        this.image();
        this.boutons();
        CropVideo.loadImage("00", "00", "00");
        this.globalTimer();
        Shutter.ratioFinal = 0.0f;
        Utils.changeDialogVisibility(frame, false);
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(CropVideo.frame.getSize().width - 24, 0, 21, 21);
        this.topPanel.add(this.quit);
        this.topPanel.setBounds(0, 0, 1000, 52);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CropVideo.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                    Shutter.ratioFinal = 0.0f;
                    Utils.changeDialogVisibility(frame, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CropVideo.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CropVideo.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        JLabel title = new JLabel(Shutter.language.getProperty("frameCropVideo"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 52);
        title.setFont(new Font("Magneto", 0, 26));
        this.topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.topPanel.add(this.topImage);
        this.topPanel.setBounds(0, 0, 1000, 52);
        frame.getContentPane().add(this.topPanel);
        image.setBounds(12, 58, 640, 360);
        frame.getContentPane().add(image);
        this.topImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.topImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void image() {
        image.setLayout(null);
        image.setOpaque(false);
        haut = new JPanel();
        haut.setBackground(Color.BLACK);
        haut.setForeground(Color.BLACK);
        haut.setBounds(0, 0, 640, 0);
        image.add(haut);
        bas = new JPanel();
        bas.setForeground(Color.BLACK);
        bas.setBackground(Color.BLACK);
        bas.setBounds(0, 360, 640, 0);
        image.add(bas);
        gauche = new JPanel();
        gauche.setBackground(Color.BLACK);
        gauche.setForeground(Color.BLACK);
        gauche.setBounds(0, 0, 0, 360);
        image.add(gauche);
        droit = new JPanel();
        droit.setBackground(Color.BLACK);
        droit.setForeground(Color.BLACK);
        droit.setBounds(640, 0, 0, 360);
        image.add(droit);
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (comboPreset.isEnabled()) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (comboPreset.isEnabled()) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                } else if (y >= 0 && y <= (int)((float)containerHeight) / 2 - 1) {
                    frame.setCursor(Cursor.getPredefinedCursor(9));
                } else if (y <= containerHeight && y >= (int)((float)containerHeight) / 2 + 1) {
                    frame.setCursor(Cursor.getPredefinedCursor(8));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        haut.addMouseListener(mouseListener);
        image.addMouseListener(mouseListener);
        bas.addMouseListener(mouseListener);
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (caseManuel.isSelected()) {
                    if (y >= 0 && y <= (int)((float)containerHeight) / 2 - 1 && !comboPreset.isEnabled()) {
                        haut.setSize(CropVideo.haut.getSize().width, y);
                        bas.setSize(CropVideo.haut.getSize().width, y);
                        bas.setLocation(CropVideo.bas.getLocation().x, y + (CropVideo.image.getSize().height - 2 * CropVideo.haut.getSize().height));
                    } else if (y <= containerHeight && y >= (int)((float)containerHeight) / 2 + 1 && !comboPreset.isEnabled()) {
                        haut.setSize(CropVideo.haut.getSize().width, containerHeight - y);
                        bas.setSize(CropVideo.haut.getSize().width, containerHeight - y);
                        bas.setLocation(CropVideo.bas.getLocation().x, containerHeight - y + (CropVideo.image.getSize().height - 2 * CropVideo.bas.getSize().height));
                    }
                    int borderSize = CropVideo.image.getSize().height - 2 * CropVideo.haut.getSize().height;
                    lblRatio.setText(String.valueOf(Shutter.language.getProperty("ratio")) + " " + Math.floor((float)containerWidth / (float)borderSize * 100.0f) / 100.0);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
        haut.addMouseMotionListener(mouseMotionListener);
        image.addMouseMotionListener(mouseMotionListener);
        bas.addMouseMotionListener(mouseMotionListener);
    }

    private void boutons() {
        this.btnOK = new JButton("OK");
        this.btnOK.setFont(new Font("Montserrat", 0, 12));
        this.btnOK.setBounds(537, 433, 113, 21);
        frame.getContentPane().add(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float ratio = 0.0f;
                ratio = !caseManuel.isSelected() ? (Float.parseFloat(comboPreset.getSelectedItem().toString()) == 1.33f ? 1.3333334f : (Float.parseFloat(comboPreset.getSelectedItem().toString()) == 1.0f ? 1.0f : (Float.parseFloat(comboPreset.getSelectedItem().toString()) == 0.8f ? 0.8f : (Float.parseFloat(comboPreset.getSelectedItem().toString()) == 1.77f ? 1.7777778f : (Float.parseFloat(comboPreset.getSelectedItem().toString()) < 1.77f ? (float)((double)containerWidth / ((double)CropVideo.image.getSize().width - 2.0 * gauche.getSize().getWidth())) : (Float.parseFloat(comboPreset.getSelectedItem().toString()) == 2.33f ? 2.3333333f : (float)((double)containerWidth / ((double)CropVideo.image.getSize().height - 2.0 * haut.getSize().getHeight())))))))) : (float)((double)containerWidth / ((double)CropVideo.image.getSize().height - 2.0 * haut.getSize().getHeight()));
                Shutter.ratioFinal = ratio;
                Shutter.tempsRestant.setVisible(false);
                Shutter.progressBar1.setValue(0);
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                Utils.changeDialogVisibility(frame, true);
            }
        });
        String[] listePreset = new String[]{"2.75", "2.55", "2.39", "2.35", "2.33", "1.91", "1.85", "1.77", "1.33", "1", "0.8"};
        comboPreset.setName("comboPreset");
        comboPreset.setModel(new DefaultComboBoxModel<String>(listePreset));
        comboPreset.setMaximumRowCount(10);
        comboPreset.setEnabled(false);
        comboPreset.setEditable(true);
        comboPreset.setSelectedIndex(-1);
        comboPreset.setFont(new Font("FreeSans", 0, 11));
        comboPreset.setBounds(465, 433, 63, 22);
        frame.getContentPane().add(comboPreset);
        comboPreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block6: {
                    if (!comboPreset.getSelectedItem().toString().isEmpty()) {
                        try {
                            String[] r = FFPROBE.imageResolution.split("x");
                            String original = String.valueOf((float)Integer.parseInt(r[0]) / (float)Integer.parseInt(r[1]));
                            if (original.length() > 4) {
                                original = original.substring(0, 4);
                            }
                            if (Float.parseFloat(comboPreset.getSelectedItem().toString()) < Float.parseFloat(original)) {
                                Float ratio = Float.valueOf(Float.parseFloat(comboPreset.getSelectedItem().toString()) * (float)containerHeight);
                                int largeur = (int)((float)CropVideo.image.getSize().width - ratio.floatValue()) / 2;
                                gauche.setSize(largeur, CropVideo.gauche.getSize().height);
                                droit.setSize(largeur, CropVideo.gauche.getSize().height);
                                droit.setLocation(largeur + (CropVideo.image.getSize().width - 2 * CropVideo.gauche.getSize().width), CropVideo.droit.getLocation().y);
                                haut.setBounds(0, 0, 640, 0);
                                bas.setBounds(0, 360, 640, 0);
                            } else {
                                Float ratio = Float.valueOf((float)containerWidth / Float.parseFloat(comboPreset.getSelectedItem().toString()));
                                int hauteur = (int)((float)CropVideo.image.getSize().height - ratio.floatValue()) / 2;
                                haut.setSize(CropVideo.haut.getSize().width, hauteur);
                                bas.setSize(CropVideo.haut.getSize().width, hauteur);
                                bas.setLocation(CropVideo.bas.getLocation().x, hauteur + (CropVideo.image.getSize().height - 2 * CropVideo.haut.getSize().height));
                                gauche.setBounds(0, 0, 0, 360);
                                droit.setBounds(640, 0, 0, 360);
                            }
                            lblRatio.setText(String.valueOf(Shutter.language.getProperty("ratio")) + " " + comboPreset.getSelectedItem().toString());
                        }
                        catch (Exception er) {
                            if (comboPreset.getSelectedItem().toString() == "") break block6;
                            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("wrongValue"), Shutter.language.getProperty("wrongFormat"), 0);
                        }
                    }
                }
            }
        });
        this.lblPresets = new JLabel(Shutter.language.getProperty("lblPresets"));
        this.lblPresets.setFont(new Font("FreeSans", 0, 13));
        this.lblPresets.setBounds(comboPreset.getX() - this.lblPresets.getPreferredSize().width - 4, 435, this.lblPresets.getPreferredSize().width, 16);
        frame.getContentPane().add(this.lblPresets);
        caseManuel.setName("caseManuel");
        caseManuel.setFont(new Font("FreeSans", 0, 12));
        caseManuel.setSelected(true);
        caseManuel.setBounds(250, 435, CropVideo.caseManuel.getPreferredSize().width, 16);
        frame.getContentPane().add(caseManuel);
        caseManuel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (caseManuel.isSelected()) {
                    comboPreset.setEnabled(false);
                    comboPreset.setSelectedItem("");
                    gauche.setBounds(0, 0, 0, 360);
                    droit.setBounds(640, 0, 0, 360);
                } else {
                    comboPreset.setEnabled(true);
                    comboPreset.setSelectedIndex(0);
                }
            }
        });
        lblRatio.setName("lblRatio");
        lblRatio.setFont(new Font("Montserrat", 0, 13));
        lblRatio.setForeground(Utils.themeColor);
        lblRatio.setBounds(170, 434, 88, 16);
        frame.getContentPane().add(lblRatio);
        this.positionVideo = new JSlider();
        if (Shutter.scanIsRunning) {
            File dir = new File(Shutter.liste.firstElement());
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.isHidden() && f.isFile()) {
                    FFPROBE.Data(f.toString());
                }
                ++n2;
            }
        } else if (!Utils.inputDeviceIsRunning) {
            FFPROBE.Data(Shutter.liste.firstElement());
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException dir) {
                // empty catch block
            }
        } while (FFPROBE.totalLength == 0 && FFPROBE.isRunning);
        this.positionVideo.setMaximum(FFPROBE.totalLength);
        this.positionVideo.setValue(0);
        this.positionVideo.setFont(new Font("FreeSans", 0, 11));
        this.positionVideo.setBounds(12, 432, 146, 22);
        Component[] components = frame.getContentPane().getComponents();
        boolean addToFrame = true;
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JSlider) {
                addToFrame = false;
            }
            ++i;
        }
        if (addToFrame) {
            frame.getContentPane().add(this.positionVideo);
        }
        this.positionVideo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Thread runProcess = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DecimalFormat tc = new DecimalFormat("00");
                        String h = String.valueOf(tc.format((this).CropVideo.this.positionVideo.getValue() / 3600000));
                        String m = String.valueOf(tc.format((this).CropVideo.this.positionVideo.getValue() / 60000 % 60));
                        String s = String.valueOf(tc.format((this).CropVideo.this.positionVideo.getValue() / 1000 % 60));
                        CropVideo.loadImage(h, m, s);
                    }
                });
                runProcess.start();
                sliderChange = false;
            }
        });
    }

    public static void loadImage(String h, String m, String s) {
        block22: {
            try {
                try {
                    File file;
                    String fichier = Shutter.liste.firstElement();
                    if (Shutter.scanIsRunning) {
                        File dir = new File(Shutter.liste.firstElement());
                        File[] fileArray = dir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (!f.isHidden() && f.isFile()) {
                                fichier = f.toString();
                                break;
                            }
                            ++n2;
                        }
                    }
                    if ((file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp")).exists()) {
                        file.delete();
                    }
                    Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("tempFolder") + " " + Shutter.dirTemp + System.lineSeparator() + System.lineSeparator());
                    if (!Utils.inputDeviceIsRunning) {
                        FFPROBE.Data(fichier);
                    }
                    do {
                        Thread.sleep(100L);
                    } while (FFPROBE.isRunning);
                    if ((float)ImageWidth / (float)ImageHeight >= 1.7777778f) {
                        containerHeight = (int)Math.floor(640.0f / ((float)ImageWidth / (float)ImageHeight));
                        containerWidth = 640;
                    } else {
                        containerWidth = (int)Math.floor((float)ImageWidth / (float)ImageHeight * 360.0f);
                        containerHeight = 360;
                    }
                    if (Shutter.inputDeviceIsRunning) {
                        FFMPEG.run(" " + RecordInputDevice.setInputDevices() + " -vframes 1 -an -vf scale=" + containerWidth + ":" + containerHeight + " -y " + '\"' + Shutter.dirTemp + "preview.bmp" + '\"');
                    } else {
                        FFMPEG.run(" -ss " + h + ":" + m + ":" + s + ".0 -i " + '\"' + fichier + '\"' + " -vframes 1 -an -vf scale=" + containerWidth + ":" + containerHeight + " -y " + '\"' + Shutter.dirTemp + "preview.bmp" + '\"');
                    }
                    do {
                        Thread.sleep(100L);
                    } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error);
                    if (FFMPEG.error) {
                        JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                    }
                    image.removeAll();
                    image.add(haut);
                    image.add(bas);
                    image.add(gauche);
                    image.add(droit);
                    BufferedImage imageBMP = ImageIO.read(new File(String.valueOf(Shutter.dirTemp) + "preview.bmp"));
                    ImageIcon imageIcon = new ImageIcon(imageBMP);
                    JLabel newImage = new JLabel(imageIcon);
                    imageIcon.getImage().flush();
                    newImage.setHorizontalAlignment(0);
                    newImage.setLocation(0, 0);
                    newImage.setSize(containerWidth, containerHeight);
                    image.setLocation(12 + (640 - containerWidth) / 2, 58 + (int)((float)(360 - containerHeight) / 2.0f));
                    image.setSize(newImage.getSize());
                    imageIcon = new ImageIcon(imageBMP);
                    newImage = new JLabel(imageIcon);
                    newImage.setSize(containerWidth, containerHeight);
                    image.add(newImage);
                    image.repaint();
                    frame.getContentPane().repaint();
                    if (caseManuel.isSelected()) {
                        int borderSize = CropVideo.image.getSize().height - 2 * CropVideo.haut.getSize().height;
                        lblRatio.setText(String.valueOf(Shutter.language.getProperty("ratio")) + " " + Math.floor((float)containerWidth / (float)borderSize * 100.0f) / 100.0);
                        bas.setLocation(CropVideo.bas.getLocation().x, image.getHeight() - bas.getHeight());
                    } else {
                        lblRatio.setText(String.valueOf(Shutter.language.getProperty("ratio")) + " " + comboPreset.getSelectedItem().toString());
                        comboPreset.setSelectedItem(comboPreset.getSelectedItem().toString());
                    }
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                    Shutter.enableAll();
                    if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        break block22;
                    }
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
            finally {
                Shutter.enableAll();
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        }
    }

    private void globalTimer() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                CropVideo.this.x = MouseInfo.getPointerInfo().getLocation().x - CropVideo.frame.getLocation().x - CropVideo.image.getLocation().x;
                y = MouseInfo.getPointerInfo().getLocation().y - CropVideo.frame.getLocation().y - CropVideo.image.getLocation().y;
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(task, 0L, 10L);
    }

    public static void loadSettings(final File encFile) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        Thread.sleep(100L);
                    } while (frame == null && !frame.isVisible());
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    do {
                        Thread.sleep(100L);
                    } while (!file.exists());
                    File fXmlFile = encFile;
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(fXmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("Component");
                    int temp = 0;
                    while (temp < nList.getLength()) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            Element eElement = (Element)nNode;
                            Component[] componentArray = frame.getContentPane().getComponents();
                            int n = componentArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Component p = componentArray[n2];
                                if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                    if (p instanceof JLabel) {
                                        ((JLabel)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                        ((JLabel)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JLabel)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JRadioButton) {
                                        if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                            if (!((JRadioButton)p).isSelected()) {
                                                ((JRadioButton)p).doClick();
                                            }
                                        } else if (((JRadioButton)p).isSelected()) {
                                            ((JRadioButton)p).doClick();
                                        }
                                        ((JRadioButton)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JRadioButton)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JComboBox) {
                                        comboPreset.setSelectedIndex(0);
                                        ((JComboBox)p).setSelectedItem(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                        ((JComboBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JComboBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    }
                                }
                                ++n2;
                            }
                        }
                        ++temp;
                    }
                    if (caseManuel.isSelected()) {
                        String[] s = lblRatio.getText().split(":");
                        float ratio = Float.parseFloat(s[1].replace(" ", ""));
                        int hauteur = (int)((float)CropVideo.image.getSize().height - ratio) / 2;
                        haut.setSize(CropVideo.haut.getSize().width, hauteur);
                        bas.setSize(CropVideo.haut.getSize().width, hauteur);
                        bas.setLocation(CropVideo.bas.getLocation().x, hauteur + (CropVideo.image.getSize().height - 2 * CropVideo.haut.getSize().height));
                        gauche.setBounds(0, 0, 0, 360);
                        droit.setBounds(640, 0, 0, 360);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }
}

