/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.Functions;
import application.RecordInputDevice;
import application.RenderQueue;
import application.Shutter;
import application.Utils;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import library.DCRAW;
import library.EXIFTOOL;
import library.FFMPEG;
import library.FFPROBE;
import library.XPDF;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CropImage {
    public static JDialog frame;
    private static JPanel overImage;
    private static JPanel image;
    private JLabel quit;
    private JLabel fullscreen;
    private static JPanel topPanel;
    private static JLabel title;
    ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
    private JLabel topImage;
    private JLabel bottomImage;
    private static JPanel selection;
    public static JButton btnOK;
    private static int startX;
    private static int startY;
    private static int ancrageDroit;
    private static int ancrageBas;
    public static JSlider positionVideo;
    public static int ImageWidth;
    public static int ImageHeight;
    public static int finalWidth;
    public static int finalHeight;
    private static boolean dragWindow;
    private static boolean drag;
    private static boolean shift;
    private static boolean ctrl;
    private static int frameX;
    private static int frameY;
    public static JTextField textPosX;
    public static JLabel posX;
    public static JTextField textPosY;
    public static JLabel posY;
    public static JTextField textWidth;
    public static JLabel width;
    public static JTextField textHeight;
    public static JLabel height;
    public static JLabel px1;
    public static JLabel px2;
    public static JLabel px3;
    public static JLabel px4;

    static {
        image = new JPanel();
        title = new JLabel(Shutter.language.getProperty("frameCropImage"));
        startX = 0;
        startY = 0;
        drag = false;
        shift = false;
        ctrl = false;
    }

    public CropImage() {
        frame = new JDialog();
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameCropImage"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(665, 665);
        frame.setResizable(false);
        if (Functions.frame != null && Functions.frame.isVisible()) {
            frame.setModal(false);
        } else {
            frame.setModal(true);
        }
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - CropImage.frame.getSize().width / 2, dim.height / 2 - CropImage.frame.getSize().height / 2);
        }
        dragWindow = false;
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                shape1.add(shape2);
                frame.setShape(shape1);
            }
        });
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getX() >= 625 && e.getY() >= 625 && dragWindow) {
                    frame.setSize(e.getX() + 20, e.getY() + 20);
                }
                CropImage.image();
                CropImage.this.resizeAll();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseInfo.getPointerInfo().getLocation().x - CropImage.frame.getLocation().x > CropImage.frame.getSize().width - 20 || MouseInfo.getPointerInfo().getLocation().y - CropImage.frame.getLocation().y > CropImage.frame.getSize().height - 20) {
                    frame.setCursor(Cursor.getPredefinedCursor(5));
                } else if (!dragWindow) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor().getType() == 5) {
                    dragWindow = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (dragWindow) {
                    if (CropImage.frame.getSize().width < 665 || CropImage.frame.getSize().height < 665) {
                        frame.setSize(665, 665);
                        CropImage.this.resizeAll();
                    }
                    CropImage.loadImage();
                    int value = (int)Math.floor((float)(Integer.valueOf(textPosX.getText()) * image.getHeight()) / (float)ImageHeight);
                    selection.setLocation(value, CropImage.selection.getLocation().y);
                    value = (int)Math.floor((float)(Integer.valueOf(textPosY.getText()) * image.getWidth()) / (float)ImageWidth);
                    selection.setLocation(CropImage.selection.getLocation().x, value);
                    value = (int)Math.floor((float)(Integer.valueOf(textWidth.getText()) * image.getHeight()) / (float)ImageHeight);
                    selection.setSize(value, selection.getHeight());
                    value = (int)Math.floor((float)(Integer.valueOf(textHeight.getText()) * image.getWidth()) / (float)ImageWidth);
                    selection.setSize(selection.getWidth(), value);
                }
                dragWindow = false;
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (frame.getCursor().getType() == 5) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.topPanel();
        CropImage.loadImage();
        btnOK = new JButton(Shutter.language.getProperty("btnApply"));
        btnOK.setFont(new Font("Montserrat", 0, 12));
        btnOK.setBounds(14, frame.getHeight() - 31, frame.getWidth() - 28, 21);
        frame.getContentPane().add(btnOK);
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Shutter.cropFinal = "crop=" + textWidth.getText() + ":" + textHeight.getText() + ":" + textPosX.getText() + ":" + textPosY.getText();
                Shutter.tempsRestant.setVisible(false);
                Shutter.progressBar1.setValue(0);
                Utils.changeDialogVisibility(frame, true);
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
            }
        });
        CropImage.valeurs();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent ke = (KeyEvent)event;
                int mouseInPictureX = MouseInfo.getPointerInfo().getLocation().x - CropImage.frame.getLocation().x - frameX;
                int mouseInPictureY = MouseInfo.getPointerInfo().getLocation().y - CropImage.frame.getLocation().y - frameY;
                if (mouseInPictureX > 0 && mouseInPictureX < image.getWidth() && mouseInPictureY > 0 && mouseInPictureY < image.getHeight() && ke.getID() == 401) {
                    if (ke.getKeyCode() == 16) {
                        shift = true;
                    }
                    if (ke.getKeyCode() == 17) {
                        ctrl = true;
                    }
                    if (ke.getKeyCode() == 38) {
                        selection.setLocation(CropImage.selection.getLocation().x, CropImage.selection.getLocation().y - 1);
                    }
                    if (ke.getKeyCode() == 40) {
                        selection.setLocation(CropImage.selection.getLocation().x, CropImage.selection.getLocation().y + 1);
                    }
                    if (ke.getKeyCode() == 37) {
                        selection.setLocation(CropImage.selection.getLocation().x - 1, CropImage.selection.getLocation().y);
                    }
                    if (ke.getKeyCode() == 39) {
                        selection.setLocation(CropImage.selection.getLocation().x + 1, CropImage.selection.getLocation().y);
                    }
                    if (ke.getKeyCode() == 27) {
                        selection.setBounds(image.getWidth() / 4, image.getHeight() / 4, image.getWidth() / 2, image.getHeight() / 2);
                        ancrageDroit = CropImage.selection.getLocation().x + selection.getWidth();
                        ancrageBas = CropImage.selection.getLocation().y + selection.getHeight();
                        selection.repaint();
                        image.repaint();
                    }
                    CropImage.checkSelection();
                }
                if (ke.getID() == 402) {
                    if (ke.getKeyCode() == 16) {
                        shift = false;
                    }
                    ctrl = false;
                }
            }
        }, 8L);
        CropImage.checkSelection();
        Utils.changeDialogVisibility(frame, false);
    }

    private void topPanel() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBounds(0, 0, frame.getWidth(), 52);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(CropImage.frame.getSize().width - 24, 0, 21, 21);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CropImage.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                    Utils.changeDialogVisibility(frame, true);
                    Shutter.cropFinal = null;
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    Shutter.caseRognerImage.setSelected(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CropImage.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CropImage.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        this.fullscreen = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max2.png")));
        this.fullscreen.setHorizontalAlignment(0);
        this.fullscreen.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        this.fullscreen.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CropImage.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle winSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                int taskBarHeight = screenSize.height - winSize.height;
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                if (this.accept && frame.getHeight() < screenSize.height - taskBarHeight) {
                    if (ImageHeight > ImageWidth) {
                        frame.setBounds(0, 0, screenSize.width, screenSize.height - taskBarHeight);
                    } else {
                        int setWidth = (int)((float)(screenSize.height - topPanel.getHeight() - 35 - 22 - 17 - taskBarHeight) * ((float)ImageWidth / (float)ImageHeight));
                        if (setWidth <= screenSize.width) {
                            frame.setSize(setWidth, screenSize.height - taskBarHeight);
                        } else {
                            frame.setSize(screenSize.width, screenSize.height - taskBarHeight);
                        }
                        frame.setLocation(dim.width / 2 - CropImage.frame.getSize().width / 2, 0);
                    }
                } else if (this.accept) {
                    frame.setSize(665, 665);
                    frame.setLocation(dim.width / 2 - CropImage.frame.getSize().width / 2, dim.height / 2 - CropImage.frame.getSize().height / 2);
                }
                CropImage.image();
                CropImage.this.resizeAll();
                CropImage.loadImage();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CropImage.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CropImage.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max2.png")));
                this.accept = false;
            }
        });
        this.bottomImage = new JLabel();
        ImageIcon imageIcon = new ImageIcon(this.header.getImage().getScaledInstance(CropImage.topPanel.getSize().width, CropImage.topPanel.getSize().height, 16));
        this.bottomImage.setIcon(imageIcon);
        this.bottomImage.setBounds(0, 0, CropImage.frame.getSize().width, 52);
        this.bottomImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
                if (down.getClickCount() == 2 && down.getButton() == 1) {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Rectangle winSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                    int taskBarHeight = screenSize.height - winSize.height;
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    if (frame.getHeight() < screenSize.height - taskBarHeight) {
                        if (ImageHeight > ImageWidth) {
                            frame.setBounds(0, 0, screenSize.width, screenSize.height - taskBarHeight);
                        } else {
                            int setWidth = (int)((float)(screenSize.height - topPanel.getHeight() - 35 - 22 - 17 - taskBarHeight) * ((float)ImageWidth / (float)ImageHeight));
                            if (setWidth <= screenSize.width) {
                                frame.setSize(setWidth, screenSize.height - taskBarHeight);
                            } else {
                                frame.setSize(screenSize.width, screenSize.height - taskBarHeight);
                            }
                            frame.setLocation(dim.width / 2 - CropImage.frame.getSize().width / 2, 0);
                        }
                    } else {
                        frame.setSize(665, 665);
                        frame.setLocation(dim.width / 2 - CropImage.frame.getSize().width / 2, dim.height / 2 - CropImage.frame.getSize().height / 2);
                    }
                    CropImage.image();
                    CropImage.this.resizeAll();
                    CropImage.loadImage();
                }
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
                frame.toFront();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.bottomImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 52);
        title.setFont(new Font("Magneto", 0, 26));
        topPanel.add(title);
        this.topImage = new JLabel();
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        topPanel.add(this.quit);
        topPanel.add(this.fullscreen);
        topPanel.add(this.bottomImage);
        topPanel.add(this.topImage);
        topPanel.add(this.bottomImage);
        frame.getContentPane().add(topPanel);
    }

    protected static void checkSelection() {
        int outH;
        int outW;
        if (CropImage.selection.getLocation().x < 0) {
            selection.setLocation(0, CropImage.selection.getLocation().y);
        }
        if (CropImage.selection.getLocation().y < 0) {
            selection.setLocation(CropImage.selection.getLocation().x, 0);
        }
        if (CropImage.selection.getLocation().x + selection.getWidth() > image.getWidth()) {
            if (frame.getCursor() == Cursor.getPredefinedCursor(13)) {
                selection.setLocation(image.getWidth() - selection.getWidth(), CropImage.selection.getLocation().y);
            } else {
                selection.setSize(image.getWidth() - CropImage.selection.getLocation().x, selection.getHeight());
            }
        }
        if (CropImage.selection.getLocation().y + selection.getHeight() > image.getHeight()) {
            if (frame.getCursor() == Cursor.getPredefinedCursor(13)) {
                selection.setLocation(CropImage.selection.getLocation().x, image.getHeight() - selection.getHeight());
            } else {
                selection.setSize(selection.getWidth(), image.getHeight() - CropImage.selection.getLocation().y);
            }
        }
        if (selection.getWidth() > image.getWidth()) {
            selection.setSize(image.getWidth(), selection.getHeight());
        }
        int borderW = selection.getWidth();
        int borderH = selection.getHeight();
        if (ImageHeight > ImageWidth) {
            outW = Math.round((float)ImageWidth / ((float)finalWidth / (float)borderW));
            outH = Math.round((float)ImageHeight / ((float)(frame.getHeight() - topPanel.getHeight() - 35 - 22 - 17) / (float)borderH));
        } else {
            outW = Math.round((float)ImageWidth / ((float)(frame.getWidth() - 24) / (float)borderW));
            outH = Math.round((float)ImageHeight / ((float)finalHeight / (float)borderH));
        }
        int Px = Math.round((float)ImageWidth / ((float)CropImage.image.getSize().width / (float)CropImage.selection.getLocation().x));
        int Py = Math.round((float)ImageHeight / ((float)CropImage.image.getSize().height / (float)CropImage.selection.getLocation().y));
        if (textWidth.getText().matches("[0-9]+") && textHeight.getText().matches("[0-9]+")) {
            if (Px + Integer.valueOf(textWidth.getText()) > ImageWidth) {
                Px += ImageWidth - (Px + Integer.valueOf(textWidth.getText()));
            }
            if (Py + Integer.valueOf(textHeight.getText()) > ImageHeight) {
                Py += ImageHeight - (Py + Integer.valueOf(textHeight.getText()));
            }
            if (Integer.valueOf(textWidth.getText()) != ImageWidth) {
                textPosX.setText(String.valueOf(Px));
            }
            if (Integer.valueOf(textHeight.getText()) != ImageHeight) {
                textPosY.setText(String.valueOf(Py));
            }
        } else {
            textPosX.setText(String.valueOf(Px));
            textPosY.setText(String.valueOf(Py));
        }
        if (frame.getCursor() != Cursor.getPredefinedCursor(13)) {
            textWidth.setText(String.valueOf(outW));
            textHeight.setText(String.valueOf(outH));
        }
    }

    public static void valeurs() {
        posX = new JLabel(Shutter.language.getProperty("posX"));
        posX.setHorizontalAlignment(2);
        posX.setFont(new Font("FreeSans", 0, 12));
        posX.setForeground(Utils.themeColor);
        posX.setBounds(14, CropImage.btnOK.getLocation().y - 22, CropImage.posX.getPreferredSize().width, 16);
        textPosX = new JTextField();
        textPosX.setName("textPosX");
        textPosX.setBounds(CropImage.posX.getLocation().x + posX.getWidth() + 2, CropImage.posX.getLocation().y, 34, 16);
        textPosX.setHorizontalAlignment(4);
        textPosX.setFont(new Font("FreeSans", 0, 12));
        px1 = new JLabel("px");
        px1.setFont(new Font("FreeSans", 0, 12));
        px1.setForeground(Utils.themeColor);
        px1.setBounds(CropImage.textPosX.getLocation().x + textPosX.getWidth() + 2, CropImage.btnOK.getLocation().y - 22, CropImage.posX.getPreferredSize().width, 16);
        textPosX.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textPosX.getText().length() > 0) {
                    int value = (int)Math.floor((float)(Integer.valueOf(textPosX.getText()) * image.getHeight()) / (float)ImageHeight);
                    selection.setLocation(value, CropImage.selection.getLocation().y);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textPosX.getText().length() >= 4) {
                    textPosX.setText("");
                }
            }
        });
        posY = new JLabel(Shutter.language.getProperty("posY"));
        posY.setFont(new Font("FreeSans", 0, 12));
        posY.setForeground(Utils.themeColor);
        posY.setBounds(btnOK.getWidth() / 2 - 120, CropImage.posX.getLocation().y, CropImage.posY.getPreferredSize().width, 16);
        textPosY = new JTextField();
        textPosY.setName("textPosY");
        textPosY.setBounds(CropImage.posY.getLocation().x + posY.getWidth() + 2, CropImage.posY.getLocation().y, 34, 16);
        textPosY.setHorizontalAlignment(4);
        textPosY.setFont(new Font("FreeSans", 0, 12));
        textPosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textPosY.getText().length() > 0) {
                    int value = (int)Math.floor((float)(Integer.valueOf(textPosY.getText()) * image.getWidth()) / (float)ImageWidth);
                    selection.setLocation(CropImage.selection.getLocation().x, value);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textPosY.getText().length() >= 4) {
                    textPosY.setText("");
                }
            }
        });
        px2 = new JLabel("px");
        px2.setFont(new Font("FreeSans", 0, 12));
        px2.setForeground(Utils.themeColor);
        px2.setBounds(CropImage.textPosY.getLocation().x + textPosY.getWidth() + 2, CropImage.btnOK.getLocation().y - 22, CropImage.posX.getPreferredSize().width, 16);
        width = new JLabel(Shutter.language.getProperty("lblWidth"));
        width.setFont(new Font("FreeSans", 0, 12));
        width.setForeground(Utils.themeColor);
        width.setBounds(btnOK.getWidth() / 2 + 45, CropImage.posX.getLocation().y, CropImage.width.getPreferredSize().width, 16);
        textWidth = new JTextField();
        textWidth.setName("textWidth");
        textWidth.setBounds(CropImage.width.getLocation().x + width.getWidth() + 2, CropImage.width.getLocation().y, 34, 16);
        textWidth.setHorizontalAlignment(4);
        textWidth.setFont(new Font("FreeSans", 0, 12));
        textWidth.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textWidth.getText().length() > 0) {
                    int value = (int)Math.floor((float)(Integer.valueOf(textWidth.getText()) * image.getHeight()) / (float)ImageHeight);
                    selection.setSize(value, selection.getHeight());
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textWidth.getText().length() >= 4) {
                    textWidth.setText("");
                }
            }
        });
        px3 = new JLabel("px");
        px3.setFont(new Font("FreeSans", 0, 12));
        px3.setForeground(Utils.themeColor);
        px3.setBounds(CropImage.textWidth.getLocation().x + textWidth.getWidth() + 2, CropImage.btnOK.getLocation().y - 22, CropImage.posX.getPreferredSize().width, 16);
        height = new JLabel(Shutter.language.getProperty("lblHeight"));
        height.setHorizontalAlignment(4);
        height.setFont(new Font("FreeSans", 0, 12));
        height.setForeground(Utils.themeColor);
        height.setBounds(CropImage.btnOK.getLocation().x + btnOK.getWidth() - 104, CropImage.posX.getLocation().y, CropImage.height.getPreferredSize().width, 16);
        textHeight = new JTextField();
        textHeight.setName("textHeight");
        textHeight.setBounds(CropImage.height.getLocation().x + height.getWidth() + 2, CropImage.height.getLocation().y, 34, 16);
        textHeight.setHorizontalAlignment(4);
        textHeight.setFont(new Font("FreeSans", 0, 12));
        textHeight.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textHeight.getText().length() > 0) {
                    int value = (int)Math.floor((float)(Integer.valueOf(textHeight.getText()) * image.getWidth()) / (float)ImageWidth);
                    selection.setSize(selection.getWidth(), value);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textHeight.getText().length() >= 4) {
                    textHeight.setText("");
                }
            }
        });
        px4 = new JLabel("px");
        px4.setFont(new Font("FreeSans", 0, 12));
        px4.setForeground(Utils.themeColor);
        px4.setBounds(CropImage.textHeight.getLocation().x + textHeight.getWidth() + 2, CropImage.btnOK.getLocation().y - 22, CropImage.posX.getPreferredSize().width, 16);
        frame.getContentPane().add(posX);
        frame.getContentPane().add(textPosX);
        frame.getContentPane().add(px1);
        frame.getContentPane().add(posY);
        frame.getContentPane().add(textPosY);
        frame.getContentPane().add(px2);
        frame.getContentPane().add(width);
        frame.getContentPane().add(textWidth);
        frame.getContentPane().add(px3);
        frame.getContentPane().add(height);
        frame.getContentPane().add(textHeight);
        frame.getContentPane().add(px4);
        positionVideo = new JSlider();
        if (Shutter.scanIsRunning) {
            File dir = new File(Shutter.liste.firstElement());
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.isHidden() && f.isFile()) {
                    FFPROBE.Data(f.toString());
                }
                ++n2;
            }
        } else if (!Utils.inputDeviceIsRunning) {
            FFPROBE.Data(Shutter.fileList.getSelectedValue().toString());
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (FFPROBE.totalLength == 0 && FFPROBE.isRunning);
        if (FFPROBE.totalLength > 100) {
            positionVideo.setVisible(true);
        } else {
            positionVideo.setVisible(false);
        }
        positionVideo.setMaximum(FFPROBE.totalLength);
        positionVideo.setValue(0);
        positionVideo.setFont(new Font("FreeSans", 0, 11));
        positionVideo.setBounds(14, posX.getY() - 22, frame.getWidth() - 28, 22);
        frame.getContentPane().add(positionVideo);
        positionVideo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                CropImage.loadImage();
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    private static void image() {
        int containerWidth;
        int containerHeight;
        image.removeAll();
        if (ImageHeight > ImageWidth) {
            containerHeight = frame.getHeight() - topPanel.getHeight() - 35 - 22 - 17;
            containerWidth = (int)Math.floor((float)(frame.getHeight() - topPanel.getHeight() - 35 - 22 - 17) * (float)ImageWidth / (float)ImageHeight);
        } else {
            containerHeight = (int)Math.floor((float)(frame.getWidth() - 24) * (float)ImageHeight / (float)ImageWidth);
            containerWidth = frame.getWidth() - 24;
        }
        image.setSize(containerWidth, containerHeight);
        Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
        Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
        shape1.add(shape2);
        frame.setShape(shape1);
        if (ImageHeight > ImageWidth) {
            image.setLocation((int)Math.floor((float)(frame.getWidth() - containerWidth) / 2.0f) + 10, 62);
        } else {
            image.setLocation(12, (int)Math.floor((float)(frame.getHeight() - containerHeight) / 2.0f));
        }
        frameX = CropImage.image.getLocation().x;
        frameY = CropImage.image.getLocation().y;
        image.setLayout(null);
        image.setOpaque(false);
        selection = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(Utils.themeColor);
                g.fillRect(0, 0, 6, 6);
                g.fillRect(selection.getWidth() / 2 - 3, 0, 6, 6);
                g.fillRect(selection.getWidth() - 6, 0, 6, 6);
                g.fillRect(selection.getWidth() - 6, selection.getHeight() / 2 - 3, 6, 6);
                g.fillRect(selection.getWidth() - 6, selection.getHeight() - 6, 6, 6);
                g.fillRect(selection.getWidth() / 2 - 3, selection.getHeight() - 6, 6, 6);
                g.fillRect(0, selection.getHeight() - 6, 6, 6);
                g.fillRect(0, selection.getHeight() / 2 - 3, 6, 6);
            }
        };
        selection.setBorder(BorderFactory.createDashedBorder(Color.WHITE, 4.0f, 4.0f));
        selection.setBounds(image.getWidth() / 4, image.getHeight() / 4, image.getWidth() / 2, image.getHeight() / 2);
        image.add(selection);
        ancrageDroit = CropImage.selection.getLocation().x + selection.getWidth();
        ancrageBas = CropImage.selection.getLocation().y + selection.getHeight();
        selection.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                drag = true;
                int mouseX = MouseInfo.getPointerInfo().getLocation().x - CropImage.frame.getLocation().x - startX - frameX;
                int mouseY = MouseInfo.getPointerInfo().getLocation().y - CropImage.frame.getLocation().y - startY - frameY;
                int mouseInPictureX = MouseInfo.getPointerInfo().getLocation().x - CropImage.frame.getLocation().x - frameX;
                int mouseInPictureY = MouseInfo.getPointerInfo().getLocation().y - CropImage.frame.getLocation().y - frameY;
                if (mouseInPictureX > -10 && mouseInPictureX < image.getWidth() + 10 && mouseInPictureY > -10 && mouseInPictureY < image.getHeight() + 10) {
                    if (frame.getCursor() == Cursor.getPredefinedCursor(6)) {
                        selection.setLocation(mouseX, mouseY);
                        if (shift) {
                            selection.setSize(2 * ancrageDroit - 2 * mouseX - selection.getWidth(), 2 * ancrageBas - 2 * mouseY - selection.getHeight());
                        } else {
                            selection.setSize(ancrageDroit - mouseX, ancrageBas - mouseY);
                        }
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(8)) {
                        selection.setLocation(CropImage.selection.getLocation().x, mouseY);
                        if (shift) {
                            selection.setSize(CropImage.selection.getSize().width, 2 * ancrageBas - 2 * mouseY - selection.getHeight());
                        } else {
                            selection.setSize(CropImage.selection.getSize().width, ancrageBas - mouseY);
                        }
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(7)) {
                        if (shift) {
                            selection.setLocation(CropImage.selection.getLocation().x + (selection.getWidth() - e.getX()), mouseY);
                            selection.setSize(e.getX() - (selection.getWidth() - e.getX()), 2 * ancrageBas - 2 * mouseY - selection.getHeight());
                        } else {
                            selection.setLocation(CropImage.selection.getLocation().x, mouseY);
                            selection.setSize(e.getX(), ancrageBas - mouseY);
                        }
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(11)) {
                        if (shift) {
                            selection.setLocation(CropImage.selection.getLocation().x + (selection.getWidth() - e.getX()), CropImage.selection.getLocation().y);
                            selection.setSize(e.getX() - (selection.getWidth() - e.getX()), CropImage.selection.getSize().height);
                        } else {
                            selection.setSize(e.getX(), CropImage.selection.getSize().height);
                        }
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(5)) {
                        if (shift) {
                            selection.setLocation(CropImage.selection.getLocation().x + (selection.getWidth() - e.getX()), CropImage.selection.getLocation().y + (selection.getHeight() - e.getY()));
                            selection.setSize(e.getX() - (selection.getWidth() - e.getX()), e.getY() - (selection.getHeight() - e.getY()));
                        } else {
                            selection.setSize(e.getX(), e.getY());
                        }
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(9)) {
                        if (shift) {
                            selection.setLocation(CropImage.selection.getLocation().x, CropImage.selection.getLocation().y + (selection.getHeight() - e.getY()));
                            selection.setSize(CropImage.selection.getSize().width, e.getY() - (selection.getHeight() - e.getY()));
                        } else {
                            selection.setSize(CropImage.selection.getSize().width, e.getY());
                        }
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(4)) {
                        if (shift) {
                            selection.setLocation(mouseX, CropImage.selection.getLocation().y + (selection.getHeight() - e.getY()));
                            selection.setSize(2 * ancrageDroit - 2 * mouseX - selection.getWidth(), e.getY() - (selection.getHeight() - e.getY()));
                        } else {
                            selection.setLocation(mouseX, CropImage.selection.getLocation().y);
                            selection.setSize(ancrageDroit - mouseX, e.getY());
                        }
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(10)) {
                        selection.setLocation(mouseX, CropImage.selection.getLocation().y);
                        if (shift) {
                            selection.setSize(2 * ancrageDroit - 2 * mouseX - selection.getWidth(), CropImage.selection.getSize().height);
                        } else {
                            selection.setSize(ancrageDroit - mouseX, CropImage.selection.getSize().height);
                        }
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(13)) {
                        if (shift && ctrl) {
                            selection.setLocation(mouseX, CropImage.selection.getLocation().y);
                        } else if (shift) {
                            selection.setLocation(CropImage.selection.getLocation().x, mouseY);
                        } else if (ctrl) {
                            selection.setLocation(mouseX, CropImage.selection.getLocation().y);
                        } else {
                            selection.setLocation(mouseX, mouseY);
                        }
                    }
                }
                ancrageDroit = CropImage.selection.getLocation().x + selection.getWidth();
                ancrageBas = CropImage.selection.getLocation().y + selection.getHeight();
                CropImage.checkSelection();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!drag) {
                    if (e.getX() <= 10 && e.getY() <= 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (e.getX() <= selection.getWidth() / 2 + 5 && e.getX() >= selection.getWidth() / 2 - 5 && e.getY() <= 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(8));
                    } else if (e.getX() <= selection.getWidth() && e.getX() >= selection.getWidth() - 10 && e.getY() <= 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (e.getX() <= selection.getWidth() && e.getX() >= selection.getWidth() - 10 && e.getY() <= selection.getHeight() / 2 + 5 && e.getY() >= selection.getHeight() / 2 - 5) {
                        frame.setCursor(Cursor.getPredefinedCursor(11));
                    } else if (e.getX() <= selection.getWidth() && e.getX() >= selection.getWidth() - 10 && e.getY() <= selection.getHeight() && e.getY() >= selection.getHeight() - 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else if (e.getX() <= selection.getWidth() / 2 + 5 && e.getX() >= selection.getWidth() / 2 - 5 && e.getY() <= selection.getHeight() && e.getY() >= selection.getHeight() - 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(9));
                    } else if (e.getX() <= 10 && e.getY() <= selection.getHeight() && e.getY() >= selection.getHeight() - 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (e.getX() <= 6 && e.getY() <= selection.getHeight() / 2 + 5 && e.getY() >= selection.getHeight() / 2 - 5) {
                        frame.setCursor(Cursor.getPredefinedCursor(10));
                    } else {
                        frame.setCursor(Cursor.getPredefinedCursor(13));
                    }
                }
            }
        });
        selection.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                startX = e.getPoint().x;
                startY = e.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                drag = false;
                if (CropImage.selection.getLocation().x <= 0 && CropImage.selection.getLocation().y <= 0) {
                    selection.setLocation(0, 0);
                } else if (CropImage.selection.getLocation().x + selection.getWidth() > image.getWidth() && CropImage.selection.getLocation().y <= 0) {
                    selection.setLocation(image.getWidth() - selection.getWidth(), 0);
                } else if (CropImage.selection.getLocation().x <= 0 && CropImage.selection.getLocation().y + selection.getHeight() > image.getHeight()) {
                    selection.setLocation(0, image.getHeight() - selection.getHeight());
                } else if (CropImage.selection.getLocation().x + selection.getWidth() > image.getWidth() && CropImage.selection.getLocation().y + selection.getHeight() > image.getHeight()) {
                    selection.setLocation(image.getWidth() - selection.getWidth(), image.getHeight() - selection.getHeight());
                } else if (CropImage.selection.getLocation().x + selection.getWidth() > image.getWidth()) {
                    selection.setLocation(image.getWidth() - selection.getWidth(), CropImage.selection.getLocation().y);
                } else if (CropImage.selection.getLocation().y + selection.getHeight() > image.getHeight()) {
                    selection.setLocation(CropImage.selection.getLocation().x, image.getHeight() - selection.getHeight());
                } else if (CropImage.selection.getLocation().x <= 0) {
                    selection.setLocation(0, CropImage.selection.getLocation().y);
                } else if (CropImage.selection.getLocation().y <= 0) {
                    selection.setLocation(CropImage.selection.getLocation().x, 0);
                }
            }
        });
        image.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    selection.setBounds(image.getWidth() / 4, image.getHeight() / 4, image.getWidth() / 2, image.getHeight() / 2);
                    ancrageDroit = CropImage.selection.getLocation().x + selection.getWidth();
                    ancrageBas = CropImage.selection.getLocation().y + selection.getHeight();
                    selection.repaint();
                    image.repaint();
                    CropImage.checkSelection();
                }
            }
        });
        image.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent down) {
                if (!drag) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        if (overImage == null) {
            overImage = new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setColor(new Color(255, 255, 255, 0));
                    g2d.fillRect(0, 0, containerWidth, containerHeight);
                    Area outter = new Area(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                    Rectangle inner = new Rectangle(CropImage.selection.getLocation().x, CropImage.selection.getLocation().y, selection.getWidth(), selection.getHeight());
                    outter.subtract(new Area(inner));
                    g2d.setColor(new Color(0, 0, 0, 180));
                    g2d.fill(outter);
                }
            };
        }
        overImage.setBounds(image.getBounds());
        overImage.setLayout(null);
        frame.getContentPane().add(overImage);
        frame.getContentPane().add(image);
    }

    public static void loadImage() {
        block73: {
            try {
                try {
                    File file = new File(Shutter.liste.firstElement());
                    if (Shutter.scanIsRunning) {
                        File dir = new File(Shutter.liste.firstElement());
                        File[] fileArray = dir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (!f.isHidden() && f.isFile()) {
                                file = new File(f.toString());
                                break;
                            }
                            ++n2;
                        }
                    }
                    String extension = file.toString().substring(file.toString().lastIndexOf("."));
                    boolean isRaw = false;
                    switch (extension.toLowerCase()) {
                        case ".3fr": 
                        case ".arw": 
                        case ".cr2": 
                        case ".cr3": 
                        case ".crw": 
                        case ".dng": 
                        case ".kdc": 
                        case ".mrw": 
                        case ".nef": 
                        case ".nrw": 
                        case ".orf": 
                        case ".pef": 
                        case ".r3d": 
                        case ".ptx": 
                        case ".raf": 
                        case ".rw2": 
                        case ".srw": 
                        case ".x3f": {
                            isRaw = true;
                        }
                    }
                    if (extension.toLowerCase().equals(".pdf")) {
                        XPDF.toFFPROBE(file.toString());
                        do {
                            Thread.sleep(100L);
                        } while (XPDF.isRunning);
                    } else if (isRaw) {
                        EXIFTOOL.run(file.toString());
                        do {
                            Thread.sleep(100L);
                        } while (EXIFTOOL.isRunning);
                    } else {
                        if (!Utils.inputDeviceIsRunning) {
                            FFPROBE.Data(file.toString());
                        }
                        do {
                            Thread.sleep(100L);
                        } while (FFPROBE.isRunning);
                    }
                    finalWidth = (int)Math.floor((frame.getHeight() - topPanel.getHeight() - 35 - 22 - 17) * ImageWidth / ImageHeight);
                    finalHeight = (int)Math.floor((frame.getWidth() - 24) * ImageHeight / ImageWidth);
                    File fileOut = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (fileOut.exists()) {
                        fileOut.delete();
                    }
                    Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("tempFolder") + " " + Shutter.dirTemp + System.lineSeparator() + System.lineSeparator());
                    FFMPEG.fonctionInOut();
                    if (positionVideo != null && positionVideo.getValue() > 0 && positionVideo.getValue() < positionVideo.getMaximum() && FFPROBE.totalLength > 100) {
                        DecimalFormat tc = new DecimalFormat("00");
                        String h = String.valueOf(tc.format(positionVideo.getValue() / 3600000));
                        String m = String.valueOf(tc.format(positionVideo.getValue() / 60000 % 60));
                        String s = String.valueOf(tc.format(positionVideo.getValue() / 1000 % 60));
                        FFMPEG.inPoint = " -ss " + h + ":" + m + ":" + s + ".0";
                    }
                    String cmd = ImageHeight > ImageWidth ? " -vframes 1 -an -s " + finalWidth + "x" + (frame.getHeight() - topPanel.getHeight() - 35 - 22 - 17) + " -y " : " -vframes 1 -an -s " + (frame.getWidth() - 24) + "x" + finalHeight + " -y ";
                    if (extension.toLowerCase().equals(".pdf")) {
                        XPDF.run(" -r 300 -f 1 -l 1 \"" + file.toString() + '\"' + " - | PathToFFMPEG -i -" + cmd + '\"' + fileOut + '\"');
                    } else if (isRaw) {
                        DCRAW.run(" -v -w -c -q 0 -6 -g 2.4 12.92 \"" + file.toString() + '\"' + " | PathToFFMPEG -i -" + cmd + '\"' + fileOut + '\"');
                    } else if (Shutter.inputDeviceIsRunning) {
                        FFMPEG.run(" " + RecordInputDevice.setInputDevices() + cmd + '\"' + fileOut + '\"');
                    } else {
                        FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + cmd + '\"' + fileOut + '\"');
                    }
                    do {
                        Thread.sleep(100L);
                    } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error);
                    if (FFMPEG.error) {
                        JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                    }
                    image.removeAll();
                    CropImage.image();
                    BufferedImage imageBMP = ImageIO.read(new File(String.valueOf(Shutter.dirTemp) + "preview.bmp"));
                    ImageIcon imageIcon = new ImageIcon(imageBMP);
                    JLabel newImage = new JLabel(imageIcon);
                    imageIcon.getImage().flush();
                    newImage.setHorizontalAlignment(0);
                    if (ImageHeight > ImageWidth) {
                        newImage.setBounds(0, 0, (int)Math.floor((float)(frame.getHeight() - topPanel.getHeight() - 35 - 22 - 17) * (float)ImageWidth / (float)ImageHeight), frame.getHeight() - topPanel.getHeight() - 35 - 22 - 17);
                    } else {
                        newImage.setBounds(0, 0, frame.getWidth() - 24, (int)Math.floor((float)(frame.getWidth() - 24) * (float)ImageHeight / (float)ImageWidth));
                    }
                    imageIcon = new ImageIcon(imageBMP);
                    newImage = new JLabel(imageIcon);
                    newImage.setSize(image.getSize());
                    image.add(newImage);
                    image.repaint();
                    selection.repaint();
                    frame.getContentPane().repaint();
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                    if (btnOK != null) {
                        CropImage.checkSelection();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                    Shutter.enableAll();
                    if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        break block73;
                    }
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
            finally {
                Shutter.enableAll();
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        }
    }

    public static void loadSettings(final File encFile) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        Thread.sleep(100L);
                    } while (frame == null && !frame.isVisible());
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    do {
                        Thread.sleep(100L);
                    } while (!file.exists());
                    File fXmlFile = encFile;
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(fXmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("Component");
                    int temp = 0;
                    while (temp < nList.getLength()) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            Element eElement = (Element)nNode;
                            Component[] componentArray = frame.getContentPane().getComponents();
                            int n = componentArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Component p = componentArray[n2];
                                if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent()) && p instanceof JTextField) {
                                    int value;
                                    do {
                                        Thread.sleep(100L);
                                    } while (!file.exists());
                                    ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                    ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    if (p.getName().equals("textPosX") && textPosX.getText().length() > 0) {
                                        value = (int)Math.floor((float)(Integer.valueOf(textPosX.getText()) * image.getHeight()) / (float)ImageHeight);
                                        selection.setLocation(value, CropImage.selection.getLocation().y);
                                    }
                                    if (p.getName().equals("textPosY") && textPosY.getText().length() > 0) {
                                        value = (int)Math.floor((float)(Integer.valueOf(textPosY.getText()) * image.getWidth()) / (float)ImageWidth);
                                        selection.setLocation(CropImage.selection.getLocation().x, value);
                                    }
                                    if (p.getName().equals("textWidth") && textWidth.getText().length() > 0) {
                                        value = (int)Math.floor((float)(Integer.valueOf(textWidth.getText()) * image.getHeight()) / (float)ImageHeight);
                                        selection.setSize(value, selection.getHeight());
                                    }
                                    if (p.getName().equals("textHeight") && textHeight.getText().length() > 0) {
                                        value = (int)Math.floor((float)(Integer.valueOf(textHeight.getText()) * image.getWidth()) / (float)ImageWidth);
                                        selection.setSize(selection.getWidth(), value);
                                    }
                                }
                                ++n2;
                            }
                        }
                        ++temp;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    private void resizeAll() {
        topPanel.setBounds(0, 0, CropImage.frame.getSize().width, 52);
        this.topImage.setLocation(CropImage.frame.getSize().width / 2 - this.topImage.getSize().width / 2, 0);
        this.quit.setBounds(CropImage.frame.getSize().width - 24, 0, 21, 21);
        this.fullscreen.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        ImageIcon imageIcon = new ImageIcon(this.header.getImage().getScaledInstance(CropImage.topPanel.getSize().width, CropImage.topPanel.getSize().height, 16));
        this.bottomImage.setIcon(imageIcon);
        this.bottomImage.setBounds(0, 0, CropImage.frame.getSize().width, 52);
        title.setBounds(0, 0, frame.getWidth(), 52);
        btnOK.setBounds(14, frame.getHeight() - 31, frame.getWidth() - 28, 21);
        posX.setLocation(14, CropImage.btnOK.getLocation().y - 22);
        textPosX.setLocation(CropImage.posX.getLocation().x + posX.getWidth() + 2, CropImage.posX.getLocation().y);
        px1.setLocation(CropImage.textPosX.getLocation().x + textPosX.getWidth() + 2, CropImage.btnOK.getLocation().y - 22);
        posY.setLocation(btnOK.getWidth() / 4 + posY.getWidth(), CropImage.posX.getLocation().y);
        textPosY.setLocation(CropImage.posY.getLocation().x + posY.getWidth() + 2, CropImage.posY.getLocation().y);
        px2.setLocation(CropImage.textPosY.getLocation().x + textPosY.getWidth() + 2, CropImage.btnOK.getLocation().y - 22);
        width.setLocation(btnOK.getWidth() / 4 * 2 + width.getWidth(), CropImage.posX.getLocation().y);
        textWidth.setLocation(CropImage.width.getLocation().x + width.getWidth() + 2, CropImage.width.getLocation().y);
        px3.setLocation(CropImage.textWidth.getLocation().x + textWidth.getWidth() + 2, CropImage.btnOK.getLocation().y - 22);
        height.setLocation(CropImage.btnOK.getLocation().x + btnOK.getWidth() - 104, CropImage.posX.getLocation().y);
        textHeight.setLocation(CropImage.height.getLocation().x + height.getWidth() + 2, CropImage.height.getLocation().y);
        px4.setLocation(CropImage.textHeight.getLocation().x + textHeight.getWidth() + 2, CropImage.btnOK.getLocation().y - 22);
        positionVideo.setBounds(14, posX.getY() - 22, frame.getWidth() - 28, 22);
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }
}

