/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.RecordInputDevice;
import application.RenderQueue;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import library.DCRAW;
import library.EXIFTOOL;
import library.FFMPEG;
import library.FFPLAY;
import library.FFPROBE;
import library.XPDF;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ColorImage {
    public static JFrame frame;
    private static JPanel image;
    private static Thread runProcess;
    private JLabel quit;
    private JLabel fullscreen;
    private JLabel reduce;
    private static JPanel topPanel;
    private static JLabel title;
    ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
    private JLabel topImage;
    private JLabel bottomImage;
    private static JButton btnOK;
    private static JButton btnOriginal;
    private static JButton btnPreview;
    private static JButton btnExportImage;
    private static JButton btnPrevious;
    private static JButton btnNext;
    private static JButton btnReset;
    public static JComboBox<String> comboRGB;
    public static JSlider sliderExposure;
    public static JSlider sliderContrast;
    public static JSlider sliderHighlights;
    public static JSlider sliderMediums;
    public static JSlider sliderShadows;
    public static JSlider sliderRED;
    public static JSlider sliderGREEN;
    public static JSlider sliderBLUE;
    public static JSlider sliderVibrance;
    public static JSlider sliderSaturation;
    public static JSlider sliderGrain;
    public static JSlider sliderVignette;
    public static JComboBox<String> comboRotate;
    public static JSlider sliderAngle;
    public static JSlider positionVideo;
    private static boolean dragWindow;
    public static int ImageWidth;
    public static int ImageHeight;
    public static int finalWidth;
    public static int finalHeight;
    public static int allR;
    public static int allG;
    public static int allB;
    public static int highR;
    public static int highG;
    public static int highB;
    public static int mediumR;
    public static int mediumG;
    public static int mediumB;
    public static int lowR;
    public static int lowG;
    public static int lowB;
    private static String balanceAll;
    private static String balanceHigh;
    private static String balanceMedium;
    private static String balanceLow;

    static {
        image = new JPanel();
        runProcess = new Thread();
        title = new JLabel(Shutter.language.getProperty("frameColorImage"));
        comboRGB = new JComboBox();
        sliderExposure = new JSlider();
        sliderContrast = new JSlider();
        sliderHighlights = new JSlider();
        sliderMediums = new JSlider();
        sliderShadows = new JSlider();
        sliderRED = new JSlider();
        sliderGREEN = new JSlider();
        sliderBLUE = new JSlider();
        sliderVibrance = new JSlider();
        sliderSaturation = new JSlider();
        sliderGrain = new JSlider();
        sliderVignette = new JSlider();
        comboRotate = new JComboBox();
        sliderAngle = new JSlider();
        allR = 0;
        allG = 0;
        allB = 0;
        highR = 0;
        highG = 0;
        highB = 0;
        mediumR = 0;
        mediumG = 0;
        mediumB = 0;
        lowR = 0;
        lowG = 0;
        lowB = 0;
        balanceAll = "";
        balanceHigh = "";
        balanceMedium = "";
        balanceLow = "";
    }

    public ColorImage() {
        frame = new JFrame();
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameColorImage"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(1200, 720);
        frame.setResizable(false);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - ColorImage.frame.getSize().width / 2, dim.height / 2 - ColorImage.frame.getSize().height / 2);
        }
        dragWindow = false;
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                shape1.add(shape2);
                frame.setShape(shape1);
            }
        });
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getX() >= 700 && e.getY() >= 700 && dragWindow) {
                    frame.setSize(e.getX() + 20, e.getY() + 20);
                }
                ColorImage.this.resizeAll();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseInfo.getPointerInfo().getLocation().x - ColorImage.frame.getLocation().x > ColorImage.frame.getSize().width - 20 || MouseInfo.getPointerInfo().getLocation().y - ColorImage.frame.getLocation().y > ColorImage.frame.getSize().height - 20) {
                    frame.setCursor(Cursor.getPredefinedCursor(5));
                } else if (!dragWindow) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor().getType() == 5) {
                    dragWindow = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (dragWindow && (ColorImage.frame.getSize().width < 1200 || ColorImage.frame.getSize().height < 720)) {
                    frame.setSize(1200, 720);
                    ColorImage.this.resizeAll();
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                ColorImage.loadImage(true);
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
                frame.setCursor(Cursor.getPredefinedCursor(0));
                dragWindow = false;
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (frame.getCursor().getType() == 5) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                frame.toFront();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.topPanel();
        final JLabel lblExposure = new JLabel(Shutter.language.getProperty("lblExposure"));
        lblExposure.setFont(new Font("FreeSans", 0, 13));
        lblExposure.setBounds(12, 62, 180, 16);
        frame.getContentPane().add(lblExposure);
        frame.add(lblExposure);
        sliderExposure.setName("sliderExposure");
        sliderExposure.setMaximum(100);
        sliderExposure.setMinimum(-100);
        sliderExposure.setValue(0);
        sliderExposure.setFont(new Font("FreeSans", 0, 11));
        sliderExposure.setBounds(12, lblExposure.getY() + lblExposure.getHeight(), 180, 22);
        sliderExposure.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderExposure.setValue(0);
                    lblExposure.setText(Shutter.language.getProperty("lblExposure"));
                }
            }
        });
        sliderExposure.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderExposure.getValue() == 0) {
                    lblExposure.setText(Shutter.language.getProperty("lblExposure"));
                } else {
                    lblExposure.setText(String.valueOf(Shutter.language.getProperty("lblExposure")) + " " + sliderExposure.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderExposure);
        final JLabel lblContrast = new JLabel(Shutter.language.getProperty("lblContrast"));
        lblContrast.setFont(new Font("FreeSans", 0, 13));
        lblContrast.setBounds(12, sliderExposure.getY() + sliderExposure.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblContrast);
        frame.add(lblContrast);
        sliderContrast.setName("sliderContrast");
        sliderContrast.setMaximum(100);
        sliderContrast.setMinimum(-100);
        sliderContrast.setValue(0);
        sliderContrast.setFont(new Font("FreeSans", 0, 11));
        sliderContrast.setBounds(12, lblContrast.getY() + lblContrast.getHeight(), sliderExposure.getWidth(), 22);
        sliderContrast.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderContrast.setValue(0);
                    lblContrast.setText(Shutter.language.getProperty("lblContrast"));
                }
            }
        });
        sliderContrast.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderContrast.getValue() == 0) {
                    lblContrast.setText(Shutter.language.getProperty("lblContrast"));
                } else {
                    lblContrast.setText(String.valueOf(Shutter.language.getProperty("lblContrast")) + " " + sliderContrast.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderContrast);
        final JLabel lblHighlights = new JLabel(Shutter.language.getProperty("lblHighlights"));
        lblHighlights.setFont(new Font("FreeSans", 0, 13));
        lblHighlights.setBounds(12, sliderContrast.getY() + sliderContrast.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblHighlights);
        frame.add(lblHighlights);
        sliderHighlights.setName("sliderHighlights");
        sliderHighlights.setMaximum(100);
        sliderHighlights.setMinimum(-100);
        sliderHighlights.setValue(0);
        sliderHighlights.setFont(new Font("FreeSans", 0, 11));
        sliderHighlights.setBounds(12, lblHighlights.getY() + lblHighlights.getHeight(), sliderExposure.getWidth(), 22);
        sliderHighlights.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderHighlights.setValue(0);
                    lblHighlights.setText(Shutter.language.getProperty("lblHighlights"));
                }
            }
        });
        sliderHighlights.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderHighlights.getValue() == 0) {
                    lblHighlights.setText(Shutter.language.getProperty("lblHighlights"));
                } else {
                    lblHighlights.setText(String.valueOf(Shutter.language.getProperty("lblHighlights")) + " " + sliderHighlights.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderHighlights);
        final JLabel lblMediums = new JLabel(Shutter.language.getProperty("lblMediums"));
        lblMediums.setFont(new Font("FreeSans", 0, 13));
        lblMediums.setBounds(12, sliderHighlights.getY() + sliderHighlights.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblMediums);
        frame.add(lblMediums);
        sliderMediums.setName("sliderMediums");
        sliderMediums.setMaximum(100);
        sliderMediums.setMinimum(-100);
        sliderMediums.setValue(0);
        sliderMediums.setFont(new Font("FreeSans", 0, 11));
        sliderMediums.setBounds(12, lblMediums.getY() + lblMediums.getHeight(), sliderExposure.getWidth(), 22);
        sliderMediums.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderMediums.setValue(0);
                    lblMediums.setText(Shutter.language.getProperty("lblMediums"));
                }
            }
        });
        sliderMediums.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderMediums.getValue() == 0) {
                    lblMediums.setText(Shutter.language.getProperty("lblMediums"));
                } else {
                    lblMediums.setText(String.valueOf(Shutter.language.getProperty("lblMediums")) + " " + sliderMediums.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderMediums);
        final JLabel lblShadows = new JLabel(Shutter.language.getProperty("lblShadows"));
        lblShadows.setFont(new Font("FreeSans", 0, 13));
        lblShadows.setBounds(12, sliderMediums.getY() + sliderMediums.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblShadows);
        frame.add(lblShadows);
        sliderShadows.setName("sliderShadows");
        sliderShadows.setMaximum(100);
        sliderShadows.setMinimum(-100);
        sliderShadows.setValue(0);
        sliderShadows.setFont(new Font("FreeSans", 0, 11));
        sliderShadows.setBounds(12, lblShadows.getY() + lblShadows.getHeight(), sliderExposure.getWidth(), 22);
        sliderShadows.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderShadows.setValue(0);
                    lblShadows.setText(Shutter.language.getProperty("lblShadows"));
                }
            }
        });
        sliderShadows.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderShadows.getValue() == 0) {
                    lblShadows.setText(Shutter.language.getProperty("lblShadows"));
                } else {
                    lblShadows.setText(String.valueOf(Shutter.language.getProperty("lblShadows")) + " " + sliderShadows.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderShadows);
        JLabel lblRGB = new JLabel(Shutter.language.getProperty("lblRGB"));
        lblRGB.setFont(new Font("FreeSans", 0, 13));
        lblRGB.setBounds(12, sliderShadows.getY() + sliderShadows.getHeight() + 6, lblRGB.getPreferredSize().width, 16);
        frame.getContentPane().add(lblRGB);
        frame.add(lblRGB);
        comboRGB.setName("comboRGB");
        comboRGB.setModel(new DefaultComboBoxModel<String>(new String[]{Shutter.language.getProperty("setAll"), Shutter.language.getProperty("setHigh"), Shutter.language.getProperty("setMedium"), Shutter.language.getProperty("setLow")}));
        comboRGB.setMaximumRowCount(10);
        comboRGB.setEditable(false);
        comboRGB.setSelectedIndex(0);
        comboRGB.setFont(new Font("FreeSans", 0, 10));
        comboRGB.setBounds(lblRGB.getX() + lblRGB.getWidth() + 7, lblRGB.getY() - 3, 80, 22);
        frame.getContentPane().add(comboRGB);
        comboRGB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    sliderRED.setValue(allR);
                    sliderGREEN.setValue(allG);
                    sliderBLUE.setValue(allB);
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    sliderRED.setValue(lowR);
                    sliderGREEN.setValue(lowG);
                    sliderBLUE.setValue(lowB);
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    sliderRED.setValue(mediumR);
                    sliderGREEN.setValue(mediumG);
                    sliderBLUE.setValue(mediumB);
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    sliderRED.setValue(highR);
                    sliderGREEN.setValue(highG);
                    sliderBLUE.setValue(highB);
                }
            }
        });
        final JLabel lblR = new JLabel(Shutter.language.getProperty("lblRED"));
        lblR.setFont(new Font("FreeSans", 0, 13));
        lblR.setBounds(12, comboRGB.getY() + comboRGB.getHeight() + 3, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblR);
        frame.add(lblR);
        sliderRED.setName("sliderRED");
        sliderRED.setMaximum(100);
        sliderRED.setMinimum(-100);
        sliderRED.setValue(0);
        sliderRED.setFont(new Font("FreeSans", 0, 11));
        sliderRED.setBounds(12, lblR.getY() + lblR.getHeight(), sliderExposure.getWidth(), 22);
        sliderRED.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderRED.setValue(0);
                    lblR.setText(Shutter.language.getProperty("lblRED"));
                    if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                        allR = sliderRED.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                        lowR = sliderRED.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                        mediumR = sliderRED.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                        highR = sliderRED.getValue();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    allR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    lowR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    mediumR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    highR = sliderRED.getValue();
                }
            }
        });
        sliderRED.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderRED.getValue() == 0) {
                    lblR.setText(Shutter.language.getProperty("lblRED"));
                } else {
                    lblR.setText(String.valueOf(Shutter.language.getProperty("lblRED")) + " " + sliderRED.getValue());
                }
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    allR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    lowR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    mediumR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    highR = sliderRED.getValue();
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderRED);
        final JLabel lblG = new JLabel(Shutter.language.getProperty("lblGREEN"));
        lblG.setFont(new Font("FreeSans", 0, 13));
        lblG.setBounds(12, sliderRED.getY() + sliderRED.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblG);
        frame.add(lblG);
        sliderGREEN.setName("sliderGREEN");
        sliderGREEN.setMaximum(100);
        sliderGREEN.setMinimum(-100);
        sliderGREEN.setValue(0);
        sliderGREEN.setFont(new Font("FreeSans", 0, 11));
        sliderGREEN.setBounds(12, lblG.getY() + lblG.getHeight(), sliderExposure.getWidth(), 22);
        sliderGREEN.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderGREEN.setValue(0);
                    lblG.setText(Shutter.language.getProperty("lblGREEN"));
                    if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                        allG = sliderGREEN.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                        lowG = sliderGREEN.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                        mediumG = sliderGREEN.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                        highG = sliderGREEN.getValue();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    allG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    lowG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    mediumG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    highG = sliderGREEN.getValue();
                }
            }
        });
        sliderGREEN.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderGREEN.getValue() == 0) {
                    lblG.setText(Shutter.language.getProperty("lblGREEN"));
                } else {
                    lblG.setText(String.valueOf(Shutter.language.getProperty("lblGREEN")) + " " + sliderGREEN.getValue());
                }
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    allG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    lowG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    mediumG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    highG = sliderGREEN.getValue();
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderGREEN);
        final JLabel lblB = new JLabel(Shutter.language.getProperty("lblBLUE"));
        lblB.setFont(new Font("FreeSans", 0, 13));
        lblB.setBounds(12, sliderGREEN.getY() + sliderGREEN.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblB);
        frame.add(lblB);
        sliderBLUE.setName("sliderBLUE");
        sliderBLUE.setMaximum(100);
        sliderBLUE.setMinimum(-100);
        sliderBLUE.setValue(0);
        sliderBLUE.setFont(new Font("FreeSans", 0, 11));
        sliderBLUE.setBounds(12, lblB.getY() + lblB.getHeight(), sliderExposure.getWidth(), 22);
        sliderBLUE.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderBLUE.setValue(0);
                    lblB.setText(Shutter.language.getProperty("lblBLUE"));
                    if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                        allB = sliderBLUE.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                        lowB = sliderBLUE.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                        mediumB = sliderBLUE.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                        highB = sliderBLUE.getValue();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    allB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    lowB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    mediumB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    highB = sliderBLUE.getValue();
                }
            }
        });
        sliderBLUE.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderBLUE.getValue() == 0) {
                    lblB.setText(Shutter.language.getProperty("lblBLUE"));
                } else {
                    lblB.setText(String.valueOf(Shutter.language.getProperty("lblBLUE")) + " " + sliderBLUE.getValue());
                }
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    allB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    lowB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    mediumB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    highB = sliderBLUE.getValue();
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderBLUE);
        final JLabel lblVibrance = new JLabel(Shutter.language.getProperty("lblVibrance"));
        lblVibrance.setFont(new Font("FreeSans", 0, 13));
        lblVibrance.setBounds(12, sliderBLUE.getY() + sliderBLUE.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblVibrance);
        frame.add(lblVibrance);
        sliderVibrance.setName("sliderVibrance");
        sliderVibrance.setMaximum(100);
        sliderVibrance.setMinimum(-100);
        sliderVibrance.setValue(0);
        sliderVibrance.setFont(new Font("FreeSans", 0, 11));
        sliderVibrance.setBounds(12, lblVibrance.getY() + lblVibrance.getHeight(), sliderExposure.getWidth(), 22);
        sliderVibrance.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderVibrance.setValue(0);
                    lblVibrance.setText(Shutter.language.getProperty("lblVibrance"));
                }
            }
        });
        sliderVibrance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderVibrance.getValue() == 0) {
                    lblVibrance.setText(Shutter.language.getProperty("lblVibrance"));
                } else {
                    lblVibrance.setText(String.valueOf(Shutter.language.getProperty("lblVibrance")) + " " + sliderVibrance.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderVibrance);
        final JLabel lblSaturation = new JLabel(Shutter.language.getProperty("lblSaturation"));
        lblSaturation.setFont(new Font("FreeSans", 0, 13));
        lblSaturation.setBounds(12, sliderVibrance.getY() + sliderVibrance.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblSaturation);
        frame.add(lblSaturation);
        sliderSaturation.setName("sliderSaturation");
        sliderSaturation.setMaximum(100);
        sliderSaturation.setMinimum(-100);
        sliderSaturation.setValue(0);
        sliderSaturation.setFont(new Font("FreeSans", 0, 11));
        sliderSaturation.setBounds(12, lblSaturation.getY() + lblSaturation.getHeight(), sliderExposure.getWidth(), 22);
        sliderSaturation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderSaturation.setValue(0);
                    lblSaturation.setText(Shutter.language.getProperty("lblSaturation"));
                }
            }
        });
        sliderSaturation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderSaturation.getValue() == 0) {
                    lblSaturation.setText(Shutter.language.getProperty("lblSaturation"));
                } else {
                    lblSaturation.setText(String.valueOf(Shutter.language.getProperty("lblSaturation")) + " " + sliderSaturation.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderSaturation);
        final JLabel lblGrain = new JLabel(Shutter.language.getProperty("lblGrain"));
        lblGrain.setFont(new Font("FreeSans", 0, 13));
        lblGrain.setBounds(12, sliderSaturation.getY() + sliderSaturation.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblGrain);
        frame.add(lblGrain);
        sliderGrain.setName("sliderGrain");
        sliderGrain.setMaximum(100);
        sliderGrain.setMinimum(-100);
        sliderGrain.setValue(0);
        sliderGrain.setFont(new Font("FreeSans", 0, 11));
        sliderGrain.setBounds(12, lblGrain.getY() + lblGrain.getHeight(), sliderExposure.getWidth(), 22);
        sliderGrain.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderGrain.setValue(0);
                    lblGrain.setText(Shutter.language.getProperty("lblGrain"));
                }
            }
        });
        sliderGrain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderGrain.getValue() == 0) {
                    lblGrain.setText(Shutter.language.getProperty("lblGrain"));
                } else {
                    lblGrain.setText(String.valueOf(Shutter.language.getProperty("lblGrain")) + " " + sliderGrain.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderGrain);
        final JLabel lblVignette = new JLabel(Shutter.language.getProperty("lblVignette"));
        lblVignette.setFont(new Font("FreeSans", 0, 13));
        lblVignette.setBounds(12, sliderGrain.getY() + sliderGrain.getHeight() + 4, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblVignette);
        frame.add(lblVignette);
        sliderVignette.setName("sliderVignette");
        sliderVignette.setMaximum(100);
        sliderVignette.setMinimum(-100);
        sliderVignette.setValue(0);
        sliderVignette.setFont(new Font("FreeSans", 0, 11));
        sliderVignette.setBounds(12, lblVignette.getY() + lblVignette.getHeight(), sliderExposure.getWidth(), 22);
        sliderVignette.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderVignette.setValue(0);
                    lblVignette.setText(Shutter.language.getProperty("lblVignette"));
                }
            }
        });
        sliderVignette.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderVignette.getValue() == 0) {
                    lblVignette.setText(Shutter.language.getProperty("lblVignette"));
                } else {
                    lblVignette.setText(String.valueOf(Shutter.language.getProperty("lblVignette")) + " " + sliderVignette.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderVignette);
        JLabel lblRotate = new JLabel(Shutter.language.getProperty("caseRotate"));
        lblRotate.setFont(new Font("FreeSans", 0, 13));
        lblRotate.setBounds(12, sliderVignette.getY() + sliderVignette.getHeight() + 6, lblRotate.getPreferredSize().width, 16);
        frame.getContentPane().add(lblRotate);
        frame.add(lblRotate);
        comboRotate = new JComboBox();
        comboRotate.setName("comboRotate");
        comboRotate.setModel(new DefaultComboBoxModel<String>(new String[]{Shutter.language.getProperty("aucun"), "90", "-90", "180"}));
        comboRotate.setSelectedIndex(0);
        comboRotate.setFont(new Font("FreeSans", 0, 10));
        comboRotate.setEditable(false);
        comboRotate.setBounds(lblRotate.getX() + lblRotate.getWidth() + 7, lblRotate.getY() - 3, 80, 22);
        comboRotate.setMaximumRowCount(20);
        frame.add(comboRotate);
        comboRotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                ColorImage.loadImage(true);
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        final JLabel lblAngle = new JLabel(Shutter.language.getProperty("caseAngle"));
        lblAngle.setFont(new Font("FreeSans", 0, 13));
        lblAngle.setBounds(12, comboRotate.getY() + comboRotate.getHeight() + 3, lblExposure.getSize().width, 16);
        frame.getContentPane().add(lblAngle);
        sliderAngle.setName("sliderAngle");
        sliderAngle.setMaximum(100);
        sliderAngle.setMinimum(-100);
        sliderAngle.setValue(0);
        sliderAngle.setFont(new Font("FreeSans", 0, 11));
        sliderAngle.setBounds(12, lblAngle.getY() + lblAngle.getHeight(), sliderExposure.getWidth(), 22);
        sliderAngle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderAngle.setValue(0);
                    lblAngle.setText(Shutter.language.getProperty("caseAngle"));
                }
            }
        });
        sliderAngle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderAngle.getValue() == 0) {
                    lblAngle.setText(Shutter.language.getProperty("caseAngle"));
                } else {
                    lblAngle.setText(String.valueOf(Shutter.language.getProperty("caseAngle")) + " " + sliderAngle.getValue());
                }
                ColorImage.loadImage(false);
            }
        });
        frame.add(sliderAngle);
        ColorImage.loadImage(true);
        btnPrevious = new JButton(Shutter.language.getProperty("btnPrevious"));
        btnPrevious.setFont(new Font("Montserrat", 0, 12));
        btnPrevious.setMargin(new Insets(0, 0, 0, 0));
        btnPrevious.setBounds(14, sliderAngle.getY() + sliderAngle.getHeight() + 6, 84, 21);
        frame.getContentPane().add(btnPrevious);
        btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Shutter.fileList.getSelectedIndex() > 0) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    Shutter.fileList.setSelectedIndex(Shutter.fileList.getSelectedIndex() - 1);
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    if (Shutter.scanIsRunning) {
                        File dir = new File(Shutter.liste.firstElement());
                        File[] fileArray = dir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (!f.isHidden() && f.isFile()) {
                                FFPROBE.Data(f.toString());
                            }
                            ++n2;
                        }
                    } else if (!Shutter.inputDeviceIsRunning) {
                        FFPROBE.Data(Shutter.fileList.getSelectedValue().toString());
                    }
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (FFPROBE.isRunning);
                    positionVideo.setValue(0);
                    positionVideo.setMaximum(FFPROBE.totalLength);
                    ColorImage.loadImage(true);
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                    Shutter.enableAll();
                }
            }
        });
        btnNext = new JButton(Shutter.language.getProperty("btnNext"));
        btnNext.setFont(new Font("Montserrat", 0, 12));
        btnNext.setMargin(new Insets(0, 0, 0, 0));
        btnNext.setBounds(btnPrevious.getX() + btnPrevious.getWidth() + 6, btnPrevious.getY(), 84, 21);
        frame.getContentPane().add(btnNext);
        btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Shutter.fileList.getSelectedIndex() < Shutter.liste.getSize()) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    Shutter.fileList.setSelectedIndex(Shutter.fileList.getSelectedIndex() + 1);
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    if (Shutter.scanIsRunning) {
                        File dir = new File(Shutter.liste.firstElement());
                        File[] fileArray = dir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (!f.isHidden() && f.isFile()) {
                                FFPROBE.Data(f.toString());
                            }
                            ++n2;
                        }
                    } else if (!Utils.inputDeviceIsRunning) {
                        FFPROBE.Data(Shutter.fileList.getSelectedValue().toString());
                    }
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (FFPROBE.isRunning);
                    positionVideo.setValue(0);
                    positionVideo.setMaximum(FFPROBE.totalLength);
                    ColorImage.loadImage(true);
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                    Shutter.enableAll();
                }
            }
        });
        btnReset = new JButton(Shutter.language.getProperty("btnReset"));
        btnReset.setFont(new Font("Montserrat", 0, 12));
        btnReset.setBounds(14, frame.getHeight() - 33, btnPrevious.getWidth() + btnNext.getWidth() + 6, 21);
        frame.getContentPane().add(btnReset);
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                allR = 0;
                allG = 0;
                allB = 0;
                highR = 0;
                highG = 0;
                highB = 0;
                mediumR = 0;
                mediumG = 0;
                mediumB = 0;
                lowR = 0;
                lowG = 0;
                lowB = 0;
                balanceAll = "";
                balanceHigh = "";
                balanceMedium = "";
                balanceLow = "";
                sliderExposure.setValue(0);
                sliderContrast.setValue(0);
                sliderHighlights.setValue(0);
                sliderMediums.setValue(0);
                sliderShadows.setValue(0);
                sliderRED.setValue(0);
                sliderGREEN.setValue(0);
                sliderBLUE.setValue(0);
                sliderVibrance.setValue(0);
                sliderSaturation.setValue(0);
                sliderGrain.setValue(0);
                sliderVignette.setValue(0);
                sliderAngle.setValue(0);
                comboRGB.setSelectedIndex(0);
                comboRotate.setSelectedIndex(0);
            }
        });
        positionVideo = new JSlider();
        if (Shutter.scanIsRunning) {
            File dir = new File(Shutter.liste.firstElement());
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.isHidden() && f.isFile()) {
                    FFPROBE.Data(f.toString());
                }
                ++n2;
            }
        } else if (!Utils.inputDeviceIsRunning) {
            FFPROBE.Data(Shutter.fileList.getSelectedValue().toString());
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (FFPROBE.totalLength == 0 && FFPROBE.isRunning);
        if (FFPROBE.totalLength > 100) {
            positionVideo.setEnabled(true);
        } else {
            positionVideo.setEnabled(false);
        }
        positionVideo.setMaximum(FFPROBE.totalLength);
        positionVideo.setValue(0);
        positionVideo.setFont(new Font("FreeSans", 0, 11));
        positionVideo.setBounds(212, frame.getHeight() - 33, sliderExposure.getWidth(), 22);
        frame.getContentPane().add(positionVideo);
        positionVideo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                ColorImage.loadImage(true);
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        btnOriginal = new JButton("Original");
        btnOriginal.setFont(new Font("Montserrat", 0, 12));
        btnOriginal.setMargin(new Insets(0, 0, 0, 0));
        btnOriginal.setBounds(positionVideo.getX() + positionVideo.getWidth() + 9, frame.getHeight() - 33, ColorImage.btnOriginal.getPreferredSize().width, 21);
        frame.getContentPane().add(btnOriginal);
        btnOriginal.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                try {
                    image.removeAll();
                    ColorImage.image();
                    BufferedImage imageBMP = ImageIO.read(file);
                    ImageIcon imageIcon = new ImageIcon(imageBMP);
                    JLabel newImage = new JLabel(imageIcon);
                    imageIcon.getImage().flush();
                    newImage.setHorizontalAlignment(0);
                    if ((float)finalHeight > (float)(frame.getWidth() - 48 - sliderExposure.getWidth()) / 1.77f || ImageHeight > ImageWidth) {
                        newImage.setBounds(0, 0, (int)Math.floor((float)(frame.getHeight() - topPanel.getHeight() - 35 - 17) * (float)ImageWidth / (float)ImageHeight), frame.getHeight() - topPanel.getHeight() - 35 - 17);
                    } else {
                        newImage.setBounds(0, 0, frame.getWidth() - 48 - sliderExposure.getWidth(), (int)Math.floor((float)(frame.getWidth() - 48 - sliderExposure.getWidth()) * (float)ImageHeight / (float)ImageWidth));
                    }
                    imageIcon = new ImageIcon(imageBMP);
                    newImage = new JLabel(imageIcon);
                    newImage.setSize(image.getSize());
                    image.add(newImage);
                    image.repaint();
                    frame.getContentPane().repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                File file = new File(String.valueOf(Shutter.dirTemp) + "color.bmp");
                if (file.exists()) {
                    try {
                        image.removeAll();
                        ColorImage.image();
                        BufferedImage imageBMP = ImageIO.read(file);
                        ImageIcon imageIcon = new ImageIcon(imageBMP);
                        JLabel newImage = new JLabel(imageIcon);
                        imageIcon.getImage().flush();
                        newImage.setHorizontalAlignment(0);
                        if ((float)finalHeight > (float)(frame.getWidth() - 48 - sliderExposure.getWidth()) / 1.77f || ImageHeight > ImageWidth) {
                            newImage.setBounds(0, 0, (int)Math.floor((float)(frame.getHeight() - topPanel.getHeight() - 35 - 17) * (float)ImageWidth / (float)ImageHeight), frame.getHeight() - topPanel.getHeight() - 35 - 17);
                        } else {
                            newImage.setBounds(0, 0, frame.getWidth() - 48 - sliderExposure.getWidth(), (int)Math.floor((float)(frame.getWidth() - 48 - sliderExposure.getWidth()) * (float)ImageHeight / (float)ImageWidth));
                        }
                        imageIcon = new ImageIcon(imageBMP);
                        newImage = new JLabel(imageIcon);
                        newImage.setSize(image.getSize());
                        image.add(newImage);
                        image.repaint();
                        frame.getContentPane().repaint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        btnPreview = new JButton(Shutter.language.getProperty("preview"));
        btnPreview.setFont(new Font("Montserrat", 0, 12));
        btnPreview.setMargin(new Insets(0, 0, 0, 0));
        btnPreview.setBounds(btnOriginal.getX() + btnOriginal.getWidth() + 9, frame.getHeight() - 33, 120, 21);
        frame.getContentPane().add(btnPreview);
        btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block71: {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        try {
                            File file = new File(Shutter.fileList.getSelectedValue().toString());
                            FFMPEG.fonctionInOut();
                            if (positionVideo.getValue() > 0 && FFPROBE.totalLength > 100) {
                                DecimalFormat tc = new DecimalFormat("00");
                                String h = String.valueOf(tc.format(positionVideo.getValue() / 3600000));
                                String m = String.valueOf(tc.format(positionVideo.getValue() / 60000 % 60));
                                String s = String.valueOf(tc.format(positionVideo.getValue() / 1000 % 60));
                                FFMPEG.inPoint = " -ss " + h + ":" + m + ":" + s + ".0";
                            }
                            String extension = file.toString().substring(file.toString().lastIndexOf("."));
                            boolean isRaw = false;
                            switch (extension.toLowerCase()) {
                                case ".3fr": 
                                case ".arw": 
                                case ".cr2": 
                                case ".cr3": 
                                case ".crw": 
                                case ".dng": 
                                case ".kdc": 
                                case ".mrw": 
                                case ".nef": 
                                case ".nrw": 
                                case ".orf": 
                                case ".pef": 
                                case ".r3d": 
                                case ".ptx": 
                                case ".raf": 
                                case ".rw2": 
                                case ".srw": 
                                case ".x3f": {
                                    isRaw = true;
                                }
                            }
                            if (extension.toLowerCase().equals(".pdf")) {
                                XPDF.toFFPROBE(file.toString());
                                do {
                                    Thread.sleep(100L);
                                } while (XPDF.isRunning);
                            } else if (isRaw) {
                                EXIFTOOL.run(file.toString());
                                do {
                                    Thread.sleep(100L);
                                } while (EXIFTOOL.isRunning);
                            } else {
                                if (!Utils.inputDeviceIsRunning) {
                                    FFPROBE.Data(file.toString());
                                }
                                do {
                                    Thread.sleep(100L);
                                } while (FFPROBE.isRunning);
                            }
                            do {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException s) {
                                    // empty catch block
                                }
                            } while (FFPROBE.isRunning);
                            String eq = "";
                            eq = ColorImage.setLuts(eq);
                            eq = ColorImage.setLevels(eq);
                            eq = ColorImage.setColormatrix(eq);
                            eq = ColorImage.setExposure(eq);
                            eq = ColorImage.setHighlights(eq);
                            eq = ColorImage.setMediums(eq);
                            eq = ColorImage.setShadows(eq);
                            eq = ColorImage.setContrast(eq);
                            eq = ColorImage.setBalance(eq);
                            eq = ColorImage.setVibrance(eq);
                            eq = ColorImage.setSaturation(eq);
                            eq = ColorImage.setGrain(eq);
                            eq = ColorImage.setRotate(eq);
                            eq = ColorImage.setVignette(eq);
                            ColorImage.setFinalEQ();
                            if (!isRaw && !extension.toLowerCase().equals(".pdf") && FFPROBE.entrelaced != null && FFPROBE.entrelaced.equals("1")) {
                                eq = String.valueOf(eq) + ",yadif=0:" + FFPROBE.fieldOrder + ":0";
                            }
                            String filter = " -vf \"" + eq;
                            String compression = " -q:v 0";
                            if (Shutter.comboFonctions.getSelectedItem().toString().equals("JPEG") && !extension.toLowerCase().equals(".pdf") && !isRaw) {
                                int q = Math.round(31.0f - (float)Integer.valueOf(Shutter.comboFilter.getSelectedItem().toString().replace("%", "")).intValue() * 31.0f / 100.0f);
                                compression = " -q:v " + q;
                            }
                            if (extension.toLowerCase().equals(".pdf")) {
                                XPDF.toFFPLAY(String.valueOf(filter) + '\"');
                            } else if (isRaw) {
                                DCRAW.toFFPLAY(String.valueOf(filter) + '\"');
                            } else if (Shutter.comboFonctions.getSelectedItem().toString().equals("JPEG")) {
                                String cmd = String.valueOf(filter) + '\"' + " -an -c:v mjpeg" + compression + " -vframes 1 -f nut pipe:play |";
                                FFMPEG.toFFPLAY(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file + '\"' + FFMPEG.postInPoint + FFMPEG.outPoint + cmd);
                            } else {
                                FFPLAY.run(String.valueOf(FFMPEG.inPoint) + " -fs -i " + '\"' + file + '\"' + filter + '\"');
                            }
                            do {
                                Thread.sleep(100L);
                            } while (!FFMPEG.isRunning && !FFPLAY.isRunning && !XPDF.isRunning && !DCRAW.isRunning);
                            Utils.changeFrameVisibility(frame, true);
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.isRunning && !FFMPEG.error || FFPLAY.isRunning && !FFPLAY.error || XPDF.isRunning && !XPDF.error || DCRAW.isRunning && !DCRAW.error);
                            FFMPEG.enableAll();
                            Shutter.caseRunInBackground.setEnabled(false);
                            Shutter.caseRunInBackground.setSelected(false);
                            Shutter.btnCancel.setEnabled(false);
                            Shutter.tempsRestant.setVisible(false);
                            Shutter.progressBar1.setValue(0);
                            frame.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        catch (InterruptedException interruptedException) {
                            Utils.changeFrameVisibility(frame, false);
                            if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                                break block71;
                            }
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                        }
                    }
                    finally {
                        Utils.changeFrameVisibility(frame, false);
                        if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        } else {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                        }
                    }
                }
            }
        });
        btnExportImage = new JButton(Shutter.language.getProperty("btnExportImage"));
        btnExportImage.setFont(new Font("Montserrat", 0, 12));
        btnExportImage.setBounds(btnPreview.getX() + btnPreview.getWidth() + 9, frame.getHeight() - 33, ColorImage.btnExportImage.getPreferredSize().width, 21);
        frame.getContentPane().add(btnExportImage);
        btnExportImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block76: {
                    boolean display = false;
                    if (Shutter.caseDisplay.isSelected()) {
                        display = true;
                        Shutter.caseDisplay.setSelected(false);
                    }
                    try {
                        try {
                            File fileOut;
                            String sortie;
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            File file = new File(Shutter.fileList.getSelectedValue().toString());
                            String ext = file.toString().substring(file.toString().lastIndexOf("."));
                            FFMPEG.fonctionInOut();
                            if (positionVideo.getValue() > 0 && FFPROBE.totalLength > 100) {
                                DecimalFormat tc = new DecimalFormat("00");
                                String h = String.valueOf(tc.format(positionVideo.getValue() / 3600000));
                                String m = String.valueOf(tc.format(positionVideo.getValue() / 60000 % 60));
                                String s = String.valueOf(tc.format(positionVideo.getValue() / 1000 % 60));
                                FFMPEG.inPoint = " -ss " + h + ":" + m + ":" + s + ".0";
                            }
                            if (Shutter.caseChangeFolder1.isSelected()) {
                                sortie = Shutter.lblDestination1.getText();
                            } else {
                                sortie = file.getParent();
                                Shutter.lblDestination1.setText(sortie);
                            }
                            String newExtension = ".jpg";
                            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
                                newExtension = Shutter.comboFilter.getSelectedItem().toString();
                            }
                            if ((fileOut = new File(String.valueOf(sortie) + "/" + file.getName().replace(ext, newExtension))).exists()) {
                                int n = 1;
                                do {
                                    fileOut = new File(String.valueOf(sortie) + "/" + file.getName().replace(ext, "_" + n + newExtension));
                                    ++n;
                                } while (fileOut.exists());
                            }
                            String extension = file.toString().substring(file.toString().lastIndexOf("."));
                            boolean isRaw = false;
                            switch (extension.toLowerCase()) {
                                case ".3fr": 
                                case ".arw": 
                                case ".cr2": 
                                case ".cr3": 
                                case ".crw": 
                                case ".dng": 
                                case ".kdc": 
                                case ".mrw": 
                                case ".nef": 
                                case ".nrw": 
                                case ".orf": 
                                case ".pef": 
                                case ".r3d": 
                                case ".ptx": 
                                case ".raf": 
                                case ".rw2": 
                                case ".srw": 
                                case ".x3f": {
                                    isRaw = true;
                                }
                            }
                            if (extension.toLowerCase().equals(".pdf")) {
                                XPDF.toFFPROBE(file.toString());
                                do {
                                    Thread.sleep(100L);
                                } while (XPDF.isRunning);
                            } else if (isRaw) {
                                EXIFTOOL.run(file.toString());
                                do {
                                    Thread.sleep(100L);
                                } while (EXIFTOOL.isRunning);
                            } else {
                                if (!Utils.inputDeviceIsRunning) {
                                    FFPROBE.Data(file.toString());
                                }
                                do {
                                    Thread.sleep(100L);
                                } while (FFPROBE.isRunning);
                            }
                            FFPROBE.FrameData(file.toString());
                            do {
                                Thread.sleep(100L);
                            } while (FFPROBE.isRunning);
                            String eq = "";
                            eq = ColorImage.setLuts(eq);
                            eq = ColorImage.setLevels(eq);
                            eq = ColorImage.setColormatrix(eq);
                            eq = ColorImage.setExposure(eq);
                            eq = ColorImage.setHighlights(eq);
                            eq = ColorImage.setMediums(eq);
                            eq = ColorImage.setShadows(eq);
                            eq = ColorImage.setContrast(eq);
                            eq = ColorImage.setBalance(eq);
                            eq = ColorImage.setVibrance(eq);
                            eq = ColorImage.setSaturation(eq);
                            eq = ColorImage.setGrain(eq);
                            eq = ColorImage.setRotate(eq);
                            eq = ColorImage.setVignette(eq);
                            ColorImage.setFinalEQ();
                            if (!isRaw && !extension.toLowerCase().equals(".pdf") && FFPROBE.entrelaced != null && FFPROBE.entrelaced.equals("1")) {
                                eq = String.valueOf(eq) + ",yadif=0:" + FFPROBE.fieldOrder + ":0";
                            }
                            String compression = " -q:v 0";
                            if (Shutter.comboFonctions.getSelectedItem().equals("JPEG")) {
                                int q = Math.round(31.0f - (float)Integer.valueOf(Shutter.comboFilter.getSelectedItem().toString().replace("%", "")).intValue() * 31.0f / 100.0f);
                                compression = " -q:v " + q;
                            }
                            String cmd = " -vf \"" + eq + '\"' + " -vframes 1" + compression + " -an -y ";
                            if (extension.toLowerCase().equals(".pdf")) {
                                XPDF.run(" -r 300 -f 1 -l 1 \"" + file.toString() + '\"' + " - | PathToFFMPEG -i -" + cmd + '\"' + fileOut + '\"');
                            } else if (isRaw) {
                                DCRAW.run(" -v -w -c -q 0 -6 -g 2.4 12.92 \"" + file.toString() + '\"' + " | PathToFFMPEG -i -" + cmd + '\"' + fileOut + '\"');
                            } else if (Shutter.inputDeviceIsRunning) {
                                FFMPEG.run(" " + RecordInputDevice.setInputDevices() + cmd + '\"' + fileOut + '\"');
                            } else {
                                FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + cmd + '\"' + fileOut + '\"');
                            }
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.isRunning);
                            FFMPEG.enableAll();
                            Shutter.caseRunInBackground.setEnabled(false);
                            Shutter.caseRunInBackground.setSelected(false);
                            Shutter.btnCancel.setEnabled(false);
                            Shutter.tempsRestant.setVisible(false);
                            Shutter.progressBar1.setValue(0);
                            frame.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        catch (InterruptedException interruptedException) {
                            if (display) {
                                Shutter.caseDisplay.setSelected(true);
                            }
                            break block76;
                        }
                    }
                    catch (Throwable throwable) {
                        if (display) {
                            Shutter.caseDisplay.setSelected(true);
                        }
                        throw throwable;
                    }
                    if (display) {
                        Shutter.caseDisplay.setSelected(true);
                    }
                }
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        });
        btnOK = new JButton(Shutter.language.getProperty("btnApply"));
        btnOK.setFont(new Font("Montserrat", 0, 12));
        btnOK.setBounds(btnExportImage.getX() + btnExportImage.getWidth() + 9, frame.getHeight() - 33, frame.getWidth() - (btnExportImage.getX() + btnExportImage.getWidth()) - 25, 21);
        frame.getContentPane().add(btnOK);
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorImage.setFinalEQ();
                Shutter.tempsRestant.setVisible(false);
                Shutter.progressBar1.setValue(0);
                Utils.changeFrameVisibility(frame, true);
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                if ((file = new File(String.valueOf(Shutter.dirTemp) + "color.bmp")).exists()) {
                    file.delete();
                }
            }
        });
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
        Utils.changeFrameVisibility(frame, false);
    }

    private void topPanel() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBounds(0, 0, frame.getWidth(), 52);
        this.quit = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(ColorImage.frame.getSize().width - 24, 0, 21, 21);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ColorImage.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    Shutter.tempsRestant.setVisible(false);
                    Shutter.progressBar1.setValue(0);
                    Utils.changeFrameVisibility(frame, true);
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    Shutter.caseColor.setSelected(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ColorImage.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ColorImage.this.quit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/quit2.png")));
                this.accept = false;
            }
        });
        this.fullscreen = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max2.png")));
        this.fullscreen.setHorizontalAlignment(0);
        this.fullscreen.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        this.fullscreen.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ColorImage.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle winSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                int taskBarHeight = screenSize.height - winSize.height;
                if (this.accept && frame.getWidth() < screenSize.width) {
                    frame.setBounds(0, 0, screenSize.width, screenSize.height - taskBarHeight);
                } else if (this.accept) {
                    frame.setSize(1200, 720);
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    frame.setLocation(dim.width / 2 - ColorImage.frame.getSize().width / 2, dim.height / 2 - ColorImage.frame.getSize().height / 2);
                }
                ColorImage.this.resizeAll();
                frame.setCursor(Cursor.getPredefinedCursor(3));
                File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                if (file.exists()) {
                    file.delete();
                }
                ColorImage.loadImage(true);
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ColorImage.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ColorImage.this.fullscreen.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/max2.png")));
                this.accept = false;
            }
        });
        this.reduce = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce2.png")));
        this.reduce.setHorizontalAlignment(0);
        this.reduce.setBounds(this.fullscreen.getLocation().x - 21, 0, 21, 21);
        this.reduce.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ColorImage.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce3.png")));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    frame.setState(1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ColorImage.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ColorImage.this.reduce.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("contents/reduce2.png")));
                this.accept = false;
            }
        });
        this.bottomImage = new JLabel();
        ImageIcon imageIcon = new ImageIcon(this.header.getImage().getScaledInstance(ColorImage.topPanel.getSize().width, ColorImage.topPanel.getSize().height, 16));
        this.bottomImage.setIcon(imageIcon);
        this.bottomImage.setBounds(0, 0, ColorImage.frame.getSize().width, 52);
        this.bottomImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
                if (down.getClickCount() == 2 && down.getButton() == 1) {
                    if (frame.getWidth() > 1200) {
                        frame.setSize(1200, 720);
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        frame.setLocation(dim.width / 2 - ColorImage.frame.getSize().width / 2, dim.height / 2 - ColorImage.frame.getSize().height / 2);
                    } else {
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        Rectangle winSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                        int taskBarHeight = screenSize.height - winSize.height;
                        frame.setBounds(0, 0, screenSize.width, screenSize.height - taskBarHeight);
                    }
                    ColorImage.this.resizeAll();
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    File file = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    ColorImage.loadImage(true);
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !FFMPEG.error && !DCRAW.error && !XPDF.error);
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePosition.mouseX = down.getPoint().x;
                MousePosition.mouseY = down.getPoint().y;
                frame.toFront();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.bottomImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePosition.mouseX, MouseInfo.getPointerInfo().getLocation().y - MousePosition.mouseY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 52);
        title.setFont(new Font("Magneto", 0, 26));
        topPanel.add(title);
        this.topImage = new JLabel();
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        topPanel.add(this.quit);
        topPanel.add(this.fullscreen);
        topPanel.add(this.reduce);
        topPanel.add(this.topImage);
        topPanel.add(this.bottomImage);
        frame.getContentPane().add(topPanel);
    }

    private static void image() {
        int containerWidth;
        int containerHeight;
        image.removeAll();
        if ((float)finalHeight > (float)(frame.getWidth() - 48 - sliderExposure.getWidth()) / 1.77f || ImageHeight > ImageWidth) {
            containerHeight = frame.getHeight() - topPanel.getHeight() - 35 - 17;
            containerWidth = (int)Math.floor((float)(frame.getHeight() - topPanel.getHeight() - 35 - 17) * (float)ImageWidth / (float)ImageHeight);
        } else {
            containerHeight = (int)Math.floor((float)(frame.getWidth() - 48 - sliderExposure.getWidth()) * (float)ImageHeight / (float)ImageWidth);
            containerWidth = frame.getWidth() - 48 - sliderExposure.getWidth();
        }
        image.setSize(containerWidth, containerHeight);
        Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
        Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
        shape1.add(shape2);
        frame.setShape(shape1);
        if ((float)finalHeight > (float)(frame.getWidth() - 48 - sliderExposure.getWidth()) / 1.77f || ImageHeight > ImageWidth) {
            image.setLocation((int)Math.floor((float)(frame.getWidth() - containerWidth) / 2.0f) + 100, 62);
        } else {
            image.setLocation(212, (int)Math.floor((float)(frame.getHeight() - containerHeight) / 2.0f) + 10);
        }
        image.setLayout(null);
        image.setOpaque(false);
        frame.getContentPane().add(image);
    }

    public static void loadImage(boolean forceRefresh) {
        if (forceRefresh) {
            Thread waitProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (FFMPEG.isRunning || runProcess.isAlive());
                }
            });
            waitProcess.start();
        }
        if (forceRefresh || !FFMPEG.isRunning && !runProcess.isAlive()) {
            runProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean display = false;
                    if (Shutter.caseDisplay.isSelected()) {
                        display = true;
                        Shutter.caseDisplay.setSelected(false);
                    }
                    try {
                        try {
                            File fileOut;
                            boolean isRaw;
                            String extension;
                            File file;
                            block85: {
                                block84: {
                                    if (Shutter.fileList.getSelectedValue() == null) {
                                        Shutter.fileList.setSelectedIndex(0);
                                    }
                                    file = new File(Shutter.fileList.getSelectedValue().toString());
                                    if (Shutter.scanIsRunning) {
                                        File dir = new File(Shutter.liste.firstElement());
                                        File[] fileArray = dir.listFiles();
                                        int n = fileArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            File f = fileArray[n2];
                                            if (!f.isHidden() && f.isFile()) {
                                                file = new File(f.toString());
                                                break;
                                            }
                                            ++n2;
                                        }
                                    }
                                    extension = file.toString().substring(file.toString().lastIndexOf("."));
                                    isRaw = false;
                                    fileOut = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                                    if (!fileOut.exists()) break block84;
                                    file = fileOut;
                                    fileOut = new File(String.valueOf(Shutter.dirTemp) + "color.bmp");
                                    if (fileOut.exists()) {
                                        fileOut.delete();
                                    }
                                    break block85;
                                }
                                switch (extension.toLowerCase()) {
                                    case ".3fr": 
                                    case ".arw": 
                                    case ".cr2": 
                                    case ".cr3": 
                                    case ".crw": 
                                    case ".dng": 
                                    case ".kdc": 
                                    case ".mrw": 
                                    case ".nef": 
                                    case ".nrw": 
                                    case ".orf": 
                                    case ".pef": 
                                    case ".r3d": 
                                    case ".ptx": 
                                    case ".raf": 
                                    case ".rw2": 
                                    case ".srw": 
                                    case ".x3f": {
                                        isRaw = true;
                                    }
                                }
                                if (extension.toLowerCase().equals(".pdf")) {
                                    XPDF.toFFPROBE(file.toString());
                                    do {
                                        Thread.sleep(100L);
                                    } while (XPDF.isRunning);
                                } else if (isRaw) {
                                    EXIFTOOL.run(file.toString());
                                    do {
                                        Thread.sleep(100L);
                                    } while (EXIFTOOL.isRunning);
                                } else {
                                    if (!Utils.inputDeviceIsRunning) {
                                        FFPROBE.Data(file.toString());
                                    }
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFPROBE.isRunning);
                                }
                                if (comboRotate.getSelectedIndex() == 1 || comboRotate.getSelectedIndex() == 2) {
                                    Integer iw = ImageWidth;
                                    Integer ih = ImageHeight;
                                    ImageWidth = ih;
                                    ImageHeight = iw;
                                }
                                finalWidth = (int)Math.floor((frame.getHeight() - topPanel.getHeight() - 35 - 17) * ImageWidth / ImageHeight);
                                finalHeight = (int)Math.floor((frame.getWidth() - 48 - sliderExposure.getWidth()) * ImageHeight / ImageWidth);
                                Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("tempFolder") + " " + Shutter.dirTemp + System.lineSeparator() + System.lineSeparator());
                            }
                            FFMPEG.fonctionInOut();
                            if (positionVideo.getValue() > 0 && FFPROBE.totalLength > 100) {
                                DecimalFormat tc = new DecimalFormat("00");
                                String h = String.valueOf(tc.format(positionVideo.getValue() / 3600000));
                                String m = String.valueOf(tc.format(positionVideo.getValue() / 60000 % 60));
                                String s = String.valueOf(tc.format(positionVideo.getValue() / 1000 % 60));
                                FFMPEG.inPoint = " -ss " + h + ":" + m + ":" + s + ".0";
                            }
                            String deinterlace = "";
                            if (!isRaw && !extension.toLowerCase().equals(".pdf") && FFPROBE.entrelaced != null && FFPROBE.entrelaced.equals("1")) {
                                deinterlace = " -vf yadif=0:" + FFPROBE.fieldOrder + ":0";
                            }
                            String cmd = String.valueOf(deinterlace) + " -vframes 1 -an -s " + (frame.getWidth() - 48 - sliderExposure.getWidth()) + "x" + finalHeight + " -y ";
                            if ((float)finalHeight > (float)(frame.getWidth() - 48 - sliderExposure.getWidth()) / 1.77f || ImageHeight > ImageWidth) {
                                cmd = String.valueOf(deinterlace) + " -vframes 1 -an -s " + Math.round(finalWidth / 2) * 2 + "x" + Math.round((frame.getHeight() - topPanel.getHeight() - 35 - 17) / 2) * 2 + " -y ";
                            }
                            if (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists()) {
                                if (extension.toLowerCase().equals(".pdf")) {
                                    XPDF.run(" -r 300 -f 1 -l 1 \"" + file.toString() + '\"' + " - | PathToFFMPEG -i -" + cmd + '\"' + fileOut + '\"');
                                } else if (isRaw) {
                                    DCRAW.run(" -v -w -c -q 0 -6 -g 2.4 12.92 \"" + file.toString() + '\"' + " | PathToFFMPEG -i -" + cmd + '\"' + fileOut + '\"');
                                } else if (Shutter.inputDeviceIsRunning) {
                                    FFMPEG.run(" " + RecordInputDevice.setInputDevices() + cmd + '\"' + fileOut + '\"');
                                } else {
                                    FFMPEG.run(String.valueOf(FFMPEG.inPoint) + " -i " + '\"' + file.toString() + '\"' + FFMPEG.postInPoint + cmd + '\"' + fileOut + '\"');
                                }
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.isRunning && !FFMPEG.error || XPDF.isRunning && !XPDF.error || DCRAW.isRunning && !DCRAW.error);
                                file = fileOut;
                                fileOut = new File(String.valueOf(Shutter.dirTemp) + "color.bmp");
                            }
                            String eq = "";
                            eq = ColorImage.setLuts(eq);
                            eq = ColorImage.setLevels(eq);
                            eq = ColorImage.setColormatrix(eq);
                            eq = ColorImage.setExposure(eq);
                            eq = ColorImage.setHighlights(eq);
                            eq = ColorImage.setMediums(eq);
                            eq = ColorImage.setShadows(eq);
                            eq = ColorImage.setContrast(eq);
                            eq = ColorImage.setBalance(eq);
                            eq = ColorImage.setVibrance(eq);
                            eq = ColorImage.setSaturation(eq);
                            eq = ColorImage.setGrain(eq);
                            eq = ColorImage.setRotate(eq);
                            eq = ColorImage.setVignette(eq);
                            ColorImage.setFinalEQ();
                            String histogram = ColorImage.setHistogram(eq);
                            cmd = " -vframes 1 -an -s " + (frame.getWidth() - 48 - sliderExposure.getWidth()) + "x" + finalHeight + histogram + " -y ";
                            if ((float)finalHeight > (float)(frame.getWidth() - 48 - sliderExposure.getWidth()) / 1.77f || ImageHeight > ImageWidth) {
                                cmd = " -vframes 1 -an -s " + finalWidth + "x" + (frame.getHeight() - topPanel.getHeight() - 35 - 17) + histogram + " -y ";
                            }
                            if (Shutter.inputDeviceIsRunning) {
                                File preview = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
                                if (preview.exists()) {
                                    FFMPEG.run(" -i \"" + preview + '\"' + cmd + '\"' + fileOut + '\"');
                                } else {
                                    FFMPEG.run(" " + RecordInputDevice.setInputDevices() + cmd + '\"' + fileOut + '\"');
                                }
                            } else {
                                FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd + '\"' + fileOut + '\"');
                            }
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.isRunning && !FFMPEG.error);
                            Shutter.enableAll();
                            if (fileOut.exists()) {
                                image.removeAll();
                                ColorImage.image();
                                BufferedImage imageBMP = ImageIO.read(fileOut);
                                ImageIcon imageIcon = new ImageIcon(imageBMP);
                                JLabel newImage = new JLabel(imageIcon);
                                imageIcon.getImage().flush();
                                newImage.setHorizontalAlignment(0);
                                if ((float)finalHeight > (float)(frame.getWidth() - 48 - sliderExposure.getWidth()) / 1.77f || ImageHeight > ImageWidth) {
                                    newImage.setBounds(0, 0, (int)Math.floor((float)(frame.getHeight() - topPanel.getHeight() - 35 - 17) * (float)ImageWidth / (float)ImageHeight), frame.getHeight() - topPanel.getHeight() - 35 - 17);
                                } else {
                                    newImage.setBounds(0, 0, frame.getWidth() - 48 - sliderExposure.getWidth(), (int)Math.floor((float)(frame.getWidth() - 48 - sliderExposure.getWidth()) * (float)ImageHeight / (float)ImageWidth));
                                }
                                imageIcon = new ImageIcon(imageBMP);
                                newImage = new JLabel(imageIcon);
                                newImage.setSize(image.getSize());
                                image.add(newImage);
                                image.repaint();
                                frame.getContentPane().repaint();
                                Shutter.tempsRestant.setVisible(false);
                                Shutter.progressBar1.setValue(0);
                            }
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                            if (display) {
                                Shutter.caseDisplay.setSelected(true);
                            }
                        }
                    }
                    finally {
                        if (display) {
                            Shutter.caseDisplay.setSelected(true);
                        }
                    }
                }
            });
            runProcess.start();
        }
    }

    protected static String setHistogram(String eq) {
        String histogram = "";
        histogram = eq != "" ? " -vf \"" + eq + "," : " -vf \"";
        histogram = String.valueOf(histogram) + "split=2[a][b];[b]format=yuva444p,histogram=levels_mode=logarithmic:components=1:level_height=50:fgopacity=0.5:bgopacity=0.5,scale=-1:30[b];[a][b]overlay=x=main_w-overlay_w:y=main_h-overlay_h\"";
        return histogram;
    }

    protected static String setLuts(String eq) {
        if (Shutter.caseLUTs.isSelected()) {
            String pathToLuts;
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/";
            } else {
                pathToLuts = "LUTs/";
            }
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "lut3d=file=" + pathToLuts + Shutter.comboLUTs.getSelectedItem().toString();
        }
        return eq;
    }

    protected static String setLevels(String eq) {
        if (Shutter.caseLevels.isSelected()) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "scale=in_range=" + Shutter.comboInLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full") + ":out_range=" + Shutter.comboOutLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full");
        }
        return eq;
    }

    protected static String setColormatrix(String eq) {
        if (Shutter.caseColormatrix.isSelected()) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            if (Shutter.comboInColormatrix.getSelectedItem().equals("HDR")) {
                String pathToLuts;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                    pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/HDR-to-SDR.cube";
                } else {
                    pathToLuts = "LUTs/HDR-to-SDR.cube";
                }
                eq = String.valueOf(eq) + "lut3d=file=" + pathToLuts;
            } else {
                eq = String.valueOf(eq) + "colorspace=iall=" + Shutter.comboInColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625") + ":all=" + Shutter.comboOutColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625");
            }
        }
        return eq;
    }

    protected static String setGrain(String eq) {
        if (sliderGrain.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = sliderGrain.getValue() > 0 ? String.valueOf(eq) + "unsharp=la=" + (float)sliderGrain.getValue() / 50.0f : String.valueOf(eq) + "bm3d=sigma=" + (float)(0 - sliderGrain.getValue());
        }
        return eq;
    }

    protected static String setRotate(String eq) {
        block17: {
            if (comboRotate.getSelectedIndex() == 0) break block17;
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            switch (comboRotate.getSelectedItem().toString()) {
                case "90": {
                    eq = String.valueOf(eq) + "transpose=1";
                    break;
                }
                case "-90": {
                    eq = String.valueOf(eq) + "transpose=2";
                    break;
                }
                case "180": {
                    eq = String.valueOf(eq) + "transpose=1,transpose=1";
                }
            }
        }
        if (sliderAngle.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            float angle = sliderAngle.getValue() > 0 ? (float)((double)((float)sliderAngle.getValue() / 10.0f) * Math.PI) / 180.0f : (float)((double)(0.0f - (float)sliderAngle.getValue() / 10.0f) * Math.PI) / 180.0f;
            float ratio = (float)ImageWidth / (float)ImageHeight;
            float h = (float)((double)ImageHeight / ((double)ratio * Math.sin(angle) + Math.cos(angle)));
            float w = h * ratio;
            if (ratio < 1.0f) {
                ratio = (float)ImageHeight / (float)ImageWidth;
                w = (float)((double)ImageWidth / ((double)ratio * Math.sin(angle) + Math.cos(angle)));
                h = w * ratio;
            }
            w = 2.0f - (float)ImageWidth / w;
            h = 2.0f - (float)ImageHeight / h;
            eq = String.valueOf(eq) + "rotate=" + (float)sliderAngle.getValue() / 10.0f + "*PI/180:ow=iw*" + w + ":oh=ih*" + h;
        }
        return eq;
    }

    protected static String setVignette(String eq) {
        if (sliderVignette.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = sliderVignette.getValue() > 0 ? String.valueOf(eq) + "vignette=PI/" + (float)(100 - sliderVignette.getValue()) / 5.0f : String.valueOf(eq) + "vignette=PI/" + (float)(100 + sliderVignette.getValue()) / 5.0f + ":mode=backward";
        }
        return eq;
    }

    protected static String setVibrance(String eq) {
        if (sliderVibrance.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "vibrance=" + (float)sliderVibrance.getValue() / 50.0f;
        }
        return eq;
    }

    protected static String setSaturation(String eq) {
        if (sliderSaturation.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "eq=saturation=" + (float)(sliderSaturation.getValue() + 100) / 100.0f;
        }
        return eq;
    }

    protected static String setBalance(String eq) {
        float r = (float)sliderRED.getValue() / 400.0f;
        float g = (float)sliderGREEN.getValue() / 400.0f;
        float b = (float)sliderBLUE.getValue() / 400.0f;
        if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
            balanceAll = "rs=" + r + ":gs=" + g + ":bs=" + b + ":rm=" + r + ":gm=" + g + ":bm=" + b + ":rh=" + r + ":gh=" + g + ":bh=" + b;
        }
        if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
            balanceLow = "rs=" + r + ":gs=" + g + ":bs=" + b;
        } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
            balanceMedium = "rm=" + r + ":gm=" + g + ":bm=" + b;
        } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
            balanceHigh = "rh=" + r + ":gh=" + g + ":bh=" + b;
        }
        if (balanceAll != "" && !balanceAll.equals("rs=0.0:gs=0.0:bs=0.0:rm=0.0:gm=0.0:bm=0.0:rh=0.0:gh=0.0:bh=0.0")) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "colorbalance=" + balanceAll;
        }
        if (balanceLow != "" || balanceMedium != "" || balanceHigh != "") {
            eq = balanceAll != "" && !balanceAll.equals("rs=0.0:gs=0.0:bs=0.0:rm=0.0:gm=0.0:bm=0.0:rh=0.0:gh=0.0:bh=0.0") ? String.valueOf(eq) + ",colorbalance=" : (eq != "" ? String.valueOf(eq) + ",colorbalance=" : "colorbalance=");
            if (balanceLow == "") {
                balanceLow = "rs=0:gs=0:bs=0";
            }
            if (balanceMedium == "") {
                balanceMedium = "rm=0:gm=0:bm=0";
            }
            if (balanceHigh == "") {
                balanceHigh = "rh=0:gh=0:bh=0";
            }
            eq = String.valueOf(eq) + balanceLow + ":" + balanceMedium + ":" + balanceHigh;
        }
        return eq;
    }

    protected static String setContrast(String eq) {
        if (sliderContrast.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "eq=contrast=" + (1.0f + (float)sliderContrast.getValue() / 100.0f);
        }
        return eq;
    }

    protected static String setShadows(String eq) {
        if (sliderShadows.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = sliderShadows.getValue() > 0 ? String.valueOf(eq) + "curves=master='0/0 0.25/" + (0.25f - (0.0f - (float)sliderShadows.getValue() / 500.0f)) + " 0.5/0.5 0.75/0.75 0.875/0.875 1/1'" : String.valueOf(eq) + "curves=master='0/0 " + (0.25f - (float)sliderShadows.getValue() / 500.0f) + "/0.25 0.5/0.5 0.625/0.625 0.75/0.75 0.875/0.875 1/1" + "'";
        }
        return eq;
    }

    protected static String setMediums(String eq) {
        if (sliderMediums.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = sliderMediums.getValue() > 0 ? String.valueOf(eq) + "curves=master='0/0 " + (0.5 - (double)((float)sliderMediums.getValue() / 400.0f)) + "/" + (0.5 + (double)((float)sliderMediums.getValue() / 400.0f)) + " 1/1" + "'" : String.valueOf(eq) + "curves=master='0/0 " + (0.5 + (double)(0.0f - (float)sliderMediums.getValue() / 400.0f)) + "/" + (0.5 - (double)(0.0f - (float)sliderMediums.getValue() / 400.0f)) + " 1/1" + "'";
        }
        return eq;
    }

    protected static String setHighlights(String eq) {
        if (sliderHighlights.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = sliderHighlights.getValue() > 0 ? String.valueOf(eq) + "curves=master='0/0 0.125/0.125 0.25/0.25 0.375/0.375 0.5/0.5 " + (0.75f - (float)sliderHighlights.getValue() / 500.0f) + "/0.75 1/1" + "'" : String.valueOf(eq) + "curves=master='0/0 0.125/0.125 0.25/0.25 0.375/0.375 0.5/0.5 0.75/" + (0.75f - (0.0f - (float)sliderHighlights.getValue() / 500.0f)) + " 1/1'";
        }
        return eq;
    }

    protected static String setExposure(String eq) {
        if (sliderExposure.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = sliderExposure.getValue() > 0 ? String.valueOf(eq) + "curves=master='0/" + (float)sliderExposure.getValue() / 200.0f + " " + (1.0f - (float)sliderExposure.getValue() / 200.0f) + "/1" + "'" : String.valueOf(eq) + "curves=master='" + (0.0f - (float)sliderExposure.getValue() / 200.0f) + "/0" + " " + "1/" + (1.0f - (0.0f - (float)sliderExposure.getValue() / 200.0f)) + "'";
        }
        return eq;
    }

    protected static void setFinalEQ() {
        String eq = "";
        eq = ColorImage.setExposure(eq);
        eq = ColorImage.setHighlights(eq);
        eq = ColorImage.setMediums(eq);
        eq = ColorImage.setShadows(eq);
        eq = ColorImage.setContrast(eq);
        eq = ColorImage.setBalance(eq);
        eq = ColorImage.setVibrance(eq);
        eq = ColorImage.setSaturation(eq);
        eq = ColorImage.setGrain(eq);
        eq = ColorImage.setRotate(eq);
        eq = ColorImage.setVignette(eq);
        Shutter.finalEQ = eq.replace("\"", "'");
    }

    public static void loadSettings(final File encFile) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        Thread.sleep(100L);
                    } while (frame == null && !frame.isVisible());
                    File file = new File(String.valueOf(Shutter.dirTemp) + "color.bmp");
                    do {
                        Thread.sleep(100L);
                    } while (!file.exists());
                    File fXmlFile = encFile;
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(fXmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("Component");
                    int temp = 0;
                    while (temp < nList.getLength()) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            Element eElement = (Element)nNode;
                            Component[] componentArray = frame.getContentPane().getComponents();
                            int n = componentArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Component p = componentArray[n2];
                                if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                    if (p instanceof JSlider) {
                                        ((JSlider)p).setValue(Integer.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()));
                                        ((JSlider)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JSlider)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    } else if (p instanceof JComboBox && p.getName().equals("comboRotate")) {
                                        comboRotate.setSelectedItem(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    }
                                }
                                ++n2;
                            }
                            if (eElement.getElementsByTagName("Type").item(0).getFirstChild().getTextContent().equals("String")) {
                                if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("allR")) {
                                    allR = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                } else if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("allG")) {
                                    allG = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                } else if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("allB")) {
                                    allB = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    comboRGB.setSelectedIndex(0);
                                    ColorImage.setBalance("");
                                }
                                if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("highR")) {
                                    highR = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                } else if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("highG")) {
                                    highG = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                } else if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("highB")) {
                                    highB = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    comboRGB.setSelectedIndex(1);
                                    ColorImage.setBalance("");
                                }
                                if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("mediumR")) {
                                    mediumR = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                } else if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("mediumG")) {
                                    mediumG = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                } else if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("mediumB")) {
                                    mediumB = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    comboRGB.setSelectedIndex(2);
                                    ColorImage.setBalance("");
                                }
                                if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("lowR")) {
                                    lowR = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                } else if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("lowG")) {
                                    lowG = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                } else if (eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent().equals("lowB")) {
                                    lowB = Integer.parseInt(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                    comboRGB.setSelectedIndex(3);
                                    ColorImage.setBalance("");
                                }
                            }
                        }
                        ++temp;
                    }
                    comboRGB.setSelectedIndex(0);
                    ColorImage.loadImage(true);
                    do {
                        Thread.sleep(100L);
                    } while (!file.exists() || FFMPEG.isRunning || FFPROBE.isRunning);
                    Shutter.enableAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    private void resizeAll() {
        topPanel.setBounds(0, 0, ColorImage.frame.getSize().width, 52);
        this.topImage.setLocation(ColorImage.frame.getSize().width / 2 - this.topImage.getSize().width / 2, 0);
        this.quit.setBounds(ColorImage.frame.getSize().width - 24, 0, 21, 21);
        this.fullscreen.setBounds(this.quit.getLocation().x - 21, 0, 21, 21);
        this.reduce.setBounds(this.fullscreen.getLocation().x - 21, 0, 21, 21);
        ImageIcon imageIcon = new ImageIcon(this.header.getImage().getScaledInstance(ColorImage.topPanel.getSize().width, ColorImage.topPanel.getSize().height, 16));
        this.bottomImage.setIcon(imageIcon);
        this.bottomImage.setBounds(0, 0, ColorImage.frame.getSize().width, 52);
        title.setBounds(0, 0, frame.getWidth(), 52);
        positionVideo.setBounds(212, frame.getHeight() - 33, sliderExposure.getWidth(), 22);
        btnOriginal.setBounds(positionVideo.getX() + positionVideo.getWidth() + 9, frame.getHeight() - 33, ColorImage.btnOriginal.getPreferredSize().width, 21);
        btnPreview.setBounds(btnOriginal.getX() + btnOriginal.getWidth() + 9, frame.getHeight() - 33, 120, 21);
        btnExportImage.setBounds(btnPreview.getX() + btnPreview.getWidth() + 9, frame.getHeight() - 33, ColorImage.btnExportImage.getPreferredSize().width, 21);
        btnOK.setBounds(btnExportImage.getX() + btnExportImage.getWidth() + 9, frame.getHeight() - 33, frame.getWidth() - (btnExportImage.getX() + btnExportImage.getWidth()) - 25, 21);
    }

    private static class MousePosition {
        static int mouseX;
        static int mouseY;

        private MousePosition() {
        }
    }
}

