/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.Shutter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import library.DECKLINK;
import library.FFMPEG;
import library.FFPROBE;

public class BlackMagicOutput {
    public static JFrame frame;
    public static JSlider slider;
    public static boolean sliderChange;
    private JRadioButton caseHD;
    private JButton btnPrevious;
    private JButton btnNext;
    public static JButton btnLire;
    private JRadioButton caseForceInterlace;
    private JRadioButton caseAfficherLeTimecode;
    public static int sliderValue;
    public static JLabel lblTimecode;
    public static Integer timecode1;
    public static Integer timecode2;
    public static Integer timecode3;
    public static Integer timecode4;

    static {
        sliderChange = false;
        sliderValue = 0;
        timecode1 = 0;
        timecode2 = 0;
        timecode3 = 0;
        timecode4 = 0;
    }

    public BlackMagicOutput() {
        frame = new JFrame();
        frame.getContentPane().setLayout(null);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.setSize(498, 166);
        } else {
            frame.setSize(488, 156);
        }
        frame.setTitle(String.valueOf(Shutter.language.getProperty("frameBlackMagicOutput")) + " " + DECKLINK.getBlackMagic);
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.setDefaultCloseOperation(2);
        frame.setLocation(Shutter.frame.getLocation().x - frame.getWidth() - 20, Shutter.frame.getLocation().y + Shutter.frame.getHeight() / 2 - 40);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                File stopframe;
                if (DECKLINK.isRunning) {
                    DECKLINK.process.destroy();
                }
                if ((stopframe = new File(String.valueOf(Shutter.dirTemp) + "frame.png")).exists()) {
                    stopframe.delete();
                }
            }
        });
        this.load();
        frame.setVisible(true);
        btnLire.doClick();
    }

    private void load() {
        this.caseHD = new JRadioButton(Shutter.language.getProperty("caseHD"));
        this.caseHD.setSelected(true);
        this.caseHD.setFont(new Font("FreeSans", 0, 12));
        this.caseHD.setBounds(6, 38, this.caseHD.getPreferredSize().width, 23);
        frame.getContentPane().add(this.caseHD);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (DECKLINK.isRunning) {
                    DECKLINK.process.destroy();
                }
            }
        });
        this.btnPrevious = new JButton("<");
        this.btnPrevious.setFont(new Font("Montserrat", 0, 12));
        this.btnPrevious.setBounds(8, 8, 26, 21);
        frame.getContentPane().add(this.btnPrevious);
        this.btnPrevious.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (Shutter.fileList.getSelectedIndex() > 0) {
                    slider.setValue(0);
                    Shutter.fileList.setSelectedIndex(Shutter.fileList.getSelectedIndex() - 1);
                    btnLire.setText(Shutter.language.getProperty("btnLire"));
                    btnLire.doClick();
                }
            }
        });
        btnLire = new JButton(Shutter.language.getProperty("btnLire"));
        btnLire.setFont(new Font("Montserrat", 0, 12));
        btnLire.setBounds(44, 8, 397, 21);
        frame.getContentPane().add(btnLire);
        this.btnNext = new JButton(">");
        this.btnNext.setFont(new Font("Montserrat", 0, 12));
        this.btnNext.setBounds(btnLire.getX() + btnLire.getWidth() + 8, 8, 26, 21);
        frame.getContentPane().add(this.btnNext);
        this.btnNext.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (Shutter.fileList.getSelectedIndex() < Shutter.liste.getSize()) {
                    slider.setValue(0);
                    Shutter.fileList.setSelectedIndex(Shutter.fileList.getSelectedIndex() + 1);
                    btnLire.setText(Shutter.language.getProperty("btnLire"));
                    btnLire.doClick();
                }
            }
        });
        this.caseForceInterlace = new JRadioButton(Shutter.language.getProperty("caseForcerEntrelacement"));
        this.caseForceInterlace.setSelected(false);
        this.caseForceInterlace.setBounds(170, 38, this.caseForceInterlace.getPreferredSize().width + 20, 23);
        this.caseForceInterlace.setFont(new Font("FreeSans", 0, 12));
        frame.getContentPane().add(this.caseForceInterlace);
        this.caseAfficherLeTimecode = new JRadioButton(Shutter.language.getProperty("caseAfficherLeTimecode"));
        this.caseAfficherLeTimecode.setSelected(true);
        this.caseAfficherLeTimecode.setBounds(338, 38, this.caseAfficherLeTimecode.getPreferredSize().width + 20, 23);
        this.caseAfficherLeTimecode.setFont(new Font("FreeSans", 0, 12));
        frame.getContentPane().add(this.caseAfficherLeTimecode);
        slider = new JSlider();
        slider.setEnabled(false);
        slider.setValue(0);
        slider.setBounds(6, 62, 461, 22);
        frame.getContentPane().add(slider);
        lblTimecode = new JLabel("00:00:00:00");
        lblTimecode.setHorizontalAlignment(0);
        lblTimecode.setFont(new Font("FreeSans", 0, 30));
        lblTimecode.setForeground(Color.RED);
        lblTimecode.setBounds(6, 91, 461, 24);
        frame.getContentPane().add(lblTimecode);
        slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                sliderChange = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (sliderChange && DECKLINK.isRunning) {
                    Thread runProcess = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DECKLINK.process.destroy();
                                do {
                                    Thread.sleep(100L);
                                } while (DECKLINK.isRunning);
                                DecimalFormat tc = new DecimalFormat("00");
                                String h = String.valueOf(tc.format(slider.getValue() / 3600));
                                String m = String.valueOf(tc.format(slider.getValue() / 60 % 60));
                                String s = String.valueOf(tc.format(slider.getValue() % 60));
                                sliderValue = slider.getValue();
                                BlackMagicOutput.this.playVideo(" -ss " + h + ":" + m + ":" + s + ".0");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    runProcess.start();
                } else if (sliderChange && slider.getValue() == 0) {
                    if (DECKLINK.isRunning) {
                        DECKLINK.process.destroy();
                    }
                    btnLire.setText(Shutter.language.getProperty("btnLire"));
                    BlackMagicOutput.this.caseForceInterlace.setEnabled(true);
                    BlackMagicOutput.this.caseAfficherLeTimecode.setEnabled(true);
                    BlackMagicOutput.this.caseHD.setEnabled(true);
                }
                sliderChange = false;
            }
        });
        btnLire.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (btnLire.getText().equals(Shutter.language.getProperty("btnLire"))) {
                    if (DECKLINK.isRunning) {
                        DECKLINK.process.destroy();
                    }
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (DECKLINK.isRunning);
                    if (slider.getValue() == slider.getMaximum()) {
                        slider.setValue(0);
                    }
                    DecimalFormat tc = new DecimalFormat("00");
                    String h = String.valueOf(tc.format(slider.getValue() / 3600));
                    String m = String.valueOf(tc.format(slider.getValue() / 60 % 60));
                    String s = String.valueOf(tc.format(slider.getValue() % 60));
                    sliderValue = slider.getValue();
                    BlackMagicOutput.this.playVideo(" -ss " + h + ":" + m + ":" + s + ".0");
                    btnLire.setText(Shutter.language.getProperty("btnArret"));
                } else if (btnLire.getText().equals(Shutter.language.getProperty("btnArret"))) {
                    if (DECKLINK.isRunning) {
                        DECKLINK.process.destroy();
                    }
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException tc) {
                            // empty catch block
                        }
                    } while (DECKLINK.isRunning);
                    btnLire.setText(Shutter.language.getProperty("btnLire"));
                    BlackMagicOutput.this.caseForceInterlace.setEnabled(true);
                    BlackMagicOutput.this.caseAfficherLeTimecode.setEnabled(true);
                    BlackMagicOutput.this.caseHD.setEnabled(true);
                    DecimalFormat tc = new DecimalFormat("00");
                    String h = String.valueOf(tc.format(slider.getValue() / 3600));
                    String m = String.valueOf(tc.format(slider.getValue() / 60 % 60));
                    String s = String.valueOf(tc.format(slider.getValue() % 60));
                    sliderValue = slider.getValue();
                    BlackMagicOutput.this.playVideo(" -ss " + h + ":" + m + ":" + s + ".0");
                }
            }
        });
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                DecimalFormat tc = new DecimalFormat("00");
                String h = String.valueOf(tc.format(slider.getValue() / 3600));
                String m = String.valueOf(tc.format(slider.getValue() / 60 % 60));
                String s = String.valueOf(tc.format(slider.getValue() % 60));
                lblTimecode.setText(String.valueOf(h) + ":" + m + ":" + s + ":00");
            }
        });
    }

    private void playVideo(final String position) {
        if (!DECKLINK.isRunning) {
            Thread runProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            String file = Shutter.fileList.getSelectedIndices().length == 0 ? Shutter.liste.firstElement() : Shutter.fileList.getSelectedValue().toString();
                            FFPROBE.Data(file);
                            do {
                                Thread.sleep(100L);
                            } while (FFPROBE.isRunning);
                            FFPROBE.FrameData(file);
                            do {
                                Thread.sleep(100L);
                            } while (FFPROBE.isRunning);
                            DecimalFormat tc = new DecimalFormat("00");
                            String h = String.valueOf(tc.format(slider.getValue() / 3600 + timecode1));
                            String m = String.valueOf(tc.format(slider.getValue() / 60 % 60 + timecode2));
                            String s = String.valueOf(tc.format(slider.getValue() % 60 + timecode3));
                            String f = String.valueOf(tc.format(timecode4));
                            String videoFilter = "";
                            if (BlackMagicOutput.this.caseAfficherLeTimecode.isSelected()) {
                                videoFilter = " -vf \"drawtext=fontfile=" + Shutter.pathToFont.replace("Montserrat", "FreeSans") + ":timecode='" + h + "\\:" + m + "\\:" + s + "\\:" + f + "':r=" + FFPROBE.currentFPS + ":x=(w-tw)*0.5:y=(lh*0.5):fontcolor=white:fontsize=(" + FFPROBE.imageResolution.substring(FFPROBE.imageResolution.lastIndexOf("x") + 1) + "*0.0422):box=1:boxcolor=0x00000099" + '\"';
                            }
                            String format = "";
                            if (BlackMagicOutput.this.caseHD.isSelected()) {
                                format = " -s 1920x1080";
                            }
                            String fieldOrder = " -field_order progressive";
                            if (BlackMagicOutput.this.caseForceInterlace.isSelected()) {
                                fieldOrder = " -field_order tt";
                            } else if (FFPROBE.entrelaced.equals("1") && FFPROBE.fieldOrder.equals("1")) {
                                fieldOrder = " -field_order bt";
                            } else if (FFPROBE.entrelaced.equals("1")) {
                                fieldOrder = " -field_order tt";
                            }
                            String audio = " -c:a pcm_s16le";
                            if (FFPROBE.qantization == 24) {
                                audio = " -c:a pcm_s24le";
                            }
                            audio = FFPROBE.channels > 1 ? String.valueOf(audio) + " -ar 48000 -filter_complex \"amerge=inputs=2,channelmap=0|1:channel_layout=stereo\"" : (FFPROBE.channels == 0 ? String.valueOf(audio) + " -an" : String.valueOf(audio) + " -ar 48000");
                            File stopframe = new File(String.valueOf(Shutter.dirTemp) + "frame.png");
                            if (stopframe.exists()) {
                                stopframe.delete();
                            }
                            if (btnLire.getText().equals(Shutter.language.getProperty("btnLire"))) {
                                Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("tempFolder") + " " + Shutter.dirTemp + System.lineSeparator() + System.lineSeparator());
                                BlackMagicOutput.this.btnPrevious.setEnabled(false);
                                BlackMagicOutput.this.btnNext.setEnabled(false);
                                btnLire.setEnabled(false);
                                slider.setEnabled(false);
                                FFMPEG.run(String.valueOf(position) + " -i " + '\"' + file + '\"' + videoFilter + " -vframes 1 -an -y " + '\"' + stopframe + '\"');
                                do {
                                    Thread.sleep(100L);
                                } while (!stopframe.exists() && !FFMPEG.error);
                                BlackMagicOutput.this.btnPrevious.setEnabled(true);
                                BlackMagicOutput.this.btnNext.setEnabled(true);
                                btnLire.setEnabled(true);
                                slider.setEnabled(true);
                                Shutter.enableAll();
                                DECKLINK.run(" -loop 1 -i \"" + stopframe + '\"' + format + fieldOrder + " -an -f decklink -pix_fmt uyvy422 " + '\"' + DECKLINK.getBlackMagic + '\"');
                            } else {
                                DECKLINK.run(String.valueOf(position) + " -i " + '\"' + file + '\"' + videoFilter + format + audio + fieldOrder + " -f decklink -pix_fmt uyvy422 " + '\"' + DECKLINK.getBlackMagic + '\"');
                                Shutter.lblTermine.setVisible(false);
                                Shutter.enableAll();
                                BlackMagicOutput.this.caseForceInterlace.setEnabled(false);
                                BlackMagicOutput.this.caseAfficherLeTimecode.setEnabled(false);
                                BlackMagicOutput.this.caseHD.setEnabled(false);
                                slider.setEnabled(true);
                            }
                            frame.setCursor(Cursor.getPredefinedCursor(0));
                            do {
                                Thread.sleep(100L);
                            } while (DECKLINK.isRunning);
                        }
                        catch (InterruptedException interruptedException) {
                            if (slider.getValue() == DECKLINK.dureeTotale) {
                                btnLire.setText(Shutter.language.getProperty("btnLire"));
                                BlackMagicOutput.this.caseForceInterlace.setEnabled(true);
                                BlackMagicOutput.this.caseAfficherLeTimecode.setEnabled(true);
                                BlackMagicOutput.this.caseHD.setEnabled(true);
                                if (Shutter.fileList.getSelectedIndex() < Shutter.liste.getSize() - 1) {
                                    Shutter.fileList.setSelectedIndex(Shutter.fileList.getSelectedIndex() + 1);
                                    btnLire.doClick();
                                }
                            }
                        }
                    }
                    finally {
                        if (slider.getValue() == DECKLINK.dureeTotale) {
                            btnLire.setText(Shutter.language.getProperty("btnLire"));
                            BlackMagicOutput.this.caseForceInterlace.setEnabled(true);
                            BlackMagicOutput.this.caseAfficherLeTimecode.setEnabled(true);
                            BlackMagicOutput.this.caseHD.setEnabled(true);
                            if (Shutter.fileList.getSelectedIndex() < Shutter.liste.getSize() - 1) {
                                Shutter.fileList.setSelectedIndex(Shutter.fileList.getSelectedIndex() + 1);
                                btnLire.doClick();
                            }
                        }
                    }
                }
            });
            runProcess.start();
        }
    }
}

