/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.BlackMagicOutputTransferHandler1;
import application.BlackMagicOutputTransferHandler2;
import application.BlackMagicOutputTransferHandler3;
import application.Settings;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import library.DECKLINK;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class BlackMagicInput {
    public static JFrame frame;
    public static JButton btnRecord;
    public static JRadioButton caseStopAt;
    public static JLabel lblTimecode;
    public static JComboBox<String[]> comboInput;
    private JComboBox<String[]> comboOutput;
    protected static JTextField lblDestination1;
    protected static JTextField lblDestination2;
    protected static JTextField lblDestination3;
    private JRadioButton caseDeinterlace;
    public static JTextField TC1;
    public static JTextField TC2;
    public static JTextField TC3;

    public BlackMagicInput() {
        frame = new JFrame();
        frame.getContentPane().setLayout(null);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.setSize(473, 284);
        } else {
            frame.setSize(453, 264);
        }
        frame.setTitle(Shutter.language.getProperty("frameBlackMagicInput"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setBackground(new Color(50, 50, 50));
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.setDefaultCloseOperation(2);
        frame.setLocation(Shutter.frame.getLocation().x - frame.getWidth() - 20, Shutter.frame.getLocation().y + Shutter.frame.getHeight() / 2 - 40);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (DECKLINK.runProcess != null) {
                    if (DECKLINK.process.isAlive()) {
                        try {
                            DECKLINK.writer.write(113);
                            DECKLINK.writer.flush();
                            DECKLINK.writer.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (DECKLINK.isRunning) {
                        DECKLINK.process.destroy();
                    }
                }
            }
        });
        this.load();
        frame.setVisible(true);
    }

    private void load() {
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (DECKLINK.runProcess != null) {
                    if (DECKLINK.process.isAlive()) {
                        try {
                            DECKLINK.writer.write(113);
                            DECKLINK.writer.flush();
                            DECKLINK.writer.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (DECKLINK.isRunning) {
                        DECKLINK.process.destroy();
                    }
                }
            }
        });
        Label lblInput = new Label(Shutter.language.getProperty("lblInput"));
        lblInput.setAlignment(2);
        lblInput.setFont(new Font("FreeSans", 0, 12));
        lblInput.setForeground(Color.WHITE);
        lblInput.setBackground(new Color(50, 50, 50));
        lblInput.setBounds(10, 9, 46, 22);
        frame.getContentPane().add(lblInput);
        comboInput = new JComboBox();
        comboInput.setBounds(62, 9, 374, 22);
        comboInput.setModel(new DefaultComboBoxModel<Object>(DECKLINK.formatsList.toArray()));
        comboInput.setSelectedItem(null);
        comboInput.setFont(new Font("FreeSans", 0, 11));
        comboInput.setEditable(false);
        frame.getContentPane().add(comboInput);
        Label lblOutput = new Label(Shutter.language.getProperty("lblOutput"));
        lblOutput.setAlignment(2);
        lblOutput.setFont(new Font("FreeSans", 0, 12));
        lblOutput.setForeground(Color.WHITE);
        lblOutput.setBackground(new Color(50, 50, 50));
        lblOutput.setBounds(10, 37, 46, 22);
        frame.getContentPane().add(lblOutput);
        this.comboOutput = new JComboBox();
        this.comboOutput.setFont(new Font("FreeSans", 0, 11));
        this.comboOutput.setEditable(false);
        this.comboOutput.setBounds(62, 37, comboInput.getWidth(), 22);
        frame.getContentPane().add(this.comboOutput);
        String[] codecs = new String[]{"DV PAL 4/3", "DV PAL 16/9", "DNxHD 120", "DNxHD 185", "Apple ProRes 422", "Apple ProRes 422 HQ", "H.264 15Mb/s 320kb/s", "H.264 10Mb/s 256kb/s", "H.264 5Mb/s 128kb/s"};
        this.comboOutput.setModel(new DefaultComboBoxModel<String>(codecs));
        this.comboOutput.setSelectedIndex(2);
        this.comboOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BlackMagicInput.this.comboOutput.getSelectedItem().toString().contains("DV PAL") || !comboInput.getSelectedItem().toString().contains("interlaced")) {
                    BlackMagicInput.this.caseDeinterlace.setSelected(false);
                    BlackMagicInput.this.caseDeinterlace.setEnabled(false);
                } else {
                    BlackMagicInput.this.caseDeinterlace.setEnabled(true);
                }
                if (BlackMagicInput.this.comboOutput.getSelectedItem().toString().contains("H.264")) {
                    lblDestination2.setEnabled(true);
                    lblDestination3.setEnabled(true);
                } else {
                    lblDestination2.setEnabled(false);
                    lblDestination2.setText(Shutter.language.getProperty("aucune"));
                    lblDestination3.setEnabled(false);
                    lblDestination3.setText(Shutter.language.getProperty("aucune"));
                }
            }
        });
        JLabel defaultOutput1 = new JLabel(String.valueOf(Shutter.language.getProperty("output")) + "1" + Shutter.language.getProperty("colon"));
        defaultOutput1.setFont(new Font("FreeSans", 0, 12));
        defaultOutput1.setBounds(10, this.comboOutput.getLocation().y + this.comboOutput.getHeight() + 6, defaultOutput1.getPreferredSize().width + 4, defaultOutput1.getPreferredSize().height);
        frame.getContentPane().add(defaultOutput1);
        lblDestination1 = new JTextField();
        lblDestination1.setEditable(false);
        lblDestination1.setBorder(BorderFactory.createEmptyBorder());
        lblDestination1.setForeground(Utils.themeColor);
        lblDestination1.setFont(new Font("SansSerif", 1, 13));
        lblDestination1.setBackground(new Color(50, 50, 50));
        if (System.getProperty("os.name").contains("Windows")) {
            lblDestination1.setText(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
        } else {
            lblDestination1.setText(String.valueOf(System.getProperty("user.home")) + "/Desktop");
        }
        lblDestination1.setBounds(this.comboOutput.getX() + 2, defaultOutput1.getY() - 4, this.comboOutput.getWidth() - 2, 22);
        frame.getContentPane().add(lblDestination1);
        lblDestination1.setTransferHandler(new BlackMagicOutputTransferHandler1());
        lblDestination1.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File destination = null;
                if (System.getProperty("os.name").contains("Mac")) {
                    FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseDestinationFolder"), 0);
                    dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                    dialog.setLocation(BlackMagicInput.frame.getLocation().x - 50, BlackMagicInput.frame.getLocation().y + 50);
                    dialog.setAlwaysOnTop(true);
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                    dialog.setVisible(true);
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                    if (dialog.getDirectory() != null) {
                        destination = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                    }
                } else if (System.getProperty("os.name").contains("Linux")) {
                    JFileChooser dialog = new JFileChooser(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                    dialog.setDialogTitle(Shutter.language.getProperty("chooseDestinationFolder"));
                    dialog.setFileSelectionMode(1);
                    if (Settings.lblDestination1.getText() != "" && new File(Settings.lblDestination1.getText()).exists()) {
                        dialog.setSelectedFile(new File(Settings.lblDestination1.getText()));
                    } else {
                        dialog.setSelectedFile(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop"));
                    }
                    int result = dialog.showOpenDialog(frame);
                    if (result == 0) {
                        destination = new File(dialog.getSelectedFile().toString());
                    }
                } else {
                    Shell shell = new Shell(16384);
                    shell.setSize(BlackMagicInput.frame.getSize().width, BlackMagicInput.frame.getSize().height);
                    shell.setLocation(BlackMagicInput.frame.getLocation().x, BlackMagicInput.frame.getLocation().y);
                    shell.setAlpha(0);
                    shell.open();
                    DirectoryDialog dialog = new DirectoryDialog(shell);
                    dialog.setText(Shutter.language.getProperty("chooseDestinationFolder"));
                    dialog.setFilterPath(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                    try {
                        destination = new File(dialog.open());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    shell.dispose();
                }
                if (destination != null) {
                    if (System.getProperty("os.name").contains("Windows") && destination.toString().substring(0, 2).equals("\\\\")) {
                        destination = Utils.UNCPath(destination);
                    }
                    if (destination.isFile()) {
                        lblDestination1.setText(destination.getParent());
                    } else {
                        lblDestination1.setText(destination.toString());
                    }
                    if (lblDestination1.getText().equals(lblDestination2.getText()) || lblDestination1.getText().equals(lblDestination3.getText())) {
                        JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("ChooseDifferentFolder"), Shutter.language.getProperty("chooseDestinationFolder"), 0);
                        if (System.getProperty("os.name").contains("Windows")) {
                            lblDestination1.setText(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                        } else {
                            lblDestination1.setText(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                lblDestination1.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                lblDestination1.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        JLabel defaultOutput2 = new JLabel(String.valueOf(Shutter.language.getProperty("output")) + "2" + Shutter.language.getProperty("colon"));
        defaultOutput2.setFont(new Font("FreeSans", 0, 12));
        defaultOutput2.setBounds(10, defaultOutput1.getLocation().y + defaultOutput1.getHeight() + 6, defaultOutput2.getPreferredSize().width + 4, defaultOutput2.getPreferredSize().height);
        frame.getContentPane().add(defaultOutput2);
        lblDestination2 = new JTextField();
        lblDestination2.setEditable(false);
        lblDestination2.setEnabled(false);
        lblDestination2.setBorder(BorderFactory.createEmptyBorder());
        lblDestination2.setForeground(Utils.themeColor);
        lblDestination2.setFont(new Font("SansSerif", 1, 13));
        lblDestination2.setBackground(new Color(50, 50, 50));
        lblDestination2.setText(Shutter.language.getProperty("aucune"));
        lblDestination2.setBounds(this.comboOutput.getX() + 2, defaultOutput2.getY() - 4, this.comboOutput.getWidth() - 2, 22);
        frame.getContentPane().add(lblDestination2);
        lblDestination2.setTransferHandler(new BlackMagicOutputTransferHandler2());
        lblDestination2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (lblDestination2.isEnabled()) {
                    File destination = null;
                    if (System.getProperty("os.name").contains("Mac")) {
                        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseDestinationFolder"), 0);
                        dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setLocation(BlackMagicInput.frame.getLocation().x - 50, BlackMagicInput.frame.getLocation().y + 50);
                        dialog.setAlwaysOnTop(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "true");
                        dialog.setVisible(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "false");
                        if (dialog.getDirectory() != null) {
                            destination = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                        }
                    } else if (System.getProperty("os.name").contains("Linux")) {
                        JFileChooser dialog = new JFileChooser(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setDialogTitle(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFileSelectionMode(1);
                        if (Settings.lblDestination1.getText() != "" && new File(Settings.lblDestination1.getText()).exists()) {
                            dialog.setSelectedFile(new File(Settings.lblDestination1.getText()));
                        } else {
                            dialog.setSelectedFile(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop"));
                        }
                        int result = dialog.showOpenDialog(frame);
                        if (result == 0) {
                            destination = new File(dialog.getSelectedFile().toString());
                        }
                    } else {
                        Shell shell = new Shell(16384);
                        shell.setSize(BlackMagicInput.frame.getSize().width, BlackMagicInput.frame.getSize().height);
                        shell.setLocation(BlackMagicInput.frame.getLocation().x, BlackMagicInput.frame.getLocation().y);
                        shell.setAlpha(0);
                        shell.open();
                        DirectoryDialog dialog = new DirectoryDialog(shell);
                        dialog.setText(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFilterPath(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                        try {
                            destination = new File(dialog.open());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.dispose();
                    }
                    if (destination != null) {
                        if (System.getProperty("os.name").contains("Windows") && destination.toString().substring(0, 2).equals("\\\\")) {
                            destination = Utils.UNCPath(destination);
                        }
                        if (destination.isFile()) {
                            lblDestination2.setText(destination.getParent());
                        } else {
                            lblDestination2.setText(destination.toString());
                        }
                        if (lblDestination2.getText().equals(lblDestination1.getText()) || lblDestination2.getText().equals(lblDestination3.getText())) {
                            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("ChooseDifferentFolder"), Shutter.language.getProperty("chooseDestinationFolder"), 0);
                            lblDestination2.setText(Shutter.language.getProperty("aucune"));
                        }
                    } else {
                        lblDestination2.setText(Shutter.language.getProperty("aucune"));
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                lblDestination2.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                lblDestination2.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        JLabel defaultOutput3 = new JLabel(String.valueOf(Shutter.language.getProperty("output")) + "3" + Shutter.language.getProperty("colon"));
        defaultOutput3.setFont(new Font("FreeSans", 0, 12));
        defaultOutput3.setBounds(10, defaultOutput2.getLocation().y + defaultOutput2.getHeight() + 6, defaultOutput3.getPreferredSize().width + 4, defaultOutput3.getPreferredSize().height);
        frame.getContentPane().add(defaultOutput3);
        lblDestination3 = new JTextField();
        lblDestination3.setEditable(false);
        lblDestination3.setEnabled(false);
        lblDestination3.setBorder(BorderFactory.createEmptyBorder());
        lblDestination3.setForeground(Utils.themeColor);
        lblDestination3.setFont(new Font("SansSerif", 1, 13));
        lblDestination3.setBackground(new Color(50, 50, 50));
        lblDestination3.setText(Shutter.language.getProperty("aucune"));
        lblDestination3.setBounds(this.comboOutput.getX() + 2, defaultOutput3.getY() - 4, this.comboOutput.getWidth() - 2, 22);
        frame.getContentPane().add(lblDestination3);
        lblDestination3.setTransferHandler(new BlackMagicOutputTransferHandler3());
        lblDestination3.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (lblDestination3.isEnabled()) {
                    File destination = null;
                    if (System.getProperty("os.name").contains("Mac")) {
                        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseDestinationFolder"), 0);
                        dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setLocation(BlackMagicInput.frame.getLocation().x - 50, BlackMagicInput.frame.getLocation().y + 50);
                        dialog.setAlwaysOnTop(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "true");
                        dialog.setVisible(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "false");
                        if (dialog.getDirectory() != null) {
                            destination = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                        }
                    } else if (System.getProperty("os.name").contains("Linux")) {
                        JFileChooser dialog = new JFileChooser(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        dialog.setDialogTitle(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFileSelectionMode(1);
                        if (Settings.lblDestination1.getText() != "" && new File(Settings.lblDestination1.getText()).exists()) {
                            dialog.setSelectedFile(new File(Settings.lblDestination1.getText()));
                        } else {
                            dialog.setSelectedFile(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop"));
                        }
                        int result = dialog.showOpenDialog(frame);
                        if (result == 0) {
                            destination = new File(dialog.getSelectedFile().toString());
                        }
                    } else {
                        Shell shell = new Shell(16384);
                        shell.setSize(BlackMagicInput.frame.getSize().width, BlackMagicInput.frame.getSize().height);
                        shell.setLocation(BlackMagicInput.frame.getLocation().x, BlackMagicInput.frame.getLocation().y);
                        shell.setAlpha(0);
                        shell.open();
                        DirectoryDialog dialog = new DirectoryDialog(shell);
                        dialog.setText(Shutter.language.getProperty("chooseDestinationFolder"));
                        dialog.setFilterPath(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                        try {
                            destination = new File(dialog.open());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.dispose();
                    }
                    if (destination != null) {
                        if (System.getProperty("os.name").contains("Windows") && destination.toString().substring(0, 2).equals("\\\\")) {
                            destination = Utils.UNCPath(destination);
                        }
                        if (destination.isFile()) {
                            lblDestination3.setText(destination.getParent());
                        } else {
                            lblDestination3.setText(destination.toString());
                        }
                        if (lblDestination3.getText().equals(lblDestination1.getText()) || lblDestination3.getText().equals(lblDestination2.getText())) {
                            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("ChooseDifferentFolder"), Shutter.language.getProperty("chooseDestinationFolder"), 0);
                            lblDestination3.setText(Shutter.language.getProperty("aucune"));
                        }
                    } else {
                        lblDestination3.setText(Shutter.language.getProperty("aucune"));
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                lblDestination3.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                lblDestination3.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        comboInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DECKLINK.toFFPLAY("-f decklink -draw_bars 0 -i \"" + DECKLINK.getBlackMagic + "@" + (comboInput.getSelectedIndex() + 1) + '\"' + " -c:a copy -c:v copy -f matroska pipe:play |");
            }
        });
        this.caseDeinterlace = new JRadioButton(Shutter.language.getProperty("caseDeinterlace"));
        this.caseDeinterlace.setFont(new Font("FreeSans", 0, 12));
        this.caseDeinterlace.setBounds(10, defaultOutput3.getY() + defaultOutput3.getHeight() + 6, 157, 23);
        frame.getContentPane().add(this.caseDeinterlace);
        caseStopAt = new JRadioButton(Shutter.language.getProperty("caseStopAt"));
        caseStopAt.setFont(new Font("FreeSans", 0, 12));
        caseStopAt.setBounds(169, this.caseDeinterlace.getY(), 169, 23);
        frame.getContentPane().add(caseStopAt);
        caseStopAt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseStopAt.isSelected()) {
                    TC1.setEnabled(true);
                    TC2.setEnabled(true);
                    TC3.setEnabled(true);
                } else {
                    TC1.setEnabled(false);
                    TC2.setEnabled(false);
                    TC3.setEnabled(false);
                }
            }
        });
        TC1 = new JTextField("00");
        TC1.setBounds(336, caseStopAt.getY() + 1, 32, 21);
        TC1.setHorizontalAlignment(0);
        TC1.setFont(new Font("FreeSans", 0, 14));
        TC1.setColumns(10);
        TC1.setEnabled(false);
        frame.getContentPane().add(TC1);
        TC2 = new JTextField("00");
        TC2.setBounds(370, caseStopAt.getY() + 1, 32, 21);
        TC2.setHorizontalAlignment(0);
        TC2.setFont(new Font("FreeSans", 0, 14));
        TC2.setColumns(10);
        TC2.setEnabled(false);
        frame.getContentPane().add(TC2);
        TC3 = new JTextField("00");
        TC3.setBounds(404, caseStopAt.getY() + 1, 32, 21);
        TC3.setHorizontalAlignment(0);
        TC3.setFont(new Font("FreeSans", 0, 14));
        TC3.setColumns(10);
        TC3.setEnabled(false);
        frame.getContentPane().add(TC3);
        TC1.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC1.getText().length() >= 2) {
                    TC1.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        TC2.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC2.getText().length() >= 2) {
                    TC2.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        TC3.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC3.getText().length() >= 2) {
                    TC3.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        btnRecord = new JButton(Shutter.language.getProperty("btnRecord"));
        btnRecord.setFont(new Font("Montserrat", 0, 12));
        btnRecord.setBounds(12, caseStopAt.getY() + caseStopAt.getHeight() + 6, 423, 21);
        frame.getContentPane().add(btnRecord);
        btnRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DECKLINK.runProcess != null) {
                    if (DECKLINK.process.isAlive()) {
                        try {
                            DECKLINK.writer.write(113);
                            DECKLINK.writer.flush();
                            DECKLINK.writer.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (DECKLINK.isRunning) {
                        DECKLINK.process.destroy();
                    }
                }
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (DECKLINK.process.isAlive());
                if (btnRecord.getText().equals(Shutter.language.getProperty("btnRecord"))) {
                    BlackMagicInput.this.record();
                    comboInput.setEnabled(false);
                    BlackMagicInput.this.comboOutput.setEnabled(false);
                    BlackMagicInput.this.caseDeinterlace.setEnabled(false);
                    caseStopAt.setEnabled(false);
                    TC1.setEnabled(false);
                    TC2.setEnabled(false);
                    TC3.setEnabled(false);
                    btnRecord.setText(Shutter.language.getProperty("btnStopRecording"));
                } else if (btnRecord.getText().equals(Shutter.language.getProperty("btnStopRecording"))) {
                    comboInput.setEnabled(true);
                    BlackMagicInput.this.comboOutput.setEnabled(true);
                    BlackMagicInput.this.caseDeinterlace.setEnabled(true);
                    caseStopAt.setEnabled(true);
                    TC1.setEnabled(true);
                    TC2.setEnabled(true);
                    TC3.setEnabled(true);
                    btnRecord.setText(Shutter.language.getProperty("btnRecord"));
                    DECKLINK.toFFPLAY("-f decklink -draw_bars 0 -i \"" + DECKLINK.getBlackMagic + "@" + (comboInput.getSelectedIndex() + 1) + '\"' + " -c:a copy -c:v copy -f matroska pipe:play |");
                }
            }
        });
        lblTimecode = new JLabel("00:00:00");
        lblTimecode.setHorizontalAlignment(0);
        lblTimecode.setFont(new Font("FreeSans", 0, 30));
        lblTimecode.setForeground(Color.RED);
        lblTimecode.setBounds(10, btnRecord.getY() + btnRecord.getHeight() + 18, 422, 24);
        frame.getContentPane().add(lblTimecode);
    }

    private void record() {
        block51: {
            String interlaced = "";
            if (comboInput.getSelectedItem().toString().contains("(interlaced, upper field first)") && !this.caseDeinterlace.isSelected()) {
                if (this.comboOutput.getSelectedItem().toString().contains("Apple ProRes")) {
                    interlaced = " -field_order tt";
                } else if (this.comboOutput.getSelectedItem().toString().contains("DNxHD")) {
                    interlaced = " -flags +ildct -top 1";
                } else if (this.comboOutput.getSelectedItem().toString().contains("DV PAL")) {
                    interlaced = " -field_order tb";
                }
            } else if (comboInput.getSelectedItem().toString().contains("(interlaced, lower field first)") && !this.caseDeinterlace.isSelected()) {
                if (this.comboOutput.getSelectedItem().toString().contains("Apple ProRes")) {
                    interlaced = " -field_order bt";
                } else if (this.comboOutput.getSelectedItem().toString().contains("DNxHD")) {
                    interlaced = " -field_order bt -flags +ildct -top 1";
                }
            }
            String deinterlace = "";
            if (this.caseDeinterlace.isSelected() || comboInput.getSelectedItem().toString().contains("H.264")) {
                if (comboInput.getSelectedItem().toString().contains("(interlaced, upper field first)")) {
                    deinterlace = "yadif=0:0:0";
                } else if (comboInput.getSelectedItem().toString().contains("(interlaced, lower field first)")) {
                    deinterlace = "yadif=0:1:0";
                }
                deinterlace = this.comboOutput.getSelectedItem().toString().contains("DNxHD") ? "," + deinterlace : " -filter:v " + deinterlace;
            }
            boolean cancelled = false;
            File fileOut = new File(String.valueOf(lblDestination1.getText()) + "/Num_" + this.comboOutput.getSelectedItem().toString().replace(" 4/3", "").replace(" 16/9", "").replace(" ", "_") + ".mov");
            if (this.comboOutput.getSelectedItem().toString().contains("H.264")) {
                fileOut = new File(String.valueOf(lblDestination1.getText()) + "/Num_" + "H.264" + ".mp4");
            }
            if (fileOut.exists() && (fileOut = this.comboOutput.getSelectedItem().toString().contains("H.264") ? Utils.fileReplacement(lblDestination1.getText(), "Num.mp4", ".mp4", "_H.264_", ".mp4") : Utils.fileReplacement(lblDestination1.getText(), "Num.mov", ".mov", "_" + this.comboOutput.getSelectedItem().toString().replace(" 4/3", "").replace(" 16/9", "").replace(" ", "_") + "_", ".mov")) == null) {
                cancelled = true;
                comboInput.setEnabled(true);
                this.comboOutput.setEnabled(true);
                this.caseDeinterlace.setEnabled(true);
                caseStopAt.setEnabled(true);
                TC1.setEnabled(true);
                TC2.setEnabled(true);
                TC3.setEnabled(true);
                btnRecord.setText(Shutter.language.getProperty("btnRecord"));
            }
            if (cancelled) break block51;
            String decklink = "-f decklink -draw_bars 0 -i \"" + DECKLINK.getBlackMagic + "@" + (comboInput.getSelectedIndex() + 1) + '\"';
            String output = "-f tee \"" + fileOut.toString().replace("\\", "/") + "|[f=matroska]pipe:play" + '\"';
            if (this.comboOutput.getSelectedItem().toString().contains("H.264")) {
                if (!lblDestination2.getText().equals(Shutter.language.getProperty("aucune"))) {
                    output = String.valueOf(output) + " -f mp4 \"" + fileOut.toString().replace(lblDestination1.getText(), lblDestination2.getText()).replace("\\", "/") + '\"';
                }
                if (!lblDestination3.getText().equals(Shutter.language.getProperty("aucune"))) {
                    output = String.valueOf(output) + " -f mp4 \"" + fileOut.toString().replace(lblDestination1.getText(), lblDestination3.getText()).replace("\\", "/") + '\"';
                }
            }
            switch (this.comboOutput.getSelectedItem().toString()) {
                case "DV PAL 4/3": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -aspect 4:3 -s 720x576 -c:a copy -c:v dvvideo -b:v 25000 -r 25" + interlaced + " -map v? -map a? -y " + output);
                    break;
                }
                case "DV PAL 16/9": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -aspect 16:9 -s 720x576 -c:a copy -c:v dvvideo -b:v 25000 -r 25" + interlaced + " -map v? -map a? -y " + output);
                    break;
                }
                case "DNxHD 120": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -s 1920x1080 -filter:v scale=1920:1080:force_original_aspect_ratio=decrease,pad=" + '\"' + "1920:1080:(ow-iw)/2:(oh-ih)/2" + '\"' + deinterlace + " -c:a copy -c:v dnxhd -b:v 120M -pix_fmt yuv422p" + interlaced + " -map v? -map a? -y " + output);
                    break;
                }
                case "DNxHD 185": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -s 1920x1080 -filter:v scale=1920:1080:force_original_aspect_ratio=decrease,pad=" + '\"' + "1920:1080:(ow-iw)/2:(oh-ih)/2" + '\"' + deinterlace + " -c:a copy -c:v dnxhd -b:v 185M -pix_fmt yuv422p" + interlaced + " -map v? -map a? -y " + output);
                    break;
                }
                case "Apple ProRes 422": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -c:a copy -c:v prores -profile:v 2" + deinterlace + interlaced + " -pix_fmt yuv422p10 -map v? -map a? -y " + output);
                    break;
                }
                case "Apple ProRes 422 HQ": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -c:a copy -c:v prores -profile:v 3" + deinterlace + interlaced + " -pix_fmt yuv422p10 -map v? -map a? -y " + output);
                    break;
                }
                case "H.264 15Mb/s 320kb/s": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -c:v h264 -b:v 15000k -c:a aac -b:a 320k" + deinterlace + " -profile:v high -level 5.1 -pix_fmt yuv420p -map v? -map a? -y " + output);
                    break;
                }
                case "H.264 10Mb/s 256kb/s": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -c:v h264 -b:v 10000k -c:a aac -b:a 256k" + deinterlace + " -profile:v high -level 5.1 -pix_fmt yuv420p -map v? -map a? -y " + output);
                    break;
                }
                case "H.264 5Mb/s 128kb/s": {
                    DECKLINK.toFFMPEG(String.valueOf(decklink) + " -c:v h264 -b:v 5000k -c:a aac -b:a 128k" + deinterlace + " -profile:v high -level 5.1 -pix_fmt yuv420p -map v? -map a? -y " + output);
                }
            }
        }
    }
}

